/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface WebPubsubConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#aad_auth_enabled WebPubsub#aad_auth_enabled}
    */
    readonly aadAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#capacity WebPubsub#capacity}
    */
    readonly capacity?: number;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#id WebPubsub#id}
    *
    * Please be aware that the id field is automatically added to all resources in Terraform providers using a Terraform provider SDK version below 2.
    * If you experience problems setting this value it might not be settable. Please take a look at the provider documentation to ensure it should be settable.
    */
    readonly id?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#local_auth_enabled WebPubsub#local_auth_enabled}
    */
    readonly localAuthEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#location WebPubsub#location}
    */
    readonly location: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#name WebPubsub#name}
    */
    readonly name: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#public_network_access_enabled WebPubsub#public_network_access_enabled}
    */
    readonly publicNetworkAccessEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#resource_group_name WebPubsub#resource_group_name}
    */
    readonly resourceGroupName: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#sku WebPubsub#sku}
    */
    readonly sku: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#tags WebPubsub#tags}
    */
    readonly tags?: {
        [key: string]: string;
    };
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#tls_client_cert_enabled WebPubsub#tls_client_cert_enabled}
    */
    readonly tlsClientCertEnabled?: boolean | cdktf.IResolvable;
    /**
    * identity block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#identity WebPubsub#identity}
    */
    readonly identity?: WebPubsubIdentity;
    /**
    * live_trace block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#live_trace WebPubsub#live_trace}
    */
    readonly liveTrace?: WebPubsubLiveTrace;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#timeouts WebPubsub#timeouts}
    */
    readonly timeouts?: WebPubsubTimeouts;
}
export interface WebPubsubIdentity {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#identity_ids WebPubsub#identity_ids}
    */
    readonly identityIds?: string[];
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#type WebPubsub#type}
    */
    readonly type: string;
}
export declare function webPubsubIdentityToTerraform(struct?: WebPubsubIdentityOutputReference | WebPubsubIdentity): any;
export declare function webPubsubIdentityToHclTerraform(struct?: WebPubsubIdentityOutputReference | WebPubsubIdentity): any;
export declare class WebPubsubIdentityOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubIdentity | undefined;
    set internalValue(value: WebPubsubIdentity | undefined);
    private _identityIds?;
    get identityIds(): string[];
    set identityIds(value: string[]);
    resetIdentityIds(): void;
    get identityIdsInput(): string[] | undefined;
    get principalId(): string;
    get tenantId(): string;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
}
export interface WebPubsubLiveTrace {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#connectivity_logs_enabled WebPubsub#connectivity_logs_enabled}
    */
    readonly connectivityLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#enabled WebPubsub#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#http_request_logs_enabled WebPubsub#http_request_logs_enabled}
    */
    readonly httpRequestLogsEnabled?: boolean | cdktf.IResolvable;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#messaging_logs_enabled WebPubsub#messaging_logs_enabled}
    */
    readonly messagingLogsEnabled?: boolean | cdktf.IResolvable;
}
export declare function webPubsubLiveTraceToTerraform(struct?: WebPubsubLiveTraceOutputReference | WebPubsubLiveTrace): any;
export declare function webPubsubLiveTraceToHclTerraform(struct?: WebPubsubLiveTraceOutputReference | WebPubsubLiveTrace): any;
export declare class WebPubsubLiveTraceOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubLiveTrace | undefined;
    set internalValue(value: WebPubsubLiveTrace | undefined);
    private _connectivityLogsEnabled?;
    get connectivityLogsEnabled(): boolean | cdktf.IResolvable;
    set connectivityLogsEnabled(value: boolean | cdktf.IResolvable);
    resetConnectivityLogsEnabled(): void;
    get connectivityLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _httpRequestLogsEnabled?;
    get httpRequestLogsEnabled(): boolean | cdktf.IResolvable;
    set httpRequestLogsEnabled(value: boolean | cdktf.IResolvable);
    resetHttpRequestLogsEnabled(): void;
    get httpRequestLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _messagingLogsEnabled?;
    get messagingLogsEnabled(): boolean | cdktf.IResolvable;
    set messagingLogsEnabled(value: boolean | cdktf.IResolvable);
    resetMessagingLogsEnabled(): void;
    get messagingLogsEnabledInput(): boolean | cdktf.IResolvable | undefined;
}
export interface WebPubsubTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#create WebPubsub#create}
    */
    readonly create?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#delete WebPubsub#delete}
    */
    readonly delete?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#read WebPubsub#read}
    */
    readonly read?: string;
    /**
    * Docs at Terraform Registry: {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#update WebPubsub#update}
    */
    readonly update?: string;
}
export declare function webPubsubTimeoutsToTerraform(struct?: WebPubsubTimeouts | cdktf.IResolvable): any;
export declare function webPubsubTimeoutsToHclTerraform(struct?: WebPubsubTimeouts | cdktf.IResolvable): any;
export declare class WebPubsubTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    private resolvableValue?;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string);
    get internalValue(): WebPubsubTimeouts | cdktf.IResolvable | undefined;
    set internalValue(value: WebPubsubTimeouts | cdktf.IResolvable | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
    private _delete?;
    get delete(): string;
    set delete(value: string);
    resetDelete(): void;
    get deleteInput(): string | undefined;
    private _read?;
    get read(): string;
    set read(value: string);
    resetRead(): void;
    get readInput(): string | undefined;
    private _update?;
    get update(): string;
    set update(value: string);
    resetUpdate(): void;
    get updateInput(): string | undefined;
}
/**
* Represents a {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub azurerm_web_pubsub}
*/
export declare class WebPubsub extends cdktf.TerraformResource {
    static readonly tfResourceType = "azurerm_web_pubsub";
    /**
    * Generates CDKTF code for importing a WebPubsub resource upon running "cdktf plan <stack-name>"
    * @param scope The scope in which to define this construct
    * @param importToId The construct id used in the generated config for the WebPubsub to import
    * @param importFromId The id of the existing WebPubsub that should be imported. Refer to the {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub#import import section} in the documentation of this resource for the id to use
    * @param provider? Optional instance of the provider where the WebPubsub to import is found
    */
    static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider): cdktf.ImportableResource;
    /**
    * Create a new {@link https://registry.terraform.io/providers/hashicorp/azurerm/3.89.0/docs/resources/web_pubsub azurerm_web_pubsub} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options WebPubsubConfig
    */
    constructor(scope: Construct, id: string, config: WebPubsubConfig);
    private _aadAuthEnabled?;
    get aadAuthEnabled(): boolean | cdktf.IResolvable;
    set aadAuthEnabled(value: boolean | cdktf.IResolvable);
    resetAadAuthEnabled(): void;
    get aadAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _capacity?;
    get capacity(): number;
    set capacity(value: number);
    resetCapacity(): void;
    get capacityInput(): number | undefined;
    get externalIp(): string;
    get hostname(): string;
    private _id?;
    get id(): string;
    set id(value: string);
    resetId(): void;
    get idInput(): string | undefined;
    private _localAuthEnabled?;
    get localAuthEnabled(): boolean | cdktf.IResolvable;
    set localAuthEnabled(value: boolean | cdktf.IResolvable);
    resetLocalAuthEnabled(): void;
    get localAuthEnabledInput(): boolean | cdktf.IResolvable | undefined;
    private _location?;
    get location(): string;
    set location(value: string);
    get locationInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get primaryAccessKey(): string;
    get primaryConnectionString(): string;
    private _publicNetworkAccessEnabled?;
    get publicNetworkAccessEnabled(): boolean | cdktf.IResolvable;
    set publicNetworkAccessEnabled(value: boolean | cdktf.IResolvable);
    resetPublicNetworkAccessEnabled(): void;
    get publicNetworkAccessEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get publicPort(): number;
    private _resourceGroupName?;
    get resourceGroupName(): string;
    set resourceGroupName(value: string);
    get resourceGroupNameInput(): string | undefined;
    get secondaryAccessKey(): string;
    get secondaryConnectionString(): string;
    get serverPort(): number;
    private _sku?;
    get sku(): string;
    set sku(value: string);
    get skuInput(): string | undefined;
    private _tags?;
    get tags(): {
        [key: string]: string;
    };
    set tags(value: {
        [key: string]: string;
    });
    resetTags(): void;
    get tagsInput(): {
        [key: string]: string;
    } | undefined;
    private _tlsClientCertEnabled?;
    get tlsClientCertEnabled(): boolean | cdktf.IResolvable;
    set tlsClientCertEnabled(value: boolean | cdktf.IResolvable);
    resetTlsClientCertEnabled(): void;
    get tlsClientCertEnabledInput(): boolean | cdktf.IResolvable | undefined;
    get version(): string;
    private _identity;
    get identity(): WebPubsubIdentityOutputReference;
    putIdentity(value: WebPubsubIdentity): void;
    resetIdentity(): void;
    get identityInput(): WebPubsubIdentity | undefined;
    private _liveTrace;
    get liveTrace(): WebPubsubLiveTraceOutputReference;
    putLiveTrace(value: WebPubsubLiveTrace): void;
    resetLiveTrace(): void;
    get liveTraceInput(): WebPubsubLiveTrace | undefined;
    private _timeouts;
    get timeouts(): WebPubsubTimeoutsOutputReference;
    putTimeouts(value: WebPubsubTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): cdktf.IResolvable | WebPubsubTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
    protected synthesizeHclAttributes(): {
        [name: string]: any;
    };
}
