/*
 * Decompiled with CFR 0.152.
 */
package xsdvi;

import java.util.Stack;
import org.apache.xerces.xs.StringList;
import org.apache.xerces.xs.XSAttributeDeclaration;
import org.apache.xerces.xs.XSAttributeUse;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSIDCDefinition;
import org.apache.xerces.xs.XSModel;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSNamedMap;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.apache.xerces.xs.XSWildcard;
import xsdvi.svg.AbstractSymbol;
import xsdvi.svg.SymbolAll;
import xsdvi.svg.SymbolAny;
import xsdvi.svg.SymbolAnyAttribute;
import xsdvi.svg.SymbolAttribute;
import xsdvi.svg.SymbolChoice;
import xsdvi.svg.SymbolElement;
import xsdvi.svg.SymbolField;
import xsdvi.svg.SymbolKey;
import xsdvi.svg.SymbolKeyref;
import xsdvi.svg.SymbolLoop;
import xsdvi.svg.SymbolSchema;
import xsdvi.svg.SymbolSelector;
import xsdvi.svg.SymbolSequence;
import xsdvi.svg.SymbolUnique;
import xsdvi.utils.TreeBuilder;

public class XsdHandler {
    private TreeBuilder builder;
    private Stack<XSElementDeclaration> stack;

    public XsdHandler(TreeBuilder treeBuilder) {
        this.builder = treeBuilder;
        this.stack = new Stack();
    }

    public void processModel(XSModel xSModel) {
        if (xSModel == null) {
            return;
        }
        SymbolSchema symbolSchema = new SymbolSchema();
        this.builder.setRoot(symbolSchema);
        this.processElementDeclarations(xSModel.getComponents((short)2));
        this.builder.levelUp();
    }

    private void processElementDeclarations(XSNamedMap xSNamedMap) {
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            this.processElementDeclaration((XSElementDeclaration)xSNamedMap.item(i), null);
        }
    }

    private void processParticle(XSParticle xSParticle) {
        this.processTerm(xSParticle.getTerm(), this.getCardinalityString(xSParticle));
    }

    private void processTerm(XSTerm xSTerm, String string) {
        short s = xSTerm.getType();
        if (s == 7) {
            this.processModelGroup((XSModelGroup)xSTerm, string);
        } else if (s == 2) {
            this.processElementDeclaration((XSElementDeclaration)xSTerm, string);
        } else if (s == 9) {
            this.processElementWildcard((XSWildcard)xSTerm, string);
        }
    }

    private void processElementWildcard(XSWildcard xSWildcard, String string) {
        SymbolAny symbolAny = new SymbolAny();
        symbolAny.setNamespace(this.getNamespaceString(xSWildcard));
        symbolAny.setProcessContents(this.getProcessContents(xSWildcard));
        symbolAny.setCardinality(string);
        this.builder.appendChild(symbolAny);
        this.builder.levelUp();
    }

    private void processAttributeWildcard(XSWildcard xSWildcard) {
        SymbolAnyAttribute symbolAnyAttribute = new SymbolAnyAttribute();
        symbolAnyAttribute.setNamespace(this.getNamespaceString(xSWildcard));
        symbolAnyAttribute.setProcessContents(this.getProcessContents(xSWildcard));
        this.builder.appendChild(symbolAnyAttribute);
        this.builder.levelUp();
    }

    private void processModelGroup(XSModelGroup xSModelGroup, String string) {
        AbstractSymbol abstractSymbol = null;
        short s = xSModelGroup.getCompositor();
        if (s == 3) {
            abstractSymbol = new SymbolAll(string);
        } else if (s == 2) {
            abstractSymbol = new SymbolChoice(string);
        } else if (s == 1) {
            abstractSymbol = new SymbolSequence(string);
        }
        this.builder.appendChild(abstractSymbol);
        this.processParticles(xSModelGroup.getParticles());
        this.builder.levelUp();
    }

    private void processParticles(XSObjectList xSObjectList) {
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            this.processParticle((XSParticle)xSObjectList.item(i));
        }
    }

    private void processAttributeUse(XSAttributeUse xSAttributeUse) {
        XSAttributeDeclaration xSAttributeDeclaration = xSAttributeUse.getAttrDeclaration();
        SymbolAttribute symbolAttribute = new SymbolAttribute();
        symbolAttribute.setName(xSAttributeDeclaration.getName());
        symbolAttribute.setNamespace(xSAttributeDeclaration.getNamespace());
        symbolAttribute.setType(this.getTypeString(xSAttributeDeclaration.getTypeDefinition()));
        symbolAttribute.setRequired(xSAttributeUse.getRequired());
        symbolAttribute.setConstraint(this.getConstraintString(xSAttributeUse));
        this.builder.appendChild(symbolAttribute);
        this.builder.levelUp();
    }

    private void processElementDeclaration(XSElementDeclaration xSElementDeclaration, String string) {
        XSTypeDefinition xSTypeDefinition = xSElementDeclaration.getTypeDefinition();
        SymbolElement symbolElement = new SymbolElement();
        symbolElement.setName(xSElementDeclaration.getName());
        symbolElement.setNamespace(xSElementDeclaration.getNamespace());
        symbolElement.setType(this.getTypeString(xSTypeDefinition));
        symbolElement.setCardinality(string);
        symbolElement.setNillable(xSElementDeclaration.getNillable());
        symbolElement.setAbstr(xSElementDeclaration.getAbstract());
        symbolElement.setSubstitution(this.getSubstitutionString(xSElementDeclaration));
        this.builder.appendChild(symbolElement);
        if (this.processLoop(xSElementDeclaration)) {
            this.builder.levelUp();
            return;
        }
        this.stack.push(xSElementDeclaration);
        if (xSTypeDefinition.getTypeCategory() == 15) {
            this.processComplexTypeDefinition((XSComplexTypeDefinition)xSTypeDefinition);
        }
        this.processIdentityConstraints(xSElementDeclaration.getIdentityConstraints());
        this.stack.pop();
        this.builder.levelUp();
    }

    private void processComplexTypeDefinition(XSComplexTypeDefinition xSComplexTypeDefinition) {
        XSParticle xSParticle = xSComplexTypeDefinition.getParticle();
        if (xSParticle != null) {
            this.processParticle(xSParticle);
        }
        this.processAttributeUses(xSComplexTypeDefinition.getAttributeUses());
        XSWildcard xSWildcard = xSComplexTypeDefinition.getAttributeWildcard();
        if (xSWildcard != null) {
            this.processAttributeWildcard(xSWildcard);
        }
    }

    private void processAttributeUses(XSObjectList xSObjectList) {
        for (int i = 0; i < xSObjectList.getLength(); ++i) {
            this.processAttributeUse((XSAttributeUse)xSObjectList.item(i));
        }
    }

    private void processIdentityConstraints(XSNamedMap xSNamedMap) {
        for (int i = 0; i < xSNamedMap.getLength(); ++i) {
            this.processIdentityConstraintDefinition((XSIDCDefinition)xSNamedMap.item(i));
        }
    }

    private boolean processLoop(XSElementDeclaration xSElementDeclaration) {
        if (this.stack.contains(xSElementDeclaration)) {
            SymbolLoop symbolLoop = new SymbolLoop();
            this.builder.appendChild(symbolLoop);
            this.builder.levelUp();
            return true;
        }
        return false;
    }

    private void processIdentityConstraintDefinition(XSIDCDefinition xSIDCDefinition) {
        AbstractSymbol abstractSymbol = null;
        short s = xSIDCDefinition.getCategory();
        if (s == 3) {
            abstractSymbol = new SymbolUnique();
            abstractSymbol.setName(xSIDCDefinition.getName());
            abstractSymbol.setNamespace(xSIDCDefinition.getNamespace());
        } else if (s == 1) {
            abstractSymbol = new SymbolKey();
            ((SymbolKey)abstractSymbol).setName(xSIDCDefinition.getName());
            ((SymbolKey)abstractSymbol).setNamespace(xSIDCDefinition.getNamespace());
        } else if (s == 2) {
            abstractSymbol = new SymbolKeyref();
            ((SymbolKeyref)abstractSymbol).setName(xSIDCDefinition.getName());
            ((SymbolKeyref)abstractSymbol).setNamespace(xSIDCDefinition.getNamespace());
            ((SymbolKeyref)abstractSymbol).setRefer(xSIDCDefinition.getRefKey().getName());
        }
        this.builder.appendChild(abstractSymbol);
        SymbolSelector symbolSelector = new SymbolSelector();
        symbolSelector.setXpath(xSIDCDefinition.getSelectorStr());
        this.builder.appendChild(symbolSelector);
        this.builder.levelUp();
        StringList stringList = xSIDCDefinition.getFieldStrs();
        for (int i = 0; i < stringList.getLength(); ++i) {
            SymbolField symbolField = new SymbolField();
            symbolField.setXpath(stringList.item(i));
            this.builder.appendChild(symbolField);
            this.builder.levelUp();
        }
        this.builder.levelUp();
    }

    private String getConstraintString(XSAttributeUse xSAttributeUse) {
        if (xSAttributeUse.getConstraintType() == 1) {
            return "default: " + xSAttributeUse.getConstraintValue();
        }
        if (xSAttributeUse.getConstraintType() == 2) {
            return "fixed: " + xSAttributeUse.getConstraintValue();
        }
        return null;
    }

    private String getTypeString(XSTypeDefinition xSTypeDefinition) {
        if (xSTypeDefinition.getAnonymous()) {
            if (xSTypeDefinition.getTypeCategory() == 16) {
                return "base: " + xSTypeDefinition.getBaseType().getName();
            }
        } else {
            return "type: " + xSTypeDefinition.getName();
        }
        return null;
    }

    private String getSubstitutionString(XSElementDeclaration xSElementDeclaration) {
        XSElementDeclaration xSElementDeclaration2 = xSElementDeclaration.getSubstitutionGroupAffiliation();
        if (xSElementDeclaration2 != null) {
            return xSElementDeclaration2.getName();
        }
        return null;
    }

    private String getNamespaceString(XSWildcard xSWildcard) {
        if (xSWildcard.getConstraintType() == 1) {
            return "any NS";
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (xSWildcard.getConstraintType() == 2) {
            stringBuffer.append("not NS: ");
        } else {
            stringBuffer.append("NS: ");
        }
        StringList stringList = xSWildcard.getNsConstraintList();
        boolean bl = false;
        for (int i = 0; i < stringList.getLength(); ++i) {
            if (stringList.item(i) == null) {
                if (bl) continue;
                stringBuffer.append("[absent] ");
                bl = true;
                continue;
            }
            stringBuffer.append(stringList.item(i));
            stringBuffer.append(' ');
        }
        return stringBuffer.toString();
    }

    private String getCardinalityString(XSParticle xSParticle) {
        int n = xSParticle.getMinOccurs();
        int n2 = xSParticle.getMaxOccurs();
        if (xSParticle.getMaxOccursUnbounded()) {
            return n + "..\u221e";
        }
        if (n != 1 || n2 != 1) {
            return n + ".." + n2;
        }
        return null;
    }

    private int getProcessContents(XSWildcard xSWildcard) {
        switch (xSWildcard.getProcessContents()) {
            case 1: {
                return 1;
            }
            case 2: {
                return 2;
            }
            case 3: {
                return 3;
            }
        }
        return 1;
    }
}

