/*
 * Decompiled with CFR 0.152.
 */
package xsdvi;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.xerces.xs.XSImplementation;
import org.apache.xerces.xs.XSLoader;
import org.apache.xerces.xs.XSModel;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.bootstrap.DOMImplementationRegistry;
import xsdvi.XsdHandler;
import xsdvi.svg.AbstractSymbol;
import xsdvi.svg.SvgForXsd;
import xsdvi.utils.LoggerHelper;
import xsdvi.utils.TreeBuilder;
import xsdvi.utils.WriterHelper;
import xsdvi.utils.XsdErrorHandler;

public final class XsdVi {
    private static final Logger logger = Logger.getLogger(LoggerHelper.LOGGER_NAME);
    private static List<String> inputs = new ArrayList<String>();
    private static String style = null;
    private static String styleUrl = null;
    public static final String EMBODY_STYLE = "-embodyStyle";
    public static final String GENERATE_STYLE = "-generateStyle";
    public static final String USE_STYLE = "-useStyle";
    public static final String USAGE = "\nUSAGE:\njava -jar xsdvi.jar <input1.xsd> [<input2.xsd> [<input3.xsd> ...]] [style]\n  STYLE:\n    -embodyStyle                css style will be embodied in each svg file, this is default\n    -generateStyle <style.css>  new css file with specified name will be generated and used by svgs\n    -useStyle      <style.css>  external css file at specified url will be used by svgs\n";

    private XsdVi() {
    }

    public static void main(String[] stringArray) {
        LoggerHelper.setupLogger();
        XsdVi.parseArgs(stringArray);
        XSLoader xSLoader = XsdVi.getSchemaLoader();
        TreeBuilder treeBuilder = new TreeBuilder();
        XsdHandler xsdHandler = new XsdHandler(treeBuilder);
        WriterHelper writerHelper = new WriterHelper();
        SvgForXsd svgForXsd = new SvgForXsd(writerHelper);
        if (style.equals(EMBODY_STYLE)) {
            logger.info("The style will be embodied");
            svgForXsd.setEmbodyStyle(true);
        } else {
            logger.info("Using external style " + styleUrl);
            svgForXsd.setEmbodyStyle(false);
            svgForXsd.setStyleUri(styleUrl);
        }
        if (style.equals(GENERATE_STYLE)) {
            logger.info("Generating style " + styleUrl + "...");
            svgForXsd.printExternStyle();
            logger.info("Done.");
        }
        for (String string : inputs) {
            String string2 = XsdVi.outputUrl(string);
            logger.info("Parsing " + string + "...");
            XSModel xSModel = xSLoader.loadURI(string);
            logger.info("Processing XML Schema model...");
            xsdHandler.processModel(xSModel);
            logger.info("Drawing SVG " + string2 + "...");
            writerHelper.newWriter(string2);
            svgForXsd.draw((AbstractSymbol)treeBuilder.getRoot());
            logger.info("Done.");
        }
    }

    private static String outputUrl(String string) {
        String[] stringArray = string.split("[/\\\\]");
        String string2 = stringArray[stringArray.length - 1];
        if (string2.toLowerCase().endsWith(".xsd")) {
            return string2.substring(0, string2.length() - 4) + ".svg";
        }
        return string2 + ".svg";
    }

    private static void parseArgs(String[] stringArray) {
        if (stringArray.length < 1 || stringArray[0].equalsIgnoreCase(EMBODY_STYLE) || stringArray[0].equalsIgnoreCase(GENERATE_STYLE) || stringArray[0].equalsIgnoreCase(USE_STYLE)) {
            XsdVi.printUsage();
            System.exit(1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equalsIgnoreCase(EMBODY_STYLE)) {
                if (stringArray.length != i + 1) {
                    XsdVi.printUsage();
                    System.exit(1);
                }
                style = EMBODY_STYLE;
                return;
            }
            if (stringArray[i].equalsIgnoreCase(GENERATE_STYLE)) {
                if (stringArray.length != i + 2) {
                    XsdVi.printUsage();
                    System.exit(1);
                }
                style = GENERATE_STYLE;
                styleUrl = stringArray[i + 1];
                return;
            }
            if (stringArray[i].equalsIgnoreCase(USE_STYLE)) {
                if (stringArray.length != i + 2) {
                    XsdVi.printUsage();
                    System.exit(1);
                }
                style = USE_STYLE;
                styleUrl = stringArray[i + 1];
                return;
            }
            inputs.add(stringArray[i]);
        }
        style = EMBODY_STYLE;
    }

    private static void printUsage() {
        logger.severe(USAGE);
    }

    private static XSLoader getSchemaLoader() {
        XSLoader xSLoader = null;
        try {
            System.setProperty("org.w3c.dom.DOMImplementationSourceList", "org.apache.xerces.dom.DOMXSImplementationSourceImpl");
            DOMImplementationRegistry dOMImplementationRegistry = DOMImplementationRegistry.newInstance();
            XSImplementation xSImplementation = (XSImplementation)((Object)dOMImplementationRegistry.getDOMImplementation("XS-Loader"));
            xSLoader = xSImplementation.createXSLoader(null);
            DOMConfiguration dOMConfiguration = xSLoader.getConfig();
            XsdErrorHandler xsdErrorHandler = new XsdErrorHandler();
            dOMConfiguration.setParameter("error-handler", xsdErrorHandler);
            dOMConfiguration.setParameter("validate", Boolean.TRUE);
        }
        catch (ClassCastException classCastException) {
            logger.log(Level.SEVERE, classCastException.getLocalizedMessage(), classCastException);
        }
        catch (ClassNotFoundException classNotFoundException) {
            logger.log(Level.SEVERE, classNotFoundException.getLocalizedMessage(), classNotFoundException);
        }
        catch (InstantiationException instantiationException) {
            logger.log(Level.SEVERE, instantiationException.getLocalizedMessage(), instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            logger.log(Level.SEVERE, illegalAccessException.getLocalizedMessage(), illegalAccessException);
        }
        return xSLoader;
    }
}

