/*
 * Decompiled with CFR 0.152.
 */
package xsdvi.utils;

import java.util.ArrayList;
import java.util.List;

public class TreeElement {
    private TreeElement parent;
    private List<TreeElement> children = new ArrayList<TreeElement>();

    public int getIndex() {
        if (!this.hasParent()) {
            return 1;
        }
        return this.parent.children.indexOf(this) + 1;
    }

    public TreeElement getParent() {
        return this.parent;
    }

    public void setParent(TreeElement treeElement) {
        this.parent = treeElement;
    }

    public boolean hasParent() {
        return this.parent != null;
    }

    public TreeElement getLastChild() {
        return this.children.get(this.children.size() - 1);
    }

    public boolean isLastChild() {
        if (!this.hasParent()) {
            return true;
        }
        return this.parent.children.indexOf(this) == this.parent.children.size() - 1;
    }

    public boolean isFirstChild() {
        if (!this.hasParent()) {
            return true;
        }
        return this.parent.children.indexOf(this) == 0;
    }

    public void addChild(TreeElement treeElement) {
        this.children.add(treeElement);
    }

    public List<TreeElement> getChildren() {
        return this.children;
    }

    public boolean hasChildren() {
        return !this.children.isEmpty();
    }

    public String code() {
        StringBuffer stringBuffer = new StringBuffer();
        TreeElement treeElement = this;
        while (treeElement.hasParent()) {
            stringBuffer.insert(0, treeElement.getIndex());
            stringBuffer.insert(0, '_');
            treeElement = treeElement.getParent();
        }
        stringBuffer.insert(0, "_1");
        return stringBuffer.toString();
    }
}

