/*
 * Decompiled with CFR 0.152.
 */
package xsdvi.utils;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;
import xsdvi.utils.LoggerHelper;

public class WriterHelper {
    private static final Logger logger = Logger.getLogger(LoggerHelper.LOGGER_NAME);
    private Writer writer;
    public static final String DEFAULT_CHARSET = "UTF-8";

    public WriterHelper() {
    }

    public WriterHelper(String string) {
        this.newWriter(string, DEFAULT_CHARSET);
    }

    public WriterHelper(String string, String string2) {
        this.newWriter(string, string2);
    }

    public WriterHelper(OutputStream outputStream, String string) {
        this.newWriter(outputStream, string);
    }

    public WriterHelper(Writer writer) {
        this.writer = writer;
    }

    public void close() {
        try {
            this.writer.close();
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
    }

    public Writer append(CharSequence charSequence) {
        try {
            this.writer.append(charSequence);
        }
        catch (IOException iOException) {
            logger.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
        }
        return this.writer;
    }

    public Writer getWriter() {
        return this.writer;
    }

    public void setWriter(Writer writer) {
        this.writer = writer;
    }

    public final void newWriter(String string) {
        this.newWriter(string, DEFAULT_CHARSET);
    }

    public final void newWriter(String string, String string2) {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(string);
            this.writer = new OutputStreamWriter((OutputStream)fileOutputStream, string2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.SEVERE, unsupportedEncodingException.getLocalizedMessage(), unsupportedEncodingException);
        }
        catch (FileNotFoundException fileNotFoundException) {
            logger.log(Level.SEVERE, fileNotFoundException.getLocalizedMessage(), fileNotFoundException);
        }
    }

    public final void newWriter(OutputStream outputStream, String string) {
        try {
            this.writer = new OutputStreamWriter(outputStream, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            logger.log(Level.SEVERE, unsupportedEncodingException.getLocalizedMessage(), unsupportedEncodingException);
        }
    }
}

