/*
 * Decompiled with CFR 0.152.
 */
package xsdvi.utils;

import java.util.logging.Logger;
import org.w3c.dom.DOMError;
import org.w3c.dom.DOMErrorHandler;
import xsdvi.utils.LoggerHelper;

public class XsdErrorHandler
implements DOMErrorHandler {
    private static final Logger logger = Logger.getLogger(LoggerHelper.LOGGER_NAME);

    @Override
    public boolean handleError(DOMError dOMError) {
        short s = dOMError.getSeverity();
        if (s == 3) {
            logger.severe("[xs-fatal-error]: " + this.errorMessage(dOMError));
            System.exit(1);
        } else if (s == 2) {
            logger.severe("[xs-error]: " + this.errorMessage(dOMError));
        } else if (s == 1) {
            logger.warning("[xs-warning]: " + this.errorMessage(dOMError));
        }
        return true;
    }

    private String errorMessage(DOMError dOMError) {
        return dOMError.getMessage() + " (line: " + dOMError.getLocation().getLineNumber() + ")";
    }
}

