from dataclasses import dataclass


@dataclass
class Extension:
    """
    Represents an extension

    Attributes:
        author_name (str): Name of the individual or organization that owns the Extension
        bits_enabled (bool): Whether the Extension has features that use Bits
        can_install (bool): Indicates if a user can install the Extension on their channel
            They may not be allowed if the Extension is currently in testing mode and the user is not on the allow list
        configuration_location (str): Whether the Extension configuration is hosted by the EBS or the Extensions Configuration Service
        description (str): The description of the Extension
        eula_tos_url (str): URL to the Extension’s Terms of Service
        has_chat_support (bool): Indicates if the Extension can communicate with the installed channel’s chat
        icon_url (str): The default icon to be displayed in the Extensions directory
        icon_urls (dict): The default icon in a variety of sizes
        extension_id (str): The autogenerated ID of the Extension
        name (str): The name of the Extension
        privacy_policy_url (str): URL to the Extension’s privacy policy
        request_identity_link (bool): Indicates if the Extension wants to explicitly ask viewers to link their Twitch identity
        screenshot_urls (list[str]): Screenshots to be shown in the Extensions marketplace
        state (str): The current state of the Extension
            Valid values are "InTest", "InReview", "Rejected", "Approved", "Released", "Deprecated", "PendingAction", "AssetsUploaded", "Deleted"
        subscriptions_support_level (str): Indicates if the Extension can determine a user’s subscription level on the channel the Extension is installed on
        summary (str): A brief description of the Extension
        support_email (str): The email users can use to receive Extension support
        version (str): The version of the Extension
        viewer_summary (str): A brief description displayed on the channel to explain how the Extension works
        views (dict): All configurations related to views such as: mobile, panel, video_overlay, and component
        allowlisted_config_urls (list[str]): Allow-listed configuration URLs for displaying the Extension
        allowlisted_panel_urls (list[str]): Allow-listed panel URLs for displaying the Extension
    """

    author_name: str
    bits_enabled: bool
    can_install: bool
    configuration_location: str
    description: str
    eula_tos_url: str
    has_chat_support: bool
    icon_url: str
    icon_urls: dict
    extension_id: str
    name: str
    privacy_policy_url: str
    request_identity_link: bool
    screenshot_urls: list[str]
    state: str
    subscriptions_support_level: str
    summary: str
    support_email: str
    version: str
    viewer_summary: str
    views: dict
    allowlisted_config_urls: list[str]
    allowlisted_panel_urls: list[str]
