# -*- coding: utf-8 -*-

from setuptools import setup, find_packages

longdesc = 'tgcode\r\n=======\r\n\r\n_tgcode_ is a simple library that let\'s you convert binary data into a string and vice-versa.  \r\nThis could be useful for sharing files via an IRC channel, send files via pastebin like services, make you own protocol that uses this library or anything like that.\r\n\r\n\r\nInstallation\r\n===========\r\n \r\nYou can install using the `pip` command line utility.  \r\n```\r\npip install tgcode\r\n```\r\nUsage\r\n=====\r\nIt\'s simple, just use the `encode()` and `decode()` functions, just like that:\r\n```python\r\nimport tgcode\r\n\r\ndata = b\'Hello, World!\'\r\n\r\nencoded = tgcode.encode(data)\r\n\r\ndecoded = tgcode.decode(encoded)\r\n\r\nprint(\'Are they equals: {}\'.format(decoded==data))\r\n```\r\nComplex Usage\r\n===============\r\nOkay, okay, you want more information that a snippet? Here we go:\r\n## encode()\r\nThe `encode()` encodes a binary value into a decodable string.  It receives as argument the `bytes()` that will be encoded and returns the encoded `str()`  \r\nExample:\r\n```python\r\nimport tgcode\r\n\r\ndata = b\'Hello, World!\' #bytes data to be encoded\r\n\r\nencoded_data = tgcode.encode(data) #encodes the data\r\n\r\nprint(\'Encoded bytes: {}\'.format(encoded_data)) #prints the encoded data\r\n```\r\n## decode()\r\nThe `decode()` function accepts as argument a string returned by `decode()` or `fast_decode()`. It receives as argument the `str()` that will be decoded and returns the decoded `bytes(\'\')`.  \r\nExample:\r\n```python\r\nimport tgcode\r\n\r\nencoded_data = \'_=}o\xa7}v\xa7}v\xa7}y=SG}=}y\xa7}B\xa7}v\xa7}n=H\' #the encoded string\r\n\r\ndata = tgcode.decode(encoded_data) #decodes the string\r\n\r\nfile = open(\'tgcode.test\', \'wb\') #opens a file with "write binary" flag\r\n\r\nfile.write(data) #writes the decoded data into the file\r\n\r\nfile.close() #saves the file\r\n```\r\n## fast_encode()\r\nThis function splits the data and encodes him in different threads. The arguments are exactly equals to the `encode()`\'s arguments, except for the extra `thread_quantity` argument, that are an integer (`int()`) with the amount of threads that will be used. **JUST** use this function for binaries biggest than the number of threads, like files or big messages. The default `thread_quantity` value are 35.  \r\nExample:\r\n```python\r\nimport tgcode\r\n\r\nfile = open(\'tgcode.test\', \'rb\') #opens the file with "read binary" flag\r\n\r\ndata = file.read() #reads the data\r\n\r\nfast_encoded = tgcode.fast_encode(data) #fastly encodes the data\r\n\r\nfile.close() #closes the file\r\n\r\nprint(\'Fastly encoded data: {}\'.format(fast_encoded)) #prints the encoded data\r\n```\r\nLicense\r\n===========\r\nMIT license\r\n```\r\nCopyright (c) 2016\r\n\r\n Permission is hereby granted, free of charge, to any person obtaining a copy\r\n of this software and associated documentation files (the "Software"), to deal\r\n in the Software without restriction, including without limitation the rights\r\n to use, copy, modify, merge, publish, distribute, sublicense, and/or sell\r\n copies of the Software, and to permit persons to whom the Software is\r\n furnished to do so, subject to the following conditions:\r\n\r\n The above copyright  notice and this permission notice shall be included in\r\n all copies or substantial portions of the Software.\r\n\r\n THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\r\n OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\r\n THE SOFTWARE. \r\n ```notice and this permission notice shall be included in\r\n all copies or substantial portions of the Software.\r\n\r\n THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR\r\n IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,\r\n FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE\r\n AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER\r\n LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,\r\n OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN\r\n THE SOFTWARE. \r\n ```\r\nAuthor\r\n=====\r\nThe author of this tool wants to be called as "thegamerbr1". In case of bugs, ideas or help, contact:\r\n- Skype: xthegamerbr1x\r\n- Telegram: @thegamerbr1\r\n- Email (slow response): xthegamerbr1x@gmail.com'

setup(
    name = "TGCode",
    version = "0.2",
    packages = find_packages(),
    author = "thegamerbr1",
    author_email = "xthegamerbr1x@gmail.com",
    description = "TGCode is a simple library that let's you convert binary data into a string and vice-versa.",
    license = "MIT",
    long_description = longdesc,
    keywords = "encoding binary bytes string data irc file bin convert ",
)