/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.compress.utils;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class ByteUtils {
    public static final byte[] EMPTY_BYTE_ARRAY = new byte[0];

    private ByteUtils() {
    }

    public static long fromLittleEndian(byte[] bytes2) {
        return ByteUtils.fromLittleEndian(bytes2, 0, bytes2.length);
    }

    public static long fromLittleEndian(byte[] bytes2, int off, int length2) {
        ByteUtils.checkReadLength(length2);
        long l = 0L;
        for (int i = 0; i < length2; ++i) {
            l |= ((long)bytes2[off + i] & 0xFFL) << 8 * i;
        }
        return l;
    }

    public static long fromLittleEndian(InputStream in, int length2) throws IOException {
        ByteUtils.checkReadLength(length2);
        long l = 0L;
        for (int i = 0; i < length2; ++i) {
            long b = in.read();
            if (b == -1L) {
                throw new IOException("Premature end of data");
            }
            l |= b << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(ByteSupplier supplier, int length2) throws IOException {
        ByteUtils.checkReadLength(length2);
        long l = 0L;
        for (int i = 0; i < length2; ++i) {
            long b = supplier.getAsByte();
            if (b == -1L) {
                throw new IOException("Premature end of data");
            }
            l |= b << i * 8;
        }
        return l;
    }

    public static long fromLittleEndian(DataInput in, int length2) throws IOException {
        ByteUtils.checkReadLength(length2);
        long l = 0L;
        for (int i = 0; i < length2; ++i) {
            long b = in.readUnsignedByte();
            l |= b << i * 8;
        }
        return l;
    }

    public static void toLittleEndian(byte[] b, long value2, int off, int length2) {
        long num = value2;
        for (int i = 0; i < length2; ++i) {
            b[off + i] = (byte)(num & 0xFFL);
            num >>= 8;
        }
    }

    public static void toLittleEndian(OutputStream out2, long value2, int length2) throws IOException {
        long num = value2;
        for (int i = 0; i < length2; ++i) {
            out2.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(ByteConsumer consumer2, long value2, int length2) throws IOException {
        long num = value2;
        for (int i = 0; i < length2; ++i) {
            consumer2.accept((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    public static void toLittleEndian(DataOutput out2, long value2, int length2) throws IOException {
        long num = value2;
        for (int i = 0; i < length2; ++i) {
            out2.write((int)(num & 0xFFL));
            num >>= 8;
        }
    }

    private static void checkReadLength(int length2) {
        if (length2 > 8) {
            throw new IllegalArgumentException("Can't read more than eight bytes into a long value");
        }
    }

    public static class OutputStreamByteConsumer
    implements ByteConsumer {
        private final OutputStream os;

        public OutputStreamByteConsumer(OutputStream os) {
            this.os = os;
        }

        @Override
        public void accept(int b) throws IOException {
            this.os.write(b);
        }
    }

    public static class InputStreamByteSupplier
    implements ByteSupplier {
        private final InputStream is;

        public InputStreamByteSupplier(InputStream is) {
            this.is = is;
        }

        @Override
        public int getAsByte() throws IOException {
            return this.is.read();
        }
    }

    public static interface ByteConsumer {
        public void accept(int var1) throws IOException;
    }

    public static interface ByteSupplier {
        public int getAsByte() throws IOException;
    }
}

