/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import algorithms.UnionFind;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import spec.cvlast.CVLEnumType;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLInbuiltSimpleTypes;
import spec.cvlast.CVLInbuiltStructTypes;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeConversions;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\tJ\u0015\u0010\u000e\u001a\u00020\u000b*\u00020\t2\u0006\u0010\u000f\u001a\u00020\tH\u0082\u0004R \u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lspec/cvlast/CVLTypeCheckerSettings;", "", "()V", "allowedImplicitTwoWayTypeConversions", "", "Lkotlin/Pair;", "Lspec/cvlast/CVLSimpleType$Inbuilt;", "allowedImplicitTwoWayTypeConversionsClosure", "Lalgorithms/UnionFind;", "Lspec/cvlast/CVLType;", "isImplicitConversionAllowed", "", "t1", "t2", "equiv", "other", "Shared"})
public final class CVLTypeCheckerSettings {
    @NotNull
    public static final CVLTypeCheckerSettings INSTANCE = new CVLTypeCheckerSettings();
    @NotNull
    private static final Set<Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>> allowedImplicitTwoWayTypeConversions;
    @NotNull
    private static final UnionFind<CVLType> allowedImplicitTwoWayTypeConversionsClosure;

    private CVLTypeCheckerSettings() {
    }

    private final boolean equiv(CVLType $this$equiv, CVLType other) {
        return allowedImplicitTwoWayTypeConversionsClosure.areEqual($this$equiv, other);
    }

    public final boolean isImplicitConversionAllowed(@NotNull CVLType t1, @NotNull CVLType t2) {
        CVLInbuiltSimpleTypes t2AsInbuilt;
        Intrinsics.checkNotNullParameter(t1, "t1");
        Intrinsics.checkNotNullParameter(t2, "t2");
        if (this.equiv(t1, t2)) {
            return true;
        }
        CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible cVLInbuiltSimpleTypesConvertible = t1 instanceof CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible ? (CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)((Object)t1) : null;
        CVLInbuiltSimpleTypes t1AsInbuilt = cVLInbuiltSimpleTypesConvertible == null ? null : cVLInbuiltSimpleTypesConvertible.toCVLInbuiltSimpleTypes();
        CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible cVLInbuiltSimpleTypesConvertible2 = t2 instanceof CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible ? (CVLInbuiltSimpleTypes.CVLInbuiltSimpleTypesConvertible)((Object)t2) : null;
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes = t2AsInbuilt = cVLInbuiltSimpleTypesConvertible2 == null ? null : cVLInbuiltSimpleTypesConvertible2.toCVLInbuiltSimpleTypes();
        if (t1AsInbuilt instanceof CVLInbuiltSimpleTypes.EVMArray && t2AsInbuilt instanceof CVLInbuiltSimpleTypes.EVMArray && Intrinsics.areEqual(((CVLInbuiltSimpleTypes.EVMArray)t1AsInbuilt).getSolidityDims(), ((CVLInbuiltSimpleTypes.EVMArray)t2AsInbuilt).getSolidityDims())) {
            return this.isImplicitConversionAllowed(((CVLInbuiltSimpleTypes.EVMArray)t1AsInbuilt).getBaseType().getCvlType(), ((CVLInbuiltSimpleTypes.EVMArray)t2AsInbuilt).getBaseType().getCvlType());
        }
        CVLInbuiltStructTypes t1AsInbuiltStruct = CVLInbuiltStructTypes.Companion.valueFromCvlType(t1);
        CVLInbuiltStructTypes t2AsInbuiltStruct = CVLInbuiltStructTypes.Companion.valueFromCvlType(t2);
        if (t1 instanceof CVLFunctionType && t2AsInbuiltStruct == CVLInbuiltStructTypes.methodType) {
            return false;
        }
        if (this.equiv(t1, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE.getCvlType()) && t2AsInbuilt != null && CVLTypeConversions.INSTANCE.isConvertibleToArithmeticType(t2AsInbuilt.getCvlType())) {
            return true;
        }
        if (this.equiv(t1, CVLInbuiltSimpleTypes.numberLiteral.INSTANCE.getCvlType()) && this.equiv(t2, CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType())) {
            return true;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes2 = t1AsInbuilt;
        if ((cVLInbuiltSimpleTypes2 == null ? null : cVLInbuiltSimpleTypes2.getUintSize()) != null) {
            CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes3 = t2AsInbuilt;
            if ((cVLInbuiltSimpleTypes3 == null ? null : cVLInbuiltSimpleTypes3.getUintSize()) != null && t1AsInbuilt.getUintSize() <= t2AsInbuilt.getUintSize()) {
                return true;
            }
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes4 = t1AsInbuilt;
        if ((cVLInbuiltSimpleTypes4 == null ? null : cVLInbuiltSimpleTypes4.getUintSize()) != null && t1AsInbuilt.getUintSize() <= 160 && this.equiv(t2, CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType())) {
            return true;
        }
        if (this.equiv(t1, CVLInbuiltSimpleTypes.address.INSTANCE.getCvlType()) && this.equiv(t2, CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType())) {
            return true;
        }
        CVLInbuiltSimpleTypes cVLInbuiltSimpleTypes5 = t1AsInbuilt;
        if ((cVLInbuiltSimpleTypes5 == null ? null : cVLInbuiltSimpleTypes5.getUintSize()) != null && this.equiv(t2, CVLInbuiltSimpleTypes.mathint.INSTANCE.getCvlType())) {
            return true;
        }
        if (t2 instanceof CVLEnumType) {
            if (t1 instanceof CVLEnumType) {
                return Intrinsics.areEqual(t1, t2);
            }
            if (t1.isConvertibleTo(CVLSimpleType.Companion.buildSimpleType$Shared(CVLInbuiltSimpleTypes.Companion.uint(8)))) {
                return true;
            }
        }
        return false;
    }

    static {
        Pair[] pairArray = new Pair[]{new Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>(CVLInbuiltSimpleTypes.uint.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.uint(256).getCvlType()), new Pair<CVLSimpleType.Inbuilt, CVLSimpleType.Inbuilt>(CVLInbuiltSimpleTypes.int.INSTANCE.getCvlType(), CVLInbuiltSimpleTypes.Companion.int(256).getCvlType())};
        allowedImplicitTwoWayTypeConversions = SetsKt.setOf(pairArray);
        UnionFind<CVLSimpleType.Inbuilt> uf = new UnionFind<CVLSimpleType.Inbuilt>();
        Iterable $this$forEach$iv = allowedImplicitTwoWayTypeConversions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Pair $dstr$l$r = (Pair)element$iv;
            boolean bl = false;
            CVLSimpleType.Inbuilt l = (CVLSimpleType.Inbuilt)$dstr$l$r.component1();
            CVLSimpleType.Inbuilt r = (CVLSimpleType.Inbuilt)$dstr$l$r.component2();
            uf.union(l, r);
        }
        allowedImplicitTwoWayTypeConversionsClosure = uf;
    }
}

