/*
 * Decompiled with CFR 0.152.
 */
package spec.cvlast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import spec.CVLErrorLogger;
import spec.StandardCVLErrorLogger;
import spec.cvlast.CVLErrorType;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLFunctionType;
import spec.cvlast.CVLLhs;
import spec.cvlast.CVLLocation;
import spec.cvlast.CVLMappingType;
import spec.cvlast.CVLScope;
import spec.cvlast.CVLSimpleType;
import spec.cvlast.CVLStructType;
import spec.cvlast.CVLSymbolTable;
import spec.cvlast.CVLType;
import spec.cvlast.CVLTypeTypeChecker;
import spec.cvlast.HasCVLErrorLogger;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J4\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J4\u0010\t\u001a\u00020\u00142\u0006\u0010\u000b\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J4\u0010\t\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J*\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00122\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lspec/cvlast/CVLTypeTypeChecker;", "Lspec/cvlast/HasCVLErrorLogger;", "symbolTable", "Lspec/cvlast/CVLSymbolTable;", "errorLogger", "Lspec/CVLErrorLogger;", "(Lspec/cvlast/CVLSymbolTable;Lspec/CVLErrorLogger;)V", "getErrorLogger", "()Lspec/CVLErrorLogger;", "typeCheck", "Lspec/cvlast/CVLFunctionType;", "type", "loc", "Lspec/cvlast/CVLLocation;", "scope", "Lspec/cvlast/CVLScope;", "check", "Lkotlin/Function1;", "Lspec/cvlast/CVLType;", "", "Lspec/cvlast/CVLMappingType;", "typeCheckNoCVLStructTypes", "exp", "Lspec/cvlast/CVLExp;", "Shared"})
public final class CVLTypeTypeChecker
implements HasCVLErrorLogger {
    @NotNull
    private final CVLSymbolTable symbolTable;
    @NotNull
    private final CVLErrorLogger errorLogger;

    public CVLTypeTypeChecker(@NotNull CVLSymbolTable symbolTable, @NotNull CVLErrorLogger errorLogger) {
        Intrinsics.checkNotNullParameter(symbolTable, "symbolTable");
        Intrinsics.checkNotNullParameter(errorLogger, "errorLogger");
        this.symbolTable = symbolTable;
        this.errorLogger = errorLogger;
    }

    public /* synthetic */ CVLTypeTypeChecker(CVLSymbolTable cVLSymbolTable, CVLErrorLogger cVLErrorLogger, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            cVLErrorLogger = StandardCVLErrorLogger.INSTANCE;
        }
        this(cVLSymbolTable, cVLErrorLogger);
    }

    @Override
    @NotNull
    public CVLErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final CVLType typeCheck(@NotNull CVLType type, @NotNull CVLLocation loc, @NotNull CVLScope scope, @NotNull Function1<? super CVLType, Unit> check2) {
        CVLType cVLType;
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Intrinsics.checkNotNullParameter(check2, "check");
        if (type instanceof CVLSimpleType.UninterpretedSort) {
            CVLSymbolTable.SymbolInfo symbolInfo = this.symbolTable.lookUpNonFunctionLikeSymbol(((CVLSimpleType.UninterpretedSort)type).getName(), scope);
            if (!Intrinsics.areEqual(symbolInfo == null ? null : symbolInfo.getCVLType(), type)) {
                cVLType = this.getErrorLogger().typeError(new CVLExp.VariableExp(((CVLSimpleType.UninterpretedSort)type).getName(), false, 2, null), loc, "Cannot resolve sort \"" + ((CVLSimpleType.UninterpretedSort)type).getName() + "\"");
                return cVLType;
            }
        }
        if (type instanceof CVLMappingType) {
            cVLType = this.typeCheck((CVLMappingType)type, loc, scope, check2);
            return cVLType;
        }
        CVLType cVLType2 = type instanceof CVLFunctionType ? (CVLType)this.typeCheck((CVLFunctionType)type, loc, scope, check2) : type;
        check2.invoke(cVLType2);
        cVLType = cVLType2;
        return cVLType;
    }

    public static /* synthetic */ CVLType typeCheck$default(CVLTypeTypeChecker cVLTypeTypeChecker, CVLType cVLType, CVLLocation cVLLocation, CVLScope cVLScope, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = typeCheck.1.INSTANCE;
        }
        return cVLTypeTypeChecker.typeCheck(cVLType, cVLLocation, cVLScope, (Function1<? super CVLType, Unit>)function1);
    }

    @NotNull
    public final CVLType typeCheckNoCVLStructTypes(@NotNull CVLType type, @NotNull CVLLocation loc, @NotNull CVLScope scope, @Nullable CVLExp exp) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(scope, "scope");
        return this.typeCheck(type, loc, scope, (Function1<? super CVLType, Unit>)new Function1<CVLType, Unit>(this, exp, type, loc){
            final /* synthetic */ CVLTypeTypeChecker this$0;
            final /* synthetic */ CVLExp $exp;
            final /* synthetic */ CVLType $type;
            final /* synthetic */ CVLLocation $loc;
            {
                this.this$0 = $receiver;
                this.$exp = $exp;
                this.$type = $type;
                this.$loc = $loc;
                super(1);
            }

            public final void invoke(@NotNull CVLType t2) {
                Intrinsics.checkNotNullParameter(t2, "t");
                if (t2 instanceof CVLStructType) {
                    CVLErrorLogger cVLErrorLogger = this.this$0.getErrorLogger();
                    CVLExp cVLExp = this.$exp;
                    if (cVLExp == null) {
                        cVLExp = new CVLExp.VariableExp(this.$type.toString(), false, 2, null);
                    }
                    cVLErrorLogger.typeError(cVLExp, this.$loc, "Struct type " + t2 + " is not allowed here.");
                }
            }
        });
    }

    public static /* synthetic */ CVLType typeCheckNoCVLStructTypes$default(CVLTypeTypeChecker cVLTypeTypeChecker, CVLType cVLType, CVLLocation cVLLocation, CVLScope cVLScope, CVLExp cVLExp, int n, Object object) {
        if ((n & 8) != 0) {
            cVLExp = null;
        }
        return cVLTypeTypeChecker.typeCheckNoCVLStructTypes(cVLType, cVLLocation, cVLScope, cVLExp);
    }

    @NotNull
    public final CVLMappingType typeCheck(@NotNull CVLMappingType type, @NotNull CVLLocation loc, @NotNull CVLScope scope, @NotNull Function1<? super CVLType, Unit> check2) {
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Intrinsics.checkNotNullParameter(check2, "check");
        return new CVLMappingType(this.typeCheck(type.getDomain(), loc, scope, check2), this.typeCheck(type.getCodomain(), loc, scope, check2));
    }

    public static /* synthetic */ CVLMappingType typeCheck$default(CVLTypeTypeChecker cVLTypeTypeChecker, CVLMappingType cVLMappingType, CVLLocation cVLLocation, CVLScope cVLScope, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = typeCheck.2.INSTANCE;
        }
        return cVLTypeTypeChecker.typeCheck(cVLMappingType, cVLLocation, cVLScope, (Function1<? super CVLType, Unit>)function1);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final CVLFunctionType typeCheck(@NotNull CVLFunctionType type, @NotNull CVLLocation loc, @NotNull CVLScope scope, @NotNull Function1<? super CVLType, Unit> check2) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter(type, "type");
        Intrinsics.checkNotNullParameter(loc, "loc");
        Intrinsics.checkNotNullParameter(scope, "scope");
        Intrinsics.checkNotNullParameter(check2, "check");
        Iterable $this$map$iv = type.getParamTypes();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void t2;
            CVLType cVLType = (CVLType)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.typeCheck((CVLType)t2, loc, scope, check2));
        }
        CVLType cVLType = this.typeCheck(type.getResultType(), loc, scope, check2);
        List list = (List)destination$iv$iv;
        return new CVLFunctionType(list, cVLType);
    }

    public static /* synthetic */ CVLFunctionType typeCheck$default(CVLTypeTypeChecker cVLTypeTypeChecker, CVLFunctionType cVLFunctionType, CVLLocation cVLLocation, CVLScope cVLScope, Function1 function1, int n, Object object) {
        if ((n & 8) != 0) {
            function1 = typeCheck.3.INSTANCE;
        }
        return cVLTypeTypeChecker.typeCheck(cVLFunctionType, cVLLocation, cVLScope, (Function1<? super CVLType, Unit>)function1);
    }

    @Override
    public void syntaxError(@NotNull CVLLocation loc, @NotNull String message) {
        HasCVLErrorLogger.DefaultImpls.syntaxError(this, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLLhs lhs, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, lhs, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc, @NotNull String message) {
        return HasCVLErrorLogger.DefaultImpls.typeError((HasCVLErrorLogger)this, exp, loc, message);
    }

    @Override
    @NotNull
    public CVLErrorType typeError(@NotNull CVLExp exp, @NotNull CVLLocation loc) {
        return HasCVLErrorLogger.DefaultImpls.typeError(this, exp, loc);
    }
}

