/*
 * Decompiled with CFR 0.152.
 */
package parallel;

import java.io.Closeable;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ForkJoinPool;
import java.util.concurrent.ForkJoinTask;
import java.util.concurrent.ForkJoinWorkerThread;
import java.util.concurrent.RecursiveTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.ExecutorCoroutineDispatcher;
import kotlinx.coroutines.ExecutorsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import parallel.CancellableJob;
import parallel.CompleteJob;
import parallel.Parallel;
import parallel.ParallelPool;
import parallel.ParallelPoolKt;
import parallel.PreserveDepsOrder;
import parallel.Scheduler;
import utils.ExtStdlibKt;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 \u001c2\u00020\u0001:\t\u001c\u001d\u001e\u001f !\"#$B\u0017\b\u0012\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0011\b\u0016\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B\u0017\b\u0002\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0006\u0010\u000e\u001a\u00020\u000fJ\b\u0010\u0010\u001a\u00020\u0011H\u0016J\u001f\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u00130\u0015\u00a2\u0006\u0002\u0010\u0016J0\u0010\u0012\u001a\u0002H\u0013\"\u0004\b\u0000\u0010\u00132\u001d\u0010\u0017\u001a\u0019\u0012\u0004\u0012\u00020\u0019\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00130\u00150\u0018\u00a2\u0006\u0002\b\u001a\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lparallel/ParallelPool;", "Ljava/io/Closeable;", "workerThreads", "", "poolFactory", "Lparallel/ParallelPool$PoolFactory;", "(ILparallel/ParallelPool$PoolFactory;)V", "(I)V", "forkJoinPool", "Ljava/util/concurrent/ForkJoinPool;", "ioPool", "Ljava/util/concurrent/ExecutorService;", "(Ljava/util/concurrent/ForkJoinPool;Ljava/util/concurrent/ExecutorService;)V", "workerThreadPool", "asCoroutineDispatcher", "Lkotlinx/coroutines/ExecutorCoroutineDispatcher;", "close", "", "run", "T", "x", "Lparallel/Parallel;", "(Lparallel/Parallel;)Ljava/lang/Object;", "f", "Lkotlin/Function1;", "Lparallel/Scheduler;", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "Companion", "ObjectReference", "ParallelPoolWorkerThread", "PoolFactory", "ResourceKey", "SchedulingTask", "SimpleScheduler", "SpawnPolicy", "TaskQueue", "GeneralUtils"})
public final class ParallelPool
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ExecutorService ioPool;
    @NotNull
    private final ForkJoinPool workerThreadPool;
    @NotNull
    private static final Lazy<ParallelPool> globalPool$delegate = LazyKt.lazy(Companion.globalPool.2.INSTANCE);
    @NotNull
    private static final Map<ParallelPool, Map<ResourceKey<?, ?>, ObjectReference<?>>> scopeMap = new IdentityHashMap();

    private ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool) {
        this.ioPool = ioPool;
        this.workerThreadPool = forkJoinPool;
    }

    private ParallelPool(int workerThreads, PoolFactory poolFactory) {
        ForkJoinPool forkJoinPool = new ForkJoinPool(workerThreads, poolFactory, null, false, 0, Integer.MAX_VALUE, 1, ParallelPool::_init_$lambda-0, 60L, TimeUnit.SECONDS);
        ExecutorService executorService = Executors.newCachedThreadPool();
        Intrinsics.checkNotNullExpressionValue(executorService, "newCachedThreadPool()");
        this(forkJoinPool, executorService);
        poolFactory.setParallelPool(this);
    }

    public ParallelPool(int workerThreads) {
        this(workerThreads, new PoolFactory());
    }

    public /* synthetic */ ParallelPool(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            String string2 = System.getProperty("cvt.default.parallelism");
            Integer n3 = string2 == null ? null : StringsKt.toIntOrNull(string2);
            n = n3 == null ? Runtime.getRuntime().availableProcessors() : n3.intValue();
        }
        this(n);
    }

    @NotNull
    public final ExecutorCoroutineDispatcher asCoroutineDispatcher() {
        return ExecutorsKt.from(this.workerThreadPool);
    }

    public final <T> T run(@NotNull Function1<? super Scheduler, ? extends Parallel<? extends T>> f) {
        Intrinsics.checkNotNullParameter(f, "f");
        Parallel<? extends T> x = f.invoke(Scheduler.INSTANCE);
        return this.run(x);
    }

    public final <T> T run(@NotNull Parallel<? extends T> x) {
        Intrinsics.checkNotNullParameter(x, "x");
        if (x instanceof CompleteJob) {
            return x.getResult();
        }
        if (System.getProperty("cvt.simple.parallel") == null) {
            ForkJoinTask submit = this.workerThreadPool.submit(new SchedulingTask(x, false, null, 4, null));
            try {
                submit.get();
            }
            catch (InterruptedException i) {
                Intrinsics.checkNotNullExpressionValue(submit, "submit");
                ParallelPool.run$exceptional(this, x, submit, i);
            }
            return x.getResult();
        }
        new SimpleScheduler().resolve(x);
        return x.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        this.workerThreadPool.shutdownNow();
        this.workerThreadPool.awaitQuiescence(10L, TimeUnit.MILLISECONDS);
        this.ioPool.shutdownNow();
        Map<ParallelPool, Map<ResourceKey<?, ?>, ObjectReference<?>>> map2 = scopeMap;
        synchronized (map2) {
            boolean bl = false;
            Map<ResourceKey<?, ?>, ObjectReference<?>> map3 = scopeMap.remove(this);
        }
    }

    private static final boolean _init_$lambda-0(ForkJoinPool $noName_0) {
        Intrinsics.checkNotNullParameter($noName_0, "$noName_0");
        return true;
    }

    private static final <T> void run$exceptional(ParallelPool this$0, Parallel<? extends T> $x, ForkJoinTask<?> submit, Exception e) {
        ParallelPoolKt.access$getLogger$p().warn(e, (Function0<? extends Object>)new Function0<Object>($x){
            final /* synthetic */ Parallel<T> $x;
            {
                this.$x = $x;
                super(0);
            }

            @NotNull
            public final Object invoke() {
                return "Failed to run task " + this.$x;
            }
        });
        this$0.workerThreadPool.shutdown();
        this$0.ioPool.shutdownNow();
        submit.get();
        this$0.close();
    }

    public /* synthetic */ ParallelPool(ForkJoinPool forkJoinPool, ExecutorService ioPool, DefaultConstructorMarker $constructor_marker) {
        this(forkJoinPool, ioPool);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u0016R\u001a\u0010\u0003\u001a\u00020\u0004X\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lparallel/ParallelPool$PoolFactory;", "Ljava/util/concurrent/ForkJoinPool$ForkJoinWorkerThreadFactory;", "()V", "parallelPool", "Lparallel/ParallelPool;", "getParallelPool", "()Lparallel/ParallelPool;", "setParallelPool", "(Lparallel/ParallelPool;)V", "newThread", "Ljava/util/concurrent/ForkJoinWorkerThread;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "GeneralUtils"})
    private static final class PoolFactory
    implements ForkJoinPool.ForkJoinWorkerThreadFactory {
        public ParallelPool parallelPool;

        @NotNull
        public final ParallelPool getParallelPool() {
            ParallelPool parallelPool = this.parallelPool;
            if (parallelPool != null) {
                return parallelPool;
            }
            Intrinsics.throwUninitializedPropertyAccessException("parallelPool");
            return null;
        }

        public final void setParallelPool(@NotNull ParallelPool parallelPool) {
            Intrinsics.checkNotNullParameter(parallelPool, "<set-?>");
            this.parallelPool = parallelPool;
        }

        @Override
        @NotNull
        public ForkJoinWorkerThread newThread(@Nullable ForkJoinPool pool) {
            ParallelPool parallelPool = this.getParallelPool();
            ForkJoinPool forkJoinPool = pool;
            Intrinsics.checkNotNull(forkJoinPool);
            return new ParallelPoolWorkerThread(parallelPool, forkJoinPool);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$ParallelPoolWorkerThread;", "Ljava/util/concurrent/ForkJoinWorkerThread;", "parallelPool", "Lparallel/ParallelPool;", "pool", "Ljava/util/concurrent/ForkJoinPool;", "(Lparallel/ParallelPool;Ljava/util/concurrent/ForkJoinPool;)V", "getParallelPool", "()Lparallel/ParallelPool;", "GeneralUtils"})
    public static final class ParallelPoolWorkerThread
    extends ForkJoinWorkerThread {
        @NotNull
        private final ParallelPool parallelPool;

        public ParallelPoolWorkerThread(@NotNull ParallelPool parallelPool, @NotNull ForkJoinPool pool) {
            Intrinsics.checkNotNullParameter(parallelPool, "parallelPool");
            Intrinsics.checkNotNullParameter(pool, "pool");
            super(pool);
            this.parallelPool = parallelPool;
        }

        @NotNull
        public final ParallelPool getParallelPool() {
            return this.parallelPool;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\n\u0010\u0005\u001a\u0006\u0012\u0002\b\u00030\u0006\u00a8\u0006\u0007"}, d2={"Lparallel/ParallelPool$SimpleScheduler;", "", "(Lparallel/ParallelPool;)V", "resolve", "", "v", "Lparallel/Parallel;", "GeneralUtils"})
    private final class SimpleScheduler {
        public SimpleScheduler() {
            Intrinsics.checkNotNullParameter(ParallelPool.this, "this$0");
        }

        public final void resolve(@NotNull Parallel<?> v) {
            Intrinsics.checkNotNullParameter(v, "v");
            Parallel[] parallelArray = new Parallel[]{v};
            List<Parallel> depQueue = CollectionsKt.mutableListOf(parallelArray);
            List execQueue = new ArrayList();
            block0: while (!((Collection)depQueue).isEmpty() || !((Collection)execQueue).isEmpty()) {
                while (!((Collection)depQueue).isEmpty()) {
                    Parallel j = ExtStdlibKt.removeLast(depQueue);
                    execQueue.add(j);
                    depQueue.addAll((Collection<Parallel>)j.getDeps());
                }
                while (!((Collection)execQueue).isEmpty()) {
                    Parallel exec = (Parallel)ExtStdlibKt.removeLast(execQueue);
                    if (!exec.getRunnable()) {
                        String string2 = "Check failed.";
                        throw new IllegalStateException(string2.toString());
                    }
                    List<Parallel<?>> res2 = exec.queueSchedule(ParallelPool.this.ioPool);
                    if (!(exec.done() || !((Collection)res2).isEmpty())) {
                        String string3 = "Check failed.";
                        throw new IllegalStateException(string3.toString());
                    }
                    depQueue.addAll((Collection<Parallel>)res2);
                    if (!(!((Collection)depQueue).isEmpty())) continue;
                    continue block0;
                }
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u001f\u0012\u0010\u0010\u0002\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0018\u0010\u0019\u001a\u0012 \u001a*\b\u0018\u00010\u000eR\u00020\u000f0\u000eR\u00020\u000fH\u0002J\u0016\u0010\u001b\u001a\u0012\u0012\f\u0012\n \u001a*\u0004\u0018\u00010\u001d0\u001d\u0018\u00010\u001cJ\u0006\u0010\u001e\u001a\u00020\u001dR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001b\u0010\f\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0016\u001a\f\u0012\b\u0012\u00060\u000eR\u00020\u000f0\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001f"}, d2={"Lparallel/ParallelPool$TaskQueue;", "", "parallels", "", "Lparallel/Parallel;", "cancelFlag", "", "(Lparallel/ParallelPool;Ljava/util/List;Z)V", "lock", "Ljava/lang/Object;", "getLock", "()Ljava/lang/Object;", "queue", "Ljava/util/ArrayDeque;", "Lparallel/ParallelPool$SchedulingTask;", "Lparallel/ParallelPool;", "getQueue", "()Ljava/util/ArrayDeque;", "runByMain", "", "getRunByMain", "()Ljava/util/Set;", "tasks", "getTasks", "()Ljava/util/List;", "first", "kotlin.jvm.PlatformType", "forkNext", "Ljava/util/concurrent/ForkJoinTask;", "", "runAll", "GeneralUtils"})
    private final class TaskQueue {
        @NotNull
        private final List<SchedulingTask> tasks;
        @NotNull
        private final ArrayDeque<SchedulingTask> queue;
        @NotNull
        private final Set<SchedulingTask> runByMain;
        @NotNull
        private final Object lock;

        /*
         * WARNING - void declaration
         */
        public TaskQueue(List<? extends Parallel<?>> parallels, boolean cancelFlag) {
            void it;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(ParallelPool.this, "this$0");
            Intrinsics.checkNotNullParameter(parallels, "parallels");
            ArrayDeque arrayDeque = (ArrayDeque)((Object)parallels);
            Object object = ParallelPool.this;
            TaskQueue taskQueue = this;
            boolean $i$f$map = false;
            void var7_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it2;
                Parallel parallel = (Parallel)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add((ParallelPool)object.new SchedulingTask((Parallel<?>)it2, cancelFlag, this));
            }
            taskQueue.tasks = (List)destination$iv$iv;
            arrayDeque = new ArrayDeque();
            object = arrayDeque;
            taskQueue = this;
            boolean bl = false;
            it.addAll((Collection)this.getTasks());
            taskQueue.queue = arrayDeque;
            this.runByMain = new LinkedHashSet();
            this.lock = new Object();
        }

        @NotNull
        public final List<SchedulingTask> getTasks() {
            return this.tasks;
        }

        @NotNull
        public final ArrayDeque<SchedulingTask> getQueue() {
            return this.queue;
        }

        @NotNull
        public final Set<SchedulingTask> getRunByMain() {
            return this.runByMain;
        }

        @NotNull
        public final Object getLock() {
            return this.lock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final SchedulingTask first() {
            SchedulingTask schedulingTask;
            Object object = this.lock;
            synchronized (object) {
                boolean bl = false;
                schedulingTask = this.getQueue().pollFirst();
            }
            return schedulingTask;
        }

        @Nullable
        public final ForkJoinTask<Unit> forkNext() {
            SchedulingTask schedulingTask = this.first();
            return schedulingTask == null ? null : schedulingTask.fork();
        }

        /*
         * WARNING - void declaration
         */
        public final void runAll() {
            void $this$filterNotTo$iv$iv;
            boolean firstTime = true;
            while (true) {
                SchedulingTask nextTask = this.first();
                if (firstTime) {
                    firstTime = false;
                    SchedulingTask schedulingTask = this.first();
                    if (schedulingTask != null) {
                        schedulingTask.fork();
                    }
                }
                if (nextTask == null) break;
                this.runByMain.add(nextTask);
                nextTask.computeWithoutFork();
            }
            Iterable $this$filterNot$iv = this.tasks;
            boolean $i$f$filterNot = false;
            Iterable iterable = $this$filterNot$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterNotTo = false;
            for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                SchedulingTask it = (SchedulingTask)element$iv$iv;
                boolean bl = false;
                if (this.getRunByMain().contains(it)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable $this$forEach$iv = CollectionsKt.reversed((List)destination$iv$iv);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                SchedulingTask it = (SchedulingTask)element$iv;
                boolean bl = false;
                it.join();
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0082\u0004\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B)\u0012\n\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u000e\b\u0002\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\t\u00a2\u0006\u0002\u0010\nJ\b\u0010\u000b\u001a\u00020\u0002H\u0002J\b\u0010\f\u001a\u00020\u0002H\u0016J\u0006\u0010\r\u001a\u00020\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0018\u00010\bR\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0003\u001a\u0006\u0012\u0002\b\u00030\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lparallel/ParallelPool$SchedulingTask;", "Ljava/util/concurrent/RecursiveTask;", "", "v", "Lparallel/Parallel;", "cancelFlag", "", "queue", "Lparallel/ParallelPool$TaskQueue;", "Lparallel/ParallelPool;", "(Lparallel/ParallelPool;Lparallel/Parallel;ZLparallel/ParallelPool$TaskQueue;)V", "checkCancellation", "compute", "computeWithoutFork", "GeneralUtils"})
    private final class SchedulingTask
    extends RecursiveTask<Unit> {
        @NotNull
        private final Parallel<?> v;
        private final boolean cancelFlag;
        @Nullable
        private final TaskQueue queue;

        public SchedulingTask(Parallel<?> v, @Nullable boolean cancelFlag, TaskQueue queue) {
            Intrinsics.checkNotNullParameter(ParallelPool.this, "this$0");
            Intrinsics.checkNotNullParameter(v, "v");
            this.v = v;
            this.cancelFlag = cancelFlag;
            this.queue = queue;
        }

        public /* synthetic */ SchedulingTask(Parallel parallel, boolean bl, TaskQueue taskQueue, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                taskQueue = null;
            }
            this(parallel, bl, taskQueue);
        }

        private final void checkCancellation() {
            if (this.cancelFlag && ForkJoinTask.inForkJoinPool() && ForkJoinTask.getPool().isShutdown()) {
                throw new CancellationException();
            }
        }

        @Override
        public void compute() {
            this.checkCancellation();
            TaskQueue taskQueue = this.queue;
            if (taskQueue != null) {
                taskQueue.forkNext();
            }
            this.computeWithoutFork();
        }

        public final void computeWithoutFork() {
            Parallel it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            boolean $i$f$mapTo;
            Collection destination$iv$iv;
            Iterable $this$map$iv;
            boolean $i$f$map;
            Object object;
            this.checkCancellation();
            if (!this.v.getRunnable()) {
                List<Parallel<?>> deps = this.v.getDeps();
                if (!(!((Collection)deps).isEmpty())) {
                    String string2 = "Check failed.";
                    throw new IllegalStateException(string2.toString());
                }
                if (this.v instanceof PreserveDepsOrder) {
                    new TaskQueue(deps, this.cancelFlag).runAll();
                } else {
                    Iterable iterable = deps;
                    object = ParallelPool.this;
                    $i$f$map = false;
                    Iterable iterable2 = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        Parallel parallel = (Parallel)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((ParallelPool)object.new SchedulingTask(it, this.cancelFlag, null, 4, null));
                    }
                    RecursiveTask.invokeAll((List)destination$iv$iv);
                }
            }
            this.checkCancellation();
            List<Parallel<?>> d = this.v.queueSchedule(ParallelPool.this.ioPool);
            if (!((Collection)d).isEmpty()) {
                this.checkCancellation();
                try {
                    $this$map$iv = d;
                    object = ParallelPool.this;
                    $i$f$map = false;
                    $this$mapTo$iv$iv = $this$map$iv;
                    destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                    $i$f$mapTo = false;
                    for (Object item$iv$iv : $this$mapTo$iv$iv) {
                        it = (Parallel)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl = false;
                        collection.add((ParallelPool)object.new SchedulingTask(it, this.cancelFlag || this.v instanceof CancellableJob, null, 4, null));
                    }
                    RecursiveTask.invokeAll((List)destination$iv$iv);
                }
                catch (Throwable t2) {
                    if (this.v instanceof CancellableJob) {
                        ((CancellableJob)this.v).signalError(t2);
                    }
                    throw t2;
                }
            } else if (!d.isEmpty()) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
            if (!this.v.done()) {
                object = "Check failed.";
                throw new IllegalStateException(object.toString());
            }
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b6\u0018\u00002\u00020\u0001:\u0003\u0003\u0004\u0005B\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002\u0082\u0001\u0003\u0006\u0007\b\u00a8\u0006\t"}, d2={"Lparallel/ParallelPool$SpawnPolicy;", "", "()V", "FAIL", "GLOBAL", "New", "Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy$New;", "GeneralUtils"})
    public static abstract class SpawnPolicy {
        private SpawnPolicy() {
        }

        public /* synthetic */ SpawnPolicy(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$GLOBAL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class GLOBAL
        extends SpawnPolicy {
            @NotNull
            public static final GLOBAL INSTANCE = new GLOBAL();

            private GLOBAL() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lparallel/ParallelPool$SpawnPolicy$FAIL;", "Lparallel/ParallelPool$SpawnPolicy;", "()V", "GeneralUtils"})
        public static final class FAIL
        extends SpawnPolicy {
            @NotNull
            public static final FAIL INSTANCE = new FAIL();

            private FAIL() {
                super(null);
            }
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00122\u00020\u0001:\u0001\u0012B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u000f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\u0019\u0010\t\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u00d6\u0003J\t\u0010\u000e\u001a\u00020\u000fH\u00d6\u0001J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0013"}, d2={"Lparallel/ParallelPool$SpawnPolicy$New;", "Lparallel/ParallelPool$SpawnPolicy;", "f", "Lkotlin/Function0;", "Lparallel/ParallelPool;", "(Lkotlin/jvm/functions/Function0;)V", "getF", "()Lkotlin/jvm/functions/Function0;", "component1", "copy", "equals", "", "other", "", "hashCode", "", "toString", "", "Companion", "GeneralUtils"})
        public static final class New
        extends SpawnPolicy {
            @NotNull
            public static final Companion Companion = new Companion(null);
            @NotNull
            private final Function0<ParallelPool> f;

            public New(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                super(null);
                this.f = f;
            }

            @NotNull
            public final Function0<ParallelPool> getF() {
                return this.f;
            }

            @NotNull
            public final Function0<ParallelPool> component1() {
                return this.f;
            }

            @NotNull
            public final New copy(@NotNull Function0<ParallelPool> f) {
                Intrinsics.checkNotNullParameter(f, "f");
                return new New(f);
            }

            public static /* synthetic */ New copy$default(New new_, Function0 function0, int n, Object object) {
                if ((n & 1) != 0) {
                    function0 = new_.f;
                }
                return new_.copy(function0);
            }

            @NotNull
            public String toString() {
                return "New(f=" + this.f + ")";
            }

            public int hashCode() {
                return this.f.hashCode();
            }

            public boolean equals(@Nullable Object other) {
                if (this == other) {
                    return true;
                }
                if (!(other instanceof New)) {
                    return false;
                }
                New new_ = (New)other;
                return Intrinsics.areEqual(this.f, new_.f);
            }

            @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\t\u0010\u0003\u001a\u00020\u0004H\u0086\u0002\u00a8\u0006\u0005"}, d2={"Lparallel/ParallelPool$SpawnPolicy$New$Companion;", "", "()V", "invoke", "Lparallel/ParallelPool$SpawnPolicy$New;", "GeneralUtils"})
            public static final class Companion {
                private Companion() {
                }

                @NotNull
                public final New invoke() {
                    return new New(invoke.1.INSTANCE);
                }

                public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                    this();
                }
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JQ\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u0010\"\u0004\b\u0001\u0010\u000e2\u0016\b\b\u0010\u0011\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\u0013\u0012\u0004\u0012\u0002H\u000f0\u00122\u0014\b\b\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0015J]\u0010\r\u001a\u0002H\u000e\"\n\b\u0000\u0010\u000f\u0018\u0001*\u00020\u0010\"\u0004\b\u0001\u0010\u000e\"\u0004\b\u0002\u0010\u00162\u0006\u0010\u0017\u001a\u0002H\u00162\u0014\b\b\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u000f0\u00122\u0014\b\b\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0012H\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0018J]\u0010\r\u001a\u0002H\u000e\"\b\b\u0000\u0010\u000f*\u00020\u0010\"\u0004\b\u0001\u0010\u000e\"\u0004\b\u0002\u0010\u00162\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u00160\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u0016\u0012\u0004\u0012\u0002H\u000f0\u00122\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u0002H\u000e0\u0012\u00a2\u0006\u0002\u0010\u001aJ-\u0010\u001b\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010\u001e\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u0002H\u000f0\u0012\u00a2\u0006\u0002\u0010\u001fJ\u0006\u0010 \u001a\u00020!J'\u0010\"\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f2\f\u0010#\u001a\b\u0012\u0004\u0012\u0002H\u000f0$2\u0006\u0010\u001c\u001a\u00020\u001d\u00a2\u0006\u0002\u0010%J)\u0010\"\u001a\u0002H\u000f\"\u0004\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u0002H\u000f0$2\b\b\u0002\u0010&\u001a\u00020\u001dH\u0007\u00a2\u0006\u0004\b'\u0010%R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R2\u0010\t\u001a&\u0012\u0004\u0012\u00020\u0004\u0012\u001c\u0012\u001a\u0012\f\u0012\n\u0012\u0002\b\u0003\u0012\u0002\b\u00030\u000b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\f0\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006("}, d2={"Lparallel/ParallelPool$Companion;", "", "()V", "globalPool", "Lparallel/ParallelPool;", "getGlobalPool", "()Lparallel/ParallelPool;", "globalPool$delegate", "Lkotlin/Lazy;", "scopeMap", "", "Lparallel/ParallelPool$ResourceKey;", "Lparallel/ParallelPool$ObjectReference;", "allocInScope", "R", "T", "Ljava/io/Closeable;", "mk", "Lkotlin/Function1;", "", "f", "(Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "U", "args", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "k", "(Lparallel/ParallelPool$ResourceKey;Lkotlin/jvm/functions/Function1;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "inherit", "spawnPolicy", "Lparallel/ParallelPool$SpawnPolicy;", "poolF", "(Lparallel/ParallelPool$SpawnPolicy;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "isPoolCancelled", "", "runInherit", "task", "Lparallel/Parallel;", "(Lparallel/Parallel;Lparallel/ParallelPool$SpawnPolicy;)Ljava/lang/Object;", "policy", "runInheritT", "GeneralUtils"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isPoolCancelled() {
            if (Thread.interrupted()) return true;
            Thread thread2 = Thread.currentThread();
            if (!(thread2 instanceof ForkJoinWorkerThread)) return false;
            ForkJoinWorkerThread forkJoinWorkerThread = (ForkJoinWorkerThread)thread2;
            if (forkJoinWorkerThread == null) {
                return false;
            }
            ForkJoinPool forkJoinPool = forkJoinWorkerThread.getPool();
            if (forkJoinPool == null) {
                return false;
            }
            if (!forkJoinPool.isShutdown()) return false;
            return true;
        }

        @NotNull
        public final ParallelPool getGlobalPool() {
            Lazy lazy = globalPool$delegate;
            return (ParallelPool)lazy.getValue();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T> T inherit(@NotNull SpawnPolicy spawnPolicy, @NotNull Function1<? super ParallelPool, ? extends T> poolF2) {
            T t2;
            Intrinsics.checkNotNullParameter(spawnPolicy, "spawnPolicy");
            Intrinsics.checkNotNullParameter(poolF2, "poolF");
            Thread t3 = Thread.currentThread();
            if (t3 instanceof ParallelPoolWorkerThread) {
                t2 = poolF2.invoke(((ParallelPoolWorkerThread)t3).getParallelPool());
            } else {
                SpawnPolicy spawnPolicy2 = spawnPolicy;
                if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.GLOBAL.INSTANCE)) {
                    t2 = poolF2.invoke(this.getGlobalPool());
                } else {
                    if (Intrinsics.areEqual(spawnPolicy2, SpawnPolicy.FAIL.INSTANCE)) {
                        throw new IllegalStateException("Expected that this call to runInherit occurred within a parallel computation; it is not");
                    }
                    if (spawnPolicy2 instanceof SpawnPolicy.New) {
                        Closeable closeable = ((SpawnPolicy.New)spawnPolicy).getF().invoke();
                        Throwable throwable = null;
                        try {
                            T t4 = poolF2.invoke((ParallelPool)closeable);
                            t2 = t4;
                        }
                        catch (Throwable throwable2) {
                            throwable = throwable2;
                            throw throwable2;
                        }
                        finally {
                            CloseableKt.closeFinally(closeable, throwable);
                        }
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            return t2;
        }

        public final <T> T runInherit(@NotNull Parallel<? extends T> task, @NotNull SpawnPolicy spawnPolicy) {
            Intrinsics.checkNotNullParameter(task, "task");
            Intrinsics.checkNotNullParameter(spawnPolicy, "spawnPolicy");
            Function1 poolF2 = new Function1<ParallelPool, T>(task){
                final /* synthetic */ Parallel<T> $task;
                {
                    this.$task = $task;
                    super(1);
                }

                public final T invoke(@NotNull ParallelPool pool) {
                    Intrinsics.checkNotNullParameter(pool, "pool");
                    return pool.run(this.$task);
                }
            };
            return this.inherit(spawnPolicy, poolF2);
        }

        @JvmName(name="runInheritT")
        public final <T> T runInheritT(@NotNull Parallel<? extends T> $this$runInherit, @NotNull SpawnPolicy policy) {
            Intrinsics.checkNotNullParameter($this$runInherit, "<this>");
            Intrinsics.checkNotNullParameter(policy, "policy");
            return this.runInherit($this$runInherit, policy);
        }

        public static /* synthetic */ Object runInheritT$default(Companion companion, Parallel parallel, SpawnPolicy spawnPolicy, int n, Object object) {
            if ((n & 1) != 0) {
                spawnPolicy = SpawnPolicy.New.Companion.invoke();
            }
            return companion.runInheritT(parallel, spawnPolicy);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public final <T extends Closeable, R, U> R allocInScope(@NotNull ResourceKey<T, U> k, @NotNull Function1<? super U, ? extends T> mk, @NotNull Function1<? super T, ? extends R> f) {
            ObjectReference<Closeable> $i$a$-synchronized-ParallelPool$Companion$allocInScope$wrapped$22;
            Map resourceMap;
            Map $i$a$-synchronized-ParallelPool$Companion$allocInScope$resourceMap$22;
            Intrinsics.checkNotNullParameter(k, "k");
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            Thread t2 = Thread.currentThread();
            if (!(t2 instanceof ParallelPoolWorkerThread)) {
                Closeable closeable = (Closeable)mk.invoke(k.getArgs());
                Throwable throwable = null;
                try {
                    Closeable it = closeable;
                    boolean bl = false;
                    it = f.invoke(it);
                }
                catch (Throwable it) {
                    throwable = it;
                    throw it;
                }
                finally {
                    CloseableKt.closeFinally(closeable, throwable);
                }
                return (R)it;
            }
            ParallelPool pool = ((ParallelPoolWorkerThread)t2).getParallelPool();
            Map map2 = scopeMap;
            synchronized (map2) {
                boolean $i$a$-synchronized-ParallelPool$Companion$allocInScope$resourceMap$22 = false;
                $i$a$-synchronized-ParallelPool$Companion$allocInScope$resourceMap$22 = scopeMap.computeIfAbsent(pool, Companion::allocInScope$lambda-2$lambda-1);
            }
            Map it = $i$a$-synchronized-ParallelPool$Companion$allocInScope$resourceMap$22;
            Intrinsics.checkNotNullExpressionValue(it, "synchronized(scopeMap) {\u2026          }\n            }");
            Map bl = resourceMap = it;
            synchronized (bl) {
                ObjectReference<Closeable> objectReference;
                boolean $i$a$-synchronized-ParallelPool$Companion$allocInScope$wrapped$22 = false;
                ObjectReference d = (ObjectReference)resourceMap.get(k);
                if (d == null) {
                    ObjectReference<Closeable> r = new ObjectReference<Closeable>((Closeable)mk.invoke(k.getArgs()), new AtomicInteger(1));
                    resourceMap.put(k, r);
                    objectReference = r;
                } else {
                    d.getRefCount().incrementAndGet();
                    ObjectReference $this$uncheckedAs$iv = d;
                    boolean $i$f$uncheckedAs = false;
                    objectReference = (ObjectReference<Closeable>)((Object)$this$uncheckedAs$iv);
                }
                $i$a$-synchronized-ParallelPool$Companion$allocInScope$wrapped$22 = objectReference;
            }
            ObjectReference<Closeable> wrapped = $i$a$-synchronized-ParallelPool$Companion$allocInScope$wrapped$22;
            R ret = f.invoke(wrapped.getWrapped());
            int newCount = wrapped.getRefCount().decrementAndGet();
            if (newCount == 0) {
                Map map3 = resourceMap;
                synchronized (map3) {
                    boolean bl2 = false;
                    if (wrapped.getRefCount().get() == 0) {
                        wrapped.getWrapped().close();
                        resourceMap.remove(k);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            return ret;
        }

        public final /* synthetic */ <T extends Closeable, R, U> R allocInScope(U args2, Function1<? super U, ? extends T> mk, Function1<? super T, ? extends R> f) {
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            boolean $i$f$allocInScope = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this.allocInScope((U)new ResourceKey<Closeable, U>(Closeable.class, args2), mk, f);
        }

        /*
         * WARNING - void declaration
         */
        public final /* synthetic */ <T extends Closeable, R> R allocInScope(Function1 mk, Function1<? super T, ? extends R> f) {
            void this_$iv;
            Intrinsics.checkNotNullParameter(mk, "mk");
            Intrinsics.checkNotNullParameter(f, "f");
            boolean $i$f$allocInScope = false;
            Companion companion = this;
            Object args$iv = null;
            boolean $i$f$allocInScope2 = false;
            Intrinsics.reifiedOperationMarker(4, "T");
            return this_$iv.allocInScope((Object)new ResourceKey<Closeable, Object>(Closeable.class, args$iv), (Function1)mk, f);
        }

        private static final Map allocInScope$lambda-2$lambda-1(ParallelPool it) {
            Intrinsics.checkNotNullParameter(it, "it");
            return new LinkedHashMap();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0015\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000f"}, d2={"Lparallel/ParallelPool$ObjectReference;", "T", "Ljava/io/Closeable;", "", "wrapped", "refCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "(Ljava/io/Closeable;Ljava/util/concurrent/atomic/AtomicInteger;)V", "getRefCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "setRefCount", "(Ljava/util/concurrent/atomic/AtomicInteger;)V", "getWrapped", "()Ljava/io/Closeable;", "Ljava/io/Closeable;", "GeneralUtils"})
    public static final class ObjectReference<T extends Closeable> {
        @NotNull
        private final T wrapped;
        @NotNull
        private AtomicInteger refCount;

        public ObjectReference(@NotNull T wrapped, @NotNull AtomicInteger refCount) {
            Intrinsics.checkNotNullParameter(wrapped, "wrapped");
            Intrinsics.checkNotNullParameter(refCount, "refCount");
            this.wrapped = wrapped;
            this.refCount = refCount;
        }

        @NotNull
        public final T getWrapped() {
            return this.wrapped;
        }

        @NotNull
        public final AtomicInteger getRefCount() {
            return this.refCount;
        }

        public final void setRefCount(@NotNull AtomicInteger atomicInteger) {
            Intrinsics.checkNotNullParameter(atomicInteger, "<set-?>");
            this.refCount = atomicInteger;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u0001*\u0004\b\u0001\u0010\u00022\u00020\u0003B\u001b\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\u0006\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\u0002\u0010\u0007J\u000f\u0010\r\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005H\u00c6\u0003J\u000e\u0010\u000e\u001a\u00028\u0001H\u00c6\u0003\u00a2\u0006\u0002\u0010\tJ4\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\u00002\u000e\b\u0002\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u00052\b\b\u0002\u0010\u0006\u001a\u00028\u0001H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0010J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\t\u0010\u0016\u001a\u00020\u0017H\u00d6\u0001R\u0013\u0010\u0006\u001a\u00028\u0001\u00a2\u0006\n\n\u0002\u0010\n\u001a\u0004\b\b\u0010\tR\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0018"}, d2={"Lparallel/ParallelPool$ResourceKey;", "T", "U", "", "klass", "Ljava/lang/Class;", "args", "(Ljava/lang/Class;Ljava/lang/Object;)V", "getArgs", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getKlass", "()Ljava/lang/Class;", "component1", "component2", "copy", "(Ljava/lang/Class;Ljava/lang/Object;)Lparallel/ParallelPool$ResourceKey;", "equals", "", "other", "hashCode", "", "toString", "", "GeneralUtils"})
    public static final class ResourceKey<T, U> {
        @NotNull
        private final Class<T> klass;
        private final U args;

        public ResourceKey(@NotNull Class<T> klass, U args2) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            this.klass = klass;
            this.args = args2;
        }

        @NotNull
        public final Class<T> getKlass() {
            return this.klass;
        }

        public final U getArgs() {
            return this.args;
        }

        @NotNull
        public final Class<T> component1() {
            return this.klass;
        }

        public final U component2() {
            return this.args;
        }

        @NotNull
        public final ResourceKey<T, U> copy(@NotNull Class<T> klass, U args2) {
            Intrinsics.checkNotNullParameter(klass, "klass");
            return new ResourceKey<T, U>(klass, args2);
        }

        public static /* synthetic */ ResourceKey copy$default(ResourceKey resourceKey, Class clazz, Object object, int n, Object object2) {
            if ((n & 1) != 0) {
                clazz = resourceKey.klass;
            }
            if ((n & 2) != 0) {
                object = resourceKey.args;
            }
            return resourceKey.copy(clazz, object);
        }

        @NotNull
        public String toString() {
            return "ResourceKey(klass=" + this.klass + ", args=" + this.args + ")";
        }

        public int hashCode() {
            int result2 = this.klass.hashCode();
            result2 = result2 * 31 + (this.args == null ? 0 : this.args.hashCode());
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ResourceKey)) {
                return false;
            }
            ResourceKey resourceKey = (ResourceKey)other;
            if (!Intrinsics.areEqual(this.klass, resourceKey.klass)) {
                return false;
            }
            return Intrinsics.areEqual(this.args, resourceKey.args);
        }
    }
}

