"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * Defines an API Gateway domain name as the alias target.
 *
 * Use the `ApiGateway` class if you wish to map the alias to an REST API with a
 * domain name defined throug the `RestApiProps.domainName` prop.
 */
class ApiGatewayDomain {
    constructor(domainName) {
        this.domainName = domainName;
    }
    bind(_record) {
        return {
            dnsName: this.domainName.domainNameAliasDomainName,
            hostedZoneId: this.domainName.domainNameAliasHostedZoneId,
        };
    }
}
exports.ApiGatewayDomain = ApiGatewayDomain;
/**
 * Defines an API Gateway REST API as the alias target. Requires that the domain
 * name will be defined through `RestApiProps.domainName`.
 *
 * You can direct the alias to any `apigateway.DomainName` resource through the
 * `ApiGatewayDomain` class.
 */
class ApiGateway extends ApiGatewayDomain {
    constructor(api) {
        if (!api.domainName) {
            throw new Error(`API does not define a default domain name`);
        }
        super(api.domainName);
    }
}
exports.ApiGateway = ApiGateway;
//# sourceMappingURL=data:application/json;base64,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