"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/**
 * The hosted zone Id if using an alias record in Route53.
 * This value never changes.
 */
const CLOUDFRONT_ZONE_ID = "Z2FDTNDATAQYW2";
/**
 * Use a CloudFront Distribution as an alias record target
 */
class CloudFrontTarget {
    constructor(distribution) {
        this.distribution = distribution;
    }
    bind(_record) {
        return {
            hostedZoneId: CLOUDFRONT_ZONE_ID,
            dnsName: this.distribution.domainName
        };
    }
}
exports.CloudFrontTarget = CloudFrontTarget;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2xvdWRmcm9udC10YXJnZXQuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJjbG91ZGZyb250LXRhcmdldC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUdBOzs7R0FHRztBQUNILE1BQU0sa0JBQWtCLEdBQUcsZ0JBQWdCLENBQUM7QUFFNUM7O0dBRUc7QUFDSCxNQUFhLGdCQUFnQjtJQUMzQixZQUE2QixZQUFrRDtRQUFsRCxpQkFBWSxHQUFaLFlBQVksQ0FBc0M7SUFDL0UsQ0FBQztJQUVNLElBQUksQ0FBQyxPQUEyQjtRQUNyQyxPQUFPO1lBQ0wsWUFBWSxFQUFFLGtCQUFrQjtZQUNoQyxPQUFPLEVBQUUsSUFBSSxDQUFDLFlBQVksQ0FBQyxVQUFVO1NBQ3RDLENBQUM7SUFDSixDQUFDO0NBQ0Y7QUFWRCw0Q0FVQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCBjbG91ZGZyb250ID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLWNsb3VkZnJvbnQnKTtcbmltcG9ydCByb3V0ZTUzID0gcmVxdWlyZSgnQGF3cy1jZGsvYXdzLXJvdXRlNTMnKTtcblxuLyoqXG4gKiBUaGUgaG9zdGVkIHpvbmUgSWQgaWYgdXNpbmcgYW4gYWxpYXMgcmVjb3JkIGluIFJvdXRlNTMuXG4gKiBUaGlzIHZhbHVlIG5ldmVyIGNoYW5nZXMuXG4gKi9cbmNvbnN0IENMT1VERlJPTlRfWk9ORV9JRCA9IFwiWjJGRFROREFUQVFZVzJcIjtcblxuLyoqXG4gKiBVc2UgYSBDbG91ZEZyb250IERpc3RyaWJ1dGlvbiBhcyBhbiBhbGlhcyByZWNvcmQgdGFyZ2V0XG4gKi9cbmV4cG9ydCBjbGFzcyBDbG91ZEZyb250VGFyZ2V0IGltcGxlbWVudHMgcm91dGU1My5JQWxpYXNSZWNvcmRUYXJnZXQge1xuICBjb25zdHJ1Y3Rvcihwcml2YXRlIHJlYWRvbmx5IGRpc3RyaWJ1dGlvbjogY2xvdWRmcm9udC5DbG91ZEZyb250V2ViRGlzdHJpYnV0aW9uKSB7XG4gIH1cblxuICBwdWJsaWMgYmluZChfcmVjb3JkOiByb3V0ZTUzLklSZWNvcmRTZXQpOiByb3V0ZTUzLkFsaWFzUmVjb3JkVGFyZ2V0Q29uZmlnIHtcbiAgICByZXR1cm4ge1xuICAgICAgaG9zdGVkWm9uZUlkOiBDTE9VREZST05UX1pPTkVfSUQsXG4gICAgICBkbnNOYW1lOiB0aGlzLmRpc3RyaWJ1dGlvbi5kb21haW5OYW1lXG4gICAgfTtcbiAgfVxufVxuIl19