from dataclasses import dataclass

from psdm_analysis.models.enums import SystemParticipantsEnum
from psdm_analysis.models.input.participant.participant import SystemParticipants


@dataclass(frozen=True)
class EvChargingStations(SystemParticipants):
    @staticmethod
    def get_enum() -> SystemParticipantsEnum:
        return SystemParticipantsEnum.EV_CHARGING_STATION

    @property
    def charging_points(self):
        return self.data["charging_points"]

    @property
    def location_type(self):
        return self.data["location_type"]

    @property
    def s_rated(self):
        return self.data["s_rated"]

    @property
    def electric_current_type(self):
        return self.data["electric_current_type"]

    def get_public_evcs(self):
        return self.data[self.location_type.isin(["CUSTOMER_PARKING", "WORK"])]

    def get_home_evcs(self):
        return self.data[self.location_type.isin(["HOME"])]
