# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: info@sidra.dev
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class DatabricksJobsJobsApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_databricks_jobs_id_delete(self, id, **kwargs):  # noqa: E501
        """Delete a specific Job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_id_delete(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the Job to be deleted (required)
        :param str data_intake_process_id: Id of the DataIntakeProcess of the job
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_databricks_jobs_id_delete_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_databricks_jobs_id_delete_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_databricks_jobs_id_delete_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete a specific Job  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_id_delete_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of the Job to be deleted (required)
        :param str data_intake_process_id: Id of the DataIntakeProcess of the job
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'data_intake_process_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_databricks_jobs_id_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_databricks_jobs_id_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'data_intake_process_id' in params:
            query_params.append(('dataIntakeProcessId', params['data_intake_process_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/databricks/Jobs/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_databricks_jobs_id_get(self, id, **kwargs):  # noqa: E501
        """Get a job by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_id_get(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of trigger to find (required)
        :param str api_version: The requested API version
        :return: DatabricksJobsJobDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_databricks_jobs_id_get_with_http_info(id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_databricks_jobs_id_get_with_http_info(id, **kwargs)  # noqa: E501
            return data

    def api_databricks_jobs_id_get_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get a job by id  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_id_get_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int id: Id of trigger to find (required)
        :param str api_version: The requested API version
        :return: DatabricksJobsJobDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_databricks_jobs_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'id' is set
        if ('id' not in params or
                params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `api_databricks_jobs_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in params:
            path_params['id'] = params['id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/databricks/Jobs/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatabricksJobsJobDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_databricks_jobs_item_id_post(self, item_id, **kwargs):  # noqa: E501
        """Creates a Schedule for a Job in Databricks.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_item_id_post(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Item Id to identify the job to create or update (required)
        :param APIDatabricksJobUpsertDefinitionRequest body: All parameters that allow job creation including the databricks DSU
        :param str api_version: The requested API version
        :return: DatabricksJobsJobDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_databricks_jobs_item_id_post_with_http_info(item_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_databricks_jobs_item_id_post_with_http_info(item_id, **kwargs)  # noqa: E501
            return data

    def api_databricks_jobs_item_id_post_with_http_info(self, item_id, **kwargs):  # noqa: E501
        """Creates a Schedule for a Job in Databricks.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_databricks_jobs_item_id_post_with_http_info(item_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str item_id: Item Id to identify the job to create or update (required)
        :param APIDatabricksJobUpsertDefinitionRequest body: All parameters that allow job creation including the databricks DSU
        :param str api_version: The requested API version
        :return: DatabricksJobsJobDTO
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['item_id', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_databricks_jobs_item_id_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'item_id' is set
        if ('item_id' not in params or
                params['item_id'] is None):
            raise ValueError("Missing the required parameter `item_id` when calling `api_databricks_jobs_item_id_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'item_id' in params:
            path_params['itemId'] = params['item_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/databricks/Jobs/{itemId}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DatabricksJobsJobDTO',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
