# coding: utf-8

"""
    Sidra API

    Sidra API  # noqa: E501

    OpenAPI spec version: 1.0
    Contact: info@sidra.dev
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from SidraCoreApiPythonClient.api_client import ApiClient


class PluginsPluginApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def api_plugins_latest_version_installed_plugin_type_post(self, plugin_type, **kwargs):  # noqa: E501
        """Get the latest version installed from the list of plugin version Item Ids received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_installed_plugin_type_post(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: Type of plugin (required)
        :param list[str] body: List of plugin version Item Ids for a specific plugin
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_latest_version_installed_plugin_type_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_latest_version_installed_plugin_type_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_latest_version_installed_plugin_type_post_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Get the latest version installed from the list of plugin version Item Ids received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_installed_plugin_type_post_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: Type of plugin (required)
        :param list[str] body: List of plugin version Item Ids for a specific plugin
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_latest_version_installed_plugin_type_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_latest_version_installed_plugin_type_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/latestVersionInstalled/{pluginType}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_latest_version_installed_post(self, **kwargs):  # noqa: E501
        """Get the latest version installed from the list of plugin versions received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_installed_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[APIPluginsModelsPluginLlagarVersion] body: List of plugin versions for a specific plugin
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_latest_version_installed_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_latest_version_installed_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_plugins_latest_version_installed_post_with_http_info(self, **kwargs):  # noqa: E501
        """Get the latest version installed from the list of plugin versions received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_installed_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[APIPluginsModelsPluginLlagarVersion] body: List of plugin versions for a specific plugin
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_latest_version_installed_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/latestVersionInstalled', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIPluginsModelsPluginLlagarVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_latest_version_post(self, **kwargs):  # noqa: E501
        """Get the latest version from the list of plugin versions received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[APIPluginsModelsPluginLlagarWithMediaVersion] body: List of plugin versions for a specific plugin
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarWithMediaVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_latest_version_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_latest_version_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_plugins_latest_version_post_with_http_info(self, **kwargs):  # noqa: E501
        """Get the latest version from the list of plugin versions received  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_latest_version_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param list[APIPluginsModelsPluginLlagarWithMediaVersion] body: List of plugin versions for a specific plugin
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarWithMediaVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_latest_version_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/latestVersion', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIPluginsModelsPluginLlagarWithMediaVersion',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_available_get(self, plugin_type, **kwargs):  # noqa: E501
        """Get a list of all the plugins that can be installed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_available_get(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str api_version: The requested API version
        :return: list[APIPluginsModelsPluginLlagarWithMedia]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_available_get_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_available_get_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_available_get_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Get a list of all the plugins that can be installed  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_available_get_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str api_version: The requested API version
        :return: list[APIPluginsModelsPluginLlagarWithMedia]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_available_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_available_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/available', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[APIPluginsModelsPluginLlagarWithMedia]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_installed_get(self, plugin_type, **kwargs):  # noqa: E501
        """Get a list of the installed plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_installed_get(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str api_version: The requested API version
        :return: list[APIPluginsModelsPluginLlagarVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_installed_get_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_installed_get_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_installed_get_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Get a list of the installed plugins  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_installed_get_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str api_version: The requested API version
        :return: list[APIPluginsModelsPluginLlagarVersion]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_installed_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_installed_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/installed', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[APIPluginsModelsPluginLlagarVersion]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_id_execute_post(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Performs an execution to the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_execute_post(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param dict(str, object) body:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_id_execute_post_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_id_execute_post_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_id_execute_post_with_http_info(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Performs an execution to the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_execute_post_with_http_info(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param dict(str, object) body:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'body', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_id_execute_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_id_execute_post`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `api_plugins_plugin_type_plugin_id_execute_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501

        query_params = []
        if 'plugin_version_id' in params:
            query_params.append(('pluginVersionId', params['plugin_version_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}/execute', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_id_get(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Gets a Sidra.API.Plugins.Models.PluginLlagarWithMedia by type and Id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarWithMedia
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_id_get_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_id_get_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_id_get_with_http_info(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Gets a Sidra.API.Plugins.Models.PluginLlagarWithMedia by type and Id.  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get_with_http_info(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str api_version: The requested API version
        :return: APIPluginsModelsPluginLlagarWithMedia
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_id_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_id_get`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `api_plugins_plugin_type_plugin_id_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='APIPluginsModelsPluginLlagarWithMedia',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get(self, plugin_type, plugin_id, section_name, field_name, **kwargs):  # noqa: E501
        """Gets valid values for wizard form control  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get(plugin_type, plugin_id, section_name, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str section_name: (required)
        :param str field_name: (required)
        :param str depends_on:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get_with_http_info(plugin_type, plugin_id, section_name, field_name, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get_with_http_info(plugin_type, plugin_id, section_name, field_name, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get_with_http_info(self, plugin_type, plugin_id, section_name, field_name, **kwargs):  # noqa: E501
        """Gets valid values for wizard form control  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get_with_http_info(plugin_type, plugin_id, section_name, field_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str section_name: (required)
        :param str field_name: (required)
        :param str depends_on:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'section_name', 'field_name', 'depends_on', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get`")  # noqa: E501
        # verify the required parameter 'section_name' is set
        if ('section_name' not in params or
                params['section_name'] is None):
            raise ValueError("Missing the required parameter `section_name` when calling `api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get`")  # noqa: E501
        # verify the required parameter 'field_name' is set
        if ('field_name' not in params or
                params['field_name'] is None):
            raise ValueError("Missing the required parameter `field_name` when calling `api_plugins_plugin_type_plugin_id_get_field_options_section_name_field_name_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501
        if 'section_name' in params:
            path_params['sectionName'] = params['section_name']  # noqa: E501
        if 'field_name' in params:
            path_params['fieldName'] = params['field_name']  # noqa: E501

        query_params = []
        if 'depends_on' in params:
            query_params.append(('dependsOn', params['depends_on']))  # noqa: E501
        if 'plugin_version_id' in params:
            query_params.append(('pluginVersionId', params['plugin_version_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}/getFieldOptions/{sectionName}/{fieldName}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_id_get_web_form_get(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Get information about how to use the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get_web_form_get(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_id_get_web_form_get_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_id_get_web_form_get_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_id_get_web_form_get_with_http_info(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Get information about how to use the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_get_web_form_get_with_http_info(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_id_get_web_form_get" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_id_get_web_form_get`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `api_plugins_plugin_type_plugin_id_get_web_form_get`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501

        query_params = []
        if 'plugin_version_id' in params:
            query_params.append(('pluginVersionId', params['plugin_version_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}/getWebForm', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_id_validate_post(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Performs a validate to the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_validate_post(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param dict(str, object) body:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_id_validate_post_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_id_validate_post_with_http_info(plugin_type, plugin_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_id_validate_post_with_http_info(self, plugin_type, plugin_id, **kwargs):  # noqa: E501
        """Performs a validate to the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_id_validate_post_with_http_info(plugin_type, plugin_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param dict(str, object) body:
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'body', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_id_validate_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_id_validate_post`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `api_plugins_plugin_type_plugin_id_validate_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501

        query_params = []
        if 'plugin_version_id' in params:
            query_params.append(('pluginVersionId', params['plugin_version_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}/validate', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_version_id_install_post(self, plugin_type, plugin_version_id, **kwargs):  # noqa: E501
        """Install the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_version_id_install_post(plugin_type, plugin_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_id: (required)
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_version_id_install_post_with_http_info(plugin_type, plugin_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_version_id_install_post_with_http_info(plugin_type, plugin_version_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_version_id_install_post_with_http_info(self, plugin_type, plugin_version_id, **kwargs):  # noqa: E501
        """Install the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_version_id_install_post_with_http_info(plugin_type, plugin_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_id: (required)
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_version_id_install_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_version_id_install_post`")  # noqa: E501
        # verify the required parameter 'plugin_version_id' is set
        if ('plugin_version_id' not in params or
                params['plugin_version_id'] is None):
            raise ValueError("Missing the required parameter `plugin_version_id` when calling `api_plugins_plugin_type_plugin_version_id_install_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_version_id' in params:
            path_params['pluginVersionId'] = params['plugin_version_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginVersionId}/install', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_plugin_version_id_uninstall_delete(self, plugin_type, plugin_version_id, **kwargs):  # noqa: E501
        """Unsintall the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_version_id_uninstall_delete(plugin_type, plugin_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_id: (required)
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_plugin_version_id_uninstall_delete_with_http_info(plugin_type, plugin_version_id, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_plugin_version_id_uninstall_delete_with_http_info(plugin_type, plugin_version_id, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_plugin_version_id_uninstall_delete_with_http_info(self, plugin_type, plugin_version_id, **kwargs):  # noqa: E501
        """Unsintall the selected plugin  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_plugin_version_id_uninstall_delete_with_http_info(plugin_type, plugin_version_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_id: (required)
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_plugin_version_id_uninstall_delete" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_plugin_version_id_uninstall_delete`")  # noqa: E501
        # verify the required parameter 'plugin_version_id' is set
        if ('plugin_version_id' not in params or
                params['plugin_version_id'] is None):
            raise ValueError("Missing the required parameter `plugin_version_id` when calling `api_plugins_plugin_type_plugin_version_id_uninstall_delete`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_version_id' in params:
            path_params['pluginVersionId'] = params['plugin_version_id']  # noqa: E501

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginVersionId}/uninstall', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_register_plugin_post(self, plugin_type, **kwargs):  # noqa: E501
        """Registers a new Sidra.API.Plugins.Models.PluginLlagarRegister  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_register_plugin_post(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_logo:
        :param str plugin_arm_diagram:
        :param APIPluginsModelsPluginLlagarRegister plugin:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_register_plugin_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_register_plugin_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_register_plugin_post_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Registers a new Sidra.API.Plugins.Models.PluginLlagarRegister  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_register_plugin_post_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_logo:
        :param str plugin_arm_diagram:
        :param APIPluginsModelsPluginLlagarRegister plugin:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_logo', 'plugin_arm_diagram', 'plugin', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_register_plugin_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_register_plugin_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'plugin_logo' in params:
            local_var_files['pluginLogo'] = params['plugin_logo']  # noqa: E501
        if 'plugin_arm_diagram' in params:
            local_var_files['pluginArmDiagram'] = params['plugin_arm_diagram']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/RegisterPlugin', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_register_plugin_version_post(self, plugin_type, **kwargs):  # noqa: E501
        """Registers a new Sidra.API.Plugins.Models.PluginLlagarRegisterVersion  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_register_plugin_version_post(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_file:
        :param APIPluginsModelsPluginLlagarRegisterVersion plugin_version:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_register_plugin_version_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_register_plugin_version_post_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_register_plugin_version_post_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Registers a new Sidra.API.Plugins.Models.PluginLlagarRegisterVersion  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_register_plugin_version_post_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_version_file:
        :param APIPluginsModelsPluginLlagarRegisterVersion plugin_version:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_version_file', 'plugin_version', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_register_plugin_version_post" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_register_plugin_version_post`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'plugin_version' in params:
            query_params.append(('pluginVersion', params['plugin_version']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'plugin_version_file' in params:
            local_var_files['pluginVersionFile'] = params['plugin_version_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/RegisterPluginVersion', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_plugin_type_update_registered_plugin_async_put(self, plugin_type, **kwargs):  # noqa: E501
        """Updates existing Sidra.API.Plugins.Models.PluginLlagarRegister  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_update_registered_plugin_async_put(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_logo:
        :param str plugin_arm_diagram:
        :param APIPluginsModelsPluginLlagarRegister plugin:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_plugin_type_update_registered_plugin_async_put_with_http_info(plugin_type, **kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_plugin_type_update_registered_plugin_async_put_with_http_info(plugin_type, **kwargs)  # noqa: E501
            return data

    def api_plugins_plugin_type_update_registered_plugin_async_put_with_http_info(self, plugin_type, **kwargs):  # noqa: E501
        """Updates existing Sidra.API.Plugins.Models.PluginLlagarRegister  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_plugin_type_update_registered_plugin_async_put_with_http_info(plugin_type, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_logo:
        :param str plugin_arm_diagram:
        :param APIPluginsModelsPluginLlagarRegister plugin:
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_logo', 'plugin_arm_diagram', 'plugin', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_plugin_type_update_registered_plugin_async_put" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `api_plugins_plugin_type_update_registered_plugin_async_put`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501

        query_params = []
        if 'plugin' in params:
            query_params.append(('plugin', params['plugin']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'plugin_logo' in params:
            local_var_files['pluginLogo'] = params['plugin_logo']  # noqa: E501
        if 'plugin_arm_diagram' in params:
            local_var_files['pluginArmDiagram'] = params['plugin_arm_diagram']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/UpdateRegisteredPluginAsync', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def api_plugins_upgrade_post(self, **kwargs):  # noqa: E501
        """Upgrade plugin version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_upgrade_post(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIDataIngestionDataIntakeProcessesDataIntakeProcessWithPluginUpdateDTO body: Sidra.API.DataIngestion.DataIntakeProcesses.DataIntakeProcessWithProviderAndPluginDTO
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.api_plugins_upgrade_post_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.api_plugins_upgrade_post_with_http_info(**kwargs)  # noqa: E501
            return data

    def api_plugins_upgrade_post_with_http_info(self, **kwargs):  # noqa: E501
        """Upgrade plugin version  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.api_plugins_upgrade_post_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIDataIngestionDataIntakeProcessesDataIntakeProcessWithPluginUpdateDTO body: Sidra.API.DataIngestion.DataIntakeProcesses.DataIntakeProcessWithProviderAndPluginDTO
        :param str api_version: The requested API version
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method api_plugins_upgrade_post" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']
        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json-patch+json', 'application/json', 'text/json', 'application/*+json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/upgrade', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def execution_status_route(self, plugin_type, plugin_id, job_id, **kwargs):  # noqa: E501
        """execution_status_route  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execution_status_route(plugin_type, plugin_id, job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str job_id: (required)
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.execution_status_route_with_http_info(plugin_type, plugin_id, job_id, **kwargs)  # noqa: E501
        else:
            (data) = self.execution_status_route_with_http_info(plugin_type, plugin_id, job_id, **kwargs)  # noqa: E501
            return data

    def execution_status_route_with_http_info(self, plugin_type, plugin_id, job_id, **kwargs):  # noqa: E501
        """execution_status_route  # noqa: E501

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.execution_status_route_with_http_info(plugin_type, plugin_id, job_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param APIPluginsModelsPluginTypeEnum plugin_type: (required)
        :param str plugin_id: (required)
        :param str job_id: (required)
        :param str plugin_version_id:
        :param str api_version: The requested API version
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['plugin_type', 'plugin_id', 'job_id', 'plugin_version_id', 'api_version']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method execution_status_route" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'plugin_type' is set
        if ('plugin_type' not in params or
                params['plugin_type'] is None):
            raise ValueError("Missing the required parameter `plugin_type` when calling `execution_status_route`")  # noqa: E501
        # verify the required parameter 'plugin_id' is set
        if ('plugin_id' not in params or
                params['plugin_id'] is None):
            raise ValueError("Missing the required parameter `plugin_id` when calling `execution_status_route`")  # noqa: E501
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params or
                params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `execution_status_route`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'plugin_type' in params:
            path_params['pluginType'] = params['plugin_type']  # noqa: E501
        if 'plugin_id' in params:
            path_params['pluginId'] = params['plugin_id']  # noqa: E501
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']  # noqa: E501

        query_params = []
        if 'plugin_version_id' in params:
            query_params.append(('pluginVersionId', params['plugin_version_id']))  # noqa: E501
        if 'api_version' in params:
            query_params.append(('api-version', params['api_version']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json', 'text/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['oauth2']  # noqa: E501

        return self.api_client.call_api(
            '/api/plugins/{pluginType}/{pluginId}/execute/{jobId}/status', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
