# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetDedicatedVantagePointResult',
    'AwaitableGetDedicatedVantagePointResult',
    'get_dedicated_vantage_point',
    'get_dedicated_vantage_point_output',
]

@pulumi.output_type
class GetDedicatedVantagePointResult:
    """
    A collection of values returned by getDedicatedVantagePoint.
    """
    def __init__(__self__, apm_domain_id=None, dedicated_vantage_point_id=None, defined_tags=None, display_name=None, dvp_stack_details=None, freeform_tags=None, id=None, monitor_status_count_maps=None, name=None, region=None, status=None, time_created=None, time_updated=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if dedicated_vantage_point_id and not isinstance(dedicated_vantage_point_id, str):
            raise TypeError("Expected argument 'dedicated_vantage_point_id' to be a str")
        pulumi.set(__self__, "dedicated_vantage_point_id", dedicated_vantage_point_id)
        if defined_tags and not isinstance(defined_tags, dict):
            raise TypeError("Expected argument 'defined_tags' to be a dict")
        pulumi.set(__self__, "defined_tags", defined_tags)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if dvp_stack_details and not isinstance(dvp_stack_details, list):
            raise TypeError("Expected argument 'dvp_stack_details' to be a list")
        pulumi.set(__self__, "dvp_stack_details", dvp_stack_details)
        if freeform_tags and not isinstance(freeform_tags, dict):
            raise TypeError("Expected argument 'freeform_tags' to be a dict")
        pulumi.set(__self__, "freeform_tags", freeform_tags)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if monitor_status_count_maps and not isinstance(monitor_status_count_maps, list):
            raise TypeError("Expected argument 'monitor_status_count_maps' to be a list")
        pulumi.set(__self__, "monitor_status_count_maps", monitor_status_count_maps)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if region and not isinstance(region, str):
            raise TypeError("Expected argument 'region' to be a str")
        pulumi.set(__self__, "region", region)
        if status and not isinstance(status, str):
            raise TypeError("Expected argument 'status' to be a str")
        pulumi.set(__self__, "status", status)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="dedicatedVantagePointId")
    def dedicated_vantage_point_id(self) -> str:
        return pulumi.get(self, "dedicated_vantage_point_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Unique dedicated vantage point name that cannot be edited. The name should not contain any confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="dvpStackDetails")
    def dvp_stack_details(self) -> Sequence['outputs.GetDedicatedVantagePointDvpStackDetailResult']:
        """
        Details of a Dedicated Vantage Point (DVP) stack in Resource Manager.
        """
        return pulumi.get(self, "dvp_stack_details")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the dedicated vantage point.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="monitorStatusCountMaps")
    def monitor_status_count_maps(self) -> Sequence['outputs.GetDedicatedVantagePointMonitorStatusCountMapResult']:
        """
        Details of the monitor count per state. Example: `{ "total" : 5, "enabled" : 3 , "disabled" : 2, "invalid" : 0 }`
        """
        return pulumi.get(self, "monitor_status_count_maps")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Unique permanent name of the dedicated vantage point. This is the same as the displayName.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def region(self) -> str:
        """
        Name of the region.
        """
        return pulumi.get(self, "region")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Status of the dedicated vantage point.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the resource was created, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-12T22:47:12.613Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the resource was updated, expressed in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: `2020-02-13T22:47:12.613Z`
        """
        return pulumi.get(self, "time_updated")


class AwaitableGetDedicatedVantagePointResult(GetDedicatedVantagePointResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDedicatedVantagePointResult(
            apm_domain_id=self.apm_domain_id,
            dedicated_vantage_point_id=self.dedicated_vantage_point_id,
            defined_tags=self.defined_tags,
            display_name=self.display_name,
            dvp_stack_details=self.dvp_stack_details,
            freeform_tags=self.freeform_tags,
            id=self.id,
            monitor_status_count_maps=self.monitor_status_count_maps,
            name=self.name,
            region=self.region,
            status=self.status,
            time_created=self.time_created,
            time_updated=self.time_updated)


def get_dedicated_vantage_point(apm_domain_id: Optional[str] = None,
                                dedicated_vantage_point_id: Optional[str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDedicatedVantagePointResult:
    """
    This data source provides details about a specific Dedicated Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the details of the dedicated vantage point identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_vantage_point = oci.ApmSynthetics.get_dedicated_vantage_point(apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
        dedicated_vantage_point_id=oci_apm_synthetics_dedicated_vantage_point["test_dedicated_vantage_point"]["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str dedicated_vantage_point_id: The OCID of the dedicated vantage point.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['dedicatedVantagePointId'] = dedicated_vantage_point_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:ApmSynthetics/getDedicatedVantagePoint:getDedicatedVantagePoint', __args__, opts=opts, typ=GetDedicatedVantagePointResult).value

    return AwaitableGetDedicatedVantagePointResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        dedicated_vantage_point_id=pulumi.get(__ret__, 'dedicated_vantage_point_id'),
        defined_tags=pulumi.get(__ret__, 'defined_tags'),
        display_name=pulumi.get(__ret__, 'display_name'),
        dvp_stack_details=pulumi.get(__ret__, 'dvp_stack_details'),
        freeform_tags=pulumi.get(__ret__, 'freeform_tags'),
        id=pulumi.get(__ret__, 'id'),
        monitor_status_count_maps=pulumi.get(__ret__, 'monitor_status_count_maps'),
        name=pulumi.get(__ret__, 'name'),
        region=pulumi.get(__ret__, 'region'),
        status=pulumi.get(__ret__, 'status'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'))


@_utilities.lift_output_func(get_dedicated_vantage_point)
def get_dedicated_vantage_point_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                                       dedicated_vantage_point_id: Optional[pulumi.Input[str]] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDedicatedVantagePointResult]:
    """
    This data source provides details about a specific Dedicated Vantage Point resource in Oracle Cloud Infrastructure Apm Synthetics service.

    Gets the details of the dedicated vantage point identified by the OCID.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_dedicated_vantage_point = oci.ApmSynthetics.get_dedicated_vantage_point(apm_domain_id=oci_apm_apm_domain["test_apm_domain"]["id"],
        dedicated_vantage_point_id=oci_apm_synthetics_dedicated_vantage_point["test_dedicated_vantage_point"]["id"])
    ```


    :param str apm_domain_id: The APM domain ID the request is intended for.
    :param str dedicated_vantage_point_id: The OCID of the dedicated vantage point.
    """
    ...
