# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetIpsecStatusResult',
    'AwaitableGetIpsecStatusResult',
    'get_ipsec_status',
    'get_ipsec_status_output',
]

@pulumi.output_type
class GetIpsecStatusResult:
    """
    A collection of values returned by getIpsecStatus.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, ipsec_id=None, time_created=None, tunnels=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if ipsec_id and not isinstance(ipsec_id, str):
            raise TypeError("Expected argument 'ipsec_id' to be a str")
        pulumi.set(__self__, "ipsec_id", ipsec_id)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if tunnels and not isinstance(tunnels, list):
            raise TypeError("Expected argument 'tunnels' to be a list")
        pulumi.set(__self__, "tunnels", tunnels)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment containing the IPSec connection.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetIpsecStatusFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="ipsecId")
    def ipsec_id(self) -> str:
        return pulumi.get(self, "ipsec_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time the IPSec connection was created, in the format defined by [RFC3339](https://tools.ietf.org/html/rfc3339).  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def tunnels(self) -> Sequence['outputs.GetIpsecStatusTunnelResult']:
        """
        Two [TunnelStatus](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/TunnelStatus/) objects.
        """
        return pulumi.get(self, "tunnels")


class AwaitableGetIpsecStatusResult(GetIpsecStatusResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetIpsecStatusResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            ipsec_id=self.ipsec_id,
            time_created=self.time_created,
            tunnels=self.tunnels)


def get_ipsec_status(filters: Optional[Sequence[pulumi.InputType['GetIpsecStatusFilterArgs']]] = None,
                     ipsec_id: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetIpsecStatusResult:
    """
    This data source provides details about a specific Ip Sec Connection Device Status resource in Oracle Cloud Infrastructure Core service.

    Deprecated. To get the tunnel status, instead use
    [GetIPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/GetIPSecConnectionTunnel).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_device_status = oci.Core.get_ipsec_status(ipsec_id=oci_core_ipsec["test_ipsec"]["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    """
    __args__ = dict()
    __args__['filters'] = filters
    __args__['ipsecId'] = ipsec_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Core/getIpsecStatus:getIpsecStatus', __args__, opts=opts, typ=GetIpsecStatusResult).value

    return AwaitableGetIpsecStatusResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        ipsec_id=pulumi.get(__ret__, 'ipsec_id'),
        time_created=pulumi.get(__ret__, 'time_created'),
        tunnels=pulumi.get(__ret__, 'tunnels'))


@_utilities.lift_output_func(get_ipsec_status)
def get_ipsec_status_output(filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetIpsecStatusFilterArgs']]]]] = None,
                            ipsec_id: Optional[pulumi.Input[str]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetIpsecStatusResult]:
    """
    This data source provides details about a specific Ip Sec Connection Device Status resource in Oracle Cloud Infrastructure Core service.

    Deprecated. To get the tunnel status, instead use
    [GetIPSecConnectionTunnel](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/latest/IPSecConnectionTunnel/GetIPSecConnectionTunnel).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_ip_sec_connection_device_status = oci.Core.get_ipsec_status(ipsec_id=oci_core_ipsec["test_ipsec"]["id"])
    ```


    :param str ipsec_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the IPSec connection.
    """
    ...
