# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DataGuardAssociationArgs', 'DataGuardAssociation']

@pulumi.input_type
class DataGuardAssociationArgs:
    def __init__(__self__, *,
                 creation_type: pulumi.Input[str],
                 database_admin_password: pulumi.Input[str],
                 database_id: pulumi.Input[str],
                 delete_standby_db_home_on_delete: pulumi.Input[str],
                 protection_mode: pulumi.Input[str],
                 transport_type: pulumi.Input[str],
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 data_collection_options: Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']] = None,
                 database_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_software_image_id: Optional[pulumi.Input[str]] = None,
                 db_system_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 db_system_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_active_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_db_home_id: Optional[pulumi.Input[str]] = None,
                 peer_db_system_id: Optional[pulumi.Input[str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[str]] = None,
                 peer_sid_prefix: Optional[pulumi.Input[str]] = None,
                 peer_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DataGuardAssociation resource.
        :param pulumi.Input[str] creation_type: Specifies whether to create the peer database in an existing DB system or in a new DB system.
        :param pulumi.Input[str] database_admin_password: (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.
               
               The password must contain no fewer than nine characters and include:
               * At least two uppercase characters.
               * At least two lowercase characters.
               * At least two numeric characters.
               * At least two special characters. Valid special characters include "_", "#", and "-" only.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] protection_mode: (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        :param pulumi.Input[str] transport_type: (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
               * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
               * MAXIMUM_PERFORMANCE - ASYNC
               * MAXIMUM_PROTECTION - SYNC
               
               For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[int] cpu_core_count: The number of OCPU cores available for AMD-based virtual machine DB systems.
        :param pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs'] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[Mapping[str, Any]] database_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] database_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        :param pulumi.Input[Mapping[str, Any]] db_system_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] db_system_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] display_name: The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[str] hostname: The hostname for the DB node.
        :param pulumi.Input[bool] is_active_data_guard_enabled: (Updatable) True if active Data Guard is enabled.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[int] node_count: The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] peer_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        :param pulumi.Input[str] peer_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        :param pulumi.Input[str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[str] peer_sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] peer_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        :param pulumi.Input[str] private_ip: The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        :param pulumi.Input[str] shape: The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.
               
               To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
               * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        :param pulumi.Input[str] time_zone: The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        pulumi.set(__self__, "creation_type", creation_type)
        pulumi.set(__self__, "database_admin_password", database_admin_password)
        pulumi.set(__self__, "database_id", database_id)
        pulumi.set(__self__, "delete_standby_db_home_on_delete", delete_standby_db_home_on_delete)
        pulumi.set(__self__, "protection_mode", protection_mode)
        pulumi.set(__self__, "transport_type", transport_type)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if create_async is not None:
            pulumi.set(__self__, "create_async", create_async)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if database_defined_tags is not None:
            pulumi.set(__self__, "database_defined_tags", database_defined_tags)
        if database_freeform_tags is not None:
            pulumi.set(__self__, "database_freeform_tags", database_freeform_tags)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_system_defined_tags is not None:
            pulumi.set(__self__, "db_system_defined_tags", db_system_defined_tags)
        if db_system_freeform_tags is not None:
            pulumi.set(__self__, "db_system_freeform_tags", db_system_freeform_tags)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_active_data_guard_enabled is not None:
            pulumi.set(__self__, "is_active_data_guard_enabled", is_active_data_guard_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if peer_db_home_id is not None:
            pulumi.set(__self__, "peer_db_home_id", peer_db_home_id)
        if peer_db_system_id is not None:
            pulumi.set(__self__, "peer_db_system_id", peer_db_system_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if peer_sid_prefix is not None:
            pulumi.set(__self__, "peer_sid_prefix", peer_sid_prefix)
        if peer_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_vm_cluster_id", peer_vm_cluster_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if storage_volume_performance_mode is not None:
            pulumi.set(__self__, "storage_volume_performance_mode", storage_volume_performance_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> pulumi.Input[str]:
        """
        Specifies whether to create the peer database in an existing DB system or in a new DB system.
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "creation_type", value)

    @property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> pulumi.Input[str]:
        """
        (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.

        The password must contain no fewer than nine characters and include:
        * At least two uppercase characters.
        * At least two lowercase characters.
        * At least two numeric characters.
        * At least two special characters. Valid special characters include "_", "#", and "-" only.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @database_admin_password.setter
    def database_admin_password(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_admin_password", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Input[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="deleteStandbyDbHomeOnDelete")
    def delete_standby_db_home_on_delete(self) -> pulumi.Input[str]:
        return pulumi.get(self, "delete_standby_db_home_on_delete")

    @delete_standby_db_home_on_delete.setter
    def delete_standby_db_home_on_delete(self, value: pulumi.Input[str]):
        pulumi.set(self, "delete_standby_db_home_on_delete", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Input[str]:
        """
        (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: pulumi.Input[str]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "transport_type")

    @transport_type.setter
    def transport_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "transport_type", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of OCPU cores available for AMD-based virtual machine DB systems.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']]:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="databaseDefinedTags")
    def database_defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "database_defined_tags")

    @database_defined_tags.setter
    def database_defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "database_defined_tags", value)

    @property
    @pulumi.getter(name="databaseFreeformTags")
    def database_freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "database_freeform_tags")

    @database_freeform_tags.setter
    def database_freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "database_freeform_tags", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_software_image_id", value)

    @property
    @pulumi.getter(name="dbSystemDefinedTags")
    def db_system_defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "db_system_defined_tags")

    @db_system_defined_tags.setter
    def db_system_defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "db_system_defined_tags", value)

    @property
    @pulumi.getter(name="dbSystemFreeformTags")
    def db_system_freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "db_system_freeform_tags")

    @db_system_freeform_tags.setter
    def db_system_freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "db_system_freeform_tags", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the DB node.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="isActiveDataGuardEnabled")
    def is_active_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if active Data Guard is enabled.
        """
        return pulumi.get(self, "is_active_data_guard_enabled")

    @is_active_data_guard_enabled.setter
    def is_active_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active_data_guard_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="peerDbHomeId")
    def peer_db_home_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        """
        return pulumi.get(self, "peer_db_home_id")

    @peer_db_home_id.setter
    def peer_db_home_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_home_id", value)

    @property
    @pulumi.getter(name="peerDbSystemId")
    def peer_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        """
        return pulumi.get(self, "peer_db_system_id")

    @peer_db_system_id.setter
    def peer_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_system_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="peerSidPrefix")
    def peer_sid_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "peer_sid_prefix")

    @peer_sid_prefix.setter
    def peer_sid_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_sid_prefix", value)

    @property
    @pulumi.getter(name="peerVmClusterId")
    def peer_vm_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        """
        return pulumi.get(self, "peer_vm_cluster_id")

    @peer_vm_cluster_id.setter
    def peer_vm_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_vm_cluster_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.

        To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @storage_volume_performance_mode.setter
    def storage_volume_performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_volume_performance_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
        * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)


@pulumi.input_type
class _DataGuardAssociationState:
    def __init__(__self__, *,
                 apply_lag: Optional[pulumi.Input[str]] = None,
                 apply_rate: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 creation_type: Optional[pulumi.Input[str]] = None,
                 data_collection_options: Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']] = None,
                 database_admin_password: Optional[pulumi.Input[str]] = None,
                 database_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_software_image_id: Optional[pulumi.Input[str]] = None,
                 db_system_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 db_system_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_standby_db_home_on_delete: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_active_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_data_guard_association_id: Optional[pulumi.Input[str]] = None,
                 peer_database_id: Optional[pulumi.Input[str]] = None,
                 peer_db_home_id: Optional[pulumi.Input[str]] = None,
                 peer_db_system_id: Optional[pulumi.Input[str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[str]] = None,
                 peer_role: Optional[pulumi.Input[str]] = None,
                 peer_sid_prefix: Optional[pulumi.Input[str]] = None,
                 peer_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 transport_type: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DataGuardAssociation resources.
        :param pulumi.Input[str] apply_lag: The lag time between updates to the primary database and application of the redo data on the standby database, as computed by the reporting database.  Example: `9 seconds`
        :param pulumi.Input[str] apply_rate: The rate at which redo logs are synced between the associated databases.  Example: `180 Mb per second`
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[int] cpu_core_count: The number of OCPU cores available for AMD-based virtual machine DB systems.
        :param pulumi.Input[str] creation_type: Specifies whether to create the peer database in an existing DB system or in a new DB system.
        :param pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs'] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[str] database_admin_password: (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.
               
               The password must contain no fewer than nine characters and include:
               * At least two uppercase characters.
               * At least two lowercase characters.
               * At least two numeric characters.
               * At least two special characters. Valid special characters include "_", "#", and "-" only.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[Mapping[str, Any]] database_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] database_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        :param pulumi.Input[Mapping[str, Any]] db_system_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] db_system_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] display_name: The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[str] hostname: The hostname for the DB node.
        :param pulumi.Input[bool] is_active_data_guard_enabled: (Updatable) True if active Data Guard is enabled.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycleState, if available.
        :param pulumi.Input[int] node_count: The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] peer_data_guard_association_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer database's Data Guard association.
        :param pulumi.Input[str] peer_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated peer database.
        :param pulumi.Input[str] peer_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        :param pulumi.Input[str] peer_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        :param pulumi.Input[str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[str] peer_role: The role of the peer database in this Data Guard association.
        :param pulumi.Input[str] peer_sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] peer_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        :param pulumi.Input[str] private_ip: The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        :param pulumi.Input[str] protection_mode: (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        :param pulumi.Input[str] role: The role of the reporting database in this Data Guard association.
        :param pulumi.Input[str] shape: The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.
               
               To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] state: The current state of the Data Guard association.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
               * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        :param pulumi.Input[str] time_created: The date and time the Data Guard association was created.
        :param pulumi.Input[str] time_zone: The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] transport_type: (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
               * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
               * MAXIMUM_PERFORMANCE - ASYNC
               * MAXIMUM_PROTECTION - SYNC
               
               For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        if apply_lag is not None:
            pulumi.set(__self__, "apply_lag", apply_lag)
        if apply_rate is not None:
            pulumi.set(__self__, "apply_rate", apply_rate)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if create_async is not None:
            pulumi.set(__self__, "create_async", create_async)
        if creation_type is not None:
            pulumi.set(__self__, "creation_type", creation_type)
        if data_collection_options is not None:
            pulumi.set(__self__, "data_collection_options", data_collection_options)
        if database_admin_password is not None:
            pulumi.set(__self__, "database_admin_password", database_admin_password)
        if database_defined_tags is not None:
            pulumi.set(__self__, "database_defined_tags", database_defined_tags)
        if database_freeform_tags is not None:
            pulumi.set(__self__, "database_freeform_tags", database_freeform_tags)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_software_image_id is not None:
            pulumi.set(__self__, "database_software_image_id", database_software_image_id)
        if db_system_defined_tags is not None:
            pulumi.set(__self__, "db_system_defined_tags", db_system_defined_tags)
        if db_system_freeform_tags is not None:
            pulumi.set(__self__, "db_system_freeform_tags", db_system_freeform_tags)
        if delete_standby_db_home_on_delete is not None:
            pulumi.set(__self__, "delete_standby_db_home_on_delete", delete_standby_db_home_on_delete)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if is_active_data_guard_enabled is not None:
            pulumi.set(__self__, "is_active_data_guard_enabled", is_active_data_guard_enabled)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if peer_data_guard_association_id is not None:
            pulumi.set(__self__, "peer_data_guard_association_id", peer_data_guard_association_id)
        if peer_database_id is not None:
            pulumi.set(__self__, "peer_database_id", peer_database_id)
        if peer_db_home_id is not None:
            pulumi.set(__self__, "peer_db_home_id", peer_db_home_id)
        if peer_db_system_id is not None:
            pulumi.set(__self__, "peer_db_system_id", peer_db_system_id)
        if peer_db_unique_name is not None:
            pulumi.set(__self__, "peer_db_unique_name", peer_db_unique_name)
        if peer_role is not None:
            pulumi.set(__self__, "peer_role", peer_role)
        if peer_sid_prefix is not None:
            pulumi.set(__self__, "peer_sid_prefix", peer_sid_prefix)
        if peer_vm_cluster_id is not None:
            pulumi.set(__self__, "peer_vm_cluster_id", peer_vm_cluster_id)
        if private_ip is not None:
            pulumi.set(__self__, "private_ip", private_ip)
        if protection_mode is not None:
            pulumi.set(__self__, "protection_mode", protection_mode)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if storage_volume_performance_mode is not None:
            pulumi.set(__self__, "storage_volume_performance_mode", storage_volume_performance_mode)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if transport_type is not None:
            pulumi.set(__self__, "transport_type", transport_type)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> Optional[pulumi.Input[str]]:
        """
        The lag time between updates to the primary database and application of the redo data on the standby database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @apply_lag.setter
    def apply_lag(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_lag", value)

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> Optional[pulumi.Input[str]]:
        """
        The rate at which redo logs are synced between the associated databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @apply_rate.setter
    def apply_rate(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "apply_rate", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of OCPU cores available for AMD-based virtual machine DB systems.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> Optional[pulumi.Input[bool]]:
        return pulumi.get(self, "create_async")

    @create_async.setter
    def create_async(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "create_async", value)

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies whether to create the peer database in an existing DB system or in a new DB system.
        """
        return pulumi.get(self, "creation_type")

    @creation_type.setter
    def creation_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creation_type", value)

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']]:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @data_collection_options.setter
    def data_collection_options(self, value: Optional[pulumi.Input['DataGuardAssociationDataCollectionOptionsArgs']]):
        pulumi.set(self, "data_collection_options", value)

    @property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.

        The password must contain no fewer than nine characters and include:
        * At least two uppercase characters.
        * At least two lowercase characters.
        * At least two numeric characters.
        * At least two special characters. Valid special characters include "_", "#", and "-" only.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @database_admin_password.setter
    def database_admin_password(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_admin_password", value)

    @property
    @pulumi.getter(name="databaseDefinedTags")
    def database_defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "database_defined_tags")

    @database_defined_tags.setter
    def database_defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "database_defined_tags", value)

    @property
    @pulumi.getter(name="databaseFreeformTags")
    def database_freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "database_freeform_tags")

    @database_freeform_tags.setter
    def database_freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "database_freeform_tags", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> Optional[pulumi.Input[str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        """
        return pulumi.get(self, "database_software_image_id")

    @database_software_image_id.setter
    def database_software_image_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_software_image_id", value)

    @property
    @pulumi.getter(name="dbSystemDefinedTags")
    def db_system_defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "db_system_defined_tags")

    @db_system_defined_tags.setter
    def db_system_defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "db_system_defined_tags", value)

    @property
    @pulumi.getter(name="dbSystemFreeformTags")
    def db_system_freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "db_system_freeform_tags")

    @db_system_freeform_tags.setter
    def db_system_freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "db_system_freeform_tags", value)

    @property
    @pulumi.getter(name="deleteStandbyDbHomeOnDelete")
    def delete_standby_db_home_on_delete(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "delete_standby_db_home_on_delete")

    @delete_standby_db_home_on_delete.setter
    def delete_standby_db_home_on_delete(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "delete_standby_db_home_on_delete", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the DB node.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="isActiveDataGuardEnabled")
    def is_active_data_guard_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) True if active Data Guard is enabled.
        """
        return pulumi.get(self, "is_active_data_guard_enabled")

    @is_active_data_guard_enabled.setter
    def is_active_data_guard_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_active_data_guard_enabled", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="peerDataGuardAssociationId")
    def peer_data_guard_association_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer database's Data Guard association.
        """
        return pulumi.get(self, "peer_data_guard_association_id")

    @peer_data_guard_association_id.setter
    def peer_data_guard_association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_data_guard_association_id", value)

    @property
    @pulumi.getter(name="peerDatabaseId")
    def peer_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated peer database.
        """
        return pulumi.get(self, "peer_database_id")

    @peer_database_id.setter
    def peer_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_database_id", value)

    @property
    @pulumi.getter(name="peerDbHomeId")
    def peer_db_home_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        """
        return pulumi.get(self, "peer_db_home_id")

    @peer_db_home_id.setter
    def peer_db_home_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_home_id", value)

    @property
    @pulumi.getter(name="peerDbSystemId")
    def peer_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        """
        return pulumi.get(self, "peer_db_system_id")

    @peer_db_system_id.setter
    def peer_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_system_id", value)

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @peer_db_unique_name.setter
    def peer_db_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_db_unique_name", value)

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of the peer database in this Data Guard association.
        """
        return pulumi.get(self, "peer_role")

    @peer_role.setter
    def peer_role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_role", value)

    @property
    @pulumi.getter(name="peerSidPrefix")
    def peer_sid_prefix(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "peer_sid_prefix")

    @peer_sid_prefix.setter
    def peer_sid_prefix(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_sid_prefix", value)

    @property
    @pulumi.getter(name="peerVmClusterId")
    def peer_vm_cluster_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        """
        return pulumi.get(self, "peer_vm_cluster_id")

    @peer_vm_cluster_id.setter
    def peer_vm_cluster_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_vm_cluster_id", value)

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[pulumi.Input[str]]:
        """
        The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        """
        return pulumi.get(self, "private_ip")

    @private_ip.setter
    def private_ip(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "private_ip", value)

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        """
        return pulumi.get(self, "protection_mode")

    @protection_mode.setter
    def protection_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "protection_mode", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        The role of the reporting database in this Data Guard association.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.

        To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Data Guard association.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> Optional[pulumi.Input[str]]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @storage_volume_performance_mode.setter
    def storage_volume_performance_mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "storage_volume_performance_mode", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
        * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the Data Guard association was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "transport_type")

    @transport_type.setter
    def transport_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "transport_type", value)


class DataGuardAssociation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 creation_type: Optional[pulumi.Input[str]] = None,
                 data_collection_options: Optional[pulumi.Input[pulumi.InputType['DataGuardAssociationDataCollectionOptionsArgs']]] = None,
                 database_admin_password: Optional[pulumi.Input[str]] = None,
                 database_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_software_image_id: Optional[pulumi.Input[str]] = None,
                 db_system_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 db_system_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_standby_db_home_on_delete: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_active_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_db_home_id: Optional[pulumi.Input[str]] = None,
                 peer_db_system_id: Optional[pulumi.Input[str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[str]] = None,
                 peer_sid_prefix: Optional[pulumi.Input[str]] = None,
                 peer_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 transport_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Data Guard Association resource in Oracle Cloud Infrastructure Database service.

        Creates a new Data Guard association.  A Data Guard association represents the replication relationship between the
        specified database and a peer database. For more information, see [Using Oracle Data Guard](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/usingdataguard.htm).

        All Oracle Cloud Infrastructure resources, including Data Guard associations, get an Oracle-assigned, unique ID
        called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource type, or by viewing the
        resource in the Console. For more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_guard_association = oci.database.DataGuardAssociation("testDataGuardAssociation",
            creation_type=var["data_guard_association_creation_type"],
            database_admin_password=var["data_guard_association_database_admin_password"],
            database_id=oci_database_database["test_database"]["id"],
            delete_standby_db_home_on_delete=var["data_guard_association_delete_standby_db_home_on_delete"],
            protection_mode=var["data_guard_association_protection_mode"],
            transport_type=var["data_guard_association_transport_type"],
            availability_domain=var["data_guard_association_availability_domain"],
            backup_network_nsg_ids=var["data_guard_association_backup_network_nsg_ids"],
            cpu_core_count=var["data_guard_association_cpu_core_count"],
            database_defined_tags=var["data_guard_association_database_defined_tags"],
            database_freeform_tags=var["data_guard_association_database_freeform_tags"],
            data_collection_options=oci.database.DataGuardAssociationDataCollectionOptionsArgs(
                is_diagnostics_events_enabled=var["data_guard_association_data_collection_options_is_diagnostics_events_enabled"],
                is_health_monitoring_enabled=var["data_guard_association_data_collection_options_is_health_monitoring_enabled"],
                is_incident_logs_enabled=var["data_guard_association_data_collection_options_is_incident_logs_enabled"],
            ),
            database_software_image_id=oci_database_database_software_image["test_database_software_image"]["id"],
            db_system_defined_tags=var["data_guard_association_db_system_defined_tags"],
            db_system_freeform_tags=var["data_guard_association_db_system_freeform_tags"],
            display_name=var["data_guard_association_display_name"],
            fault_domains=var["data_guard_association_fault_domains"],
            hostname=var["data_guard_association_hostname"],
            is_active_data_guard_enabled=var["data_guard_association_is_active_data_guard_enabled"],
            license_model=var["data_guard_association_license_model"],
            node_count=var["data_guard_association_node_count"],
            nsg_ids=var["data_guard_association_nsg_ids"],
            peer_db_home_id=oci_database_db_home["test_db_home"]["id"],
            peer_db_system_id=oci_database_db_system["test_db_system"]["id"],
            peer_db_unique_name=var["data_guard_association_peer_db_unique_name"],
            peer_sid_prefix=var["data_guard_association_peer_sid_prefix"],
            peer_vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
            private_ip=var["data_guard_association_private_ip"],
            shape=var["data_guard_association_shape"],
            storage_volume_performance_mode=var["data_guard_association_storage_volume_performance_mode"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            time_zone=var["data_guard_association_time_zone"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[int] cpu_core_count: The number of OCPU cores available for AMD-based virtual machine DB systems.
        :param pulumi.Input[str] creation_type: Specifies whether to create the peer database in an existing DB system or in a new DB system.
        :param pulumi.Input[pulumi.InputType['DataGuardAssociationDataCollectionOptionsArgs']] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[str] database_admin_password: (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.
               
               The password must contain no fewer than nine characters and include:
               * At least two uppercase characters.
               * At least two lowercase characters.
               * At least two numeric characters.
               * At least two special characters. Valid special characters include "_", "#", and "-" only.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[Mapping[str, Any]] database_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] database_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        :param pulumi.Input[Mapping[str, Any]] db_system_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] db_system_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] display_name: The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[str] hostname: The hostname for the DB node.
        :param pulumi.Input[bool] is_active_data_guard_enabled: (Updatable) True if active Data Guard is enabled.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[int] node_count: The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] peer_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        :param pulumi.Input[str] peer_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        :param pulumi.Input[str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[str] peer_sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] peer_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        :param pulumi.Input[str] private_ip: The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        :param pulumi.Input[str] protection_mode: (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        :param pulumi.Input[str] shape: The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.
               
               To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
               * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        :param pulumi.Input[str] time_zone: The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] transport_type: (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
               * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
               * MAXIMUM_PERFORMANCE - ASYNC
               * MAXIMUM_PROTECTION - SYNC
               
               For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DataGuardAssociationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Data Guard Association resource in Oracle Cloud Infrastructure Database service.

        Creates a new Data Guard association.  A Data Guard association represents the replication relationship between the
        specified database and a peer database. For more information, see [Using Oracle Data Guard](https://docs.cloud.oracle.com/iaas/Content/Database/Tasks/usingdataguard.htm).

        All Oracle Cloud Infrastructure resources, including Data Guard associations, get an Oracle-assigned, unique ID
        called an Oracle Cloud Identifier (OCID). When you create a resource, you can find its OCID in the response.
        You can also retrieve a resource's OCID by using a List API operation on that resource type, or by viewing the
        resource in the Console. For more information, see
        [Resource Identifiers](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_data_guard_association = oci.database.DataGuardAssociation("testDataGuardAssociation",
            creation_type=var["data_guard_association_creation_type"],
            database_admin_password=var["data_guard_association_database_admin_password"],
            database_id=oci_database_database["test_database"]["id"],
            delete_standby_db_home_on_delete=var["data_guard_association_delete_standby_db_home_on_delete"],
            protection_mode=var["data_guard_association_protection_mode"],
            transport_type=var["data_guard_association_transport_type"],
            availability_domain=var["data_guard_association_availability_domain"],
            backup_network_nsg_ids=var["data_guard_association_backup_network_nsg_ids"],
            cpu_core_count=var["data_guard_association_cpu_core_count"],
            database_defined_tags=var["data_guard_association_database_defined_tags"],
            database_freeform_tags=var["data_guard_association_database_freeform_tags"],
            data_collection_options=oci.database.DataGuardAssociationDataCollectionOptionsArgs(
                is_diagnostics_events_enabled=var["data_guard_association_data_collection_options_is_diagnostics_events_enabled"],
                is_health_monitoring_enabled=var["data_guard_association_data_collection_options_is_health_monitoring_enabled"],
                is_incident_logs_enabled=var["data_guard_association_data_collection_options_is_incident_logs_enabled"],
            ),
            database_software_image_id=oci_database_database_software_image["test_database_software_image"]["id"],
            db_system_defined_tags=var["data_guard_association_db_system_defined_tags"],
            db_system_freeform_tags=var["data_guard_association_db_system_freeform_tags"],
            display_name=var["data_guard_association_display_name"],
            fault_domains=var["data_guard_association_fault_domains"],
            hostname=var["data_guard_association_hostname"],
            is_active_data_guard_enabled=var["data_guard_association_is_active_data_guard_enabled"],
            license_model=var["data_guard_association_license_model"],
            node_count=var["data_guard_association_node_count"],
            nsg_ids=var["data_guard_association_nsg_ids"],
            peer_db_home_id=oci_database_db_home["test_db_home"]["id"],
            peer_db_system_id=oci_database_db_system["test_db_system"]["id"],
            peer_db_unique_name=var["data_guard_association_peer_db_unique_name"],
            peer_sid_prefix=var["data_guard_association_peer_sid_prefix"],
            peer_vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
            private_ip=var["data_guard_association_private_ip"],
            shape=var["data_guard_association_shape"],
            storage_volume_performance_mode=var["data_guard_association_storage_volume_performance_mode"],
            subnet_id=oci_core_subnet["test_subnet"]["id"],
            time_zone=var["data_guard_association_time_zone"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DataGuardAssociationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DataGuardAssociationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 create_async: Optional[pulumi.Input[bool]] = None,
                 creation_type: Optional[pulumi.Input[str]] = None,
                 data_collection_options: Optional[pulumi.Input[pulumi.InputType['DataGuardAssociationDataCollectionOptionsArgs']]] = None,
                 database_admin_password: Optional[pulumi.Input[str]] = None,
                 database_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_software_image_id: Optional[pulumi.Input[str]] = None,
                 db_system_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 db_system_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 delete_standby_db_home_on_delete: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 is_active_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_db_home_id: Optional[pulumi.Input[str]] = None,
                 peer_db_system_id: Optional[pulumi.Input[str]] = None,
                 peer_db_unique_name: Optional[pulumi.Input[str]] = None,
                 peer_sid_prefix: Optional[pulumi.Input[str]] = None,
                 peer_vm_cluster_id: Optional[pulumi.Input[str]] = None,
                 private_ip: Optional[pulumi.Input[str]] = None,
                 protection_mode: Optional[pulumi.Input[str]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 transport_type: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DataGuardAssociationArgs.__new__(DataGuardAssociationArgs)

            __props__.__dict__["availability_domain"] = availability_domain
            __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
            __props__.__dict__["cpu_core_count"] = cpu_core_count
            __props__.__dict__["create_async"] = create_async
            if creation_type is None and not opts.urn:
                raise TypeError("Missing required property 'creation_type'")
            __props__.__dict__["creation_type"] = creation_type
            __props__.__dict__["data_collection_options"] = data_collection_options
            if database_admin_password is None and not opts.urn:
                raise TypeError("Missing required property 'database_admin_password'")
            __props__.__dict__["database_admin_password"] = None if database_admin_password is None else pulumi.Output.secret(database_admin_password)
            __props__.__dict__["database_defined_tags"] = database_defined_tags
            __props__.__dict__["database_freeform_tags"] = database_freeform_tags
            if database_id is None and not opts.urn:
                raise TypeError("Missing required property 'database_id'")
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["database_software_image_id"] = database_software_image_id
            __props__.__dict__["db_system_defined_tags"] = db_system_defined_tags
            __props__.__dict__["db_system_freeform_tags"] = db_system_freeform_tags
            if delete_standby_db_home_on_delete is None and not opts.urn:
                raise TypeError("Missing required property 'delete_standby_db_home_on_delete'")
            __props__.__dict__["delete_standby_db_home_on_delete"] = delete_standby_db_home_on_delete
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["fault_domains"] = fault_domains
            __props__.__dict__["hostname"] = hostname
            __props__.__dict__["is_active_data_guard_enabled"] = is_active_data_guard_enabled
            __props__.__dict__["license_model"] = license_model
            __props__.__dict__["node_count"] = node_count
            __props__.__dict__["nsg_ids"] = nsg_ids
            __props__.__dict__["peer_db_home_id"] = peer_db_home_id
            __props__.__dict__["peer_db_system_id"] = peer_db_system_id
            __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
            __props__.__dict__["peer_sid_prefix"] = peer_sid_prefix
            __props__.__dict__["peer_vm_cluster_id"] = peer_vm_cluster_id
            __props__.__dict__["private_ip"] = private_ip
            if protection_mode is None and not opts.urn:
                raise TypeError("Missing required property 'protection_mode'")
            __props__.__dict__["protection_mode"] = protection_mode
            __props__.__dict__["shape"] = shape
            __props__.__dict__["storage_volume_performance_mode"] = storage_volume_performance_mode
            __props__.__dict__["subnet_id"] = subnet_id
            __props__.__dict__["time_zone"] = time_zone
            if transport_type is None and not opts.urn:
                raise TypeError("Missing required property 'transport_type'")
            __props__.__dict__["transport_type"] = transport_type
            __props__.__dict__["apply_lag"] = None
            __props__.__dict__["apply_rate"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["peer_data_guard_association_id"] = None
            __props__.__dict__["peer_database_id"] = None
            __props__.__dict__["peer_role"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["databaseAdminPassword"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(DataGuardAssociation, __self__).__init__(
            'oci:Database/dataGuardAssociation:DataGuardAssociation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            apply_lag: Optional[pulumi.Input[str]] = None,
            apply_rate: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            create_async: Optional[pulumi.Input[bool]] = None,
            creation_type: Optional[pulumi.Input[str]] = None,
            data_collection_options: Optional[pulumi.Input[pulumi.InputType['DataGuardAssociationDataCollectionOptionsArgs']]] = None,
            database_admin_password: Optional[pulumi.Input[str]] = None,
            database_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            database_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_software_image_id: Optional[pulumi.Input[str]] = None,
            db_system_defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            db_system_freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            delete_standby_db_home_on_delete: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            is_active_data_guard_enabled: Optional[pulumi.Input[bool]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            peer_data_guard_association_id: Optional[pulumi.Input[str]] = None,
            peer_database_id: Optional[pulumi.Input[str]] = None,
            peer_db_home_id: Optional[pulumi.Input[str]] = None,
            peer_db_system_id: Optional[pulumi.Input[str]] = None,
            peer_db_unique_name: Optional[pulumi.Input[str]] = None,
            peer_role: Optional[pulumi.Input[str]] = None,
            peer_sid_prefix: Optional[pulumi.Input[str]] = None,
            peer_vm_cluster_id: Optional[pulumi.Input[str]] = None,
            private_ip: Optional[pulumi.Input[str]] = None,
            protection_mode: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            storage_volume_performance_mode: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            transport_type: Optional[pulumi.Input[str]] = None) -> 'DataGuardAssociation':
        """
        Get an existing DataGuardAssociation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] apply_lag: The lag time between updates to the primary database and application of the redo data on the standby database, as computed by the reporting database.  Example: `9 seconds`
        :param pulumi.Input[str] apply_rate: The rate at which redo logs are synced between the associated databases.  Example: `180 Mb per second`
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[int] cpu_core_count: The number of OCPU cores available for AMD-based virtual machine DB systems.
        :param pulumi.Input[str] creation_type: Specifies whether to create the peer database in an existing DB system or in a new DB system.
        :param pulumi.Input[pulumi.InputType['DataGuardAssociationDataCollectionOptionsArgs']] data_collection_options: Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        :param pulumi.Input[str] database_admin_password: (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.
               
               The password must contain no fewer than nine characters and include:
               * At least two uppercase characters.
               * At least two lowercase characters.
               * At least two numeric characters.
               * At least two special characters. Valid special characters include "_", "#", and "-" only.
               
               **The password MUST be the same as the primary admin password.**
        :param pulumi.Input[Mapping[str, Any]] database_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] database_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] database_id: The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[str] database_software_image_id: The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        :param pulumi.Input[Mapping[str, Any]] db_system_defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[Mapping[str, Any]] db_system_freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] display_name: The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.
               
               If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.
               
               If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.
               
               To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.
               
               Example: `FAULT-DOMAIN-1`
        :param pulumi.Input[str] hostname: The hostname for the DB node.
        :param pulumi.Input[bool] is_active_data_guard_enabled: (Updatable) True if active Data Guard is enabled.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycleState, if available.
        :param pulumi.Input[int] node_count: The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        :param pulumi.Input[str] peer_data_guard_association_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer database's Data Guard association.
        :param pulumi.Input[str] peer_database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated peer database.
        :param pulumi.Input[str] peer_db_home_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        :param pulumi.Input[str] peer_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        :param pulumi.Input[str] peer_db_unique_name: Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        :param pulumi.Input[str] peer_role: The role of the peer database in this Data Guard association.
        :param pulumi.Input[str] peer_sid_prefix: Specifies a prefix for the `Oracle SID` of the database to be created.
        :param pulumi.Input[str] peer_vm_cluster_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        :param pulumi.Input[str] private_ip: The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        :param pulumi.Input[str] protection_mode: (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        :param pulumi.Input[str] role: The role of the reporting database in this Data Guard association.
        :param pulumi.Input[str] shape: The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.
               
               To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        :param pulumi.Input[str] state: The current state of the Data Guard association.
        :param pulumi.Input[str] storage_volume_performance_mode: The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        :param pulumi.Input[str] subnet_id: The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
               * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28
               
               These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        :param pulumi.Input[str] time_created: The date and time the Data Guard association was created.
        :param pulumi.Input[str] time_zone: The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] transport_type: (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
               * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
               * MAXIMUM_PERFORMANCE - ASYNC
               * MAXIMUM_PROTECTION - SYNC
               
               For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.
               
               **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DataGuardAssociationState.__new__(_DataGuardAssociationState)

        __props__.__dict__["apply_lag"] = apply_lag
        __props__.__dict__["apply_rate"] = apply_rate
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["create_async"] = create_async
        __props__.__dict__["creation_type"] = creation_type
        __props__.__dict__["data_collection_options"] = data_collection_options
        __props__.__dict__["database_admin_password"] = database_admin_password
        __props__.__dict__["database_defined_tags"] = database_defined_tags
        __props__.__dict__["database_freeform_tags"] = database_freeform_tags
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_software_image_id"] = database_software_image_id
        __props__.__dict__["db_system_defined_tags"] = db_system_defined_tags
        __props__.__dict__["db_system_freeform_tags"] = db_system_freeform_tags
        __props__.__dict__["delete_standby_db_home_on_delete"] = delete_standby_db_home_on_delete
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["fault_domains"] = fault_domains
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["is_active_data_guard_enabled"] = is_active_data_guard_enabled
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["peer_data_guard_association_id"] = peer_data_guard_association_id
        __props__.__dict__["peer_database_id"] = peer_database_id
        __props__.__dict__["peer_db_home_id"] = peer_db_home_id
        __props__.__dict__["peer_db_system_id"] = peer_db_system_id
        __props__.__dict__["peer_db_unique_name"] = peer_db_unique_name
        __props__.__dict__["peer_role"] = peer_role
        __props__.__dict__["peer_sid_prefix"] = peer_sid_prefix
        __props__.__dict__["peer_vm_cluster_id"] = peer_vm_cluster_id
        __props__.__dict__["private_ip"] = private_ip
        __props__.__dict__["protection_mode"] = protection_mode
        __props__.__dict__["role"] = role
        __props__.__dict__["shape"] = shape
        __props__.__dict__["state"] = state
        __props__.__dict__["storage_volume_performance_mode"] = storage_volume_performance_mode
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["transport_type"] = transport_type
        return DataGuardAssociation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="applyLag")
    def apply_lag(self) -> pulumi.Output[str]:
        """
        The lag time between updates to the primary database and application of the redo data on the standby database, as computed by the reporting database.  Example: `9 seconds`
        """
        return pulumi.get(self, "apply_lag")

    @property
    @pulumi.getter(name="applyRate")
    def apply_rate(self) -> pulumi.Output[str]:
        """
        The rate at which redo logs are synced between the associated databases.  Example: `180 Mb per second`
        """
        return pulumi.get(self, "apply_rate")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the standby database DB system will be located in. For example- "Uocm:PHX-AD-1".
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        The number of OCPU cores available for AMD-based virtual machine DB systems.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="createAsync")
    def create_async(self) -> pulumi.Output[Optional[bool]]:
        return pulumi.get(self, "create_async")

    @property
    @pulumi.getter(name="creationType")
    def creation_type(self) -> pulumi.Output[str]:
        """
        Specifies whether to create the peer database in an existing DB system or in a new DB system.
        """
        return pulumi.get(self, "creation_type")

    @property
    @pulumi.getter(name="dataCollectionOptions")
    def data_collection_options(self) -> pulumi.Output['outputs.DataGuardAssociationDataCollectionOptions']:
        """
        Indicates user preferences for the various diagnostic collection options for the VM cluster/Cloud VM cluster/VMBM DBCS.
        """
        return pulumi.get(self, "data_collection_options")

    @property
    @pulumi.getter(name="databaseAdminPassword")
    def database_admin_password(self) -> pulumi.Output[str]:
        """
        (Updatable) A strong password for the `SYS`, `SYSTEM`, and `PDB Admin` users to apply during standby creation.

        The password must contain no fewer than nine characters and include:
        * At least two uppercase characters.
        * At least two lowercase characters.
        * At least two numeric characters.
        * At least two special characters. Valid special characters include "_", "#", and "-" only.

        **The password MUST be the same as the primary admin password.**
        """
        return pulumi.get(self, "database_admin_password")

    @property
    @pulumi.getter(name="databaseDefinedTags")
    def database_defined_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "database_defined_tags")

    @property
    @pulumi.getter(name="databaseFreeformTags")
    def database_freeform_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "database_freeform_tags")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        The database [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseSoftwareImageId")
    def database_software_image_id(self) -> pulumi.Output[Optional[str]]:
        """
        The database software image [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm). Applicable only when creationType=`ExistingDbSystem` and when the existing database has Exadata shape.
        """
        return pulumi.get(self, "database_software_image_id")

    @property
    @pulumi.getter(name="dbSystemDefinedTags")
    def db_system_defined_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "db_system_defined_tags")

    @property
    @pulumi.getter(name="dbSystemFreeformTags")
    def db_system_freeform_tags(self) -> pulumi.Output[Optional[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "db_system_freeform_tags")

    @property
    @pulumi.getter(name="deleteStandbyDbHomeOnDelete")
    def delete_standby_db_home_on_delete(self) -> pulumi.Output[str]:
        return pulumi.get(self, "delete_standby_db_home_on_delete")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name of the DB system that will contain the the standby database. The display name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        A Fault Domain is a grouping of hardware and infrastructure within an availability domain. Fault Domains let you distribute your instances so that they are not on the same physical hardware within a single availability domain. A hardware failure or maintenance that affects one Fault Domain does not affect DB systems in other Fault Domains.

        If you do not specify the Fault Domain, the system selects one for you. To change the Fault Domain for a DB system, terminate it and launch a new DB system in the preferred Fault Domain.

        If the node count is greater than 1, you can specify which Fault Domains these nodes will be distributed into. The system assigns your nodes automatically to the Fault Domains you specify so that no Fault Domain contains more than one node.

        To get a list of Fault Domains, use the [ListFaultDomains](https://docs.cloud.oracle.com/iaas/api/#/en/identity/latest/FaultDomain/ListFaultDomains) operation in the Identity and Access Management Service API.

        Example: `FAULT-DOMAIN-1`
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname for the DB node.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="isActiveDataGuardEnabled")
    def is_active_data_guard_enabled(self) -> pulumi.Output[Optional[bool]]:
        """
        (Updatable) True if active Data Guard is enabled.
        """
        return pulumi.get(self, "is_active_data_guard_enabled")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[Optional[str]]:
        """
        The Oracle license model that applies to all the databases on the dataguard standby DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycleState, if available.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[Optional[int]]:
        """
        The number of nodes to launch for the DB system of the standby in the Data Guard association. For a 2-node RAC virtual machine DB system, specify either 1 or 2. If you do not supply this parameter, the default is the node count of the primary DB system.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Optional[Sequence[str]]]:
        """
        The list of [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) for the network security groups (NSGs) to which this resource belongs. Setting this to an empty list removes all resources from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * A network security group (NSG) is optional for Autonomous Databases with private access. The nsgIds list can be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="peerDataGuardAssociationId")
    def peer_data_guard_association_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the peer database's Data Guard association.
        """
        return pulumi.get(self, "peer_data_guard_association_id")

    @property
    @pulumi.getter(name="peerDatabaseId")
    def peer_database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the associated peer database.
        """
        return pulumi.get(self, "peer_database_id")

    @property
    @pulumi.getter(name="peerDbHomeId")
    def peer_db_home_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB home in which to create the standby database. You must supply this value to create standby database with an existing DB home
        """
        return pulumi.get(self, "peer_db_home_id")

    @property
    @pulumi.getter(name="peerDbSystemId")
    def peer_db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system in which to create the standby database. You must supply this value if creationType is `ExistingDbSystem`.
        """
        return pulumi.get(self, "peer_db_system_id")

    @property
    @pulumi.getter(name="peerDbUniqueName")
    def peer_db_unique_name(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the `DB_UNIQUE_NAME` of the peer database to be created.
        """
        return pulumi.get(self, "peer_db_unique_name")

    @property
    @pulumi.getter(name="peerRole")
    def peer_role(self) -> pulumi.Output[str]:
        """
        The role of the peer database in this Data Guard association.
        """
        return pulumi.get(self, "peer_role")

    @property
    @pulumi.getter(name="peerSidPrefix")
    def peer_sid_prefix(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies a prefix for the `Oracle SID` of the database to be created.
        """
        return pulumi.get(self, "peer_sid_prefix")

    @property
    @pulumi.getter(name="peerVmClusterId")
    def peer_vm_cluster_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster in which to create the standby database. You must supply this value if creationType is `ExistingVmCluster`.
        """
        return pulumi.get(self, "peer_vm_cluster_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> pulumi.Output[Optional[str]]:
        """
        The IPv4 address from the provided Oracle Cloud Infrastructure subnet which needs to be assigned to the VNIC. If not provided, it will be auto-assigned with an available IPv4 address from the subnet.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="protectionMode")
    def protection_mode(self) -> pulumi.Output[str]:
        """
        (Updatable) The protection mode to set up between the primary and standby databases. For more information, see [Oracle Data Guard Protection Modes](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-protection-modes.htm#SBYDB02000) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only protection mode currently supported by the Database service is MAXIMUM_PERFORMANCE.
        """
        return pulumi.get(self, "protection_mode")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        The role of the reporting database in this Data Guard association.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The virtual machine DB system shape to launch for the standby database in the Data Guard association. The shape determines the number of CPU cores and the amount of memory available for the DB system. Only virtual machine shapes are valid options. If you do not supply this parameter, the default shape is the shape of the primary DB system.

        To get a list of all shapes, use the [ListDbSystemShapes](https://docs.cloud.oracle.com/iaas/api/#/en/database/latest/DbSystemShapeSummary/ListDbSystemShapes) operation.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Data Guard association.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="storageVolumePerformanceMode")
    def storage_volume_performance_mode(self) -> pulumi.Output[str]:
        """
        The block storage volume performance level. Valid values are `BALANCED` and `HIGH_PERFORMANCE`. See [Block Volume Performance](https://docs.cloud.oracle.com/iaas/Content/Block/Concepts/blockvolumeperformance.htm) for more information.
        """
        return pulumi.get(self, "storage_volume_performance_mode")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The OCID of the subnet the DB system is associated with. **Subnet Restrictions:**
        * For 1- and 2-node RAC DB systems, do not use a subnet that overlaps with 192.168.16.16/28

        These subnets are used by the Oracle Clusterware private interconnect on the database instance. Specifying an overlapping subnet will cause the private interconnect to malfunction. This restriction applies to both the client subnet and backup subnet.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the Data Guard association was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[Optional[str]]:
        """
        The time zone of the dataguard standby DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter(name="transportType")
    def transport_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The redo transport type to use for this Data Guard association.  Valid values depend on the specified `protectionMode`:
        * MAXIMUM_AVAILABILITY - SYNC or FASTSYNC
        * MAXIMUM_PERFORMANCE - ASYNC
        * MAXIMUM_PROTECTION - SYNC

        For more information, see [Redo Transport Services](http://docs.oracle.com/database/122/SBYDB/oracle-data-guard-redo-transport-services.htm#SBYDB00400) in the Oracle Data Guard documentation.

        **IMPORTANT** - The only transport type currently supported by the Database service is ASYNC.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "transport_type")

