# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DbSystemsUpgradeArgs', 'DbSystemsUpgrade']

@pulumi.input_type
class DbSystemsUpgradeArgs:
    def __init__(__self__, *,
                 action: pulumi.Input[str],
                 db_system_id: pulumi.Input[str],
                 is_snapshot_retention_days_force_updated: Optional[pulumi.Input[bool]] = None,
                 new_gi_version: Optional[pulumi.Input[str]] = None,
                 new_os_version: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_period_in_days: Optional[pulumi.Input[int]] = None):
        """
        The set of arguments for constructing a DbSystemsUpgrade resource.
        :param pulumi.Input[str] action: The operating system upgrade action.
        :param pulumi.Input[str] db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[bool] is_snapshot_retention_days_force_updated: If true, rollback time is updated even if operating system upgrade history contains errors.
        :param pulumi.Input[str] new_gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[int] snapshot_retention_period_in_days: The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "action", action)
        pulumi.set(__self__, "db_system_id", db_system_id)
        if is_snapshot_retention_days_force_updated is not None:
            pulumi.set(__self__, "is_snapshot_retention_days_force_updated", is_snapshot_retention_days_force_updated)
        if new_gi_version is not None:
            pulumi.set(__self__, "new_gi_version", new_gi_version)
        if new_os_version is not None:
            pulumi.set(__self__, "new_os_version", new_os_version)
        if snapshot_retention_period_in_days is not None:
            pulumi.set(__self__, "snapshot_retention_period_in_days", snapshot_retention_period_in_days)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Input[str]:
        """
        The operating system upgrade action.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: pulumi.Input[str]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Input[str]:
        """
        The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="isSnapshotRetentionDaysForceUpdated")
    def is_snapshot_retention_days_force_updated(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, rollback time is updated even if operating system upgrade history contains errors.
        """
        return pulumi.get(self, "is_snapshot_retention_days_force_updated")

    @is_snapshot_retention_days_force_updated.setter
    def is_snapshot_retention_days_force_updated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_snapshot_retention_days_force_updated", value)

    @property
    @pulumi.getter(name="newGiVersion")
    def new_gi_version(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "new_gi_version")

    @new_gi_version.setter
    def new_gi_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_gi_version", value)

    @property
    @pulumi.getter(name="newOsVersion")
    def new_os_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "new_os_version")

    @new_os_version.setter
    def new_os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_os_version", value)

    @property
    @pulumi.getter(name="snapshotRetentionPeriodInDays")
    def snapshot_retention_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snapshot_retention_period_in_days")

    @snapshot_retention_period_in_days.setter
    def snapshot_retention_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_period_in_days", value)


@pulumi.input_type
class _DbSystemsUpgradeState:
    def __init__(__self__, *,
                 action: Optional[pulumi.Input[str]] = None,
                 availability_domain: Optional[pulumi.Input[str]] = None,
                 backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 backup_subnet_id: Optional[pulumi.Input[str]] = None,
                 cluster_name: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 cpu_core_count: Optional[pulumi.Input[int]] = None,
                 data_storage_percentage: Optional[pulumi.Input[int]] = None,
                 data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 database_edition: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 db_system_options: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeDbSystemOptionArgs']]]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 disk_redundancy: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 domain: Optional[pulumi.Input[str]] = None,
                 fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeIormConfigCachArgs']]]] = None,
                 is_snapshot_retention_days_force_updated: Optional[pulumi.Input[bool]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 last_patch_history_entry_id: Optional[pulumi.Input[str]] = None,
                 license_model: Optional[pulumi.Input[str]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 listener_port: Optional[pulumi.Input[int]] = None,
                 maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeMaintenanceWindowArgs']]]] = None,
                 new_gi_version: Optional[pulumi.Input[str]] = None,
                 new_os_version: Optional[pulumi.Input[str]] = None,
                 next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
                 node_count: Optional[pulumi.Input[int]] = None,
                 nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 point_in_time_data_disk_clone_timestamp: Optional[pulumi.Input[str]] = None,
                 reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
                 scan_dns_name: Optional[pulumi.Input[str]] = None,
                 scan_dns_record_id: Optional[pulumi.Input[str]] = None,
                 scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 shape: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 source_db_system_id: Optional[pulumi.Input[str]] = None,
                 sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
                 ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 subnet_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_zone: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None,
                 vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 zone_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DbSystemsUpgrade resources.
        :param pulumi.Input[str] action: The operating system upgrade action.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the DB system is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: The number of CPU cores enabled on the DB system.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 40 and 80. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems.
        :param pulumi.Input[int] data_storage_size_in_gb: The data storage size, in gigabytes, that is currently available to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] database_edition: The Oracle Database edition that applies to all the databases on the DB system.
        :param pulumi.Input[str] db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeDbSystemOptionArgs']]] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: The domain name for the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: List of the Fault Domains in which this DB system is provisioned.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the DB system.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeIormConfigCachArgs']]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[bool] is_snapshot_retention_days_force_updated: If true, rollback time is updated even if operating system upgrade history contains errors.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] listener_port: The port number configured for the listener on the DB system.
        :param pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeMaintenanceWindowArgs']]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[str] new_gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes in the DB system. For RAC DB systems, the value is greater than 1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that this resource belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * Autonomous Databases with private access require at least 1 Network Security Group (NSG). The nsgIds array cannot be empty.
        :param pulumi.Input[str] point_in_time_data_disk_clone_timestamp: The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the DB system. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[str] shape: The shape of the DB system. The shape determines resources to allocate to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, storage, and memory
        :param pulumi.Input[int] snapshot_retention_period_in_days: The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: True, if Sparse Diskgroup is configured for Exadata dbsystem, False, if Sparse diskgroup was not configured.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the DB system.
        :param pulumi.Input[str] state: The current state of the DB system.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
        :param pulumi.Input[str] time_created: The date and time the DB system was created.
        :param pulumi.Input[str] time_zone: The time zone of the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] version: The Oracle Database version of the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the DB system is associated with.
        """
        if action is not None:
            pulumi.set(__self__, "action", action)
        if availability_domain is not None:
            pulumi.set(__self__, "availability_domain", availability_domain)
        if backup_network_nsg_ids is not None:
            pulumi.set(__self__, "backup_network_nsg_ids", backup_network_nsg_ids)
        if backup_subnet_id is not None:
            pulumi.set(__self__, "backup_subnet_id", backup_subnet_id)
        if cluster_name is not None:
            pulumi.set(__self__, "cluster_name", cluster_name)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if cpu_core_count is not None:
            pulumi.set(__self__, "cpu_core_count", cpu_core_count)
        if data_storage_percentage is not None:
            pulumi.set(__self__, "data_storage_percentage", data_storage_percentage)
        if data_storage_size_in_gb is not None:
            pulumi.set(__self__, "data_storage_size_in_gb", data_storage_size_in_gb)
        if database_edition is not None:
            pulumi.set(__self__, "database_edition", database_edition)
        if db_system_id is not None:
            pulumi.set(__self__, "db_system_id", db_system_id)
        if db_system_options is not None:
            pulumi.set(__self__, "db_system_options", db_system_options)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if disk_redundancy is not None:
            pulumi.set(__self__, "disk_redundancy", disk_redundancy)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if fault_domains is not None:
            pulumi.set(__self__, "fault_domains", fault_domains)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if iorm_config_caches is not None:
            pulumi.set(__self__, "iorm_config_caches", iorm_config_caches)
        if is_snapshot_retention_days_force_updated is not None:
            pulumi.set(__self__, "is_snapshot_retention_days_force_updated", is_snapshot_retention_days_force_updated)
        if kms_key_id is not None:
            pulumi.set(__self__, "kms_key_id", kms_key_id)
        if last_maintenance_run_id is not None:
            pulumi.set(__self__, "last_maintenance_run_id", last_maintenance_run_id)
        if last_patch_history_entry_id is not None:
            pulumi.set(__self__, "last_patch_history_entry_id", last_patch_history_entry_id)
        if license_model is not None:
            pulumi.set(__self__, "license_model", license_model)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if listener_port is not None:
            pulumi.set(__self__, "listener_port", listener_port)
        if maintenance_windows is not None:
            pulumi.set(__self__, "maintenance_windows", maintenance_windows)
        if new_gi_version is not None:
            pulumi.set(__self__, "new_gi_version", new_gi_version)
        if new_os_version is not None:
            pulumi.set(__self__, "new_os_version", new_os_version)
        if next_maintenance_run_id is not None:
            pulumi.set(__self__, "next_maintenance_run_id", next_maintenance_run_id)
        if node_count is not None:
            pulumi.set(__self__, "node_count", node_count)
        if nsg_ids is not None:
            pulumi.set(__self__, "nsg_ids", nsg_ids)
        if point_in_time_data_disk_clone_timestamp is not None:
            pulumi.set(__self__, "point_in_time_data_disk_clone_timestamp", point_in_time_data_disk_clone_timestamp)
        if reco_storage_size_in_gb is not None:
            pulumi.set(__self__, "reco_storage_size_in_gb", reco_storage_size_in_gb)
        if scan_dns_name is not None:
            pulumi.set(__self__, "scan_dns_name", scan_dns_name)
        if scan_dns_record_id is not None:
            pulumi.set(__self__, "scan_dns_record_id", scan_dns_record_id)
        if scan_ip_ids is not None:
            pulumi.set(__self__, "scan_ip_ids", scan_ip_ids)
        if shape is not None:
            pulumi.set(__self__, "shape", shape)
        if snapshot_retention_period_in_days is not None:
            pulumi.set(__self__, "snapshot_retention_period_in_days", snapshot_retention_period_in_days)
        if source_db_system_id is not None:
            pulumi.set(__self__, "source_db_system_id", source_db_system_id)
        if sparse_diskgroup is not None:
            pulumi.set(__self__, "sparse_diskgroup", sparse_diskgroup)
        if ssh_public_keys is not None:
            pulumi.set(__self__, "ssh_public_keys", ssh_public_keys)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if subnet_id is not None:
            pulumi.set(__self__, "subnet_id", subnet_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_zone is not None:
            pulumi.set(__self__, "time_zone", time_zone)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if vip_ids is not None:
            pulumi.set(__self__, "vip_ids", vip_ids)
        if zone_id is not None:
            pulumi.set(__self__, "zone_id", zone_id)

    @property
    @pulumi.getter
    def action(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system upgrade action.
        """
        return pulumi.get(self, "action")

    @action.setter
    def action(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "action", value)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the availability domain that the DB system is located in.
        """
        return pulumi.get(self, "availability_domain")

    @availability_domain.setter
    def availability_domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "availability_domain", value)

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @backup_network_nsg_ids.setter
    def backup_network_nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "backup_network_nsg_ids", value)

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
        """
        return pulumi.get(self, "backup_subnet_id")

    @backup_subnet_id.setter
    def backup_subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "backup_subnet_id", value)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> Optional[pulumi.Input[str]]:
        """
        The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @cluster_name.setter
    def cluster_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cluster_name", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of CPU cores enabled on the DB system.
        """
        return pulumi.get(self, "cpu_core_count")

    @cpu_core_count.setter
    def cpu_core_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "cpu_core_count", value)

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 40 and 80. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems.
        """
        return pulumi.get(self, "data_storage_percentage")

    @data_storage_percentage.setter
    def data_storage_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_percentage", value)

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The data storage size, in gigabytes, that is currently available to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @data_storage_size_in_gb.setter
    def data_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "data_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database edition that applies to all the databases on the DB system.
        """
        return pulumi.get(self, "database_edition")

    @database_edition.setter
    def database_edition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_edition", value)

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @db_system_id.setter
    def db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "db_system_id", value)

    @property
    @pulumi.getter(name="dbSystemOptions")
    def db_system_options(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeDbSystemOptionArgs']]]]:
        """
        The DB system options.
        """
        return pulumi.get(self, "db_system_options")

    @db_system_options.setter
    def db_system_options(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeDbSystemOptionArgs']]]]):
        pulumi.set(self, "db_system_options", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> Optional[pulumi.Input[str]]:
        """
        The type of redundancy configured for the DB system. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @disk_redundancy.setter
    def disk_redundancy(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "disk_redundancy", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def domain(self) -> Optional[pulumi.Input[str]]:
        """
        The domain name for the DB system.
        """
        return pulumi.get(self, "domain")

    @domain.setter
    def domain(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "domain", value)

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        List of the Fault Domains in which this DB system is provisioned.
        """
        return pulumi.get(self, "fault_domains")

    @fault_domains.setter
    def fault_domains(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "fault_domains", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        The hostname for the DB system.
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeIormConfigCachArgs']]]]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @iorm_config_caches.setter
    def iorm_config_caches(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeIormConfigCachArgs']]]]):
        pulumi.set(self, "iorm_config_caches", value)

    @property
    @pulumi.getter(name="isSnapshotRetentionDaysForceUpdated")
    def is_snapshot_retention_days_force_updated(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, rollback time is updated even if operating system upgrade history contains errors.
        """
        return pulumi.get(self, "is_snapshot_retention_days_force_updated")

    @is_snapshot_retention_days_force_updated.setter
    def is_snapshot_retention_days_force_updated(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_snapshot_retention_days_force_updated", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @last_maintenance_run_id.setter
    def last_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_maintenance_run_id", value)

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @last_patch_history_entry_id.setter
    def last_patch_history_entry_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_patch_history_entry_id", value)

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @license_model.setter
    def license_model(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_model", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> Optional[pulumi.Input[int]]:
        """
        The port number configured for the listener on the DB system.
        """
        return pulumi.get(self, "listener_port")

    @listener_port.setter
    def listener_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "listener_port", value)

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeMaintenanceWindowArgs']]]]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @maintenance_windows.setter
    def maintenance_windows(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DbSystemsUpgradeMaintenanceWindowArgs']]]]):
        pulumi.set(self, "maintenance_windows", value)

    @property
    @pulumi.getter(name="newGiVersion")
    def new_gi_version(self) -> Optional[pulumi.Input[str]]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "new_gi_version")

    @new_gi_version.setter
    def new_gi_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_gi_version", value)

    @property
    @pulumi.getter(name="newOsVersion")
    def new_os_version(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "new_os_version")

    @new_os_version.setter
    def new_os_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "new_os_version", value)

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @next_maintenance_run_id.setter
    def next_maintenance_run_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "next_maintenance_run_id", value)

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> Optional[pulumi.Input[int]]:
        """
        The number of nodes in the DB system. For RAC DB systems, the value is greater than 1.
        """
        return pulumi.get(self, "node_count")

    @node_count.setter
    def node_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "node_count", value)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that this resource belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * Autonomous Databases with private access require at least 1 Network Security Group (NSG). The nsgIds array cannot be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @nsg_ids.setter
    def nsg_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "nsg_ids", value)

    @property
    @pulumi.getter(name="pointInTimeDataDiskCloneTimestamp")
    def point_in_time_data_disk_clone_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "point_in_time_data_disk_clone_timestamp")

    @point_in_time_data_disk_clone_timestamp.setter
    def point_in_time_data_disk_clone_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "point_in_time_data_disk_clone_timestamp", value)

    @property
    @pulumi.getter(name="recoStorageSizeInGb")
    def reco_storage_size_in_gb(self) -> Optional[pulumi.Input[int]]:
        """
        The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "reco_storage_size_in_gb")

    @reco_storage_size_in_gb.setter
    def reco_storage_size_in_gb(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "reco_storage_size_in_gb", value)

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> Optional[pulumi.Input[str]]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_name")

    @scan_dns_name.setter
    def scan_dns_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_name", value)

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @scan_dns_record_id.setter
    def scan_dns_record_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_dns_record_id", value)

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the DB system. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @scan_ip_ids.setter
    def scan_ip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "scan_ip_ids", value)

    @property
    @pulumi.getter
    def shape(self) -> Optional[pulumi.Input[str]]:
        """
        The shape of the DB system. The shape determines resources to allocate to the DB system.
        * For virtual machine shapes, the number of CPU cores and memory
        * For bare metal and Exadata shapes, the number of CPU cores, storage, and memory
        """
        return pulumi.get(self, "shape")

    @shape.setter
    def shape(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "shape", value)

    @property
    @pulumi.getter(name="snapshotRetentionPeriodInDays")
    def snapshot_retention_period_in_days(self) -> Optional[pulumi.Input[int]]:
        """
        The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snapshot_retention_period_in_days")

    @snapshot_retention_period_in_days.setter
    def snapshot_retention_period_in_days(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "snapshot_retention_period_in_days", value)

    @property
    @pulumi.getter(name="sourceDbSystemId")
    def source_db_system_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "source_db_system_id")

    @source_db_system_id.setter
    def source_db_system_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_db_system_id", value)

    @property
    @pulumi.getter(name="sparseDiskgroup")
    def sparse_diskgroup(self) -> Optional[pulumi.Input[bool]]:
        """
        True, if Sparse Diskgroup is configured for Exadata dbsystem, False, if Sparse diskgroup was not configured.
        """
        return pulumi.get(self, "sparse_diskgroup")

    @sparse_diskgroup.setter
    def sparse_diskgroup(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "sparse_diskgroup", value)

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The public key portion of one or more key pairs used for SSH access to the DB system.
        """
        return pulumi.get(self, "ssh_public_keys")

    @ssh_public_keys.setter
    def ssh_public_keys(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "ssh_public_keys", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the DB system.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @subnet_id.setter
    def subnet_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "subnet_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the DB system was created.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> Optional[pulumi.Input[str]]:
        """
        The time zone of the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @time_zone.setter
    def time_zone(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_zone", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The Oracle Database version of the DB system.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @vip_ids.setter
    def vip_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "vip_ids", value)

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the zone the DB system is associated with.
        """
        return pulumi.get(self, "zone_id")

    @zone_id.setter
    def zone_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "zone_id", value)


class DbSystemsUpgrade(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 is_snapshot_retention_days_force_updated: Optional[pulumi.Input[bool]] = None,
                 new_gi_version: Optional[pulumi.Input[str]] = None,
                 new_os_version: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        """
        This resource provides the Db Systems Upgrade resource in Oracle Cloud Infrastructure Database service.

        Upgrades the operating system and grid infrastructure of the DB system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_systems_upgrade = oci.database.DbSystemsUpgrade("testDbSystemsUpgrade",
            action=var["db_systems_upgrade_action"],
            db_system_id=oci_database_db_system["test_db_system"]["id"],
            is_snapshot_retention_days_force_updated=var["db_systems_upgrade_is_snapshot_retention_days_force_updated"],
            new_gi_version=var["db_systems_upgrade_new_gi_version"],
            snapshot_retention_period_in_days=var["db_systems_upgrade_snapshot_retention_period_in_days"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The operating system upgrade action.
        :param pulumi.Input[str] db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[bool] is_snapshot_retention_days_force_updated: If true, rollback time is updated even if operating system upgrade history contains errors.
        :param pulumi.Input[str] new_gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[int] snapshot_retention_period_in_days: The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DbSystemsUpgradeArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Db Systems Upgrade resource in Oracle Cloud Infrastructure Database service.

        Upgrades the operating system and grid infrastructure of the DB system.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_db_systems_upgrade = oci.database.DbSystemsUpgrade("testDbSystemsUpgrade",
            action=var["db_systems_upgrade_action"],
            db_system_id=oci_database_db_system["test_db_system"]["id"],
            is_snapshot_retention_days_force_updated=var["db_systems_upgrade_is_snapshot_retention_days_force_updated"],
            new_gi_version=var["db_systems_upgrade_new_gi_version"],
            snapshot_retention_period_in_days=var["db_systems_upgrade_snapshot_retention_period_in_days"])
        ```

        ## Import

        Import is not supported for this resource.

        :param str resource_name: The name of the resource.
        :param DbSystemsUpgradeArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DbSystemsUpgradeArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 action: Optional[pulumi.Input[str]] = None,
                 db_system_id: Optional[pulumi.Input[str]] = None,
                 is_snapshot_retention_days_force_updated: Optional[pulumi.Input[bool]] = None,
                 new_gi_version: Optional[pulumi.Input[str]] = None,
                 new_os_version: Optional[pulumi.Input[str]] = None,
                 snapshot_retention_period_in_days: Optional[pulumi.Input[int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DbSystemsUpgradeArgs.__new__(DbSystemsUpgradeArgs)

            if action is None and not opts.urn:
                raise TypeError("Missing required property 'action'")
            __props__.__dict__["action"] = action
            if db_system_id is None and not opts.urn:
                raise TypeError("Missing required property 'db_system_id'")
            __props__.__dict__["db_system_id"] = db_system_id
            __props__.__dict__["is_snapshot_retention_days_force_updated"] = is_snapshot_retention_days_force_updated
            __props__.__dict__["new_gi_version"] = new_gi_version
            __props__.__dict__["new_os_version"] = new_os_version
            __props__.__dict__["snapshot_retention_period_in_days"] = snapshot_retention_period_in_days
            __props__.__dict__["availability_domain"] = None
            __props__.__dict__["backup_network_nsg_ids"] = None
            __props__.__dict__["backup_subnet_id"] = None
            __props__.__dict__["cluster_name"] = None
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["cpu_core_count"] = None
            __props__.__dict__["data_storage_percentage"] = None
            __props__.__dict__["data_storage_size_in_gb"] = None
            __props__.__dict__["database_edition"] = None
            __props__.__dict__["db_system_options"] = None
            __props__.__dict__["defined_tags"] = None
            __props__.__dict__["disk_redundancy"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["domain"] = None
            __props__.__dict__["fault_domains"] = None
            __props__.__dict__["freeform_tags"] = None
            __props__.__dict__["hostname"] = None
            __props__.__dict__["iorm_config_caches"] = None
            __props__.__dict__["kms_key_id"] = None
            __props__.__dict__["last_maintenance_run_id"] = None
            __props__.__dict__["last_patch_history_entry_id"] = None
            __props__.__dict__["license_model"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["listener_port"] = None
            __props__.__dict__["maintenance_windows"] = None
            __props__.__dict__["next_maintenance_run_id"] = None
            __props__.__dict__["node_count"] = None
            __props__.__dict__["nsg_ids"] = None
            __props__.__dict__["point_in_time_data_disk_clone_timestamp"] = None
            __props__.__dict__["reco_storage_size_in_gb"] = None
            __props__.__dict__["scan_dns_name"] = None
            __props__.__dict__["scan_dns_record_id"] = None
            __props__.__dict__["scan_ip_ids"] = None
            __props__.__dict__["shape"] = None
            __props__.__dict__["source_db_system_id"] = None
            __props__.__dict__["sparse_diskgroup"] = None
            __props__.__dict__["ssh_public_keys"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["subnet_id"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_zone"] = None
            __props__.__dict__["version"] = None
            __props__.__dict__["vip_ids"] = None
            __props__.__dict__["zone_id"] = None
        super(DbSystemsUpgrade, __self__).__init__(
            'oci:Database/dbSystemsUpgrade:DbSystemsUpgrade',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            action: Optional[pulumi.Input[str]] = None,
            availability_domain: Optional[pulumi.Input[str]] = None,
            backup_network_nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            backup_subnet_id: Optional[pulumi.Input[str]] = None,
            cluster_name: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            cpu_core_count: Optional[pulumi.Input[int]] = None,
            data_storage_percentage: Optional[pulumi.Input[int]] = None,
            data_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            database_edition: Optional[pulumi.Input[str]] = None,
            db_system_id: Optional[pulumi.Input[str]] = None,
            db_system_options: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeDbSystemOptionArgs']]]]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            disk_redundancy: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            domain: Optional[pulumi.Input[str]] = None,
            fault_domains: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            iorm_config_caches: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeIormConfigCachArgs']]]]] = None,
            is_snapshot_retention_days_force_updated: Optional[pulumi.Input[bool]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            last_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            last_patch_history_entry_id: Optional[pulumi.Input[str]] = None,
            license_model: Optional[pulumi.Input[str]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            listener_port: Optional[pulumi.Input[int]] = None,
            maintenance_windows: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeMaintenanceWindowArgs']]]]] = None,
            new_gi_version: Optional[pulumi.Input[str]] = None,
            new_os_version: Optional[pulumi.Input[str]] = None,
            next_maintenance_run_id: Optional[pulumi.Input[str]] = None,
            node_count: Optional[pulumi.Input[int]] = None,
            nsg_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            point_in_time_data_disk_clone_timestamp: Optional[pulumi.Input[str]] = None,
            reco_storage_size_in_gb: Optional[pulumi.Input[int]] = None,
            scan_dns_name: Optional[pulumi.Input[str]] = None,
            scan_dns_record_id: Optional[pulumi.Input[str]] = None,
            scan_ip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            shape: Optional[pulumi.Input[str]] = None,
            snapshot_retention_period_in_days: Optional[pulumi.Input[int]] = None,
            source_db_system_id: Optional[pulumi.Input[str]] = None,
            sparse_diskgroup: Optional[pulumi.Input[bool]] = None,
            ssh_public_keys: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            subnet_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_zone: Optional[pulumi.Input[str]] = None,
            version: Optional[pulumi.Input[str]] = None,
            vip_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            zone_id: Optional[pulumi.Input[str]] = None) -> 'DbSystemsUpgrade':
        """
        Get an existing DbSystemsUpgrade resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] action: The operating system upgrade action.
        :param pulumi.Input[str] availability_domain: The name of the availability domain that the DB system is located in.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] backup_network_nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        :param pulumi.Input[str] backup_subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
        :param pulumi.Input[str] cluster_name: The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param pulumi.Input[int] cpu_core_count: The number of CPU cores enabled on the DB system.
        :param pulumi.Input[int] data_storage_percentage: The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 40 and 80. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems.
        :param pulumi.Input[int] data_storage_size_in_gb: The data storage size, in gigabytes, that is currently available to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] database_edition: The Oracle Database edition that applies to all the databases on the DB system.
        :param pulumi.Input[str] db_system_id: The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeDbSystemOptionArgs']]]] db_system_options: The DB system options.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        :param pulumi.Input[str] disk_redundancy: The type of redundancy configured for the DB system. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        :param pulumi.Input[str] display_name: The user-friendly name for the DB system. The name does not have to be unique.
        :param pulumi.Input[str] domain: The domain name for the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] fault_domains: List of the Fault Domains in which this DB system is provisioned.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: The hostname for the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeIormConfigCachArgs']]]] iorm_config_caches: The IORM settings of the Exadata DB system.
        :param pulumi.Input[bool] is_snapshot_retention_days_force_updated: If true, rollback time is updated even if operating system upgrade history contains errors.
        :param pulumi.Input[str] kms_key_id: The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        :param pulumi.Input[str] last_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        :param pulumi.Input[str] last_patch_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        :param pulumi.Input[str] license_model: The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        :param pulumi.Input[str] lifecycle_details: Additional information about the current lifecycle state.
        :param pulumi.Input[int] listener_port: The port number configured for the listener on the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['DbSystemsUpgradeMaintenanceWindowArgs']]]] maintenance_windows: The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        :param pulumi.Input[str] new_gi_version: A valid Oracle Grid Infrastructure (GI) software version.
        :param pulumi.Input[str] next_maintenance_run_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        :param pulumi.Input[int] node_count: The number of nodes in the DB system. For RAC DB systems, the value is greater than 1.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] nsg_ids: A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that this resource belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
               * Autonomous Databases with private access require at least 1 Network Security Group (NSG). The nsgIds array cannot be empty.
        :param pulumi.Input[str] point_in_time_data_disk_clone_timestamp: The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param pulumi.Input[int] reco_storage_size_in_gb: The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        :param pulumi.Input[str] scan_dns_name: The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[str] scan_dns_record_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] scan_ip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the DB system. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        :param pulumi.Input[str] shape: The shape of the DB system. The shape determines resources to allocate to the DB system.
               * For virtual machine shapes, the number of CPU cores and memory
               * For bare metal and Exadata shapes, the number of CPU cores, storage, and memory
        :param pulumi.Input[int] snapshot_retention_period_in_days: The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] source_db_system_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        :param pulumi.Input[bool] sparse_diskgroup: True, if Sparse Diskgroup is configured for Exadata dbsystem, False, if Sparse diskgroup was not configured.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] ssh_public_keys: The public key portion of one or more key pairs used for SSH access to the DB system.
        :param pulumi.Input[str] state: The current state of the DB system.
        :param pulumi.Input[str] subnet_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
        :param pulumi.Input[str] time_created: The date and time the DB system was created.
        :param pulumi.Input[str] time_zone: The time zone of the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        :param pulumi.Input[str] version: The Oracle Database version of the DB system.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] vip_ids: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        :param pulumi.Input[str] zone_id: The OCID of the zone the DB system is associated with.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DbSystemsUpgradeState.__new__(_DbSystemsUpgradeState)

        __props__.__dict__["action"] = action
        __props__.__dict__["availability_domain"] = availability_domain
        __props__.__dict__["backup_network_nsg_ids"] = backup_network_nsg_ids
        __props__.__dict__["backup_subnet_id"] = backup_subnet_id
        __props__.__dict__["cluster_name"] = cluster_name
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["cpu_core_count"] = cpu_core_count
        __props__.__dict__["data_storage_percentage"] = data_storage_percentage
        __props__.__dict__["data_storage_size_in_gb"] = data_storage_size_in_gb
        __props__.__dict__["database_edition"] = database_edition
        __props__.__dict__["db_system_id"] = db_system_id
        __props__.__dict__["db_system_options"] = db_system_options
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["disk_redundancy"] = disk_redundancy
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["domain"] = domain
        __props__.__dict__["fault_domains"] = fault_domains
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["iorm_config_caches"] = iorm_config_caches
        __props__.__dict__["is_snapshot_retention_days_force_updated"] = is_snapshot_retention_days_force_updated
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["last_maintenance_run_id"] = last_maintenance_run_id
        __props__.__dict__["last_patch_history_entry_id"] = last_patch_history_entry_id
        __props__.__dict__["license_model"] = license_model
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["listener_port"] = listener_port
        __props__.__dict__["maintenance_windows"] = maintenance_windows
        __props__.__dict__["new_gi_version"] = new_gi_version
        __props__.__dict__["new_os_version"] = new_os_version
        __props__.__dict__["next_maintenance_run_id"] = next_maintenance_run_id
        __props__.__dict__["node_count"] = node_count
        __props__.__dict__["nsg_ids"] = nsg_ids
        __props__.__dict__["point_in_time_data_disk_clone_timestamp"] = point_in_time_data_disk_clone_timestamp
        __props__.__dict__["reco_storage_size_in_gb"] = reco_storage_size_in_gb
        __props__.__dict__["scan_dns_name"] = scan_dns_name
        __props__.__dict__["scan_dns_record_id"] = scan_dns_record_id
        __props__.__dict__["scan_ip_ids"] = scan_ip_ids
        __props__.__dict__["shape"] = shape
        __props__.__dict__["snapshot_retention_period_in_days"] = snapshot_retention_period_in_days
        __props__.__dict__["source_db_system_id"] = source_db_system_id
        __props__.__dict__["sparse_diskgroup"] = sparse_diskgroup
        __props__.__dict__["ssh_public_keys"] = ssh_public_keys
        __props__.__dict__["state"] = state
        __props__.__dict__["subnet_id"] = subnet_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_zone"] = time_zone
        __props__.__dict__["version"] = version
        __props__.__dict__["vip_ids"] = vip_ids
        __props__.__dict__["zone_id"] = zone_id
        return DbSystemsUpgrade(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def action(self) -> pulumi.Output[str]:
        """
        The operating system upgrade action.
        """
        return pulumi.get(self, "action")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> pulumi.Output[str]:
        """
        The name of the availability domain that the DB system is located in.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="backupNetworkNsgIds")
    def backup_network_nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that the backup network of this DB system belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). Applicable only to Exadata systems.
        """
        return pulumi.get(self, "backup_network_nsg_ids")

    @property
    @pulumi.getter(name="backupSubnetId")
    def backup_subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the backup network subnet the DB system is associated with. Applicable only to Exadata DB systems.
        """
        return pulumi.get(self, "backup_subnet_id")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> pulumi.Output[str]:
        """
        The cluster name for Exadata and 2-node RAC virtual machine DB systems. The cluster name must begin with an alphabetic character, and may contain hyphens (-). Underscores (_) are not permitted. The cluster name can be no longer than 11 characters and is not case sensitive.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="cpuCoreCount")
    def cpu_core_count(self) -> pulumi.Output[int]:
        """
        The number of CPU cores enabled on the DB system.
        """
        return pulumi.get(self, "cpu_core_count")

    @property
    @pulumi.getter(name="dataStoragePercentage")
    def data_storage_percentage(self) -> pulumi.Output[int]:
        """
        The percentage assigned to DATA storage (user data and database files). The remaining percentage is assigned to RECO storage (database redo logs, archive logs, and recovery manager backups). Accepted values are 40 and 80. The default is 80 percent assigned to DATA storage. Not applicable for virtual machine DB systems.
        """
        return pulumi.get(self, "data_storage_percentage")

    @property
    @pulumi.getter(name="dataStorageSizeInGb")
    def data_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        The data storage size, in gigabytes, that is currently available to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "data_storage_size_in_gb")

    @property
    @pulumi.getter(name="databaseEdition")
    def database_edition(self) -> pulumi.Output[str]:
        """
        The Oracle Database edition that applies to all the databases on the DB system.
        """
        return pulumi.get(self, "database_edition")

    @property
    @pulumi.getter(name="dbSystemId")
    def db_system_id(self) -> pulumi.Output[str]:
        """
        The DB system [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
        """
        return pulumi.get(self, "db_system_id")

    @property
    @pulumi.getter(name="dbSystemOptions")
    def db_system_options(self) -> pulumi.Output[Sequence['outputs.DbSystemsUpgradeDbSystemOption']]:
        """
        The DB system options.
        """
        return pulumi.get(self, "db_system_options")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="diskRedundancy")
    def disk_redundancy(self) -> pulumi.Output[str]:
        """
        The type of redundancy configured for the DB system. NORMAL is 2-way redundancy. HIGH is 3-way redundancy.
        """
        return pulumi.get(self, "disk_redundancy")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        The user-friendly name for the DB system. The name does not have to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def domain(self) -> pulumi.Output[str]:
        """
        The domain name for the DB system.
        """
        return pulumi.get(self, "domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> pulumi.Output[Sequence[str]]:
        """
        List of the Fault Domains in which this DB system is provisioned.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        The hostname for the DB system.
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="iormConfigCaches")
    def iorm_config_caches(self) -> pulumi.Output[Sequence['outputs.DbSystemsUpgradeIormConfigCach']]:
        """
        The IORM settings of the Exadata DB system.
        """
        return pulumi.get(self, "iorm_config_caches")

    @property
    @pulumi.getter(name="isSnapshotRetentionDaysForceUpdated")
    def is_snapshot_retention_days_force_updated(self) -> pulumi.Output[bool]:
        """
        If true, rollback time is updated even if operating system upgrade history contains errors.
        """
        return pulumi.get(self, "is_snapshot_retention_days_force_updated")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[str]:
        """
        The OCID of the key container that is used as the master encryption key in database transparent data encryption (TDE) operations.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="lastMaintenanceRunId")
    def last_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last maintenance run.
        """
        return pulumi.get(self, "last_maintenance_run_id")

    @property
    @pulumi.getter(name="lastPatchHistoryEntryId")
    def last_patch_history_entry_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the last patch history. This value is updated as soon as a patch operation starts.
        """
        return pulumi.get(self, "last_patch_history_entry_id")

    @property
    @pulumi.getter(name="licenseModel")
    def license_model(self) -> pulumi.Output[str]:
        """
        The Oracle license model that applies to all the databases on the DB system. The default is LICENSE_INCLUDED.
        """
        return pulumi.get(self, "license_model")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Additional information about the current lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="listenerPort")
    def listener_port(self) -> pulumi.Output[int]:
        """
        The port number configured for the listener on the DB system.
        """
        return pulumi.get(self, "listener_port")

    @property
    @pulumi.getter(name="maintenanceWindows")
    def maintenance_windows(self) -> pulumi.Output[Sequence['outputs.DbSystemsUpgradeMaintenanceWindow']]:
        """
        The scheduling details for the quarterly maintenance window. Patching and system updates take place during the maintenance window.
        """
        return pulumi.get(self, "maintenance_windows")

    @property
    @pulumi.getter(name="newGiVersion")
    def new_gi_version(self) -> pulumi.Output[str]:
        """
        A valid Oracle Grid Infrastructure (GI) software version.
        """
        return pulumi.get(self, "new_gi_version")

    @property
    @pulumi.getter(name="newOsVersion")
    def new_os_version(self) -> pulumi.Output[str]:
        return pulumi.get(self, "new_os_version")

    @property
    @pulumi.getter(name="nextMaintenanceRunId")
    def next_maintenance_run_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the next maintenance run.
        """
        return pulumi.get(self, "next_maintenance_run_id")

    @property
    @pulumi.getter(name="nodeCount")
    def node_count(self) -> pulumi.Output[int]:
        """
        The number of nodes in the DB system. For RAC DB systems, the value is greater than 1.
        """
        return pulumi.get(self, "node_count")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        A list of the [OCIDs](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the network security groups (NSGs) that this resource belongs to. Setting this to an empty array after the list is created removes the resource from all NSGs. For more information about NSGs, see [Security Rules](https://docs.cloud.oracle.com/iaas/Content/Network/Concepts/securityrules.htm). **NsgIds restrictions:**
        * Autonomous Databases with private access require at least 1 Network Security Group (NSG). The nsgIds array cannot be empty.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="pointInTimeDataDiskCloneTimestamp")
    def point_in_time_data_disk_clone_timestamp(self) -> pulumi.Output[str]:
        """
        The point in time for a cloned database system when the data disks were cloned from the source database system, as described in [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "point_in_time_data_disk_clone_timestamp")

    @property
    @pulumi.getter(name="recoStorageSizeInGb")
    def reco_storage_size_in_gb(self) -> pulumi.Output[int]:
        """
        The RECO/REDO storage size, in gigabytes, that is currently allocated to the DB system. Applies only for virtual machine DB systems.
        """
        return pulumi.get(self, "reco_storage_size_in_gb")

    @property
    @pulumi.getter(name="scanDnsName")
    def scan_dns_name(self) -> pulumi.Output[str]:
        """
        The FQDN of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_name")

    @property
    @pulumi.getter(name="scanDnsRecordId")
    def scan_dns_record_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DNS record for the SCAN IP addresses that are associated with the DB system.
        """
        return pulumi.get(self, "scan_dns_record_id")

    @property
    @pulumi.getter(name="scanIpIds")
    def scan_ip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Single Client Access Name (SCAN) IP addresses associated with the DB system. SCAN IP addresses are typically used for load balancing and are not assigned to any interface. Oracle Clusterware directs the requests to the appropriate nodes in the cluster.
        """
        return pulumi.get(self, "scan_ip_ids")

    @property
    @pulumi.getter
    def shape(self) -> pulumi.Output[str]:
        """
        The shape of the DB system. The shape determines resources to allocate to the DB system.
        * For virtual machine shapes, the number of CPU cores and memory
        * For bare metal and Exadata shapes, the number of CPU cores, storage, and memory
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="snapshotRetentionPeriodInDays")
    def snapshot_retention_period_in_days(self) -> pulumi.Output[int]:
        """
        The retention period, in days, for the snapshot that allows you to perform a rollback of the upgrade operation. After this number of days passes, you cannot roll back the upgrade.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "snapshot_retention_period_in_days")

    @property
    @pulumi.getter(name="sourceDbSystemId")
    def source_db_system_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the DB system.
        """
        return pulumi.get(self, "source_db_system_id")

    @property
    @pulumi.getter(name="sparseDiskgroup")
    def sparse_diskgroup(self) -> pulumi.Output[bool]:
        """
        True, if Sparse Diskgroup is configured for Exadata dbsystem, False, if Sparse diskgroup was not configured.
        """
        return pulumi.get(self, "sparse_diskgroup")

    @property
    @pulumi.getter(name="sshPublicKeys")
    def ssh_public_keys(self) -> pulumi.Output[Sequence[str]]:
        """
        The public key portion of one or more key pairs used for SSH access to the DB system.
        """
        return pulumi.get(self, "ssh_public_keys")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the DB system.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the subnet the DB system is associated with.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the DB system was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeZone")
    def time_zone(self) -> pulumi.Output[str]:
        """
        The time zone of the DB system. For details, see [DB System Time Zones](https://docs.cloud.oracle.com/iaas/Content/Database/References/timezones.htm).
        """
        return pulumi.get(self, "time_zone")

    @property
    @pulumi.getter
    def version(self) -> pulumi.Output[str]:
        """
        The Oracle Database version of the DB system.
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter(name="vipIds")
    def vip_ids(self) -> pulumi.Output[Sequence[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the virtual IP (VIP) addresses associated with the DB system. The Cluster Ready Services (CRS) creates and maintains one VIP address for each node in the DB system to enable failover. If one node fails, the VIP is reassigned to another active node in the cluster.
        """
        return pulumi.get(self, "vip_ids")

    @property
    @pulumi.getter(name="zoneId")
    def zone_id(self) -> pulumi.Output[str]:
        """
        The OCID of the zone the DB system is associated with.
        """
        return pulumi.get(self, "zone_id")

