# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetVmClusterUpdateHistoryEntryResult',
    'AwaitableGetVmClusterUpdateHistoryEntryResult',
    'get_vm_cluster_update_history_entry',
    'get_vm_cluster_update_history_entry_output',
]

@pulumi.output_type
class GetVmClusterUpdateHistoryEntryResult:
    """
    A collection of values returned by getVmClusterUpdateHistoryEntry.
    """
    def __init__(__self__, id=None, lifecycle_details=None, state=None, time_completed=None, time_started=None, update_action=None, update_history_entry_id=None, update_id=None, update_type=None, vm_cluster_id=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if lifecycle_details and not isinstance(lifecycle_details, str):
            raise TypeError("Expected argument 'lifecycle_details' to be a str")
        pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_completed and not isinstance(time_completed, str):
            raise TypeError("Expected argument 'time_completed' to be a str")
        pulumi.set(__self__, "time_completed", time_completed)
        if time_started and not isinstance(time_started, str):
            raise TypeError("Expected argument 'time_started' to be a str")
        pulumi.set(__self__, "time_started", time_started)
        if update_action and not isinstance(update_action, str):
            raise TypeError("Expected argument 'update_action' to be a str")
        pulumi.set(__self__, "update_action", update_action)
        if update_history_entry_id and not isinstance(update_history_entry_id, str):
            raise TypeError("Expected argument 'update_history_entry_id' to be a str")
        pulumi.set(__self__, "update_history_entry_id", update_history_entry_id)
        if update_id and not isinstance(update_id, str):
            raise TypeError("Expected argument 'update_id' to be a str")
        pulumi.set(__self__, "update_id", update_id)
        if update_type and not isinstance(update_type, str):
            raise TypeError("Expected argument 'update_type' to be a str")
        pulumi.set(__self__, "update_type", update_type)
        if vm_cluster_id and not isinstance(vm_cluster_id, str):
            raise TypeError("Expected argument 'vm_cluster_id' to be a str")
        pulumi.set(__self__, "vm_cluster_id", vm_cluster_id)

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Descriptive text providing additional details about the lifecycle state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current lifecycle state of the maintenance update operation.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCompleted")
    def time_completed(self) -> str:
        """
        The date and time when the maintenance update action completed.
        """
        return pulumi.get(self, "time_completed")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The date and time when the maintenance update action started.
        """
        return pulumi.get(self, "time_started")

    @property
    @pulumi.getter(name="updateAction")
    def update_action(self) -> str:
        """
        The update action performed using this maintenance update.
        """
        return pulumi.get(self, "update_action")

    @property
    @pulumi.getter(name="updateHistoryEntryId")
    def update_history_entry_id(self) -> str:
        return pulumi.get(self, "update_history_entry_id")

    @property
    @pulumi.getter(name="updateId")
    def update_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance update.
        """
        return pulumi.get(self, "update_id")

    @property
    @pulumi.getter(name="updateType")
    def update_type(self) -> str:
        """
        The type of VM cluster maintenance update.
        """
        return pulumi.get(self, "update_type")

    @property
    @pulumi.getter(name="vmClusterId")
    def vm_cluster_id(self) -> str:
        return pulumi.get(self, "vm_cluster_id")


class AwaitableGetVmClusterUpdateHistoryEntryResult(GetVmClusterUpdateHistoryEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetVmClusterUpdateHistoryEntryResult(
            id=self.id,
            lifecycle_details=self.lifecycle_details,
            state=self.state,
            time_completed=self.time_completed,
            time_started=self.time_started,
            update_action=self.update_action,
            update_history_entry_id=self.update_history_entry_id,
            update_id=self.update_id,
            update_type=self.update_type,
            vm_cluster_id=self.vm_cluster_id)


def get_vm_cluster_update_history_entry(update_history_entry_id: Optional[str] = None,
                                        vm_cluster_id: Optional[str] = None,
                                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetVmClusterUpdateHistoryEntryResult:
    """
    This data source provides details about a specific Vm Cluster Update History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the maintenance update history details for the specified update history entry. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update_history_entry = oci.Database.get_vm_cluster_update_history_entry(update_history_entry_id=oci_database_update_history_entry["test_update_history_entry"]["id"],
        vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"])
    ```


    :param str update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance update history entry.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    __args__ = dict()
    __args__['updateHistoryEntryId'] = update_history_entry_id
    __args__['vmClusterId'] = vm_cluster_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Database/getVmClusterUpdateHistoryEntry:getVmClusterUpdateHistoryEntry', __args__, opts=opts, typ=GetVmClusterUpdateHistoryEntryResult).value

    return AwaitableGetVmClusterUpdateHistoryEntryResult(
        id=pulumi.get(__ret__, 'id'),
        lifecycle_details=pulumi.get(__ret__, 'lifecycle_details'),
        state=pulumi.get(__ret__, 'state'),
        time_completed=pulumi.get(__ret__, 'time_completed'),
        time_started=pulumi.get(__ret__, 'time_started'),
        update_action=pulumi.get(__ret__, 'update_action'),
        update_history_entry_id=pulumi.get(__ret__, 'update_history_entry_id'),
        update_id=pulumi.get(__ret__, 'update_id'),
        update_type=pulumi.get(__ret__, 'update_type'),
        vm_cluster_id=pulumi.get(__ret__, 'vm_cluster_id'))


@_utilities.lift_output_func(get_vm_cluster_update_history_entry)
def get_vm_cluster_update_history_entry_output(update_history_entry_id: Optional[pulumi.Input[str]] = None,
                                               vm_cluster_id: Optional[pulumi.Input[str]] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetVmClusterUpdateHistoryEntryResult]:
    """
    This data source provides details about a specific Vm Cluster Update History Entry resource in Oracle Cloud Infrastructure Database service.

    Gets the maintenance update history details for the specified update history entry. Applies to Exadata Cloud@Customer instances only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_vm_cluster_update_history_entry = oci.Database.get_vm_cluster_update_history_entry(update_history_entry_id=oci_database_update_history_entry["test_update_history_entry"]["id"],
        vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"])
    ```


    :param str update_history_entry_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the maintenance update history entry.
    :param str vm_cluster_id: The VM cluster [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm).
    """
    ...
