# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSqlEndpointsResult',
    'AwaitableGetSqlEndpointsResult',
    'get_sql_endpoints',
    'get_sql_endpoints_output',
]

@pulumi.output_type
class GetSqlEndpointsResult:
    """
    A collection of values returned by getSqlEndpoints.
    """
    def __init__(__self__, compartment_id=None, display_name=None, filters=None, id=None, sql_endpoint_collections=None, sql_endpoint_id=None, state=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if sql_endpoint_collections and not isinstance(sql_endpoint_collections, list):
            raise TypeError("Expected argument 'sql_endpoint_collections' to be a list")
        pulumi.set(__self__, "sql_endpoint_collections", sql_endpoint_collections)
        if sql_endpoint_id and not isinstance(sql_endpoint_id, str):
            raise TypeError("Expected argument 'sql_endpoint_id' to be a str")
        pulumi.set(__self__, "sql_endpoint_id", sql_endpoint_id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        The OCID of a compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        The SQL Endpoint name, which can be changed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSqlEndpointsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="sqlEndpointCollections")
    def sql_endpoint_collections(self) -> Sequence['outputs.GetSqlEndpointsSqlEndpointCollectionResult']:
        """
        The list of sql_endpoint_collection.
        """
        return pulumi.get(self, "sql_endpoint_collections")

    @property
    @pulumi.getter(name="sqlEndpointId")
    def sql_endpoint_id(self) -> Optional[str]:
        return pulumi.get(self, "sql_endpoint_id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the Sql Endpoint.
        """
        return pulumi.get(self, "state")


class AwaitableGetSqlEndpointsResult(GetSqlEndpointsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSqlEndpointsResult(
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            sql_endpoint_collections=self.sql_endpoint_collections,
            sql_endpoint_id=self.sql_endpoint_id,
            state=self.state)


def get_sql_endpoints(compartment_id: Optional[str] = None,
                      display_name: Optional[str] = None,
                      filters: Optional[Sequence[pulumi.InputType['GetSqlEndpointsFilterArgs']]] = None,
                      sql_endpoint_id: Optional[str] = None,
                      state: Optional[str] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSqlEndpointsResult:
    """
    This data source provides the list of Sql Endpoints in Oracle Cloud Infrastructure Data Flow service.

    Lists all Sql Endpoints in the specified compartment.
    The query must include compartmentId or sqlEndpointId.
    If the query does not include either compartmentId or sqlEndpointId, an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_endpoints = oci.DataFlow.get_sql_endpoints(compartment_id=var["compartment_id"],
        display_name=var["sql_endpoint_display_name"],
        sql_endpoint_id=oci_dataflow_sql_endpoint["test_sql_endpoint"]["id"],
        state=var["sql_endpoint_state"])
    ```


    :param str compartment_id: The OCID of the compartment in which to query resources.
    :param str display_name: The query parameter for the Spark application name.
    :param str sql_endpoint_id: The unique id of the SQL Endpoint.
    :param str state: A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['sqlEndpointId'] = sql_endpoint_id
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataFlow/getSqlEndpoints:getSqlEndpoints', __args__, opts=opts, typ=GetSqlEndpointsResult).value

    return AwaitableGetSqlEndpointsResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        sql_endpoint_collections=pulumi.get(__ret__, 'sql_endpoint_collections'),
        sql_endpoint_id=pulumi.get(__ret__, 'sql_endpoint_id'),
        state=pulumi.get(__ret__, 'state'))


@_utilities.lift_output_func(get_sql_endpoints)
def get_sql_endpoints_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                             display_name: Optional[pulumi.Input[Optional[str]]] = None,
                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSqlEndpointsFilterArgs']]]]] = None,
                             sql_endpoint_id: Optional[pulumi.Input[Optional[str]]] = None,
                             state: Optional[pulumi.Input[Optional[str]]] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSqlEndpointsResult]:
    """
    This data source provides the list of Sql Endpoints in Oracle Cloud Infrastructure Data Flow service.

    Lists all Sql Endpoints in the specified compartment.
    The query must include compartmentId or sqlEndpointId.
    If the query does not include either compartmentId or sqlEndpointId, an error is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_sql_endpoints = oci.DataFlow.get_sql_endpoints(compartment_id=var["compartment_id"],
        display_name=var["sql_endpoint_display_name"],
        sql_endpoint_id=oci_dataflow_sql_endpoint["test_sql_endpoint"]["id"],
        state=var["sql_endpoint_state"])
    ```


    :param str compartment_id: The OCID of the compartment in which to query resources.
    :param str display_name: The query parameter for the Spark application name.
    :param str sql_endpoint_id: The unique id of the SQL Endpoint.
    :param str state: A filter to return only those resources whose sqlEndpointLifecycleState matches the given sqlEndpointLifecycleState.
    """
    ...
