# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetMaskingReportMaskedColumnsResult',
    'AwaitableGetMaskingReportMaskedColumnsResult',
    'get_masking_report_masked_columns',
    'get_masking_report_masked_columns_output',
]

@pulumi.output_type
class GetMaskingReportMaskedColumnsResult:
    """
    A collection of values returned by getMaskingReportMaskedColumns.
    """
    def __init__(__self__, column_names=None, filters=None, id=None, masked_column_collections=None, masking_column_groups=None, masking_report_id=None, object_types=None, objects=None, schema_names=None, sensitive_type_id=None):
        if column_names and not isinstance(column_names, list):
            raise TypeError("Expected argument 'column_names' to be a list")
        pulumi.set(__self__, "column_names", column_names)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if masked_column_collections and not isinstance(masked_column_collections, list):
            raise TypeError("Expected argument 'masked_column_collections' to be a list")
        pulumi.set(__self__, "masked_column_collections", masked_column_collections)
        if masking_column_groups and not isinstance(masking_column_groups, list):
            raise TypeError("Expected argument 'masking_column_groups' to be a list")
        pulumi.set(__self__, "masking_column_groups", masking_column_groups)
        if masking_report_id and not isinstance(masking_report_id, str):
            raise TypeError("Expected argument 'masking_report_id' to be a str")
        pulumi.set(__self__, "masking_report_id", masking_report_id)
        if object_types and not isinstance(object_types, list):
            raise TypeError("Expected argument 'object_types' to be a list")
        pulumi.set(__self__, "object_types", object_types)
        if objects and not isinstance(objects, list):
            raise TypeError("Expected argument 'objects' to be a list")
        pulumi.set(__self__, "objects", objects)
        if schema_names and not isinstance(schema_names, list):
            raise TypeError("Expected argument 'schema_names' to be a list")
        pulumi.set(__self__, "schema_names", schema_names)
        if sensitive_type_id and not isinstance(sensitive_type_id, str):
            raise TypeError("Expected argument 'sensitive_type_id' to be a str")
        pulumi.set(__self__, "sensitive_type_id", sensitive_type_id)

    @property
    @pulumi.getter(name="columnNames")
    def column_names(self) -> Optional[Sequence[str]]:
        """
        The name of the masked column.
        """
        return pulumi.get(self, "column_names")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetMaskingReportMaskedColumnsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maskedColumnCollections")
    def masked_column_collections(self) -> Sequence['outputs.GetMaskingReportMaskedColumnsMaskedColumnCollectionResult']:
        """
        The list of masked_column_collection.
        """
        return pulumi.get(self, "masked_column_collections")

    @property
    @pulumi.getter(name="maskingColumnGroups")
    def masking_column_groups(self) -> Optional[Sequence[str]]:
        """
        The masking group of the masked column.
        """
        return pulumi.get(self, "masking_column_groups")

    @property
    @pulumi.getter(name="maskingReportId")
    def masking_report_id(self) -> str:
        return pulumi.get(self, "masking_report_id")

    @property
    @pulumi.getter(name="objectTypes")
    def object_types(self) -> Optional[Sequence[str]]:
        """
        The type of the object (table or editioning view) that contains the masked column.
        """
        return pulumi.get(self, "object_types")

    @property
    @pulumi.getter
    def objects(self) -> Optional[Sequence[str]]:
        """
        The name of the object (table or editioning view) that contains the masked column.
        """
        return pulumi.get(self, "objects")

    @property
    @pulumi.getter(name="schemaNames")
    def schema_names(self) -> Optional[Sequence[str]]:
        """
        The name of the schema that contains the masked column.
        """
        return pulumi.get(self, "schema_names")

    @property
    @pulumi.getter(name="sensitiveTypeId")
    def sensitive_type_id(self) -> Optional[str]:
        """
        The OCID of the sensitive type associated with the masked column.
        """
        return pulumi.get(self, "sensitive_type_id")


class AwaitableGetMaskingReportMaskedColumnsResult(GetMaskingReportMaskedColumnsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetMaskingReportMaskedColumnsResult(
            column_names=self.column_names,
            filters=self.filters,
            id=self.id,
            masked_column_collections=self.masked_column_collections,
            masking_column_groups=self.masking_column_groups,
            masking_report_id=self.masking_report_id,
            object_types=self.object_types,
            objects=self.objects,
            schema_names=self.schema_names,
            sensitive_type_id=self.sensitive_type_id)


def get_masking_report_masked_columns(column_names: Optional[Sequence[str]] = None,
                                      filters: Optional[Sequence[pulumi.InputType['GetMaskingReportMaskedColumnsFilterArgs']]] = None,
                                      masking_column_groups: Optional[Sequence[str]] = None,
                                      masking_report_id: Optional[str] = None,
                                      object_types: Optional[Sequence[str]] = None,
                                      objects: Optional[Sequence[str]] = None,
                                      schema_names: Optional[Sequence[str]] = None,
                                      sensitive_type_id: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetMaskingReportMaskedColumnsResult:
    """
    This data source provides the list of Masking Reports Masked Columns in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masked columns present in the specified masking report and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_reports_masked_columns = oci.DataSafe.get_masking_report_masked_columns(masking_report_id=oci_data_safe_masking_report["test_masking_report"]["id"],
        column_names=var["masking_reports_masked_column_column_name"],
        masking_column_groups=var["masking_reports_masked_column_masking_column_group"],
        objects=var["masking_reports_masked_column_object"],
        object_types=var["masking_reports_masked_column_object_type"],
        schema_names=var["masking_reports_masked_column_schema_name"],
        sensitive_type_id=oci_data_safe_sensitive_type["test_sensitive_type"]["id"])
    ```


    :param Sequence[str] column_names: A filter to return only a specific column based on column name.
    :param Sequence[str] masking_column_groups: A filter to return only the resources that match the specified masking column group.
    :param str masking_report_id: The OCID of the masking report.
    :param Sequence[str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    """
    __args__ = dict()
    __args__['columnNames'] = column_names
    __args__['filters'] = filters
    __args__['maskingColumnGroups'] = masking_column_groups
    __args__['maskingReportId'] = masking_report_id
    __args__['objectTypes'] = object_types
    __args__['objects'] = objects
    __args__['schemaNames'] = schema_names
    __args__['sensitiveTypeId'] = sensitive_type_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getMaskingReportMaskedColumns:getMaskingReportMaskedColumns', __args__, opts=opts, typ=GetMaskingReportMaskedColumnsResult).value

    return AwaitableGetMaskingReportMaskedColumnsResult(
        column_names=pulumi.get(__ret__, 'column_names'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        masked_column_collections=pulumi.get(__ret__, 'masked_column_collections'),
        masking_column_groups=pulumi.get(__ret__, 'masking_column_groups'),
        masking_report_id=pulumi.get(__ret__, 'masking_report_id'),
        object_types=pulumi.get(__ret__, 'object_types'),
        objects=pulumi.get(__ret__, 'objects'),
        schema_names=pulumi.get(__ret__, 'schema_names'),
        sensitive_type_id=pulumi.get(__ret__, 'sensitive_type_id'))


@_utilities.lift_output_func(get_masking_report_masked_columns)
def get_masking_report_masked_columns_output(column_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetMaskingReportMaskedColumnsFilterArgs']]]]] = None,
                                             masking_column_groups: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             masking_report_id: Optional[pulumi.Input[str]] = None,
                                             object_types: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             objects: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             schema_names: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                             sensitive_type_id: Optional[pulumi.Input[Optional[str]]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetMaskingReportMaskedColumnsResult]:
    """
    This data source provides the list of Masking Reports Masked Columns in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of masked columns present in the specified masking report and based on the specified query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_masking_reports_masked_columns = oci.DataSafe.get_masking_report_masked_columns(masking_report_id=oci_data_safe_masking_report["test_masking_report"]["id"],
        column_names=var["masking_reports_masked_column_column_name"],
        masking_column_groups=var["masking_reports_masked_column_masking_column_group"],
        objects=var["masking_reports_masked_column_object"],
        object_types=var["masking_reports_masked_column_object_type"],
        schema_names=var["masking_reports_masked_column_schema_name"],
        sensitive_type_id=oci_data_safe_sensitive_type["test_sensitive_type"]["id"])
    ```


    :param Sequence[str] column_names: A filter to return only a specific column based on column name.
    :param Sequence[str] masking_column_groups: A filter to return only the resources that match the specified masking column group.
    :param str masking_report_id: The OCID of the masking report.
    :param Sequence[str] object_types: A filter to return only items related to a specific object type.
    :param Sequence[str] objects: A filter to return only items related to a specific object name.
    :param Sequence[str] schema_names: A filter to return only items related to specific schema name.
    :param str sensitive_type_id: A filter to return only items related to a specific sensitive type OCID.
    """
    ...
