# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSecurityAssessmentSecurityFeatureAnalyticsResult',
    'AwaitableGetSecurityAssessmentSecurityFeatureAnalyticsResult',
    'get_security_assessment_security_feature_analytics',
    'get_security_assessment_security_feature_analytics_output',
]

@pulumi.output_type
class GetSecurityAssessmentSecurityFeatureAnalyticsResult:
    """
    A collection of values returned by getSecurityAssessmentSecurityFeatureAnalytics.
    """
    def __init__(__self__, access_level=None, compartment_id=None, compartment_id_in_subtree=None, filters=None, id=None, security_feature_analytics_collections=None, target_id=None):
        if access_level and not isinstance(access_level, str):
            raise TypeError("Expected argument 'access_level' to be a str")
        pulumi.set(__self__, "access_level", access_level)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if compartment_id_in_subtree and not isinstance(compartment_id_in_subtree, bool):
            raise TypeError("Expected argument 'compartment_id_in_subtree' to be a bool")
        pulumi.set(__self__, "compartment_id_in_subtree", compartment_id_in_subtree)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if security_feature_analytics_collections and not isinstance(security_feature_analytics_collections, list):
            raise TypeError("Expected argument 'security_feature_analytics_collections' to be a list")
        pulumi.set(__self__, "security_feature_analytics_collections", security_feature_analytics_collections)
        if target_id and not isinstance(target_id, str):
            raise TypeError("Expected argument 'target_id' to be a str")
        pulumi.set(__self__, "target_id", target_id)

    @property
    @pulumi.getter(name="accessLevel")
    def access_level(self) -> Optional[str]:
        return pulumi.get(self, "access_level")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compartmentIdInSubtree")
    def compartment_id_in_subtree(self) -> Optional[bool]:
        return pulumi.get(self, "compartment_id_in_subtree")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSecurityAssessmentSecurityFeatureAnalyticsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="securityFeatureAnalyticsCollections")
    def security_feature_analytics_collections(self) -> Sequence['outputs.GetSecurityAssessmentSecurityFeatureAnalyticsSecurityFeatureAnalyticsCollectionResult']:
        """
        The list of security_feature_analytics_collection.
        """
        return pulumi.get(self, "security_feature_analytics_collections")

    @property
    @pulumi.getter(name="targetId")
    def target_id(self) -> Optional[str]:
        return pulumi.get(self, "target_id")


class AwaitableGetSecurityAssessmentSecurityFeatureAnalyticsResult(GetSecurityAssessmentSecurityFeatureAnalyticsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSecurityAssessmentSecurityFeatureAnalyticsResult(
            access_level=self.access_level,
            compartment_id=self.compartment_id,
            compartment_id_in_subtree=self.compartment_id_in_subtree,
            filters=self.filters,
            id=self.id,
            security_feature_analytics_collections=self.security_feature_analytics_collections,
            target_id=self.target_id)


def get_security_assessment_security_feature_analytics(access_level: Optional[str] = None,
                                                       compartment_id: Optional[str] = None,
                                                       compartment_id_in_subtree: Optional[bool] = None,
                                                       filters: Optional[Sequence[pulumi.InputType['GetSecurityAssessmentSecurityFeatureAnalyticsFilterArgs']]] = None,
                                                       target_id: Optional[str] = None,
                                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSecurityAssessmentSecurityFeatureAnalyticsResult:
    """
    This data source provides the list of Security Assessment Security Feature Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of Database security feature usage aggregated details in the specified compartment. This provides information about the
    overall security controls, by returning the counting number of the target databases using the security features.

    When you perform the ListSecurityFeatureAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_security_feature_analytics = oci.DataSafe.get_security_assessment_security_feature_analytics(compartment_id=var["compartment_id"],
        access_level=var["security_assessment_security_feature_analytic_access_level"],
        compartment_id_in_subtree=var["security_assessment_security_feature_analytic_compartment_id_in_subtree"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    __args__ = dict()
    __args__['accessLevel'] = access_level
    __args__['compartmentId'] = compartment_id
    __args__['compartmentIdInSubtree'] = compartment_id_in_subtree
    __args__['filters'] = filters
    __args__['targetId'] = target_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataSafe/getSecurityAssessmentSecurityFeatureAnalytics:getSecurityAssessmentSecurityFeatureAnalytics', __args__, opts=opts, typ=GetSecurityAssessmentSecurityFeatureAnalyticsResult).value

    return AwaitableGetSecurityAssessmentSecurityFeatureAnalyticsResult(
        access_level=pulumi.get(__ret__, 'access_level'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        compartment_id_in_subtree=pulumi.get(__ret__, 'compartment_id_in_subtree'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        security_feature_analytics_collections=pulumi.get(__ret__, 'security_feature_analytics_collections'),
        target_id=pulumi.get(__ret__, 'target_id'))


@_utilities.lift_output_func(get_security_assessment_security_feature_analytics)
def get_security_assessment_security_feature_analytics_output(access_level: Optional[pulumi.Input[Optional[str]]] = None,
                                                              compartment_id: Optional[pulumi.Input[str]] = None,
                                                              compartment_id_in_subtree: Optional[pulumi.Input[Optional[bool]]] = None,
                                                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSecurityAssessmentSecurityFeatureAnalyticsFilterArgs']]]]] = None,
                                                              target_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSecurityAssessmentSecurityFeatureAnalyticsResult]:
    """
    This data source provides the list of Security Assessment Security Feature Analytics in Oracle Cloud Infrastructure Data Safe service.

    Gets a list of Database security feature usage aggregated details in the specified compartment. This provides information about the
    overall security controls, by returning the counting number of the target databases using the security features.

    When you perform the ListSecurityFeatureAnalytics operation, if the parameter compartmentIdInSubtree is set to "true," and if the
    parameter accessLevel is set to ACCESSIBLE, then the operation returns statistics from the compartments in which the requestor has INSPECT
    permissions on at least one resource, directly or indirectly (in subcompartments). If the operation is performed at the
    root compartment and the requestor does not have access to at least one subcompartment of the compartment specified by
    compartmentId, then "Not Authorized" is returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_security_assessment_security_feature_analytics = oci.DataSafe.get_security_assessment_security_feature_analytics(compartment_id=var["compartment_id"],
        access_level=var["security_assessment_security_feature_analytic_access_level"],
        compartment_id_in_subtree=var["security_assessment_security_feature_analytic_compartment_id_in_subtree"],
        target_id=oci_cloud_guard_target["test_target"]["id"])
    ```


    :param str access_level: Valid values are RESTRICTED and ACCESSIBLE. Default is RESTRICTED. Setting this to ACCESSIBLE returns only those compartments for which the user has INSPECT permissions directly or indirectly (permissions can be on a resource in a subcompartment). When set to RESTRICTED permissions are checked and no partial results are displayed.
    :param str compartment_id: A filter to return only resources that match the specified compartment OCID.
    :param bool compartment_id_in_subtree: Default is false. When set to true, the hierarchy of compartments is traversed and all compartments and subcompartments in the tenancy are returned. Depends on the 'accessLevel' setting.
    :param str target_id: A filter to return only items related to a specific target OCID.
    """
    ...
