# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetDatabasePeerTargetDatabaseInitArgs', 'TargetDatabasePeerTargetDatabase']

@pulumi.input_type
class TargetDatabasePeerTargetDatabaseInitArgs:
    def __init__(__self__, *,
                 database_details: pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs'],
                 target_database_id: pulumi.Input[str],
                 dataguard_association_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']] = None):
        """
        The set of arguments for constructing a TargetDatabasePeerTargetDatabase resource.
        :param pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs'] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[str] target_database_id: The OCID of the Data Safe target database.
        :param pulumi.Input[str] dataguard_association_id: The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        :param pulumi.Input[str] description: (Updatable) The description of the peer target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs'] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        pulumi.set(__self__, "database_details", database_details)
        pulumi.set(__self__, "target_database_id", target_database_id)
        if dataguard_association_id is not None:
            pulumi.set(__self__, "dataguard_association_id", dataguard_association_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @database_details.setter
    def database_details(self, value: pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']):
        pulumi.set(self, "database_details", value)

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> pulumi.Input[str]:
        """
        The OCID of the Data Safe target database.
        """
        return pulumi.get(self, "target_database_id")

    @target_database_id.setter
    def target_database_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "target_database_id", value)

    @property
    @pulumi.getter(name="dataguardAssociationId")
    def dataguard_association_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        """
        return pulumi.get(self, "dataguard_association_id")

    @dataguard_association_id.setter
    def dataguard_association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataguard_association_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the peer target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


@pulumi.input_type
class _TargetDatabasePeerTargetDatabaseState:
    def __init__(__self__, *,
                 database_details: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']] = None,
                 database_unique_name: Optional[pulumi.Input[str]] = None,
                 dataguard_association_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 key: Optional[pulumi.Input[int]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 role: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 target_database_id: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']] = None):
        """
        Input properties used for looking up and filtering TargetDatabasePeerTargetDatabase resources.
        :param pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs'] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[str] dataguard_association_id: The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        :param pulumi.Input[str] description: (Updatable) The description of the peer target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[int] key: The secondary key assigned for the peer target database in Data Safe.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the peer target database in Data Safe.
        :param pulumi.Input[str] role: Role of the database associated to the peer target database.
        :param pulumi.Input[str] state: The current state of the peer target database in Data Safe.
        :param pulumi.Input[str] target_database_id: The OCID of the Data Safe target database.
        :param pulumi.Input[str] time_created: The date and time of the peer target database registration in Data Safe.
        :param pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs'] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        if database_details is not None:
            pulumi.set(__self__, "database_details", database_details)
        if database_unique_name is not None:
            pulumi.set(__self__, "database_unique_name", database_unique_name)
        if dataguard_association_id is not None:
            pulumi.set(__self__, "dataguard_association_id", dataguard_association_id)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if key is not None:
            pulumi.set(__self__, "key", key)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if role is not None:
            pulumi.set(__self__, "role", role)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if target_database_id is not None:
            pulumi.set(__self__, "target_database_id", target_database_id)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if tls_config is not None:
            pulumi.set(__self__, "tls_config", tls_config)

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']]:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @database_details.setter
    def database_details(self, value: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']]):
        pulumi.set(self, "database_details", value)

    @property
    @pulumi.getter(name="databaseUniqueName")
    def database_unique_name(self) -> Optional[pulumi.Input[str]]:
        """
        Unique name of the database associated to the peer target database.
        """
        return pulumi.get(self, "database_unique_name")

    @database_unique_name.setter
    def database_unique_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_unique_name", value)

    @property
    @pulumi.getter(name="dataguardAssociationId")
    def dataguard_association_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        """
        return pulumi.get(self, "dataguard_association_id")

    @dataguard_association_id.setter
    def dataguard_association_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dataguard_association_id", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The description of the peer target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[pulumi.Input[int]]:
        """
        The secondary key assigned for the peer target database in Data Safe.
        """
        return pulumi.get(self, "key")

    @key.setter
    def key(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "key", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        Details about the current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role of the database associated to the peer target database.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the Data Safe target database.
        """
        return pulumi.get(self, "target_database_id")

    @target_database_id.setter
    def target_database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "target_database_id", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time of the peer target database registration in Data Safe.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

    @tls_config.setter
    def tls_config(self, value: Optional[pulumi.Input['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]):
        pulumi.set(self, "tls_config", value)


class TargetDatabasePeerTargetDatabase(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_details: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']]] = None,
                 dataguard_association_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 target_database_id: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Target Database Peer Target Database resource in Oracle Cloud Infrastructure Data Safe service.

        Creates the peer target database under the primary target database in Data Safe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database_peer_target_database = oci.data_safe.TargetDatabasePeerTargetDatabase("testTargetDatabasePeerTargetDatabase",
            database_details=oci.data_safe.TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs(
                database_type=var["target_database_peer_target_database_database_details_database_type"],
                infrastructure_type=var["target_database_peer_target_database_database_details_infrastructure_type"],
                autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"],
                db_system_id=oci_database_db_system["test_db_system"]["id"],
                instance_id=oci_core_instance["test_instance"]["id"],
                ip_addresses=var["target_database_peer_target_database_database_details_ip_addresses"],
                listener_port=var["target_database_peer_target_database_database_details_listener_port"],
                service_name=oci_core_service["test_service"]["name"],
                vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
            ),
            target_database_id=oci_data_safe_target_database["test_target_database"]["id"],
            dataguard_association_id=oci_certificates_management_association["test_association"]["id"],
            description=var["target_database_peer_target_database_description"],
            display_name=var["target_database_peer_target_database_display_name"],
            tls_config=oci.data_safe.TargetDatabasePeerTargetDatabaseTlsConfigArgs(
                status=var["target_database_peer_target_database_tls_config_status"],
                certificate_store_type=var["target_database_peer_target_database_tls_config_certificate_store_type"],
                key_store_content=var["target_database_peer_target_database_tls_config_key_store_content"],
                store_password=var["target_database_peer_target_database_tls_config_store_password"],
                trust_store_content=var["target_database_peer_target_database_tls_config_trust_store_content"],
            ))
        ```

        ## Import

        TargetDatabasePeerTargetDatabases can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/targetDatabasePeerTargetDatabase:TargetDatabasePeerTargetDatabase test_target_database_peer_target_database "targetDatabases/{targetDatabaseId}/peerTargetDatabases/{peerTargetDatabaseId}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[str] dataguard_association_id: The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        :param pulumi.Input[str] description: (Updatable) The description of the peer target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[str] target_database_id: The OCID of the Data Safe target database.
        :param pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseTlsConfigArgs']] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetDatabasePeerTargetDatabaseInitArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Target Database Peer Target Database resource in Oracle Cloud Infrastructure Data Safe service.

        Creates the peer target database under the primary target database in Data Safe.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_database_peer_target_database = oci.data_safe.TargetDatabasePeerTargetDatabase("testTargetDatabasePeerTargetDatabase",
            database_details=oci.data_safe.TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs(
                database_type=var["target_database_peer_target_database_database_details_database_type"],
                infrastructure_type=var["target_database_peer_target_database_database_details_infrastructure_type"],
                autonomous_database_id=oci_database_autonomous_database["test_autonomous_database"]["id"],
                db_system_id=oci_database_db_system["test_db_system"]["id"],
                instance_id=oci_core_instance["test_instance"]["id"],
                ip_addresses=var["target_database_peer_target_database_database_details_ip_addresses"],
                listener_port=var["target_database_peer_target_database_database_details_listener_port"],
                service_name=oci_core_service["test_service"]["name"],
                vm_cluster_id=oci_database_vm_cluster["test_vm_cluster"]["id"],
            ),
            target_database_id=oci_data_safe_target_database["test_target_database"]["id"],
            dataguard_association_id=oci_certificates_management_association["test_association"]["id"],
            description=var["target_database_peer_target_database_description"],
            display_name=var["target_database_peer_target_database_display_name"],
            tls_config=oci.data_safe.TargetDatabasePeerTargetDatabaseTlsConfigArgs(
                status=var["target_database_peer_target_database_tls_config_status"],
                certificate_store_type=var["target_database_peer_target_database_tls_config_certificate_store_type"],
                key_store_content=var["target_database_peer_target_database_tls_config_key_store_content"],
                store_password=var["target_database_peer_target_database_tls_config_store_password"],
                trust_store_content=var["target_database_peer_target_database_tls_config_trust_store_content"],
            ))
        ```

        ## Import

        TargetDatabasePeerTargetDatabases can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:DataSafe/targetDatabasePeerTargetDatabase:TargetDatabasePeerTargetDatabase test_target_database_peer_target_database "targetDatabases/{targetDatabaseId}/peerTargetDatabases/{peerTargetDatabaseId}"
        ```

        :param str resource_name: The name of the resource.
        :param TargetDatabasePeerTargetDatabaseInitArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetDatabasePeerTargetDatabaseInitArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 database_details: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']]] = None,
                 dataguard_association_id: Optional[pulumi.Input[str]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 target_database_id: Optional[pulumi.Input[str]] = None,
                 tls_config: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetDatabasePeerTargetDatabaseInitArgs.__new__(TargetDatabasePeerTargetDatabaseInitArgs)

            if database_details is None and not opts.urn:
                raise TypeError("Missing required property 'database_details'")
            __props__.__dict__["database_details"] = database_details
            __props__.__dict__["dataguard_association_id"] = dataguard_association_id
            __props__.__dict__["description"] = description
            __props__.__dict__["display_name"] = display_name
            if target_database_id is None and not opts.urn:
                raise TypeError("Missing required property 'target_database_id'")
            __props__.__dict__["target_database_id"] = target_database_id
            __props__.__dict__["tls_config"] = tls_config
            __props__.__dict__["database_unique_name"] = None
            __props__.__dict__["key"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["role"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_created"] = None
        super(TargetDatabasePeerTargetDatabase, __self__).__init__(
            'oci:DataSafe/targetDatabasePeerTargetDatabase:TargetDatabasePeerTargetDatabase',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            database_details: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']]] = None,
            database_unique_name: Optional[pulumi.Input[str]] = None,
            dataguard_association_id: Optional[pulumi.Input[str]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            key: Optional[pulumi.Input[int]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            role: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            target_database_id: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            tls_config: Optional[pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseTlsConfigArgs']]] = None) -> 'TargetDatabasePeerTargetDatabase':
        """
        Get an existing TargetDatabasePeerTargetDatabase resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseDatabaseDetailsArgs']] database_details: (Updatable) Details of the database for the registration in Data Safe.
        :param pulumi.Input[str] database_unique_name: Unique name of the database associated to the peer target database.
        :param pulumi.Input[str] dataguard_association_id: The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        :param pulumi.Input[str] description: (Updatable) The description of the peer target database in Data Safe.
        :param pulumi.Input[str] display_name: (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        :param pulumi.Input[int] key: The secondary key assigned for the peer target database in Data Safe.
        :param pulumi.Input[str] lifecycle_details: Details about the current state of the peer target database in Data Safe.
        :param pulumi.Input[str] role: Role of the database associated to the peer target database.
        :param pulumi.Input[str] state: The current state of the peer target database in Data Safe.
        :param pulumi.Input[str] target_database_id: The OCID of the Data Safe target database.
        :param pulumi.Input[str] time_created: The date and time of the peer target database registration in Data Safe.
        :param pulumi.Input[pulumi.InputType['TargetDatabasePeerTargetDatabaseTlsConfigArgs']] tls_config: (Updatable) The details required to establish a TLS enabled connection.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetDatabasePeerTargetDatabaseState.__new__(_TargetDatabasePeerTargetDatabaseState)

        __props__.__dict__["database_details"] = database_details
        __props__.__dict__["database_unique_name"] = database_unique_name
        __props__.__dict__["dataguard_association_id"] = dataguard_association_id
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["key"] = key
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["role"] = role
        __props__.__dict__["state"] = state
        __props__.__dict__["target_database_id"] = target_database_id
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["tls_config"] = tls_config
        return TargetDatabasePeerTargetDatabase(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="databaseDetails")
    def database_details(self) -> pulumi.Output['outputs.TargetDatabasePeerTargetDatabaseDatabaseDetails']:
        """
        (Updatable) Details of the database for the registration in Data Safe.
        """
        return pulumi.get(self, "database_details")

    @property
    @pulumi.getter(name="databaseUniqueName")
    def database_unique_name(self) -> pulumi.Output[str]:
        """
        Unique name of the database associated to the peer target database.
        """
        return pulumi.get(self, "database_unique_name")

    @property
    @pulumi.getter(name="dataguardAssociationId")
    def dataguard_association_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Data Guard Association resource in which the database being registered is considered as peer database to the primary database.
        """
        return pulumi.get(self, "dataguard_association_id")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) The description of the peer target database in Data Safe.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) The display name of the peer target database in Data Safe. The name is modifiable and does not need to be unique.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def key(self) -> pulumi.Output[int]:
        """
        The secondary key assigned for the peer target database in Data Safe.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        Details about the current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def role(self) -> pulumi.Output[str]:
        """
        Role of the database associated to the peer target database.
        """
        return pulumi.get(self, "role")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the peer target database in Data Safe.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="targetDatabaseId")
    def target_database_id(self) -> pulumi.Output[str]:
        """
        The OCID of the Data Safe target database.
        """
        return pulumi.get(self, "target_database_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time of the peer target database registration in Data Safe.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="tlsConfig")
    def tls_config(self) -> pulumi.Output['outputs.TargetDatabasePeerTargetDatabaseTlsConfig']:
        """
        (Updatable) The details required to establish a TLS enabled connection.
        """
        return pulumi.get(self, "tls_config")

