# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetListJreUsageResult',
    'AwaitableGetListJreUsageResult',
    'get_list_jre_usage',
    'get_list_jre_usage_output',
]

@pulumi.output_type
class GetListJreUsageResult:
    """
    A collection of values returned by getListJreUsage.
    """
    def __init__(__self__, application_id=None, application_name=None, compartment_id=None, host_id=None, id=None, items=None, time_end=None, time_start=None):
        if application_id and not isinstance(application_id, str):
            raise TypeError("Expected argument 'application_id' to be a str")
        pulumi.set(__self__, "application_id", application_id)
        if application_name and not isinstance(application_name, str):
            raise TypeError("Expected argument 'application_name' to be a str")
        pulumi.set(__self__, "application_name", application_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if host_id and not isinstance(host_id, str):
            raise TypeError("Expected argument 'host_id' to be a str")
        pulumi.set(__self__, "host_id", host_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if items and not isinstance(items, list):
            raise TypeError("Expected argument 'items' to be a list")
        pulumi.set(__self__, "items", items)
        if time_end and not isinstance(time_end, str):
            raise TypeError("Expected argument 'time_end' to be a str")
        pulumi.set(__self__, "time_end", time_end)
        if time_start and not isinstance(time_start, str):
            raise TypeError("Expected argument 'time_start' to be a str")
        pulumi.set(__self__, "time_start", time_start)

    @property
    @pulumi.getter(name="applicationId")
    def application_id(self) -> Optional[str]:
        return pulumi.get(self, "application_id")

    @property
    @pulumi.getter(name="applicationName")
    def application_name(self) -> Optional[str]:
        return pulumi.get(self, "application_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="hostId")
    def host_id(self) -> Optional[str]:
        return pulumi.get(self, "host_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetListJreUsageItemResult']:
        """
        A list of Java Runtimes.
        """
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="timeEnd")
    def time_end(self) -> Optional[str]:
        """
        Upper bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.
        """
        return pulumi.get(self, "time_end")

    @property
    @pulumi.getter(name="timeStart")
    def time_start(self) -> Optional[str]:
        """
        Lower bound of the specified time period filter. JMS provides a view of the data that is _per day_. The query uses only the date element of the parameter.
        """
        return pulumi.get(self, "time_start")


class AwaitableGetListJreUsageResult(GetListJreUsageResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetListJreUsageResult(
            application_id=self.application_id,
            application_name=self.application_name,
            compartment_id=self.compartment_id,
            host_id=self.host_id,
            id=self.id,
            items=self.items,
            time_end=self.time_end,
            time_start=self.time_start)


def get_list_jre_usage(application_id: Optional[str] = None,
                       application_name: Optional[str] = None,
                       compartment_id: Optional[str] = None,
                       host_id: Optional[str] = None,
                       time_end: Optional[str] = None,
                       time_start: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetListJreUsageResult:
    """
    This data source provides details about a specific List Jre Usage resource in Oracle Cloud Infrastructure Jms service.

    List Java Runtime usage in a specified host filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_list_jre_usage = oci.Jms.get_list_jre_usage(application_id=oci_dataflow_application["test_application"]["id"],
        application_name=oci_dataflow_application["test_application"]["name"],
        compartment_id=var["compartment_id"],
        host_id=oci_jms_host["test_host"]["id"],
        time_end=var["list_jre_usage_time_end"],
        time_start=var["list_jre_usage_time_start"])
    ```


    :param str application_id: The Fleet-unique identifier of the application.
    :param str application_name: The name of the application.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str host_id: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    __args__ = dict()
    __args__['applicationId'] = application_id
    __args__['applicationName'] = application_name
    __args__['compartmentId'] = compartment_id
    __args__['hostId'] = host_id
    __args__['timeEnd'] = time_end
    __args__['timeStart'] = time_start
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Jms/getListJreUsage:getListJreUsage', __args__, opts=opts, typ=GetListJreUsageResult).value

    return AwaitableGetListJreUsageResult(
        application_id=pulumi.get(__ret__, 'application_id'),
        application_name=pulumi.get(__ret__, 'application_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        host_id=pulumi.get(__ret__, 'host_id'),
        id=pulumi.get(__ret__, 'id'),
        items=pulumi.get(__ret__, 'items'),
        time_end=pulumi.get(__ret__, 'time_end'),
        time_start=pulumi.get(__ret__, 'time_start'))


@_utilities.lift_output_func(get_list_jre_usage)
def get_list_jre_usage_output(application_id: Optional[pulumi.Input[Optional[str]]] = None,
                              application_name: Optional[pulumi.Input[Optional[str]]] = None,
                              compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                              host_id: Optional[pulumi.Input[Optional[str]]] = None,
                              time_end: Optional[pulumi.Input[Optional[str]]] = None,
                              time_start: Optional[pulumi.Input[Optional[str]]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetListJreUsageResult]:
    """
    This data source provides details about a specific List Jre Usage resource in Oracle Cloud Infrastructure Jms service.

    List Java Runtime usage in a specified host filtered by query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_list_jre_usage = oci.Jms.get_list_jre_usage(application_id=oci_dataflow_application["test_application"]["id"],
        application_name=oci_dataflow_application["test_application"]["name"],
        compartment_id=var["compartment_id"],
        host_id=oci_jms_host["test_host"]["id"],
        time_end=var["list_jre_usage_time_end"],
        time_start=var["list_jre_usage_time_start"])
    ```


    :param str application_id: The Fleet-unique identifier of the application.
    :param str application_name: The name of the application.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment in which to list resources.
    :param str host_id: The host [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the managed instance.
    :param str time_end: The end of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    :param str time_start: The start of the time period during which resources are searched (formatted according to [RFC3339](https://datatracker.ietf.org/doc/html/rfc3339)).
    """
    ...
