# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetAcceptedAgreementsResult',
    'AwaitableGetAcceptedAgreementsResult',
    'get_accepted_agreements',
    'get_accepted_agreements_output',
]

@pulumi.output_type
class GetAcceptedAgreementsResult:
    """
    A collection of values returned by getAcceptedAgreements.
    """
    def __init__(__self__, accepted_agreement_id=None, accepted_agreements=None, compartment_id=None, display_name=None, filters=None, id=None, listing_id=None, package_version=None):
        if accepted_agreement_id and not isinstance(accepted_agreement_id, str):
            raise TypeError("Expected argument 'accepted_agreement_id' to be a str")
        pulumi.set(__self__, "accepted_agreement_id", accepted_agreement_id)
        if accepted_agreements and not isinstance(accepted_agreements, list):
            raise TypeError("Expected argument 'accepted_agreements' to be a list")
        pulumi.set(__self__, "accepted_agreements", accepted_agreements)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if listing_id and not isinstance(listing_id, str):
            raise TypeError("Expected argument 'listing_id' to be a str")
        pulumi.set(__self__, "listing_id", listing_id)
        if package_version and not isinstance(package_version, str):
            raise TypeError("Expected argument 'package_version' to be a str")
        pulumi.set(__self__, "package_version", package_version)

    @property
    @pulumi.getter(name="acceptedAgreementId")
    def accepted_agreement_id(self) -> Optional[str]:
        return pulumi.get(self, "accepted_agreement_id")

    @property
    @pulumi.getter(name="acceptedAgreements")
    def accepted_agreements(self) -> Sequence['outputs.GetAcceptedAgreementsAcceptedAgreementResult']:
        """
        The list of accepted_agreements.
        """
        return pulumi.get(self, "accepted_agreements")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The unique identifier for the compartment where the agreement was accepted.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A display name for the accepted agreement.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetAcceptedAgreementsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[str]:
        """
        The unique identifier for the listing associated with the agreement.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="packageVersion")
    def package_version(self) -> Optional[str]:
        """
        The package version associated with the agreement.
        """
        return pulumi.get(self, "package_version")


class AwaitableGetAcceptedAgreementsResult(GetAcceptedAgreementsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAcceptedAgreementsResult(
            accepted_agreement_id=self.accepted_agreement_id,
            accepted_agreements=self.accepted_agreements,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            listing_id=self.listing_id,
            package_version=self.package_version)


def get_accepted_agreements(accepted_agreement_id: Optional[str] = None,
                            compartment_id: Optional[str] = None,
                            display_name: Optional[str] = None,
                            filters: Optional[Sequence[pulumi.InputType['GetAcceptedAgreementsFilterArgs']]] = None,
                            listing_id: Optional[str] = None,
                            package_version: Optional[str] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAcceptedAgreementsResult:
    """
    This data source provides the list of Accepted Agreements in Oracle Cloud Infrastructure Marketplace service.

    Lists the terms of use agreements that have been accepted in the specified compartment.
    You can filter results by specifying query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_accepted_agreements = oci.Marketplace.get_accepted_agreements(compartment_id=var["compartment_id"],
        accepted_agreement_id=oci_marketplace_accepted_agreement["test_accepted_agreement"]["id"],
        display_name=var["accepted_agreement_display_name"],
        listing_id=oci_marketplace_listing["test_listing"]["id"],
        package_version=var["accepted_agreement_package_version"])
    ```


    :param str accepted_agreement_id: The unique identifier for the accepted terms of use agreement.
    :param str compartment_id: The unique identifier for the compartment.
    :param str display_name: The display name of the resource.
    :param str listing_id: The unique identifier for the listing.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    """
    __args__ = dict()
    __args__['acceptedAgreementId'] = accepted_agreement_id
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['listingId'] = listing_id
    __args__['packageVersion'] = package_version
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Marketplace/getAcceptedAgreements:getAcceptedAgreements', __args__, opts=opts, typ=GetAcceptedAgreementsResult).value

    return AwaitableGetAcceptedAgreementsResult(
        accepted_agreement_id=pulumi.get(__ret__, 'accepted_agreement_id'),
        accepted_agreements=pulumi.get(__ret__, 'accepted_agreements'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        listing_id=pulumi.get(__ret__, 'listing_id'),
        package_version=pulumi.get(__ret__, 'package_version'))


@_utilities.lift_output_func(get_accepted_agreements)
def get_accepted_agreements_output(accepted_agreement_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   compartment_id: Optional[pulumi.Input[str]] = None,
                                   display_name: Optional[pulumi.Input[Optional[str]]] = None,
                                   filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetAcceptedAgreementsFilterArgs']]]]] = None,
                                   listing_id: Optional[pulumi.Input[Optional[str]]] = None,
                                   package_version: Optional[pulumi.Input[Optional[str]]] = None,
                                   opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAcceptedAgreementsResult]:
    """
    This data source provides the list of Accepted Agreements in Oracle Cloud Infrastructure Marketplace service.

    Lists the terms of use agreements that have been accepted in the specified compartment.
    You can filter results by specifying query parameters.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_accepted_agreements = oci.Marketplace.get_accepted_agreements(compartment_id=var["compartment_id"],
        accepted_agreement_id=oci_marketplace_accepted_agreement["test_accepted_agreement"]["id"],
        display_name=var["accepted_agreement_display_name"],
        listing_id=oci_marketplace_listing["test_listing"]["id"],
        package_version=var["accepted_agreement_package_version"])
    ```


    :param str accepted_agreement_id: The unique identifier for the accepted terms of use agreement.
    :param str compartment_id: The unique identifier for the compartment.
    :param str display_name: The display name of the resource.
    :param str listing_id: The unique identifier for the listing.
    :param str package_version: The version of the package. Package versions are unique within a listing.
    """
    ...
