# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['OperatorControlAssignmentArgs', 'OperatorControlAssignment']

@pulumi.input_type
class OperatorControlAssignmentArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 is_enforced_always: pulumi.Input[bool],
                 operator_control_id: pulumi.Input[str],
                 resource_compartment_id: pulumi.Input[str],
                 resource_id: pulumi.Input[str],
                 resource_name: pulumi.Input[str],
                 resource_type: pulumi.Input[str],
                 comment: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 is_log_forwarded: Optional[pulumi.Input[bool]] = None,
                 remote_syslog_server_address: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_ca_cert: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_port: Optional[pulumi.Input[int]] = None,
                 time_assignment_from: Optional[pulumi.Input[str]] = None,
                 time_assignment_to: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a OperatorControlAssignment resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the operator control assignment.
        :param pulumi.Input[bool] is_enforced_always: (Updatable) If set, then the target resource is always governed by the operator control.
        :param pulumi.Input[str] operator_control_id: The OCID of the operator control that is being assigned to a target resource.
        :param pulumi.Input[str] resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param pulumi.Input[str] resource_id: The OCID of the target resource being brought under the governance of the operator control.
        :param pulumi.Input[str] resource_name: Name of the target resource.
        :param pulumi.Input[str] resource_type: Type of the target resource.
        :param pulumi.Input[str] comment: (Updatable) Comment about the assignment of the operator control to this target resource.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) The boolean if true would autoApprove during maintenance.
        :param pulumi.Input[bool] is_log_forwarded: (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        :param pulumi.Input[str] remote_syslog_server_address: (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        :param pulumi.Input[str] remote_syslog_server_ca_cert: (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        :param pulumi.Input[int] remote_syslog_server_port: (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param pulumi.Input[str] time_assignment_from: (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_assignment_to: (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "is_enforced_always", is_enforced_always)
        pulumi.set(__self__, "operator_control_id", operator_control_id)
        pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        pulumi.set(__self__, "resource_id", resource_id)
        pulumi.set(__self__, "resource_name", resource_name)
        pulumi.set(__self__, "resource_type", resource_type)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_approve_during_maintenance is not None:
            pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        if is_log_forwarded is not None:
            pulumi.set(__self__, "is_log_forwarded", is_log_forwarded)
        if remote_syslog_server_address is not None:
            pulumi.set(__self__, "remote_syslog_server_address", remote_syslog_server_address)
        if remote_syslog_server_ca_cert is not None:
            pulumi.set(__self__, "remote_syslog_server_ca_cert", remote_syslog_server_ca_cert)
        if remote_syslog_server_port is not None:
            pulumi.set(__self__, "remote_syslog_server_port", remote_syslog_server_port)
        if time_assignment_from is not None:
            pulumi.set(__self__, "time_assignment_from", time_assignment_from)
        if time_assignment_to is not None:
            pulumi.set(__self__, "time_assignment_to", time_assignment_to)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment that contains the operator control assignment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> pulumi.Input[bool]:
        """
        (Updatable) If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @is_enforced_always.setter
    def is_enforced_always(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_enforced_always", value)

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> pulumi.Input[str]:
        """
        The OCID of the operator control that is being assigned to a target resource.
        """
        return pulumi.get(self, "operator_control_id")

    @operator_control_id.setter
    def operator_control_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "operator_control_id", value)

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @resource_compartment_id.setter
    def resource_compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_compartment_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Input[str]:
        """
        The OCID of the target resource being brought under the governance of the operator control.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Input[str]:
        """
        Name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Input[str]:
        """
        Type of the target resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @is_auto_approve_during_maintenance.setter
    def is_auto_approve_during_maintenance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_approve_during_maintenance", value)

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @is_log_forwarded.setter
    def is_log_forwarded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_log_forwarded", value)

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @remote_syslog_server_address.setter
    def remote_syslog_server_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_syslog_server_address", value)

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @remote_syslog_server_ca_cert.setter
    def remote_syslog_server_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_syslog_server_ca_cert", value)

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @remote_syslog_server_port.setter
    def remote_syslog_server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remote_syslog_server_port", value)

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @time_assignment_from.setter
    def time_assignment_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_assignment_from", value)

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_assignment_to")

    @time_assignment_to.setter
    def time_assignment_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_assignment_to", value)


@pulumi.input_type
class _OperatorControlAssignmentState:
    def __init__(__self__, *,
                 assigner_id: Optional[pulumi.Input[str]] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 detachment_description: Optional[pulumi.Input[str]] = None,
                 error_code: Optional[pulumi.Input[int]] = None,
                 error_message: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 is_default_assignment: Optional[pulumi.Input[bool]] = None,
                 is_enforced_always: Optional[pulumi.Input[bool]] = None,
                 is_log_forwarded: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 operator_control_id: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_address: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_ca_cert: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_port: Optional[pulumi.Input[int]] = None,
                 resource_compartment_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_name: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_assignment_from: Optional[pulumi.Input[str]] = None,
                 time_assignment_to: Optional[pulumi.Input[str]] = None,
                 time_of_assignment: Optional[pulumi.Input[str]] = None,
                 time_of_deletion: Optional[pulumi.Input[str]] = None,
                 unassigner_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering OperatorControlAssignment resources.
        :param pulumi.Input[str] assigner_id: The OCID of the user who created this operator control assignment.
        :param pulumi.Input[str] comment: (Updatable) Comment about the assignment of the operator control to this target resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the operator control assignment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[str] detachment_description: description containing reason for releasing of OperatorControl.
        :param pulumi.Input[int] error_code: The code identifying the error occurred during Assignment operation.
        :param pulumi.Input[str] error_message: The message describing the error occurred during Assignment operation.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) The boolean if true would autoApprove during maintenance.
        :param pulumi.Input[bool] is_default_assignment: Whether the assignment is a default assignment.
        :param pulumi.Input[bool] is_enforced_always: (Updatable) If set, then the target resource is always governed by the operator control.
        :param pulumi.Input[bool] is_log_forwarded: (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        :param pulumi.Input[str] lifecycle_details: More in detail about the lifeCycleState.
        :param pulumi.Input[str] operator_control_id: The OCID of the operator control that is being assigned to a target resource.
        :param pulumi.Input[str] remote_syslog_server_address: (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        :param pulumi.Input[str] remote_syslog_server_ca_cert: (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        :param pulumi.Input[int] remote_syslog_server_port: (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param pulumi.Input[str] resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param pulumi.Input[str] resource_id: The OCID of the target resource being brought under the governance of the operator control.
        :param pulumi.Input[str] resource_name: Name of the target resource.
        :param pulumi.Input[str] resource_type: Type of the target resource.
        :param pulumi.Input[str] state: The current lifcycle state of the OperatorControl.
        :param pulumi.Input[str] time_assignment_from: (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_assignment_to: (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_of_assignment: Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_of_deletion: Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] unassigner_id: User id who released the operatorControl.
        """
        if assigner_id is not None:
            pulumi.set(__self__, "assigner_id", assigner_id)
        if comment is not None:
            pulumi.set(__self__, "comment", comment)
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if detachment_description is not None:
            pulumi.set(__self__, "detachment_description", detachment_description)
        if error_code is not None:
            pulumi.set(__self__, "error_code", error_code)
        if error_message is not None:
            pulumi.set(__self__, "error_message", error_message)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if is_auto_approve_during_maintenance is not None:
            pulumi.set(__self__, "is_auto_approve_during_maintenance", is_auto_approve_during_maintenance)
        if is_default_assignment is not None:
            pulumi.set(__self__, "is_default_assignment", is_default_assignment)
        if is_enforced_always is not None:
            pulumi.set(__self__, "is_enforced_always", is_enforced_always)
        if is_log_forwarded is not None:
            pulumi.set(__self__, "is_log_forwarded", is_log_forwarded)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if operator_control_id is not None:
            pulumi.set(__self__, "operator_control_id", operator_control_id)
        if remote_syslog_server_address is not None:
            pulumi.set(__self__, "remote_syslog_server_address", remote_syslog_server_address)
        if remote_syslog_server_ca_cert is not None:
            pulumi.set(__self__, "remote_syslog_server_ca_cert", remote_syslog_server_ca_cert)
        if remote_syslog_server_port is not None:
            pulumi.set(__self__, "remote_syslog_server_port", remote_syslog_server_port)
        if resource_compartment_id is not None:
            pulumi.set(__self__, "resource_compartment_id", resource_compartment_id)
        if resource_id is not None:
            pulumi.set(__self__, "resource_id", resource_id)
        if resource_name is not None:
            pulumi.set(__self__, "resource_name", resource_name)
        if resource_type is not None:
            pulumi.set(__self__, "resource_type", resource_type)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if time_assignment_from is not None:
            pulumi.set(__self__, "time_assignment_from", time_assignment_from)
        if time_assignment_to is not None:
            pulumi.set(__self__, "time_assignment_to", time_assignment_to)
        if time_of_assignment is not None:
            pulumi.set(__self__, "time_of_assignment", time_of_assignment)
        if time_of_deletion is not None:
            pulumi.set(__self__, "time_of_deletion", time_of_deletion)
        if unassigner_id is not None:
            pulumi.set(__self__, "unassigner_id", unassigner_id)

    @property
    @pulumi.getter(name="assignerId")
    def assigner_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the user who created this operator control assignment.
        """
        return pulumi.get(self, "assigner_id")

    @assigner_id.setter
    def assigner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "assigner_id", value)

    @property
    @pulumi.getter
    def comment(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @comment.setter
    def comment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "comment", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment that contains the operator control assignment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="detachmentDescription")
    def detachment_description(self) -> Optional[pulumi.Input[str]]:
        """
        description containing reason for releasing of OperatorControl.
        """
        return pulumi.get(self, "detachment_description")

    @detachment_description.setter
    def detachment_description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "detachment_description", value)

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> Optional[pulumi.Input[int]]:
        """
        The code identifying the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_code")

    @error_code.setter
    def error_code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "error_code", value)

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> Optional[pulumi.Input[str]]:
        """
        The message describing the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_message")

    @error_message.setter
    def error_message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "error_message", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @is_auto_approve_during_maintenance.setter
    def is_auto_approve_during_maintenance(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_auto_approve_during_maintenance", value)

    @property
    @pulumi.getter(name="isDefaultAssignment")
    def is_default_assignment(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether the assignment is a default assignment.
        """
        return pulumi.get(self, "is_default_assignment")

    @is_default_assignment.setter
    def is_default_assignment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_default_assignment", value)

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @is_enforced_always.setter
    def is_enforced_always(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_enforced_always", value)

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @is_log_forwarded.setter
    def is_log_forwarded(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_log_forwarded", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        More in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the operator control that is being assigned to a target resource.
        """
        return pulumi.get(self, "operator_control_id")

    @operator_control_id.setter
    def operator_control_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "operator_control_id", value)

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @remote_syslog_server_address.setter
    def remote_syslog_server_address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_syslog_server_address", value)

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @remote_syslog_server_ca_cert.setter
    def remote_syslog_server_ca_cert(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remote_syslog_server_ca_cert", value)

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @remote_syslog_server_port.setter
    def remote_syslog_server_port(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "remote_syslog_server_port", value)

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @resource_compartment_id.setter
    def resource_compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_compartment_id", value)

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the target resource being brought under the governance of the operator control.
        """
        return pulumi.get(self, "resource_id")

    @resource_id.setter
    def resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_id", value)

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @resource_name.setter
    def resource_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_name", value)

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Type of the target resource.
        """
        return pulumi.get(self, "resource_type")

    @resource_type.setter
    def resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "resource_type", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current lifcycle state of the OperatorControl.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @time_assignment_from.setter
    def time_assignment_from(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_assignment_from", value)

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_assignment_to")

    @time_assignment_to.setter
    def time_assignment_to(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_assignment_to", value)

    @property
    @pulumi.getter(name="timeOfAssignment")
    def time_of_assignment(self) -> Optional[pulumi.Input[str]]:
        """
        Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_assignment")

    @time_of_assignment.setter
    def time_of_assignment(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_assignment", value)

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> Optional[pulumi.Input[str]]:
        """
        Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_deletion")

    @time_of_deletion.setter
    def time_of_deletion(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_of_deletion", value)

    @property
    @pulumi.getter(name="unassignerId")
    def unassigner_id(self) -> Optional[pulumi.Input[str]]:
        """
        User id who released the operatorControl.
        """
        return pulumi.get(self, "unassigner_id")

    @unassigner_id.setter
    def unassigner_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "unassigner_id", value)


class OperatorControlAssignment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 is_enforced_always: Optional[pulumi.Input[bool]] = None,
                 is_log_forwarded: Optional[pulumi.Input[bool]] = None,
                 operator_control_id: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_address: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_ca_cert: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_port: Optional[pulumi.Input[int]] = None,
                 resource_compartment_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 time_assignment_from: Optional[pulumi.Input[str]] = None,
                 time_assignment_to: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Operator Control Assignment resource in Oracle Cloud Infrastructure Operator Access Control service.

        Creates an Operator Control Assignment resource. In effect, this brings the target resource under the governance of the Operator Control for specified time duration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operator_control_assignment = oci.operator_access_control.OperatorControlAssignment("testOperatorControlAssignment",
            compartment_id=var["compartment_id"],
            is_enforced_always=var["operator_control_assignment_is_enforced_always"],
            operator_control_id=oci_operator_access_control_operator_control["test_operator_control"]["id"],
            resource_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            resource_id=oci_operator_access_control_resource["test_resource"]["id"],
            resource_name_=var["operator_control_assignment_resource_name"],
            resource_type=var["operator_control_assignment_resource_type"],
            comment=var["operator_control_assignment_comment"],
            defined_tags=var["operator_control_assignment_defined_tags"],
            freeform_tags=var["operator_control_assignment_freeform_tags"],
            is_auto_approve_during_maintenance=var["operator_control_assignment_is_auto_approve_during_maintenance"],
            is_log_forwarded=var["operator_control_assignment_is_log_forwarded"],
            remote_syslog_server_address=var["operator_control_assignment_remote_syslog_server_address"],
            remote_syslog_server_ca_cert=var["operator_control_assignment_remote_syslog_server_ca_cert"],
            remote_syslog_server_port=var["operator_control_assignment_remote_syslog_server_port"],
            time_assignment_from=var["operator_control_assignment_time_assignment_from"],
            time_assignment_to=var["operator_control_assignment_time_assignment_to"])
        ```

        ## Import

        OperatorControlAssignments can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OperatorAccessControl/operatorControlAssignment:OperatorControlAssignment test_operator_control_assignment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] comment: (Updatable) Comment about the assignment of the operator control to this target resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the operator control assignment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) The boolean if true would autoApprove during maintenance.
        :param pulumi.Input[bool] is_enforced_always: (Updatable) If set, then the target resource is always governed by the operator control.
        :param pulumi.Input[bool] is_log_forwarded: (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        :param pulumi.Input[str] operator_control_id: The OCID of the operator control that is being assigned to a target resource.
        :param pulumi.Input[str] remote_syslog_server_address: (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        :param pulumi.Input[str] remote_syslog_server_ca_cert: (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        :param pulumi.Input[int] remote_syslog_server_port: (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param pulumi.Input[str] resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param pulumi.Input[str] resource_id: The OCID of the target resource being brought under the governance of the operator control.
        :param pulumi.Input[str] resource_name_: Name of the target resource.
        :param pulumi.Input[str] resource_type: Type of the target resource.
        :param pulumi.Input[str] time_assignment_from: (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_assignment_to: (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: OperatorControlAssignmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Operator Control Assignment resource in Oracle Cloud Infrastructure Operator Access Control service.

        Creates an Operator Control Assignment resource. In effect, this brings the target resource under the governance of the Operator Control for specified time duration.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_operator_control_assignment = oci.operator_access_control.OperatorControlAssignment("testOperatorControlAssignment",
            compartment_id=var["compartment_id"],
            is_enforced_always=var["operator_control_assignment_is_enforced_always"],
            operator_control_id=oci_operator_access_control_operator_control["test_operator_control"]["id"],
            resource_compartment_id=oci_identity_compartment["test_compartment"]["id"],
            resource_id=oci_operator_access_control_resource["test_resource"]["id"],
            resource_name_=var["operator_control_assignment_resource_name"],
            resource_type=var["operator_control_assignment_resource_type"],
            comment=var["operator_control_assignment_comment"],
            defined_tags=var["operator_control_assignment_defined_tags"],
            freeform_tags=var["operator_control_assignment_freeform_tags"],
            is_auto_approve_during_maintenance=var["operator_control_assignment_is_auto_approve_during_maintenance"],
            is_log_forwarded=var["operator_control_assignment_is_log_forwarded"],
            remote_syslog_server_address=var["operator_control_assignment_remote_syslog_server_address"],
            remote_syslog_server_ca_cert=var["operator_control_assignment_remote_syslog_server_ca_cert"],
            remote_syslog_server_port=var["operator_control_assignment_remote_syslog_server_port"],
            time_assignment_from=var["operator_control_assignment_time_assignment_from"],
            time_assignment_to=var["operator_control_assignment_time_assignment_to"])
        ```

        ## Import

        OperatorControlAssignments can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OperatorAccessControl/operatorControlAssignment:OperatorControlAssignment test_operator_control_assignment "id"
        ```

        :param str resource_name: The name of the resource.
        :param OperatorControlAssignmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(OperatorControlAssignmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 comment: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
                 is_enforced_always: Optional[pulumi.Input[bool]] = None,
                 is_log_forwarded: Optional[pulumi.Input[bool]] = None,
                 operator_control_id: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_address: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_ca_cert: Optional[pulumi.Input[str]] = None,
                 remote_syslog_server_port: Optional[pulumi.Input[int]] = None,
                 resource_compartment_id: Optional[pulumi.Input[str]] = None,
                 resource_id: Optional[pulumi.Input[str]] = None,
                 resource_name_: Optional[pulumi.Input[str]] = None,
                 resource_type: Optional[pulumi.Input[str]] = None,
                 time_assignment_from: Optional[pulumi.Input[str]] = None,
                 time_assignment_to: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = OperatorControlAssignmentArgs.__new__(OperatorControlAssignmentArgs)

            __props__.__dict__["comment"] = comment
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["is_auto_approve_during_maintenance"] = is_auto_approve_during_maintenance
            if is_enforced_always is None and not opts.urn:
                raise TypeError("Missing required property 'is_enforced_always'")
            __props__.__dict__["is_enforced_always"] = is_enforced_always
            __props__.__dict__["is_log_forwarded"] = is_log_forwarded
            if operator_control_id is None and not opts.urn:
                raise TypeError("Missing required property 'operator_control_id'")
            __props__.__dict__["operator_control_id"] = operator_control_id
            __props__.__dict__["remote_syslog_server_address"] = remote_syslog_server_address
            __props__.__dict__["remote_syslog_server_ca_cert"] = remote_syslog_server_ca_cert
            __props__.__dict__["remote_syslog_server_port"] = remote_syslog_server_port
            if resource_compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_compartment_id'")
            __props__.__dict__["resource_compartment_id"] = resource_compartment_id
            if resource_id is None and not opts.urn:
                raise TypeError("Missing required property 'resource_id'")
            __props__.__dict__["resource_id"] = resource_id
            if resource_name_ is None and not opts.urn:
                raise TypeError("Missing required property 'resource_name_'")
            __props__.__dict__["resource_name"] = resource_name_
            if resource_type is None and not opts.urn:
                raise TypeError("Missing required property 'resource_type'")
            __props__.__dict__["resource_type"] = resource_type
            __props__.__dict__["time_assignment_from"] = time_assignment_from
            __props__.__dict__["time_assignment_to"] = time_assignment_to
            __props__.__dict__["assigner_id"] = None
            __props__.__dict__["detachment_description"] = None
            __props__.__dict__["error_code"] = None
            __props__.__dict__["error_message"] = None
            __props__.__dict__["is_default_assignment"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["time_of_assignment"] = None
            __props__.__dict__["time_of_deletion"] = None
            __props__.__dict__["unassigner_id"] = None
        super(OperatorControlAssignment, __self__).__init__(
            'oci:OperatorAccessControl/operatorControlAssignment:OperatorControlAssignment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            assigner_id: Optional[pulumi.Input[str]] = None,
            comment: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            detachment_description: Optional[pulumi.Input[str]] = None,
            error_code: Optional[pulumi.Input[int]] = None,
            error_message: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            is_auto_approve_during_maintenance: Optional[pulumi.Input[bool]] = None,
            is_default_assignment: Optional[pulumi.Input[bool]] = None,
            is_enforced_always: Optional[pulumi.Input[bool]] = None,
            is_log_forwarded: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            operator_control_id: Optional[pulumi.Input[str]] = None,
            remote_syslog_server_address: Optional[pulumi.Input[str]] = None,
            remote_syslog_server_ca_cert: Optional[pulumi.Input[str]] = None,
            remote_syslog_server_port: Optional[pulumi.Input[int]] = None,
            resource_compartment_id: Optional[pulumi.Input[str]] = None,
            resource_id: Optional[pulumi.Input[str]] = None,
            resource_name_: Optional[pulumi.Input[str]] = None,
            resource_type: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_assignment_from: Optional[pulumi.Input[str]] = None,
            time_assignment_to: Optional[pulumi.Input[str]] = None,
            time_of_assignment: Optional[pulumi.Input[str]] = None,
            time_of_deletion: Optional[pulumi.Input[str]] = None,
            unassigner_id: Optional[pulumi.Input[str]] = None) -> 'OperatorControlAssignment':
        """
        Get an existing OperatorControlAssignment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] assigner_id: The OCID of the user who created this operator control assignment.
        :param pulumi.Input[str] comment: (Updatable) Comment about the assignment of the operator control to this target resource.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment that contains the operator control assignment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        :param pulumi.Input[str] detachment_description: description containing reason for releasing of OperatorControl.
        :param pulumi.Input[int] error_code: The code identifying the error occurred during Assignment operation.
        :param pulumi.Input[str] error_message: The message describing the error occurred during Assignment operation.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        :param pulumi.Input[bool] is_auto_approve_during_maintenance: (Updatable) The boolean if true would autoApprove during maintenance.
        :param pulumi.Input[bool] is_default_assignment: Whether the assignment is a default assignment.
        :param pulumi.Input[bool] is_enforced_always: (Updatable) If set, then the target resource is always governed by the operator control.
        :param pulumi.Input[bool] is_log_forwarded: (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        :param pulumi.Input[str] lifecycle_details: More in detail about the lifeCycleState.
        :param pulumi.Input[str] operator_control_id: The OCID of the operator control that is being assigned to a target resource.
        :param pulumi.Input[str] remote_syslog_server_address: (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        :param pulumi.Input[str] remote_syslog_server_ca_cert: (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        :param pulumi.Input[int] remote_syslog_server_port: (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        :param pulumi.Input[str] resource_compartment_id: The OCID of the compartment that contains the target resource.
        :param pulumi.Input[str] resource_id: The OCID of the target resource being brought under the governance of the operator control.
        :param pulumi.Input[str] resource_name_: Name of the target resource.
        :param pulumi.Input[str] resource_type: Type of the target resource.
        :param pulumi.Input[str] state: The current lifcycle state of the OperatorControl.
        :param pulumi.Input[str] time_assignment_from: (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_assignment_to: (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_of_assignment: Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] time_of_deletion: Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        :param pulumi.Input[str] unassigner_id: User id who released the operatorControl.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _OperatorControlAssignmentState.__new__(_OperatorControlAssignmentState)

        __props__.__dict__["assigner_id"] = assigner_id
        __props__.__dict__["comment"] = comment
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["detachment_description"] = detachment_description
        __props__.__dict__["error_code"] = error_code
        __props__.__dict__["error_message"] = error_message
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["is_auto_approve_during_maintenance"] = is_auto_approve_during_maintenance
        __props__.__dict__["is_default_assignment"] = is_default_assignment
        __props__.__dict__["is_enforced_always"] = is_enforced_always
        __props__.__dict__["is_log_forwarded"] = is_log_forwarded
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["operator_control_id"] = operator_control_id
        __props__.__dict__["remote_syslog_server_address"] = remote_syslog_server_address
        __props__.__dict__["remote_syslog_server_ca_cert"] = remote_syslog_server_ca_cert
        __props__.__dict__["remote_syslog_server_port"] = remote_syslog_server_port
        __props__.__dict__["resource_compartment_id"] = resource_compartment_id
        __props__.__dict__["resource_id"] = resource_id
        __props__.__dict__["resource_name"] = resource_name_
        __props__.__dict__["resource_type"] = resource_type
        __props__.__dict__["state"] = state
        __props__.__dict__["time_assignment_from"] = time_assignment_from
        __props__.__dict__["time_assignment_to"] = time_assignment_to
        __props__.__dict__["time_of_assignment"] = time_of_assignment
        __props__.__dict__["time_of_deletion"] = time_of_deletion
        __props__.__dict__["unassigner_id"] = unassigner_id
        return OperatorControlAssignment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="assignerId")
    def assigner_id(self) -> pulumi.Output[str]:
        """
        The OCID of the user who created this operator control assignment.
        """
        return pulumi.get(self, "assigner_id")

    @property
    @pulumi.getter
    def comment(self) -> pulumi.Output[str]:
        """
        (Updatable) Comment about the assignment of the operator control to this target resource.
        """
        return pulumi.get(self, "comment")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment that contains the operator control assignment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="detachmentDescription")
    def detachment_description(self) -> pulumi.Output[str]:
        """
        description containing reason for releasing of OperatorControl.
        """
        return pulumi.get(self, "detachment_description")

    @property
    @pulumi.getter(name="errorCode")
    def error_code(self) -> pulumi.Output[int]:
        """
        The code identifying the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_code")

    @property
    @pulumi.getter(name="errorMessage")
    def error_message(self) -> pulumi.Output[str]:
        """
        The message describing the error occurred during Assignment operation.
        """
        return pulumi.get(self, "error_message")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only.
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isAutoApproveDuringMaintenance")
    def is_auto_approve_during_maintenance(self) -> pulumi.Output[bool]:
        """
        (Updatable) The boolean if true would autoApprove during maintenance.
        """
        return pulumi.get(self, "is_auto_approve_during_maintenance")

    @property
    @pulumi.getter(name="isDefaultAssignment")
    def is_default_assignment(self) -> pulumi.Output[bool]:
        """
        Whether the assignment is a default assignment.
        """
        return pulumi.get(self, "is_default_assignment")

    @property
    @pulumi.getter(name="isEnforcedAlways")
    def is_enforced_always(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set, then the target resource is always governed by the operator control.
        """
        return pulumi.get(self, "is_enforced_always")

    @property
    @pulumi.getter(name="isLogForwarded")
    def is_log_forwarded(self) -> pulumi.Output[bool]:
        """
        (Updatable) If set, then the audit logs will be forwarded to the relevant remote logging server
        """
        return pulumi.get(self, "is_log_forwarded")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        More in detail about the lifeCycleState.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="operatorControlId")
    def operator_control_id(self) -> pulumi.Output[str]:
        """
        The OCID of the operator control that is being assigned to a target resource.
        """
        return pulumi.get(self, "operator_control_id")

    @property
    @pulumi.getter(name="remoteSyslogServerAddress")
    def remote_syslog_server_address(self) -> pulumi.Output[str]:
        """
        (Updatable) The address of the remote syslog server where the audit logs will be forwarded to. Address in host or IP format.
        """
        return pulumi.get(self, "remote_syslog_server_address")

    @property
    @pulumi.getter(name="remoteSyslogServerCaCert")
    def remote_syslog_server_ca_cert(self) -> pulumi.Output[str]:
        """
        (Updatable) The CA certificate of the remote syslog server. Identity of the remote syslog server will be asserted based on this certificate.
        """
        return pulumi.get(self, "remote_syslog_server_ca_cert")

    @property
    @pulumi.getter(name="remoteSyslogServerPort")
    def remote_syslog_server_port(self) -> pulumi.Output[int]:
        """
        (Updatable) The listening port of the remote syslog server. The port range is 0 - 65535. Only TCP supported.
        """
        return pulumi.get(self, "remote_syslog_server_port")

    @property
    @pulumi.getter(name="resourceCompartmentId")
    def resource_compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the compartment that contains the target resource.
        """
        return pulumi.get(self, "resource_compartment_id")

    @property
    @pulumi.getter(name="resourceId")
    def resource_id(self) -> pulumi.Output[str]:
        """
        The OCID of the target resource being brought under the governance of the operator control.
        """
        return pulumi.get(self, "resource_id")

    @property
    @pulumi.getter(name="resourceName")
    def resource_name(self) -> pulumi.Output[str]:
        """
        Name of the target resource.
        """
        return pulumi.get(self, "resource_name")

    @property
    @pulumi.getter(name="resourceType")
    def resource_type(self) -> pulumi.Output[str]:
        """
        Type of the target resource.
        """
        return pulumi.get(self, "resource_type")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current lifcycle state of the OperatorControl.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeAssignmentFrom")
    def time_assignment_from(self) -> pulumi.Output[str]:
        """
        (Updatable) The time at which the target resource will be brought under the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_assignment_from")

    @property
    @pulumi.getter(name="timeAssignmentTo")
    def time_assignment_to(self) -> pulumi.Output[str]:
        """
        (Updatable) The time at which the target resource will leave the governance of the operator control in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z' 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_assignment_to")

    @property
    @pulumi.getter(name="timeOfAssignment")
    def time_of_assignment(self) -> pulumi.Output[str]:
        """
        Time when the operator control assignment is created in [RFC 3339](https://tools.ietf.org/html/rfc3339) timestamp format. Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_assignment")

    @property
    @pulumi.getter(name="timeOfDeletion")
    def time_of_deletion(self) -> pulumi.Output[str]:
        """
        Time on which the operator control assignment was deleted in [RFC 3339](https://tools.ietf.org/html/rfc3339)timestamp format.Example: '2020-05-22T21:10:29.600Z'
        """
        return pulumi.get(self, "time_of_deletion")

    @property
    @pulumi.getter(name="unassignerId")
    def unassigner_id(self) -> pulumi.Output[str]:
        """
        User id who released the operatorControl.
        """
        return pulumi.get(self, "unassigner_id")

