# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['DatabaseInsightArgs', 'DatabaseInsight']

@pulumi.input_type
class DatabaseInsightArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 entity_source: pulumi.Input[str],
                 connection_credential_details: Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']] = None,
                 connection_details: Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']] = None,
                 credential_details: Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']] = None,
                 database_connection_status_details: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_resource_type: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a DatabaseInsight resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[str] entity_source: (Updatable) Source of the database entity.
        :param pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs'] connection_credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input['DatabaseInsightConnectionDetailsArgs'] connection_details: Connection details of the private endpoints.
        :param pulumi.Input['DatabaseInsightCredentialDetailsArgs'] credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[str] database_connection_status_details: A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        :param pulumi.Input[str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[str] database_resource_type: Oracle Cloud Infrastructure database resource type
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_type: Database Deployment Type
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "entity_source", entity_source)
        if connection_credential_details is not None:
            pulumi.set(__self__, "connection_credential_details", connection_credential_details)
        if connection_details is not None:
            pulumi.set(__self__, "connection_details", connection_details)
        if credential_details is not None:
            pulumi.set(__self__, "credential_details", credential_details)
        if database_connection_status_details is not None:
            pulumi.set(__self__, "database_connection_status_details", database_connection_status_details)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_resource_type is not None:
            pulumi.set(__self__, "database_resource_type", database_resource_type)
        if dbm_private_endpoint_id is not None:
            pulumi.set(__self__, "dbm_private_endpoint_id", dbm_private_endpoint_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if exadata_insight_id is not None:
            pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if opsi_private_endpoint_id is not None:
            pulumi.set(__self__, "opsi_private_endpoint_id", opsi_private_endpoint_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if status is not None:
            pulumi.set(__self__, "status", status)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Input[str]:
        """
        (Updatable) Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: pulumi.Input[str]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="connectionCredentialDetails")
    def connection_credential_details(self) -> Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "connection_credential_details")

    @connection_credential_details.setter
    def connection_credential_details(self, value: Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']]):
        pulumi.set(self, "connection_credential_details", value)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']]:
        """
        Connection details of the private endpoints.
        """
        return pulumi.get(self, "connection_details")

    @connection_details.setter
    def connection_details(self, value: Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']]):
        pulumi.set(self, "connection_details", value)

    @property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "credential_details")

    @credential_details.setter
    def credential_details(self, value: Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']]):
        pulumi.set(self, "credential_details", value)

    @property
    @pulumi.getter(name="databaseConnectionStatusDetails")
    def database_connection_status_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        """
        return pulumi.get(self, "database_connection_status_details")

    @database_connection_status_details.setter
    def database_connection_status_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_connection_status_details", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseResourceType")
    def database_resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Cloud Infrastructure database resource type
        """
        return pulumi.get(self, "database_resource_type")

    @database_resource_type.setter
    def database_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_resource_type", value)

    @property
    @pulumi.getter(name="dbmPrivateEndpointId")
    def dbm_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        """
        return pulumi.get(self, "dbm_private_endpoint_id")

    @dbm_private_endpoint_id.setter
    def dbm_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbm_private_endpoint_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Database Deployment Type
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @exadata_insight_id.setter
    def exadata_insight_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_insight_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @opsi_private_endpoint_id.setter
    def opsi_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsi_private_endpoint_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)


@pulumi.input_type
class _DatabaseInsightState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_credential_details: Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']] = None,
                 connection_details: Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']] = None,
                 credential_details: Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']] = None,
                 database_connection_status_details: Optional[pulumi.Input[str]] = None,
                 database_display_name: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_name: Optional[pulumi.Input[str]] = None,
                 database_resource_type: Optional[pulumi.Input[str]] = None,
                 database_type: Optional[pulumi.Input[str]] = None,
                 database_version: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_display_name: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_name: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 parent_id: Optional[pulumi.Input[str]] = None,
                 processor_count: Optional[pulumi.Input[int]] = None,
                 root_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering DatabaseInsight resources.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs'] connection_credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input['DatabaseInsightConnectionDetailsArgs'] connection_details: Connection details of the private endpoints.
        :param pulumi.Input['DatabaseInsightCredentialDetailsArgs'] credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[str] database_connection_status_details: A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        :param pulumi.Input[str] database_display_name: Display name of database
        :param pulumi.Input[str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[str] database_name: Name of database
        :param pulumi.Input[str] database_resource_type: Oracle Cloud Infrastructure database resource type
        :param pulumi.Input[str] database_type: Operations Insights internal representation of the database type.
        :param pulumi.Input[str] database_version: The version of the database.
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_type: Database Deployment Type
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: (Updatable) Source of the database entity.
        :param pulumi.Input[str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] parent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster or DB System ID, depending on which configuration the resource belongs to.
        :param pulumi.Input[int] processor_count: Processor count. This is the OCPU count for Autonomous Database and CPU core count for other database types.
        :param pulumi.Input[str] root_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Infrastructure.
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        :param pulumi.Input[str] state: The current state of the database.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the database insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the database insight was updated. An RFC3339 formatted datetime string
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if connection_credential_details is not None:
            pulumi.set(__self__, "connection_credential_details", connection_credential_details)
        if connection_details is not None:
            pulumi.set(__self__, "connection_details", connection_details)
        if credential_details is not None:
            pulumi.set(__self__, "credential_details", credential_details)
        if database_connection_status_details is not None:
            pulumi.set(__self__, "database_connection_status_details", database_connection_status_details)
        if database_display_name is not None:
            pulumi.set(__self__, "database_display_name", database_display_name)
        if database_id is not None:
            pulumi.set(__self__, "database_id", database_id)
        if database_name is not None:
            pulumi.set(__self__, "database_name", database_name)
        if database_resource_type is not None:
            pulumi.set(__self__, "database_resource_type", database_resource_type)
        if database_type is not None:
            pulumi.set(__self__, "database_type", database_type)
        if database_version is not None:
            pulumi.set(__self__, "database_version", database_version)
        if dbm_private_endpoint_id is not None:
            pulumi.set(__self__, "dbm_private_endpoint_id", dbm_private_endpoint_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if deployment_type is not None:
            pulumi.set(__self__, "deployment_type", deployment_type)
        if enterprise_manager_bridge_id is not None:
            pulumi.set(__self__, "enterprise_manager_bridge_id", enterprise_manager_bridge_id)
        if enterprise_manager_entity_display_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_display_name", enterprise_manager_entity_display_name)
        if enterprise_manager_entity_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_entity_identifier", enterprise_manager_entity_identifier)
        if enterprise_manager_entity_name is not None:
            pulumi.set(__self__, "enterprise_manager_entity_name", enterprise_manager_entity_name)
        if enterprise_manager_entity_type is not None:
            pulumi.set(__self__, "enterprise_manager_entity_type", enterprise_manager_entity_type)
        if enterprise_manager_identifier is not None:
            pulumi.set(__self__, "enterprise_manager_identifier", enterprise_manager_identifier)
        if entity_source is not None:
            pulumi.set(__self__, "entity_source", entity_source)
        if exadata_insight_id is not None:
            pulumi.set(__self__, "exadata_insight_id", exadata_insight_id)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if lifecycle_details is not None:
            pulumi.set(__self__, "lifecycle_details", lifecycle_details)
        if opsi_private_endpoint_id is not None:
            pulumi.set(__self__, "opsi_private_endpoint_id", opsi_private_endpoint_id)
        if parent_id is not None:
            pulumi.set(__self__, "parent_id", parent_id)
        if processor_count is not None:
            pulumi.set(__self__, "processor_count", processor_count)
        if root_id is not None:
            pulumi.set(__self__, "root_id", root_id)
        if service_name is not None:
            pulumi.set(__self__, "service_name", service_name)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if status is not None:
            pulumi.set(__self__, "status", status)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if time_created is not None:
            pulumi.set(__self__, "time_created", time_created)
        if time_updated is not None:
            pulumi.set(__self__, "time_updated", time_updated)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="connectionCredentialDetails")
    def connection_credential_details(self) -> Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "connection_credential_details")

    @connection_credential_details.setter
    def connection_credential_details(self, value: Optional[pulumi.Input['DatabaseInsightConnectionCredentialDetailsArgs']]):
        pulumi.set(self, "connection_credential_details", value)

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']]:
        """
        Connection details of the private endpoints.
        """
        return pulumi.get(self, "connection_details")

    @connection_details.setter
    def connection_details(self, value: Optional[pulumi.Input['DatabaseInsightConnectionDetailsArgs']]):
        pulumi.set(self, "connection_details", value)

    @property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "credential_details")

    @credential_details.setter
    def credential_details(self, value: Optional[pulumi.Input['DatabaseInsightCredentialDetailsArgs']]):
        pulumi.set(self, "credential_details", value)

    @property
    @pulumi.getter(name="databaseConnectionStatusDetails")
    def database_connection_status_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        """
        return pulumi.get(self, "database_connection_status_details")

    @database_connection_status_details.setter
    def database_connection_status_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_connection_status_details", value)

    @property
    @pulumi.getter(name="databaseDisplayName")
    def database_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Display name of database
        """
        return pulumi.get(self, "database_display_name")

    @database_display_name.setter
    def database_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_display_name", value)

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @database_id.setter
    def database_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_id", value)

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of database
        """
        return pulumi.get(self, "database_name")

    @database_name.setter
    def database_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_name", value)

    @property
    @pulumi.getter(name="databaseResourceType")
    def database_resource_type(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle Cloud Infrastructure database resource type
        """
        return pulumi.get(self, "database_resource_type")

    @database_resource_type.setter
    def database_resource_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_resource_type", value)

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> Optional[pulumi.Input[str]]:
        """
        Operations Insights internal representation of the database type.
        """
        return pulumi.get(self, "database_type")

    @database_type.setter
    def database_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_type", value)

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the database.
        """
        return pulumi.get(self, "database_version")

    @database_version.setter
    def database_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "database_version", value)

    @property
    @pulumi.getter(name="dbmPrivateEndpointId")
    def dbm_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        """
        return pulumi.get(self, "dbm_private_endpoint_id")

    @dbm_private_endpoint_id.setter
    def dbm_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dbm_private_endpoint_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> Optional[pulumi.Input[str]]:
        """
        Database Deployment Type
        """
        return pulumi.get(self, "deployment_type")

    @deployment_type.setter
    def deployment_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deployment_type", value)

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> Optional[pulumi.Input[str]]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @enterprise_manager_bridge_id.setter
    def enterprise_manager_bridge_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_bridge_id", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @enterprise_manager_entity_display_name.setter
    def enterprise_manager_entity_display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_display_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @enterprise_manager_entity_identifier.setter
    def enterprise_manager_entity_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_identifier", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @enterprise_manager_entity_name.setter
    def enterprise_manager_entity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_name", value)

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @enterprise_manager_entity_type.setter
    def enterprise_manager_entity_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_entity_type", value)

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> Optional[pulumi.Input[str]]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @enterprise_manager_identifier.setter
    def enterprise_manager_identifier(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "enterprise_manager_identifier", value)

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @entity_source.setter
    def entity_source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entity_source", value)

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @exadata_insight_id.setter
    def exadata_insight_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "exadata_insight_id", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @opsi_private_endpoint_id.setter
    def opsi_private_endpoint_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "opsi_private_endpoint_id", value)

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster or DB System ID, depending on which configuration the resource belongs to.
        """
        return pulumi.get(self, "parent_id")

    @parent_id.setter
    def parent_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "parent_id", value)

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> Optional[pulumi.Input[int]]:
        """
        Processor count. This is the OCPU count for Autonomous Database and CPU core count for other database types.
        """
        return pulumi.get(self, "processor_count")

    @processor_count.setter
    def processor_count(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "processor_count", value)

    @property
    @pulumi.getter(name="rootId")
    def root_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Infrastructure.
        """
        return pulumi.get(self, "root_id")

    @root_id.setter
    def root_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "root_id", value)

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> Optional[pulumi.Input[str]]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @service_name.setter
    def service_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_name", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter
    def status(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "status")

    @status.setter
    def status(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "status", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time the the database insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time the database insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class DatabaseInsight(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionCredentialDetailsArgs']]] = None,
                 connection_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionDetailsArgs']]] = None,
                 credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightCredentialDetailsArgs']]] = None,
                 database_connection_status_details: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_resource_type: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Import

        DatabaseInsights can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/databaseInsight:DatabaseInsight test_database_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[pulumi.InputType['DatabaseInsightConnectionCredentialDetailsArgs']] connection_credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[pulumi.InputType['DatabaseInsightConnectionDetailsArgs']] connection_details: Connection details of the private endpoints.
        :param pulumi.Input[pulumi.InputType['DatabaseInsightCredentialDetailsArgs']] credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[str] database_connection_status_details: A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        :param pulumi.Input[str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[str] database_resource_type: Oracle Cloud Infrastructure database resource type
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_type: Database Deployment Type
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: (Updatable) Source of the database entity.
        :param pulumi.Input[str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: DatabaseInsightArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Import

        DatabaseInsights can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Opsi/databaseInsight:DatabaseInsight test_database_insight "id"
        ```

        :param str resource_name: The name of the resource.
        :param DatabaseInsightArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(DatabaseInsightArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 connection_credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionCredentialDetailsArgs']]] = None,
                 connection_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionDetailsArgs']]] = None,
                 credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightCredentialDetailsArgs']]] = None,
                 database_connection_status_details: Optional[pulumi.Input[str]] = None,
                 database_id: Optional[pulumi.Input[str]] = None,
                 database_resource_type: Optional[pulumi.Input[str]] = None,
                 dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 deployment_type: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
                 enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
                 entity_source: Optional[pulumi.Input[str]] = None,
                 exadata_insight_id: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
                 service_name: Optional[pulumi.Input[str]] = None,
                 status: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = DatabaseInsightArgs.__new__(DatabaseInsightArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["connection_credential_details"] = connection_credential_details
            __props__.__dict__["connection_details"] = connection_details
            __props__.__dict__["credential_details"] = credential_details
            __props__.__dict__["database_connection_status_details"] = database_connection_status_details
            __props__.__dict__["database_id"] = database_id
            __props__.__dict__["database_resource_type"] = database_resource_type
            __props__.__dict__["dbm_private_endpoint_id"] = dbm_private_endpoint_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["deployment_type"] = deployment_type
            __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
            __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
            __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
            if entity_source is None and not opts.urn:
                raise TypeError("Missing required property 'entity_source'")
            __props__.__dict__["entity_source"] = entity_source
            __props__.__dict__["exadata_insight_id"] = exadata_insight_id
            __props__.__dict__["freeform_tags"] = freeform_tags
            __props__.__dict__["opsi_private_endpoint_id"] = opsi_private_endpoint_id
            __props__.__dict__["service_name"] = service_name
            __props__.__dict__["status"] = status
            __props__.__dict__["database_display_name"] = None
            __props__.__dict__["database_name"] = None
            __props__.__dict__["database_type"] = None
            __props__.__dict__["database_version"] = None
            __props__.__dict__["enterprise_manager_entity_display_name"] = None
            __props__.__dict__["enterprise_manager_entity_name"] = None
            __props__.__dict__["enterprise_manager_entity_type"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["parent_id"] = None
            __props__.__dict__["processor_count"] = None
            __props__.__dict__["root_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(DatabaseInsight, __self__).__init__(
            'oci:Opsi/databaseInsight:DatabaseInsight',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            connection_credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionCredentialDetailsArgs']]] = None,
            connection_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightConnectionDetailsArgs']]] = None,
            credential_details: Optional[pulumi.Input[pulumi.InputType['DatabaseInsightCredentialDetailsArgs']]] = None,
            database_connection_status_details: Optional[pulumi.Input[str]] = None,
            database_display_name: Optional[pulumi.Input[str]] = None,
            database_id: Optional[pulumi.Input[str]] = None,
            database_name: Optional[pulumi.Input[str]] = None,
            database_resource_type: Optional[pulumi.Input[str]] = None,
            database_type: Optional[pulumi.Input[str]] = None,
            database_version: Optional[pulumi.Input[str]] = None,
            dbm_private_endpoint_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            deployment_type: Optional[pulumi.Input[str]] = None,
            enterprise_manager_bridge_id: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_display_name: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_identifier: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_name: Optional[pulumi.Input[str]] = None,
            enterprise_manager_entity_type: Optional[pulumi.Input[str]] = None,
            enterprise_manager_identifier: Optional[pulumi.Input[str]] = None,
            entity_source: Optional[pulumi.Input[str]] = None,
            exadata_insight_id: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            opsi_private_endpoint_id: Optional[pulumi.Input[str]] = None,
            parent_id: Optional[pulumi.Input[str]] = None,
            processor_count: Optional[pulumi.Input[int]] = None,
            root_id: Optional[pulumi.Input[str]] = None,
            service_name: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            status: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'DatabaseInsight':
        """
        Get an existing DatabaseInsight resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: (Updatable) Compartment Identifier of database
        :param pulumi.Input[pulumi.InputType['DatabaseInsightConnectionCredentialDetailsArgs']] connection_credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[pulumi.InputType['DatabaseInsightConnectionDetailsArgs']] connection_details: Connection details of the private endpoints.
        :param pulumi.Input[pulumi.InputType['DatabaseInsightCredentialDetailsArgs']] credential_details: User credential details to connect to the database. This is supplied via the External Database Service.
        :param pulumi.Input[str] database_connection_status_details: A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        :param pulumi.Input[str] database_display_name: Display name of database
        :param pulumi.Input[str] database_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        :param pulumi.Input[str] database_name: Name of database
        :param pulumi.Input[str] database_resource_type: Oracle Cloud Infrastructure database resource type
        :param pulumi.Input[str] database_type: Operations Insights internal representation of the database type.
        :param pulumi.Input[str] database_version: The version of the database.
        :param pulumi.Input[str] dbm_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        :param pulumi.Input[str] deployment_type: Database Deployment Type
        :param pulumi.Input[str] enterprise_manager_bridge_id: OPSI Enterprise Manager Bridge OCID
        :param pulumi.Input[str] enterprise_manager_entity_display_name: Enterprise Manager Entity Display Name
        :param pulumi.Input[str] enterprise_manager_entity_identifier: Enterprise Manager Entity Unique Identifier
        :param pulumi.Input[str] enterprise_manager_entity_name: Enterprise Manager Entity Name
        :param pulumi.Input[str] enterprise_manager_entity_type: Enterprise Manager Entity Type
        :param pulumi.Input[str] enterprise_manager_identifier: Enterprise Manager Unique Identifier
        :param pulumi.Input[str] entity_source: (Updatable) Source of the database entity.
        :param pulumi.Input[str] exadata_insight_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[str] opsi_private_endpoint_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        :param pulumi.Input[str] parent_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster or DB System ID, depending on which configuration the resource belongs to.
        :param pulumi.Input[int] processor_count: Processor count. This is the OCPU count for Autonomous Database and CPU core count for other database types.
        :param pulumi.Input[str] root_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Infrastructure.
        :param pulumi.Input[str] service_name: Database service name used for connection requests.
        :param pulumi.Input[str] state: The current state of the database.
        :param pulumi.Input[str] status: (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[str] time_created: The time the the database insight was first enabled. An RFC3339 formatted datetime string
        :param pulumi.Input[str] time_updated: The time the database insight was updated. An RFC3339 formatted datetime string
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _DatabaseInsightState.__new__(_DatabaseInsightState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["connection_credential_details"] = connection_credential_details
        __props__.__dict__["connection_details"] = connection_details
        __props__.__dict__["credential_details"] = credential_details
        __props__.__dict__["database_connection_status_details"] = database_connection_status_details
        __props__.__dict__["database_display_name"] = database_display_name
        __props__.__dict__["database_id"] = database_id
        __props__.__dict__["database_name"] = database_name
        __props__.__dict__["database_resource_type"] = database_resource_type
        __props__.__dict__["database_type"] = database_type
        __props__.__dict__["database_version"] = database_version
        __props__.__dict__["dbm_private_endpoint_id"] = dbm_private_endpoint_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["deployment_type"] = deployment_type
        __props__.__dict__["enterprise_manager_bridge_id"] = enterprise_manager_bridge_id
        __props__.__dict__["enterprise_manager_entity_display_name"] = enterprise_manager_entity_display_name
        __props__.__dict__["enterprise_manager_entity_identifier"] = enterprise_manager_entity_identifier
        __props__.__dict__["enterprise_manager_entity_name"] = enterprise_manager_entity_name
        __props__.__dict__["enterprise_manager_entity_type"] = enterprise_manager_entity_type
        __props__.__dict__["enterprise_manager_identifier"] = enterprise_manager_identifier
        __props__.__dict__["entity_source"] = entity_source
        __props__.__dict__["exadata_insight_id"] = exadata_insight_id
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["opsi_private_endpoint_id"] = opsi_private_endpoint_id
        __props__.__dict__["parent_id"] = parent_id
        __props__.__dict__["processor_count"] = processor_count
        __props__.__dict__["root_id"] = root_id
        __props__.__dict__["service_name"] = service_name
        __props__.__dict__["state"] = state
        __props__.__dict__["status"] = status
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return DatabaseInsight(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) Compartment Identifier of database
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="connectionCredentialDetails")
    def connection_credential_details(self) -> pulumi.Output['outputs.DatabaseInsightConnectionCredentialDetails']:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "connection_credential_details")

    @property
    @pulumi.getter(name="connectionDetails")
    def connection_details(self) -> pulumi.Output['outputs.DatabaseInsightConnectionDetails']:
        """
        Connection details of the private endpoints.
        """
        return pulumi.get(self, "connection_details")

    @property
    @pulumi.getter(name="credentialDetails")
    def credential_details(self) -> pulumi.Output[Optional['outputs.DatabaseInsightCredentialDetails']]:
        """
        User credential details to connect to the database. This is supplied via the External Database Service.
        """
        return pulumi.get(self, "credential_details")

    @property
    @pulumi.getter(name="databaseConnectionStatusDetails")
    def database_connection_status_details(self) -> pulumi.Output[str]:
        """
        A message describing the status of the database connection of this resource. For example, it can be used to provide actionable information about the permission and content validity of the database connection.
        """
        return pulumi.get(self, "database_connection_status_details")

    @property
    @pulumi.getter(name="databaseDisplayName")
    def database_display_name(self) -> pulumi.Output[str]:
        """
        Display name of database
        """
        return pulumi.get(self, "database_display_name")

    @property
    @pulumi.getter(name="databaseId")
    def database_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the database.
        """
        return pulumi.get(self, "database_id")

    @property
    @pulumi.getter(name="databaseName")
    def database_name(self) -> pulumi.Output[str]:
        """
        Name of database
        """
        return pulumi.get(self, "database_name")

    @property
    @pulumi.getter(name="databaseResourceType")
    def database_resource_type(self) -> pulumi.Output[str]:
        """
        Oracle Cloud Infrastructure database resource type
        """
        return pulumi.get(self, "database_resource_type")

    @property
    @pulumi.getter(name="databaseType")
    def database_type(self) -> pulumi.Output[str]:
        """
        Operations Insights internal representation of the database type.
        """
        return pulumi.get(self, "database_type")

    @property
    @pulumi.getter(name="databaseVersion")
    def database_version(self) -> pulumi.Output[str]:
        """
        The version of the database.
        """
        return pulumi.get(self, "database_version")

    @property
    @pulumi.getter(name="dbmPrivateEndpointId")
    def dbm_private_endpoint_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Database Management private endpoint. This field and opsi_private_endpoint_id are mutually exclusive. If DBM private endpoint ID is provided, a new OPSI private endpoint ID will be created.
        """
        return pulumi.get(self, "dbm_private_endpoint_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="deploymentType")
    def deployment_type(self) -> pulumi.Output[str]:
        """
        Database Deployment Type
        """
        return pulumi.get(self, "deployment_type")

    @property
    @pulumi.getter(name="enterpriseManagerBridgeId")
    def enterprise_manager_bridge_id(self) -> pulumi.Output[str]:
        """
        OPSI Enterprise Manager Bridge OCID
        """
        return pulumi.get(self, "enterprise_manager_bridge_id")

    @property
    @pulumi.getter(name="enterpriseManagerEntityDisplayName")
    def enterprise_manager_entity_display_name(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Display Name
        """
        return pulumi.get(self, "enterprise_manager_entity_display_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityIdentifier")
    def enterprise_manager_entity_identifier(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_entity_identifier")

    @property
    @pulumi.getter(name="enterpriseManagerEntityName")
    def enterprise_manager_entity_name(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Name
        """
        return pulumi.get(self, "enterprise_manager_entity_name")

    @property
    @pulumi.getter(name="enterpriseManagerEntityType")
    def enterprise_manager_entity_type(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Entity Type
        """
        return pulumi.get(self, "enterprise_manager_entity_type")

    @property
    @pulumi.getter(name="enterpriseManagerIdentifier")
    def enterprise_manager_identifier(self) -> pulumi.Output[str]:
        """
        Enterprise Manager Unique Identifier
        """
        return pulumi.get(self, "enterprise_manager_identifier")

    @property
    @pulumi.getter(name="entitySource")
    def entity_source(self) -> pulumi.Output[str]:
        """
        (Updatable) Source of the database entity.
        """
        return pulumi.get(self, "entity_source")

    @property
    @pulumi.getter(name="exadataInsightId")
    def exadata_insight_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata insight.
        """
        return pulumi.get(self, "exadata_insight_id")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="opsiPrivateEndpointId")
    def opsi_private_endpoint_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the OPSI private endpoint
        """
        return pulumi.get(self, "opsi_private_endpoint_id")

    @property
    @pulumi.getter(name="parentId")
    def parent_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the VM Cluster or DB System ID, depending on which configuration the resource belongs to.
        """
        return pulumi.get(self, "parent_id")

    @property
    @pulumi.getter(name="processorCount")
    def processor_count(self) -> pulumi.Output[int]:
        """
        Processor count. This is the OCPU count for Autonomous Database and CPU core count for other database types.
        """
        return pulumi.get(self, "processor_count")

    @property
    @pulumi.getter(name="rootId")
    def root_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Exadata Infrastructure.
        """
        return pulumi.get(self, "root_id")

    @property
    @pulumi.getter(name="serviceName")
    def service_name(self) -> pulumi.Output[str]:
        """
        Database service name used for connection requests.
        """
        return pulumi.get(self, "service_name")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the database.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def status(self) -> pulumi.Output[str]:
        """
        (Updatable) Status of the resource. Example: "ENABLED", "DISABLED". Resource can be either enabled or disabled by updating the value of status field to either "ENABLED" or "DISABLED"

        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values. The resource destruction here is basically a soft delete. User cannot create resource using the same EM managed bridge OCID. If resource is in enabled state during destruction, the resource will be disabled automatically before performing delete operation.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time the the database insight was first enabled. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time the database insight was updated. An RFC3339 formatted datetime string
        """
        return pulumi.get(self, "time_updated")

