# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'GetOpsiConfigurationConfigurationItemResult',
    'AwaitableGetOpsiConfigurationConfigurationItemResult',
    'get_opsi_configuration_configuration_item',
    'get_opsi_configuration_configuration_item_output',
]

@pulumi.output_type
class GetOpsiConfigurationConfigurationItemResult:
    """
    A collection of values returned by getOpsiConfigurationConfigurationItem.
    """
    def __init__(__self__, compartment_id=None, config_item_fields=None, config_items=None, config_items_applicable_contexts=None, id=None, name=None, opsi_config_type=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if config_item_fields and not isinstance(config_item_fields, list):
            raise TypeError("Expected argument 'config_item_fields' to be a list")
        pulumi.set(__self__, "config_item_fields", config_item_fields)
        if config_items and not isinstance(config_items, list):
            raise TypeError("Expected argument 'config_items' to be a list")
        pulumi.set(__self__, "config_items", config_items)
        if config_items_applicable_contexts and not isinstance(config_items_applicable_contexts, list):
            raise TypeError("Expected argument 'config_items_applicable_contexts' to be a list")
        pulumi.set(__self__, "config_items_applicable_contexts", config_items_applicable_contexts)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if opsi_config_type and not isinstance(opsi_config_type, str):
            raise TypeError("Expected argument 'opsi_config_type' to be a str")
        pulumi.set(__self__, "opsi_config_type", opsi_config_type)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="configItemFields")
    def config_item_fields(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "config_item_fields")

    @property
    @pulumi.getter(name="configItems")
    def config_items(self) -> Sequence['outputs.GetOpsiConfigurationConfigurationItemConfigItemResult']:
        """
        Array of configuration item summary objects.
        """
        return pulumi.get(self, "config_items")

    @property
    @pulumi.getter(name="configItemsApplicableContexts")
    def config_items_applicable_contexts(self) -> Optional[Sequence[str]]:
        return pulumi.get(self, "config_items_applicable_contexts")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        Name of configuration item.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="opsiConfigType")
    def opsi_config_type(self) -> str:
        """
        OPSI configuration type.
        """
        return pulumi.get(self, "opsi_config_type")


class AwaitableGetOpsiConfigurationConfigurationItemResult(GetOpsiConfigurationConfigurationItemResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetOpsiConfigurationConfigurationItemResult(
            compartment_id=self.compartment_id,
            config_item_fields=self.config_item_fields,
            config_items=self.config_items,
            config_items_applicable_contexts=self.config_items_applicable_contexts,
            id=self.id,
            name=self.name,
            opsi_config_type=self.opsi_config_type)


def get_opsi_configuration_configuration_item(compartment_id: Optional[str] = None,
                                              config_item_fields: Optional[Sequence[str]] = None,
                                              config_items_applicable_contexts: Optional[Sequence[str]] = None,
                                              name: Optional[str] = None,
                                              opsi_config_type: Optional[str] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetOpsiConfigurationConfigurationItemResult:
    """
    This data source provides details about a specific Opsi Configuration Configuration Item resource in Oracle Cloud Infrastructure Opsi service.

    Gets the applicable configuration items based on the query parameters specified. Configuration items for an opsiConfigType with respect to a compartmentId can be fetched.
    Values specified in configItemField param will determine what fields for each configuration items have to be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opsi_configuration_configuration_item = oci.Opsi.get_opsi_configuration_configuration_item(compartment_id=var["compartment_id"],
        config_item_fields=var["opsi_configuration_configuration_item_config_item_field"],
        config_items_applicable_contexts=var["opsi_configuration_configuration_item_config_items_applicable_context"],
        name=var["opsi_configuration_configuration_item_name"],
        opsi_config_type=var["opsi_configuration_configuration_item_opsi_config_type"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param Sequence[str] config_item_fields: Specifies the fields to return in a config item summary.
    :param Sequence[str] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
    :param str name: A filter to return only configuration items that match the entire name.
    :param str opsi_config_type: Filter to return configuration items based on configuration type of OPSI configuration.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['configItemFields'] = config_item_fields
    __args__['configItemsApplicableContexts'] = config_items_applicable_contexts
    __args__['name'] = name
    __args__['opsiConfigType'] = opsi_config_type
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Opsi/getOpsiConfigurationConfigurationItem:getOpsiConfigurationConfigurationItem', __args__, opts=opts, typ=GetOpsiConfigurationConfigurationItemResult).value

    return AwaitableGetOpsiConfigurationConfigurationItemResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        config_item_fields=pulumi.get(__ret__, 'config_item_fields'),
        config_items=pulumi.get(__ret__, 'config_items'),
        config_items_applicable_contexts=pulumi.get(__ret__, 'config_items_applicable_contexts'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'),
        opsi_config_type=pulumi.get(__ret__, 'opsi_config_type'))


@_utilities.lift_output_func(get_opsi_configuration_configuration_item)
def get_opsi_configuration_configuration_item_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                                     config_item_fields: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                     config_items_applicable_contexts: Optional[pulumi.Input[Optional[Sequence[str]]]] = None,
                                                     name: Optional[pulumi.Input[Optional[str]]] = None,
                                                     opsi_config_type: Optional[pulumi.Input[str]] = None,
                                                     opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetOpsiConfigurationConfigurationItemResult]:
    """
    This data source provides details about a specific Opsi Configuration Configuration Item resource in Oracle Cloud Infrastructure Opsi service.

    Gets the applicable configuration items based on the query parameters specified. Configuration items for an opsiConfigType with respect to a compartmentId can be fetched.
    Values specified in configItemField param will determine what fields for each configuration items have to be returned.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_opsi_configuration_configuration_item = oci.Opsi.get_opsi_configuration_configuration_item(compartment_id=var["compartment_id"],
        config_item_fields=var["opsi_configuration_configuration_item_config_item_field"],
        config_items_applicable_contexts=var["opsi_configuration_configuration_item_config_items_applicable_context"],
        name=var["opsi_configuration_configuration_item_name"],
        opsi_config_type=var["opsi_configuration_configuration_item_opsi_config_type"])
    ```


    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param Sequence[str] config_item_fields: Specifies the fields to return in a config item summary.
    :param Sequence[str] config_items_applicable_contexts: Returns the configuration items filtered by applicable contexts sent in this param. By default configuration items of all applicable contexts are returned.
    :param str name: A filter to return only configuration items that match the entire name.
    :param str opsi_config_type: Filter to return configuration items based on configuration type of OPSI configuration.
    """
    ...
