# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetSoftwareSourceStreamProfileResult',
    'AwaitableGetSoftwareSourceStreamProfileResult',
    'get_software_source_stream_profile',
    'get_software_source_stream_profile_output',
]

@pulumi.output_type
class GetSoftwareSourceStreamProfileResult:
    """
    A collection of values returned by getSoftwareSourceStreamProfile.
    """
    def __init__(__self__, compartment_id=None, filters=None, id=None, module_name=None, module_stream_profiles=None, profile_name=None, software_source_id=None, stream_name=None):
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if module_name and not isinstance(module_name, str):
            raise TypeError("Expected argument 'module_name' to be a str")
        pulumi.set(__self__, "module_name", module_name)
        if module_stream_profiles and not isinstance(module_stream_profiles, list):
            raise TypeError("Expected argument 'module_stream_profiles' to be a list")
        pulumi.set(__self__, "module_stream_profiles", module_stream_profiles)
        if profile_name and not isinstance(profile_name, str):
            raise TypeError("Expected argument 'profile_name' to be a str")
        pulumi.set(__self__, "profile_name", profile_name)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if stream_name and not isinstance(stream_name, str):
            raise TypeError("Expected argument 'stream_name' to be a str")
        pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetSoftwareSourceStreamProfileFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> Optional[str]:
        """
        The name of the module that contains the stream profile
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter(name="moduleStreamProfiles")
    def module_stream_profiles(self) -> Sequence['outputs.GetSoftwareSourceStreamProfileModuleStreamProfileResult']:
        """
        The list of module_stream_profiles.
        """
        return pulumi.get(self, "module_stream_profiles")

    @property
    @pulumi.getter(name="profileName")
    def profile_name(self) -> Optional[str]:
        """
        The name of the profile
        """
        return pulumi.get(self, "profile_name")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> Optional[str]:
        """
        The name of the stream that contains the profile
        """
        return pulumi.get(self, "stream_name")


class AwaitableGetSoftwareSourceStreamProfileResult(GetSoftwareSourceStreamProfileResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceStreamProfileResult(
            compartment_id=self.compartment_id,
            filters=self.filters,
            id=self.id,
            module_name=self.module_name,
            module_stream_profiles=self.module_stream_profiles,
            profile_name=self.profile_name,
            software_source_id=self.software_source_id,
            stream_name=self.stream_name)


def get_software_source_stream_profile(compartment_id: Optional[str] = None,
                                       filters: Optional[Sequence[pulumi.InputType['GetSoftwareSourceStreamProfileFilterArgs']]] = None,
                                       module_name: Optional[str] = None,
                                       profile_name: Optional[str] = None,
                                       software_source_id: Optional[str] = None,
                                       stream_name: Optional[str] = None,
                                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceStreamProfileResult:
    """
    This data source provides the list of Software Source Stream Profiles in Oracle Cloud Infrastructure OS Management service.

    Retrieve a list of module stream profiles from a software source.
    Filters may be applied to select a subset of module stream profiles
    based on the filter criteria.

    The "moduleName", "streamName", and "profileName" attributes combine
    to form a set of filters on the list of module stream profiles.  If
    a "moduleName" is provided, only profiles that belong to that module
    are returned.  If both a "moduleName" and "streamName" are given,
    only profiles belonging to that module stream are returned.  Finally,
    if all three are given then only the particular profile indicated
    by the triple is returned.  It is not valid to supply a "streamName"
    without a "moduleName".  It is also not valid to supply a "profileName"
    without a "streamName".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_stream_profiles = oci.OsManagement.get_software_source_stream_profile(software_source_id=var["software_source"]["id"],
        compartment_id=var["compartment_id"],
        module_name=var["software_source_module_name"],
        profile_name=var["software_source_module_stream_profile_name"],
        stream_name=var["software_source_module_stream_name"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources. This parameter is optional and in some cases may have no effect.
    :param str module_name: The name of a module.  This parameter is required if a streamName is specified.
    :param str profile_name: The name of the profile of the containing module stream
    :param str software_source_id: The OCID of the software source.
    :param str stream_name: The name of the stream of the containing module.  This parameter is required if a profileName is specified.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['filters'] = filters
    __args__['moduleName'] = module_name
    __args__['profileName'] = profile_name
    __args__['softwareSourceId'] = software_source_id
    __args__['streamName'] = stream_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagement/getSoftwareSourceStreamProfile:getSoftwareSourceStreamProfile', __args__, opts=opts, typ=GetSoftwareSourceStreamProfileResult).value

    return AwaitableGetSoftwareSourceStreamProfileResult(
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        module_name=pulumi.get(__ret__, 'module_name'),
        module_stream_profiles=pulumi.get(__ret__, 'module_stream_profiles'),
        profile_name=pulumi.get(__ret__, 'profile_name'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        stream_name=pulumi.get(__ret__, 'stream_name'))


@_utilities.lift_output_func(get_software_source_stream_profile)
def get_software_source_stream_profile_output(compartment_id: Optional[pulumi.Input[Optional[str]]] = None,
                                              filters: Optional[pulumi.Input[Optional[Sequence[pulumi.InputType['GetSoftwareSourceStreamProfileFilterArgs']]]]] = None,
                                              module_name: Optional[pulumi.Input[Optional[str]]] = None,
                                              profile_name: Optional[pulumi.Input[Optional[str]]] = None,
                                              software_source_id: Optional[pulumi.Input[str]] = None,
                                              stream_name: Optional[pulumi.Input[Optional[str]]] = None,
                                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwareSourceStreamProfileResult]:
    """
    This data source provides the list of Software Source Stream Profiles in Oracle Cloud Infrastructure OS Management service.

    Retrieve a list of module stream profiles from a software source.
    Filters may be applied to select a subset of module stream profiles
    based on the filter criteria.

    The "moduleName", "streamName", and "profileName" attributes combine
    to form a set of filters on the list of module stream profiles.  If
    a "moduleName" is provided, only profiles that belong to that module
    are returned.  If both a "moduleName" and "streamName" are given,
    only profiles belonging to that module stream are returned.  Finally,
    if all three are given then only the particular profile indicated
    by the triple is returned.  It is not valid to supply a "streamName"
    without a "moduleName".  It is also not valid to supply a "profileName"
    without a "streamName".

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_stream_profiles = oci.OsManagement.get_software_source_stream_profile(software_source_id=var["software_source"]["id"],
        compartment_id=var["compartment_id"],
        module_name=var["software_source_module_name"],
        profile_name=var["software_source_module_stream_profile_name"],
        stream_name=var["software_source_module_stream_name"])
    ```


    :param str compartment_id: The ID of the compartment in which to list resources. This parameter is optional and in some cases may have no effect.
    :param str module_name: The name of a module.  This parameter is required if a streamName is specified.
    :param str profile_name: The name of the profile of the containing module stream
    :param str software_source_id: The OCID of the software source.
    :param str stream_name: The name of the stream of the containing module.  This parameter is required if a profileName is specified.
    """
    ...
