# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetSoftwareSourceModuleStreamResult',
    'AwaitableGetSoftwareSourceModuleStreamResult',
    'get_software_source_module_stream',
    'get_software_source_module_stream_output',
]

@pulumi.output_type
class GetSoftwareSourceModuleStreamResult:
    """
    A collection of values returned by getSoftwareSourceModuleStream.
    """
    def __init__(__self__, arch_type=None, description=None, id=None, is_default=None, is_latest=None, module_name=None, name=None, packages=None, profiles=None, software_source_id=None, stream_name=None):
        if arch_type and not isinstance(arch_type, str):
            raise TypeError("Expected argument 'arch_type' to be a str")
        pulumi.set(__self__, "arch_type", arch_type)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if is_default and not isinstance(is_default, bool):
            raise TypeError("Expected argument 'is_default' to be a bool")
        pulumi.set(__self__, "is_default", is_default)
        if is_latest and not isinstance(is_latest, bool):
            raise TypeError("Expected argument 'is_latest' to be a bool")
        pulumi.set(__self__, "is_latest", is_latest)
        if module_name and not isinstance(module_name, str):
            raise TypeError("Expected argument 'module_name' to be a str")
        pulumi.set(__self__, "module_name", module_name)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if packages and not isinstance(packages, list):
            raise TypeError("Expected argument 'packages' to be a list")
        pulumi.set(__self__, "packages", packages)
        if profiles and not isinstance(profiles, list):
            raise TypeError("Expected argument 'profiles' to be a list")
        pulumi.set(__self__, "profiles", profiles)
        if software_source_id and not isinstance(software_source_id, str):
            raise TypeError("Expected argument 'software_source_id' to be a str")
        pulumi.set(__self__, "software_source_id", software_source_id)
        if stream_name and not isinstance(stream_name, str):
            raise TypeError("Expected argument 'stream_name' to be a str")
        pulumi.set(__self__, "stream_name", stream_name)

    @property
    @pulumi.getter(name="archType")
    def arch_type(self) -> str:
        """
        The architecture for which the packages in this module stream were built.
        """
        return pulumi.get(self, "arch_type")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        A description of the contents of the module stream.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isDefault")
    def is_default(self) -> bool:
        """
        Indicates if this stream is the default for its module.
        """
        return pulumi.get(self, "is_default")

    @property
    @pulumi.getter(name="isLatest")
    def is_latest(self) -> bool:
        """
        Indicates whether this module stream is the latest.
        """
        return pulumi.get(self, "is_latest")

    @property
    @pulumi.getter(name="moduleName")
    def module_name(self) -> str:
        """
        The name of the module that contains the stream.
        """
        return pulumi.get(self, "module_name")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the stream.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def packages(self) -> Sequence[str]:
        """
        A list of packages that are contained by the stream.  Each element in the list is the name of a package.  The name is suitable to use as an argument to other OS Management Hub APIs that interact directly with packages.
        """
        return pulumi.get(self, "packages")

    @property
    @pulumi.getter
    def profiles(self) -> Sequence[str]:
        """
        A list of profiles that are part of the stream.  Each element in the list is the name of a profile.  The name is suitable to use as an argument to other OS Management Hub APIs that interact directly with module stream profiles.  However, it is not URL encoded.
        """
        return pulumi.get(self, "profiles")

    @property
    @pulumi.getter(name="softwareSourceId")
    def software_source_id(self) -> str:
        """
        The OCID of the software source that provides this module stream.
        """
        return pulumi.get(self, "software_source_id")

    @property
    @pulumi.getter(name="streamName")
    def stream_name(self) -> str:
        return pulumi.get(self, "stream_name")


class AwaitableGetSoftwareSourceModuleStreamResult(GetSoftwareSourceModuleStreamResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetSoftwareSourceModuleStreamResult(
            arch_type=self.arch_type,
            description=self.description,
            id=self.id,
            is_default=self.is_default,
            is_latest=self.is_latest,
            module_name=self.module_name,
            name=self.name,
            packages=self.packages,
            profiles=self.profiles,
            software_source_id=self.software_source_id,
            stream_name=self.stream_name)


def get_software_source_module_stream(module_name: Optional[str] = None,
                                      software_source_id: Optional[str] = None,
                                      stream_name: Optional[str] = None,
                                      opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetSoftwareSourceModuleStreamResult:
    """
    This data source provides details about a specific Software Source Module Stream resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified module stream in a software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_module_stream = oci.OsManagementHub.get_software_source_module_stream(module_name=var["software_source_module_stream_module_name"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"],
        stream_name=oci_streaming_stream["test_stream"]["name"])
    ```


    :param str module_name: The name of the module.
    :param str software_source_id: The software source OCID.
    :param str stream_name: The name of the stream of the containing module.
    """
    __args__ = dict()
    __args__['moduleName'] = module_name
    __args__['softwareSourceId'] = software_source_id
    __args__['streamName'] = stream_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OsManagementHub/getSoftwareSourceModuleStream:getSoftwareSourceModuleStream', __args__, opts=opts, typ=GetSoftwareSourceModuleStreamResult).value

    return AwaitableGetSoftwareSourceModuleStreamResult(
        arch_type=pulumi.get(__ret__, 'arch_type'),
        description=pulumi.get(__ret__, 'description'),
        id=pulumi.get(__ret__, 'id'),
        is_default=pulumi.get(__ret__, 'is_default'),
        is_latest=pulumi.get(__ret__, 'is_latest'),
        module_name=pulumi.get(__ret__, 'module_name'),
        name=pulumi.get(__ret__, 'name'),
        packages=pulumi.get(__ret__, 'packages'),
        profiles=pulumi.get(__ret__, 'profiles'),
        software_source_id=pulumi.get(__ret__, 'software_source_id'),
        stream_name=pulumi.get(__ret__, 'stream_name'))


@_utilities.lift_output_func(get_software_source_module_stream)
def get_software_source_module_stream_output(module_name: Optional[pulumi.Input[str]] = None,
                                             software_source_id: Optional[pulumi.Input[str]] = None,
                                             stream_name: Optional[pulumi.Input[str]] = None,
                                             opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetSoftwareSourceModuleStreamResult]:
    """
    This data source provides details about a specific Software Source Module Stream resource in Oracle Cloud Infrastructure Os Management Hub service.

    Gets information about the specified module stream in a software source.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_software_source_module_stream = oci.OsManagementHub.get_software_source_module_stream(module_name=var["software_source_module_stream_module_name"],
        software_source_id=oci_os_management_hub_software_source["test_software_source"]["id"],
        stream_name=oci_streaming_stream["test_stream"]["name"])
    ```


    :param str module_name: The name of the module.
    :param str software_source_id: The software source OCID.
    :param str stream_name: The name of the stream of the containing module.
    """
    ...
