# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ManagementStationArgs', 'ManagementStation']

@pulumi.input_type
class ManagementStationArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 display_name: pulumi.Input[str],
                 hostname: pulumi.Input[str],
                 mirror: pulumi.Input['ManagementStationMirrorArgs'],
                 proxy: pulumi.Input['ManagementStationProxyArgs'],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None):
        """
        The set of arguments for constructing a ManagementStation resource.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the Management Station.
        :param pulumi.Input[str] display_name: (Updatable) Management Station name
        :param pulumi.Input[str] hostname: (Updatable) Name of the host
        :param pulumi.Input['ManagementStationMirrorArgs'] mirror: (Updatable) Information for creating a mirror configuration
        :param pulumi.Input['ManagementStationProxyArgs'] proxy: (Updatable) Information for creating a proxy configuration
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Details describing the Management Station config.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        pulumi.set(__self__, "compartment_id", compartment_id)
        pulumi.set(__self__, "display_name", display_name)
        pulumi.set(__self__, "hostname", hostname)
        pulumi.set(__self__, "mirror", mirror)
        pulumi.set(__self__, "proxy", proxy)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The OCID of the tenancy containing the Management Station.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Input[str]:
        """
        (Updatable) Management Station name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Input[str]:
        """
        (Updatable) Name of the host
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: pulumi.Input[str]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Input['ManagementStationMirrorArgs']:
        """
        (Updatable) Information for creating a mirror configuration
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: pulumi.Input['ManagementStationMirrorArgs']):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Input['ManagementStationProxyArgs']:
        """
        (Updatable) Information for creating a proxy configuration
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: pulumi.Input['ManagementStationProxyArgs']):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Details describing the Management Station config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)


@pulumi.input_type
class _ManagementStationState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 managed_instance_id: Optional[pulumi.Input[str]] = None,
                 mirror: Optional[pulumi.Input['ManagementStationMirrorArgs']] = None,
                 mirror_capacity: Optional[pulumi.Input[int]] = None,
                 mirror_sync_statuses: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]] = None,
                 overall_percentage: Optional[pulumi.Input[int]] = None,
                 overall_state: Optional[pulumi.Input[str]] = None,
                 profile_id: Optional[pulumi.Input[str]] = None,
                 proxy: Optional[pulumi.Input['ManagementStationProxyArgs']] = None,
                 scheduled_job_id: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 total_mirrors: Optional[pulumi.Input[int]] = None):
        """
        Input properties used for looking up and filtering ManagementStation resources.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the Management Station.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Details describing the Management Station config.
        :param pulumi.Input[str] display_name: (Updatable) Management Station name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: (Updatable) Name of the host
        :param pulumi.Input[str] managed_instance_id: OCID for the Instance associated with the Management Station.
        :param pulumi.Input['ManagementStationMirrorArgs'] mirror: (Updatable) Information for creating a mirror configuration
        :param pulumi.Input[int] mirror_capacity: A decimal number representing the mirror capacity
        :param pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]] mirror_sync_statuses: Status summary of all repos
        :param pulumi.Input[int] overall_percentage: A decimal number representing the completeness percentage
        :param pulumi.Input[str] overall_state: Current state of the mirroring
        :param pulumi.Input[str] profile_id: OCID of the Profile associated with the Station
        :param pulumi.Input['ManagementStationProxyArgs'] proxy: (Updatable) Information for creating a proxy configuration
        :param pulumi.Input[str] scheduled_job_id: OCID of the Scheduled Job for mirror sync
        :param pulumi.Input[str] state: The current state of the Management Station config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[int] total_mirrors: A decimal number representing the total of repos
        """
        if compartment_id is not None:
            pulumi.set(__self__, "compartment_id", compartment_id)
        if defined_tags is not None:
            pulumi.set(__self__, "defined_tags", defined_tags)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if display_name is not None:
            pulumi.set(__self__, "display_name", display_name)
        if freeform_tags is not None:
            pulumi.set(__self__, "freeform_tags", freeform_tags)
        if hostname is not None:
            pulumi.set(__self__, "hostname", hostname)
        if managed_instance_id is not None:
            pulumi.set(__self__, "managed_instance_id", managed_instance_id)
        if mirror is not None:
            pulumi.set(__self__, "mirror", mirror)
        if mirror_capacity is not None:
            pulumi.set(__self__, "mirror_capacity", mirror_capacity)
        if mirror_sync_statuses is not None:
            pulumi.set(__self__, "mirror_sync_statuses", mirror_sync_statuses)
        if overall_percentage is not None:
            pulumi.set(__self__, "overall_percentage", overall_percentage)
        if overall_state is not None:
            pulumi.set(__self__, "overall_state", overall_state)
        if profile_id is not None:
            pulumi.set(__self__, "profile_id", profile_id)
        if proxy is not None:
            pulumi.set(__self__, "proxy", proxy)
        if scheduled_job_id is not None:
            pulumi.set(__self__, "scheduled_job_id", scheduled_job_id)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if system_tags is not None:
            pulumi.set(__self__, "system_tags", system_tags)
        if total_mirrors is not None:
            pulumi.set(__self__, "total_mirrors", total_mirrors)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the tenancy containing the Management Station.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Details describing the Management Station config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Management Station name
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter
    def hostname(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Name of the host
        """
        return pulumi.get(self, "hostname")

    @hostname.setter
    def hostname(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "hostname", value)

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID for the Instance associated with the Management Station.
        """
        return pulumi.get(self, "managed_instance_id")

    @managed_instance_id.setter
    def managed_instance_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "managed_instance_id", value)

    @property
    @pulumi.getter
    def mirror(self) -> Optional[pulumi.Input['ManagementStationMirrorArgs']]:
        """
        (Updatable) Information for creating a mirror configuration
        """
        return pulumi.get(self, "mirror")

    @mirror.setter
    def mirror(self, value: Optional[pulumi.Input['ManagementStationMirrorArgs']]):
        pulumi.set(self, "mirror", value)

    @property
    @pulumi.getter(name="mirrorCapacity")
    def mirror_capacity(self) -> Optional[pulumi.Input[int]]:
        """
        A decimal number representing the mirror capacity
        """
        return pulumi.get(self, "mirror_capacity")

    @mirror_capacity.setter
    def mirror_capacity(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "mirror_capacity", value)

    @property
    @pulumi.getter(name="mirrorSyncStatuses")
    def mirror_sync_statuses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]]:
        """
        Status summary of all repos
        """
        return pulumi.get(self, "mirror_sync_statuses")

    @mirror_sync_statuses.setter
    def mirror_sync_statuses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ManagementStationMirrorSyncStatusArgs']]]]):
        pulumi.set(self, "mirror_sync_statuses", value)

    @property
    @pulumi.getter(name="overallPercentage")
    def overall_percentage(self) -> Optional[pulumi.Input[int]]:
        """
        A decimal number representing the completeness percentage
        """
        return pulumi.get(self, "overall_percentage")

    @overall_percentage.setter
    def overall_percentage(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "overall_percentage", value)

    @property
    @pulumi.getter(name="overallState")
    def overall_state(self) -> Optional[pulumi.Input[str]]:
        """
        Current state of the mirroring
        """
        return pulumi.get(self, "overall_state")

    @overall_state.setter
    def overall_state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "overall_state", value)

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Profile associated with the Station
        """
        return pulumi.get(self, "profile_id")

    @profile_id.setter
    def profile_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "profile_id", value)

    @property
    @pulumi.getter
    def proxy(self) -> Optional[pulumi.Input['ManagementStationProxyArgs']]:
        """
        (Updatable) Information for creating a proxy configuration
        """
        return pulumi.get(self, "proxy")

    @proxy.setter
    def proxy(self, value: Optional[pulumi.Input['ManagementStationProxyArgs']]):
        pulumi.set(self, "proxy", value)

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the Scheduled Job for mirror sync
        """
        return pulumi.get(self, "scheduled_job_id")

    @scheduled_job_id.setter
    def scheduled_job_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheduled_job_id", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the Management Station config.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @system_tags.setter
    def system_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "system_tags", value)

    @property
    @pulumi.getter(name="totalMirrors")
    def total_mirrors(self) -> Optional[pulumi.Input[int]]:
        """
        A decimal number representing the total of repos
        """
        return pulumi.get(self, "total_mirrors")

    @total_mirrors.setter
    def total_mirrors(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "total_mirrors", value)


class ManagementStation(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 mirror: Optional[pulumi.Input[pulumi.InputType['ManagementStationMirrorArgs']]] = None,
                 proxy: Optional[pulumi.Input[pulumi.InputType['ManagementStationProxyArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a management station.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station = oci.os_management_hub.ManagementStation("testManagementStation",
            compartment_id=var["compartment_id"],
            display_name=var["management_station_display_name"],
            hostname=var["management_station_hostname"],
            mirror=oci.os_management_hub.ManagementStationMirrorArgs(
                directory=var["management_station_mirror_directory"],
                port=var["management_station_mirror_port"],
                sslport=var["management_station_mirror_sslport"],
                sslcert=var["management_station_mirror_sslcert"],
            ),
            proxy=oci.os_management_hub.ManagementStationProxyArgs(
                is_enabled=var["management_station_proxy_is_enabled"],
                forward=var["management_station_proxy_forward"],
                hosts=var["management_station_proxy_hosts"],
                port=var["management_station_proxy_port"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["management_station_description"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ManagementStations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OsManagementHub/managementStation:ManagementStation test_management_station "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the Management Station.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Details describing the Management Station config.
        :param pulumi.Input[str] display_name: (Updatable) Management Station name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: (Updatable) Name of the host
        :param pulumi.Input[pulumi.InputType['ManagementStationMirrorArgs']] mirror: (Updatable) Information for creating a mirror configuration
        :param pulumi.Input[pulumi.InputType['ManagementStationProxyArgs']] proxy: (Updatable) Information for creating a proxy configuration
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ManagementStationArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Management Station resource in Oracle Cloud Infrastructure Os Management Hub service.

        Creates a management station.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_management_station = oci.os_management_hub.ManagementStation("testManagementStation",
            compartment_id=var["compartment_id"],
            display_name=var["management_station_display_name"],
            hostname=var["management_station_hostname"],
            mirror=oci.os_management_hub.ManagementStationMirrorArgs(
                directory=var["management_station_mirror_directory"],
                port=var["management_station_mirror_port"],
                sslport=var["management_station_mirror_sslport"],
                sslcert=var["management_station_mirror_sslcert"],
            ),
            proxy=oci.os_management_hub.ManagementStationProxyArgs(
                is_enabled=var["management_station_proxy_is_enabled"],
                forward=var["management_station_proxy_forward"],
                hosts=var["management_station_proxy_hosts"],
                port=var["management_station_proxy_port"],
            ),
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["management_station_description"],
            freeform_tags={
                "Department": "Finance",
            })
        ```

        ## Import

        ManagementStations can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:OsManagementHub/managementStation:ManagementStation test_management_station "id"
        ```

        :param str resource_name: The name of the resource.
        :param ManagementStationArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ManagementStationArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 hostname: Optional[pulumi.Input[str]] = None,
                 mirror: Optional[pulumi.Input[pulumi.InputType['ManagementStationMirrorArgs']]] = None,
                 proxy: Optional[pulumi.Input[pulumi.InputType['ManagementStationProxyArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ManagementStationArgs.__new__(ManagementStationArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            if display_name is None and not opts.urn:
                raise TypeError("Missing required property 'display_name'")
            __props__.__dict__["display_name"] = display_name
            __props__.__dict__["freeform_tags"] = freeform_tags
            if hostname is None and not opts.urn:
                raise TypeError("Missing required property 'hostname'")
            __props__.__dict__["hostname"] = hostname
            if mirror is None and not opts.urn:
                raise TypeError("Missing required property 'mirror'")
            __props__.__dict__["mirror"] = mirror
            if proxy is None and not opts.urn:
                raise TypeError("Missing required property 'proxy'")
            __props__.__dict__["proxy"] = proxy
            __props__.__dict__["managed_instance_id"] = None
            __props__.__dict__["mirror_capacity"] = None
            __props__.__dict__["mirror_sync_statuses"] = None
            __props__.__dict__["overall_percentage"] = None
            __props__.__dict__["overall_state"] = None
            __props__.__dict__["profile_id"] = None
            __props__.__dict__["scheduled_job_id"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["system_tags"] = None
            __props__.__dict__["total_mirrors"] = None
        super(ManagementStation, __self__).__init__(
            'oci:OsManagementHub/managementStation:ManagementStation',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            hostname: Optional[pulumi.Input[str]] = None,
            managed_instance_id: Optional[pulumi.Input[str]] = None,
            mirror: Optional[pulumi.Input[pulumi.InputType['ManagementStationMirrorArgs']]] = None,
            mirror_capacity: Optional[pulumi.Input[int]] = None,
            mirror_sync_statuses: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagementStationMirrorSyncStatusArgs']]]]] = None,
            overall_percentage: Optional[pulumi.Input[int]] = None,
            overall_state: Optional[pulumi.Input[str]] = None,
            profile_id: Optional[pulumi.Input[str]] = None,
            proxy: Optional[pulumi.Input[pulumi.InputType['ManagementStationProxyArgs']]] = None,
            scheduled_job_id: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            system_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            total_mirrors: Optional[pulumi.Input[int]] = None) -> 'ManagementStation':
        """
        Get an existing ManagementStation resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The OCID of the tenancy containing the Management Station.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Details describing the Management Station config.
        :param pulumi.Input[str] display_name: (Updatable) Management Station name
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] hostname: (Updatable) Name of the host
        :param pulumi.Input[str] managed_instance_id: OCID for the Instance associated with the Management Station.
        :param pulumi.Input[pulumi.InputType['ManagementStationMirrorArgs']] mirror: (Updatable) Information for creating a mirror configuration
        :param pulumi.Input[int] mirror_capacity: A decimal number representing the mirror capacity
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ManagementStationMirrorSyncStatusArgs']]]] mirror_sync_statuses: Status summary of all repos
        :param pulumi.Input[int] overall_percentage: A decimal number representing the completeness percentage
        :param pulumi.Input[str] overall_state: Current state of the mirroring
        :param pulumi.Input[str] profile_id: OCID of the Profile associated with the Station
        :param pulumi.Input[pulumi.InputType['ManagementStationProxyArgs']] proxy: (Updatable) Information for creating a proxy configuration
        :param pulumi.Input[str] scheduled_job_id: OCID of the Scheduled Job for mirror sync
        :param pulumi.Input[str] state: The current state of the Management Station config.
        :param pulumi.Input[Mapping[str, Any]] system_tags: System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param pulumi.Input[int] total_mirrors: A decimal number representing the total of repos
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ManagementStationState.__new__(_ManagementStationState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["hostname"] = hostname
        __props__.__dict__["managed_instance_id"] = managed_instance_id
        __props__.__dict__["mirror"] = mirror
        __props__.__dict__["mirror_capacity"] = mirror_capacity
        __props__.__dict__["mirror_sync_statuses"] = mirror_sync_statuses
        __props__.__dict__["overall_percentage"] = overall_percentage
        __props__.__dict__["overall_state"] = overall_state
        __props__.__dict__["profile_id"] = profile_id
        __props__.__dict__["proxy"] = proxy
        __props__.__dict__["scheduled_job_id"] = scheduled_job_id
        __props__.__dict__["state"] = state
        __props__.__dict__["system_tags"] = system_tags
        __props__.__dict__["total_mirrors"] = total_mirrors
        return ManagementStation(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The OCID of the tenancy containing the Management Station.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Details describing the Management Station config.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) Management Station name
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def hostname(self) -> pulumi.Output[str]:
        """
        (Updatable) Name of the host
        """
        return pulumi.get(self, "hostname")

    @property
    @pulumi.getter(name="managedInstanceId")
    def managed_instance_id(self) -> pulumi.Output[str]:
        """
        OCID for the Instance associated with the Management Station.
        """
        return pulumi.get(self, "managed_instance_id")

    @property
    @pulumi.getter
    def mirror(self) -> pulumi.Output['outputs.ManagementStationMirror']:
        """
        (Updatable) Information for creating a mirror configuration
        """
        return pulumi.get(self, "mirror")

    @property
    @pulumi.getter(name="mirrorCapacity")
    def mirror_capacity(self) -> pulumi.Output[int]:
        """
        A decimal number representing the mirror capacity
        """
        return pulumi.get(self, "mirror_capacity")

    @property
    @pulumi.getter(name="mirrorSyncStatuses")
    def mirror_sync_statuses(self) -> pulumi.Output[Sequence['outputs.ManagementStationMirrorSyncStatus']]:
        """
        Status summary of all repos
        """
        return pulumi.get(self, "mirror_sync_statuses")

    @property
    @pulumi.getter(name="overallPercentage")
    def overall_percentage(self) -> pulumi.Output[int]:
        """
        A decimal number representing the completeness percentage
        """
        return pulumi.get(self, "overall_percentage")

    @property
    @pulumi.getter(name="overallState")
    def overall_state(self) -> pulumi.Output[str]:
        """
        Current state of the mirroring
        """
        return pulumi.get(self, "overall_state")

    @property
    @pulumi.getter(name="profileId")
    def profile_id(self) -> pulumi.Output[str]:
        """
        OCID of the Profile associated with the Station
        """
        return pulumi.get(self, "profile_id")

    @property
    @pulumi.getter
    def proxy(self) -> pulumi.Output['outputs.ManagementStationProxy']:
        """
        (Updatable) Information for creating a proxy configuration
        """
        return pulumi.get(self, "proxy")

    @property
    @pulumi.getter(name="scheduledJobId")
    def scheduled_job_id(self) -> pulumi.Output[str]:
        """
        OCID of the Scheduled Job for mirror sync
        """
        return pulumi.get(self, "scheduled_job_id")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the Management Station config.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="totalMirrors")
    def total_mirrors(self) -> pulumi.Output[int]:
        """
        A decimal number representing the total of repos
        """
        return pulumi.get(self, "total_mirrors")

