# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetAddressResult',
    'AwaitableGetAddressResult',
    'get_address',
    'get_address_output',
]

@pulumi.output_type
class GetAddressResult:
    """
    A collection of values returned by getAddress.
    """
    def __init__(__self__, address_id=None, address_key=None, city=None, company_name=None, compartment_id=None, contributor_class=None, country=None, county=None, department_name=None, email_address=None, first_name=None, id=None, internal_number=None, job_title=None, last_name=None, line1=None, line2=None, line3=None, line4=None, middle_name=None, municipal_inscription=None, osp_home_region=None, phone_country_code=None, phone_number=None, postal_code=None, province=None, state=None, state_inscription=None, street_name=None, street_number=None):
        if address_id and not isinstance(address_id, str):
            raise TypeError("Expected argument 'address_id' to be a str")
        pulumi.set(__self__, "address_id", address_id)
        if address_key and not isinstance(address_key, str):
            raise TypeError("Expected argument 'address_key' to be a str")
        pulumi.set(__self__, "address_key", address_key)
        if city and not isinstance(city, str):
            raise TypeError("Expected argument 'city' to be a str")
        pulumi.set(__self__, "city", city)
        if company_name and not isinstance(company_name, str):
            raise TypeError("Expected argument 'company_name' to be a str")
        pulumi.set(__self__, "company_name", company_name)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if contributor_class and not isinstance(contributor_class, str):
            raise TypeError("Expected argument 'contributor_class' to be a str")
        pulumi.set(__self__, "contributor_class", contributor_class)
        if country and not isinstance(country, str):
            raise TypeError("Expected argument 'country' to be a str")
        pulumi.set(__self__, "country", country)
        if county and not isinstance(county, str):
            raise TypeError("Expected argument 'county' to be a str")
        pulumi.set(__self__, "county", county)
        if department_name and not isinstance(department_name, str):
            raise TypeError("Expected argument 'department_name' to be a str")
        pulumi.set(__self__, "department_name", department_name)
        if email_address and not isinstance(email_address, str):
            raise TypeError("Expected argument 'email_address' to be a str")
        pulumi.set(__self__, "email_address", email_address)
        if first_name and not isinstance(first_name, str):
            raise TypeError("Expected argument 'first_name' to be a str")
        pulumi.set(__self__, "first_name", first_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if internal_number and not isinstance(internal_number, str):
            raise TypeError("Expected argument 'internal_number' to be a str")
        pulumi.set(__self__, "internal_number", internal_number)
        if job_title and not isinstance(job_title, str):
            raise TypeError("Expected argument 'job_title' to be a str")
        pulumi.set(__self__, "job_title", job_title)
        if last_name and not isinstance(last_name, str):
            raise TypeError("Expected argument 'last_name' to be a str")
        pulumi.set(__self__, "last_name", last_name)
        if line1 and not isinstance(line1, str):
            raise TypeError("Expected argument 'line1' to be a str")
        pulumi.set(__self__, "line1", line1)
        if line2 and not isinstance(line2, str):
            raise TypeError("Expected argument 'line2' to be a str")
        pulumi.set(__self__, "line2", line2)
        if line3 and not isinstance(line3, str):
            raise TypeError("Expected argument 'line3' to be a str")
        pulumi.set(__self__, "line3", line3)
        if line4 and not isinstance(line4, str):
            raise TypeError("Expected argument 'line4' to be a str")
        pulumi.set(__self__, "line4", line4)
        if middle_name and not isinstance(middle_name, str):
            raise TypeError("Expected argument 'middle_name' to be a str")
        pulumi.set(__self__, "middle_name", middle_name)
        if municipal_inscription and not isinstance(municipal_inscription, str):
            raise TypeError("Expected argument 'municipal_inscription' to be a str")
        pulumi.set(__self__, "municipal_inscription", municipal_inscription)
        if osp_home_region and not isinstance(osp_home_region, str):
            raise TypeError("Expected argument 'osp_home_region' to be a str")
        pulumi.set(__self__, "osp_home_region", osp_home_region)
        if phone_country_code and not isinstance(phone_country_code, str):
            raise TypeError("Expected argument 'phone_country_code' to be a str")
        pulumi.set(__self__, "phone_country_code", phone_country_code)
        if phone_number and not isinstance(phone_number, str):
            raise TypeError("Expected argument 'phone_number' to be a str")
        pulumi.set(__self__, "phone_number", phone_number)
        if postal_code and not isinstance(postal_code, str):
            raise TypeError("Expected argument 'postal_code' to be a str")
        pulumi.set(__self__, "postal_code", postal_code)
        if province and not isinstance(province, str):
            raise TypeError("Expected argument 'province' to be a str")
        pulumi.set(__self__, "province", province)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if state_inscription and not isinstance(state_inscription, str):
            raise TypeError("Expected argument 'state_inscription' to be a str")
        pulumi.set(__self__, "state_inscription", state_inscription)
        if street_name and not isinstance(street_name, str):
            raise TypeError("Expected argument 'street_name' to be a str")
        pulumi.set(__self__, "street_name", street_name)
        if street_number and not isinstance(street_number, str):
            raise TypeError("Expected argument 'street_number' to be a str")
        pulumi.set(__self__, "street_number", street_number)

    @property
    @pulumi.getter(name="addressId")
    def address_id(self) -> str:
        return pulumi.get(self, "address_id")

    @property
    @pulumi.getter(name="addressKey")
    def address_key(self) -> str:
        """
        Address identifier.
        """
        return pulumi.get(self, "address_key")

    @property
    @pulumi.getter
    def city(self) -> str:
        """
        Name of the city.
        """
        return pulumi.get(self, "city")

    @property
    @pulumi.getter(name="companyName")
    def company_name(self) -> str:
        """
        Name of the customer company.
        """
        return pulumi.get(self, "company_name")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="contributorClass")
    def contributor_class(self) -> str:
        """
        Contributor class of the customer company.
        """
        return pulumi.get(self, "contributor_class")

    @property
    @pulumi.getter
    def country(self) -> str:
        """
        Country of the address.
        """
        return pulumi.get(self, "country")

    @property
    @pulumi.getter
    def county(self) -> str:
        """
        County of the address.
        """
        return pulumi.get(self, "county")

    @property
    @pulumi.getter(name="departmentName")
    def department_name(self) -> str:
        """
        Department name of the customer company.
        """
        return pulumi.get(self, "department_name")

    @property
    @pulumi.getter(name="emailAddress")
    def email_address(self) -> str:
        """
        Contact person email address.
        """
        return pulumi.get(self, "email_address")

    @property
    @pulumi.getter(name="firstName")
    def first_name(self) -> str:
        """
        First name of the contact person.
        """
        return pulumi.get(self, "first_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="internalNumber")
    def internal_number(self) -> str:
        """
        Internal number of the customer company.
        """
        return pulumi.get(self, "internal_number")

    @property
    @pulumi.getter(name="jobTitle")
    def job_title(self) -> str:
        """
        Job title of the contact person.
        """
        return pulumi.get(self, "job_title")

    @property
    @pulumi.getter(name="lastName")
    def last_name(self) -> str:
        """
        Last name of the contact person.
        """
        return pulumi.get(self, "last_name")

    @property
    @pulumi.getter
    def line1(self) -> str:
        """
        Address line 1.
        """
        return pulumi.get(self, "line1")

    @property
    @pulumi.getter
    def line2(self) -> str:
        """
        Address line 2.
        """
        return pulumi.get(self, "line2")

    @property
    @pulumi.getter
    def line3(self) -> str:
        """
        Address line 3.
        """
        return pulumi.get(self, "line3")

    @property
    @pulumi.getter
    def line4(self) -> str:
        """
        Address line 4.
        """
        return pulumi.get(self, "line4")

    @property
    @pulumi.getter(name="middleName")
    def middle_name(self) -> str:
        """
        Middle name of the contact person.
        """
        return pulumi.get(self, "middle_name")

    @property
    @pulumi.getter(name="municipalInscription")
    def municipal_inscription(self) -> str:
        """
        Municipal Inscription.
        """
        return pulumi.get(self, "municipal_inscription")

    @property
    @pulumi.getter(name="ospHomeRegion")
    def osp_home_region(self) -> str:
        return pulumi.get(self, "osp_home_region")

    @property
    @pulumi.getter(name="phoneCountryCode")
    def phone_country_code(self) -> str:
        """
        Phone country code of the contact person.
        """
        return pulumi.get(self, "phone_country_code")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Phone number of the contact person.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> str:
        """
        Post code of the address.
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def province(self) -> str:
        """
        Province of the address.
        """
        return pulumi.get(self, "province")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        State of the address.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateInscription")
    def state_inscription(self) -> str:
        """
        State Inscription.
        """
        return pulumi.get(self, "state_inscription")

    @property
    @pulumi.getter(name="streetName")
    def street_name(self) -> str:
        """
        Street name of the address.
        """
        return pulumi.get(self, "street_name")

    @property
    @pulumi.getter(name="streetNumber")
    def street_number(self) -> str:
        """
        Street number of the address.
        """
        return pulumi.get(self, "street_number")


class AwaitableGetAddressResult(GetAddressResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAddressResult(
            address_id=self.address_id,
            address_key=self.address_key,
            city=self.city,
            company_name=self.company_name,
            compartment_id=self.compartment_id,
            contributor_class=self.contributor_class,
            country=self.country,
            county=self.county,
            department_name=self.department_name,
            email_address=self.email_address,
            first_name=self.first_name,
            id=self.id,
            internal_number=self.internal_number,
            job_title=self.job_title,
            last_name=self.last_name,
            line1=self.line1,
            line2=self.line2,
            line3=self.line3,
            line4=self.line4,
            middle_name=self.middle_name,
            municipal_inscription=self.municipal_inscription,
            osp_home_region=self.osp_home_region,
            phone_country_code=self.phone_country_code,
            phone_number=self.phone_number,
            postal_code=self.postal_code,
            province=self.province,
            state=self.state,
            state_inscription=self.state_inscription,
            street_name=self.street_name,
            street_number=self.street_number)


def get_address(address_id: Optional[str] = None,
                compartment_id: Optional[str] = None,
                osp_home_region: Optional[str] = None,
                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAddressResult:
    """
    This data source provides details about a specific Address resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the address by id for the compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_address = oci.OspGateway.get_address(address_id=oci_osp_gateway_addres["test_addres"]["id"],
        compartment_id=var["compartment_id"],
        osp_home_region=var["address_osp_home_region"])
    ```


    :param str address_id: The identifier of the address.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    __args__ = dict()
    __args__['addressId'] = address_id
    __args__['compartmentId'] = compartment_id
    __args__['ospHomeRegion'] = osp_home_region
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:OspGateway/getAddress:getAddress', __args__, opts=opts, typ=GetAddressResult).value

    return AwaitableGetAddressResult(
        address_id=pulumi.get(__ret__, 'address_id'),
        address_key=pulumi.get(__ret__, 'address_key'),
        city=pulumi.get(__ret__, 'city'),
        company_name=pulumi.get(__ret__, 'company_name'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        contributor_class=pulumi.get(__ret__, 'contributor_class'),
        country=pulumi.get(__ret__, 'country'),
        county=pulumi.get(__ret__, 'county'),
        department_name=pulumi.get(__ret__, 'department_name'),
        email_address=pulumi.get(__ret__, 'email_address'),
        first_name=pulumi.get(__ret__, 'first_name'),
        id=pulumi.get(__ret__, 'id'),
        internal_number=pulumi.get(__ret__, 'internal_number'),
        job_title=pulumi.get(__ret__, 'job_title'),
        last_name=pulumi.get(__ret__, 'last_name'),
        line1=pulumi.get(__ret__, 'line1'),
        line2=pulumi.get(__ret__, 'line2'),
        line3=pulumi.get(__ret__, 'line3'),
        line4=pulumi.get(__ret__, 'line4'),
        middle_name=pulumi.get(__ret__, 'middle_name'),
        municipal_inscription=pulumi.get(__ret__, 'municipal_inscription'),
        osp_home_region=pulumi.get(__ret__, 'osp_home_region'),
        phone_country_code=pulumi.get(__ret__, 'phone_country_code'),
        phone_number=pulumi.get(__ret__, 'phone_number'),
        postal_code=pulumi.get(__ret__, 'postal_code'),
        province=pulumi.get(__ret__, 'province'),
        state=pulumi.get(__ret__, 'state'),
        state_inscription=pulumi.get(__ret__, 'state_inscription'),
        street_name=pulumi.get(__ret__, 'street_name'),
        street_number=pulumi.get(__ret__, 'street_number'))


@_utilities.lift_output_func(get_address)
def get_address_output(address_id: Optional[pulumi.Input[str]] = None,
                       compartment_id: Optional[pulumi.Input[str]] = None,
                       osp_home_region: Optional[pulumi.Input[str]] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAddressResult]:
    """
    This data source provides details about a specific Address resource in Oracle Cloud Infrastructure Osp Gateway service.

    Get the address by id for the compartment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_address = oci.OspGateway.get_address(address_id=oci_osp_gateway_addres["test_addres"]["id"],
        compartment_id=var["compartment_id"],
        osp_home_region=var["address_osp_home_region"])
    ```


    :param str address_id: The identifier of the address.
    :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
    :param str osp_home_region: The home region's public name of the logged in user.
    """
    ...
