# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = [
    'GetProtectedDatabaseFetchConfigurationResult',
    'AwaitableGetProtectedDatabaseFetchConfigurationResult',
    'get_protected_database_fetch_configuration',
    'get_protected_database_fetch_configuration_output',
]

@pulumi.output_type
class GetProtectedDatabaseFetchConfigurationResult:
    """
    A collection of values returned by getProtectedDatabaseFetchConfiguration.
    """
    def __init__(__self__, base64_encode_content=None, configuration_type=None, content=None, id=None, protected_database_id=None):
        if base64_encode_content and not isinstance(base64_encode_content, bool):
            raise TypeError("Expected argument 'base64_encode_content' to be a bool")
        pulumi.set(__self__, "base64_encode_content", base64_encode_content)
        if configuration_type and not isinstance(configuration_type, str):
            raise TypeError("Expected argument 'configuration_type' to be a str")
        pulumi.set(__self__, "configuration_type", configuration_type)
        if content and not isinstance(content, str):
            raise TypeError("Expected argument 'content' to be a str")
        pulumi.set(__self__, "content", content)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if protected_database_id and not isinstance(protected_database_id, str):
            raise TypeError("Expected argument 'protected_database_id' to be a str")
        pulumi.set(__self__, "protected_database_id", protected_database_id)

    @property
    @pulumi.getter(name="base64EncodeContent")
    def base64_encode_content(self) -> Optional[bool]:
        return pulumi.get(self, "base64_encode_content")

    @property
    @pulumi.getter(name="configurationType")
    def configuration_type(self) -> Optional[str]:
        return pulumi.get(self, "configuration_type")

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        content of the downloaded config file for recovery service. It is base64 encoded by default. To store the config in plaintext set `base_64_encode_content` to false.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="protectedDatabaseId")
    def protected_database_id(self) -> str:
        return pulumi.get(self, "protected_database_id")


class AwaitableGetProtectedDatabaseFetchConfigurationResult(GetProtectedDatabaseFetchConfigurationResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetProtectedDatabaseFetchConfigurationResult(
            base64_encode_content=self.base64_encode_content,
            configuration_type=self.configuration_type,
            content=self.content,
            id=self.id,
            protected_database_id=self.protected_database_id)


def get_protected_database_fetch_configuration(base64_encode_content: Optional[bool] = None,
                                               configuration_type: Optional[str] = None,
                                               protected_database_id: Optional[str] = None,
                                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetProtectedDatabaseFetchConfigurationResult:
    """
    This data source provides details about a specific Protected Database Fetch Configuration resource in Oracle Cloud Infrastructure Recovery service.

    Downloads the network service configuration file 'tnsnames.ora' for a specified protected database. Applies to user-defined recovery systems only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_database_fetch_configuration = oci.RecoveryMod.get_protected_database_fetch_configuration(protected_database_id=oci_recovery_protected_database["test_protected_database"]["id"],
        base64_encode_content=True,
        configuration_type=var["protected_database_fetch_configuration_configuration_type"])
    ```


    :param str configuration_type: Currently has four config options ALL, TNSNAMES, HOSTS and CABUNDLE. All will return a zipped folder containing the contents of both tnsnames and the certificateChainPem.
    :param str protected_database_id: The protected database OCID.
    """
    __args__ = dict()
    __args__['base64EncodeContent'] = base64_encode_content
    __args__['configurationType'] = configuration_type
    __args__['protectedDatabaseId'] = protected_database_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:RecoveryMod/getProtectedDatabaseFetchConfiguration:getProtectedDatabaseFetchConfiguration', __args__, opts=opts, typ=GetProtectedDatabaseFetchConfigurationResult).value

    return AwaitableGetProtectedDatabaseFetchConfigurationResult(
        base64_encode_content=pulumi.get(__ret__, 'base64_encode_content'),
        configuration_type=pulumi.get(__ret__, 'configuration_type'),
        content=pulumi.get(__ret__, 'content'),
        id=pulumi.get(__ret__, 'id'),
        protected_database_id=pulumi.get(__ret__, 'protected_database_id'))


@_utilities.lift_output_func(get_protected_database_fetch_configuration)
def get_protected_database_fetch_configuration_output(base64_encode_content: Optional[pulumi.Input[Optional[bool]]] = None,
                                                      configuration_type: Optional[pulumi.Input[Optional[str]]] = None,
                                                      protected_database_id: Optional[pulumi.Input[str]] = None,
                                                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetProtectedDatabaseFetchConfigurationResult]:
    """
    This data source provides details about a specific Protected Database Fetch Configuration resource in Oracle Cloud Infrastructure Recovery service.

    Downloads the network service configuration file 'tnsnames.ora' for a specified protected database. Applies to user-defined recovery systems only.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_protected_database_fetch_configuration = oci.RecoveryMod.get_protected_database_fetch_configuration(protected_database_id=oci_recovery_protected_database["test_protected_database"]["id"],
        base64_encode_content=True,
        configuration_type=var["protected_database_fetch_configuration_configuration_type"])
    ```


    :param str configuration_type: Currently has four config options ALL, TNSNAMES, HOSTS and CABUNDLE. All will return a zipped folder containing the contents of both tnsnames and the certificateChainPem.
    :param str protected_database_id: The protected database OCID.
    """
    ...
