"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from enum import Enum
import httpx
from mollie.models import ClientError
from mollie.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
from mollie.utils import FieldMetadata, PathParamMetadata, QueryParamMetadata
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class QueryParamGrouping(str, Enum):
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped
    by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where
    available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by
    transaction type, then by status, and then again by other sub-groupings where available.
    """

    STATUS_BALANCES = "status-balances"
    TRANSACTION_CATEGORIES = "transaction-categories"


class GetBalanceReportRequestTypedDict(TypedDict):
    balance_id: str
    r"""Provide the ID of the related balance."""
    from_: str
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is
    'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will
    include transactions from 2024-01-01 0:00:00 CET and onwards.
    """
    until: str
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include transactions up until
    2024-01-31 23:59:59 CET.
    """
    grouping: NotRequired[Nullable[QueryParamGrouping]]
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped
    by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where
    available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by
    transaction type, then by status, and then again by other sub-groupings where available.
    """
    testmode: NotRequired[Nullable[bool]]
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """


class GetBalanceReportRequest(BaseModel):
    balance_id: Annotated[
        str,
        pydantic.Field(alias="balanceId"),
        FieldMetadata(path=PathParamMetadata(style="simple", explode=False)),
    ]
    r"""Provide the ID of the related balance."""

    from_: Annotated[
        str,
        pydantic.Field(alias="from"),
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is
    'inclusive', and in Central European Time. This means a report with for example `from=2024-01-01` will
    include transactions from 2024-01-01 0:00:00 CET and onwards.
    """

    until: Annotated[
        str, FieldMetadata(query=QueryParamMetadata(style="form", explode=True))
    ]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include transactions up until
    2024-01-31 23:59:59 CET.
    """

    grouping: Annotated[
        OptionalNullable[QueryParamGrouping],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped
    by status (e.g. `pending`, `available`), then by transaction type, and then by other sub-groupings where
    available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by
    transaction type, then by status, and then again by other sub-groupings where available.
    """

    testmode: Annotated[
        OptionalNullable[bool],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = UNSET
    r"""Most API credentials are specifically created for either live mode or test mode. In those cases the `testmode` query
    parameter can be omitted. For organization-level credentials such as OAuth access tokens, you can enable test mode by
    setting the `testmode` query parameter to `true`.

    Test entities cannot be retrieved when the endpoint is set to live mode, and vice versa.
    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["grouping", "testmode"]
        nullable_fields = ["grouping", "testmode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportUnprocessableEntityDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetBalanceReportUnprocessableEntityDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetBalanceReportUnprocessableEntityLinksTypedDict(TypedDict):
    documentation: GetBalanceReportUnprocessableEntityDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportUnprocessableEntityLinks(BaseModel):
    documentation: GetBalanceReportUnprocessableEntityDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportUnprocessableEntityHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[
        GetBalanceReportUnprocessableEntityLinks, pydantic.Field(alias="_links")
    ]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetBalanceReportUnprocessableEntityHalJSONError(ClientError):
    r"""An error response object."""

    data: GetBalanceReportUnprocessableEntityHalJSONErrorData

    def __init__(
        self,
        data: GetBalanceReportUnprocessableEntityHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GetBalanceReportNotFoundDocumentationTypedDict(TypedDict):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str
    type: str


class GetBalanceReportNotFoundDocumentation(BaseModel):
    r"""The URL to the generic Mollie API error handling guide."""

    href: str

    type: str


class GetBalanceReportNotFoundLinksTypedDict(TypedDict):
    documentation: GetBalanceReportNotFoundDocumentationTypedDict
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportNotFoundLinks(BaseModel):
    documentation: GetBalanceReportNotFoundDocumentation
    r"""The URL to the generic Mollie API error handling guide."""


class GetBalanceReportNotFoundHalJSONErrorData(BaseModel):
    status: int
    r"""The status code of the error message. This is always the same code as the status code of the HTTP message itself."""

    title: str
    r"""The HTTP reason phrase of the error. For example, for a `404` error, the `title` will be `Not Found`."""

    detail: str
    r"""A detailed human-readable description of the error that occurred."""

    links: Annotated[GetBalanceReportNotFoundLinks, pydantic.Field(alias="_links")]

    field: Optional[str] = None
    r"""If the error was caused by a value provided by you in a specific field, the `field` property will contain the name
    of the field that caused the issue.
    """


class GetBalanceReportNotFoundHalJSONError(ClientError):
    r"""An error response object."""

    data: GetBalanceReportNotFoundHalJSONErrorData

    def __init__(
        self,
        data: GetBalanceReportNotFoundHalJSONErrorData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        message = body or raw_response.text
        super().__init__(message, raw_response, body)
        self.data = data


class GroupingResponse(str, Enum):
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by
    status (e.g. `pending`, `available`), then by direction of movement (e.g. moved from pending to available), then
    by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by direction of
    movement, and then again by other sub-groupings where available.

    Both reporting formats will always contain opening and closing amounts that correspond to the start and end dates
    of the report.
    """

    STATUS_BALANCES = "status-balances"
    TRANSACTION_CATEGORIES = "transaction-categories"


class PendingBalanceOpenAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceOpenAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceOpenSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceOpenSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceOpenSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceOpenSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceOpenSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceOpenSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceOpenSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceOpenSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceOpenSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalanceOpenSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalanceOpenSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalanceOpenSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceOpenSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceOpenSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PendingBalanceOpenSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class PendingBalanceOpenSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceOpenSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceOpenSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceOpenSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceOpenSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceOpenSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceOpenSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceOpenSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceOpenSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceOpenSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[PendingBalanceOpenSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceOpenSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalanceOpenSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalanceOpenSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalanceOpenSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceOpenSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceOpenSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PendingBalanceOpenSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class PendingBalanceOpenSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PendingBalanceOpenSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceOpenSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceOpenSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceOpenTypedDict(TypedDict):
    amount: NotRequired[PendingBalanceOpenAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[PendingBalanceOpenSubtotal2TypedDict]]]


class PendingBalanceOpen(BaseModel):
    amount: Optional[PendingBalanceOpenAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PendingBalanceOpenSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceCloseAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceCloseAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceCloseSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceCloseSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceCloseSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceCloseSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceCloseSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceCloseSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceCloseSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceCloseSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceCloseSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalanceCloseSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalanceCloseSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalanceCloseSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceCloseSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceCloseSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PendingBalanceCloseSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class PendingBalanceCloseSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceCloseSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceCloseSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceCloseSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceCloseSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceCloseSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceCloseSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceCloseSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceCloseSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceCloseSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[PendingBalanceCloseSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceCloseSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalanceCloseSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalanceCloseSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalanceCloseSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceCloseSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceCloseSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PendingBalanceCloseSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class PendingBalanceCloseSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PendingBalanceCloseSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceCloseSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceCloseSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceCloseTypedDict(TypedDict):
    amount: NotRequired[PendingBalanceCloseAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[PendingBalanceCloseSubtotal2TypedDict]]]


class PendingBalanceClose(BaseModel):
    amount: Optional[PendingBalanceCloseAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PendingBalanceCloseSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalancePendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalancePendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalancePendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalancePendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalancePendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalancePendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalancePendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalancePendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalancePendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalancePendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalancePendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalancePendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalancePendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalancePendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalancePendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalancePendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PendingBalancePendingSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class PendingBalancePendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalancePendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalancePendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalancePendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalancePendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalancePendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalancePendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalancePendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalancePendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalancePendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalancePendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[PendingBalancePendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalancePendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PendingBalancePendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PendingBalancePendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PendingBalancePendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalancePendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalancePendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PendingBalancePendingSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class PendingBalancePendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PendingBalancePendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalancePendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalancePendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalancePendingTypedDict(TypedDict):
    amount: NotRequired[PendingBalancePendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[PendingBalancePendingSubtotal2TypedDict]]]


class PendingBalancePending(BaseModel):
    amount: Optional[PendingBalancePendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PendingBalancePendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PendingBalanceMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class PendingBalanceMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PendingBalanceMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PendingBalanceMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PendingBalanceMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PendingBalanceMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PendingBalanceMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[PendingBalanceMovedToAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PendingBalanceMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PendingBalanceMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PendingBalanceMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class PendingBalanceMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PendingBalanceMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PendingBalanceMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PendingBalanceMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[PendingBalanceMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[PendingBalanceMovedToAvailableSubtotal2TypedDict]]
    ]


class PendingBalanceMovedToAvailable(BaseModel):
    amount: Optional[PendingBalanceMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PendingBalanceMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PendingBalanceTypedDict(TypedDict):
    r"""The pending balance. Only available if grouping is `status-balances`."""

    open: NotRequired[PendingBalanceOpenTypedDict]
    close: NotRequired[PendingBalanceCloseTypedDict]
    pending: NotRequired[PendingBalancePendingTypedDict]
    moved_to_available: NotRequired[PendingBalanceMovedToAvailableTypedDict]


class PendingBalance(BaseModel):
    r"""The pending balance. Only available if grouping is `status-balances`."""

    open: Optional[PendingBalanceOpen] = None

    close: Optional[PendingBalanceClose] = None

    pending: Optional[PendingBalancePending] = None

    moved_to_available: Annotated[
        Optional[PendingBalanceMovedToAvailable],
        pydantic.Field(alias="movedToAvailable"),
    ] = None


class AvailableBalanceOpenAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceOpenAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceOpenSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceOpenSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceOpenSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceOpenSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceOpenSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceOpenSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceOpenSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceOpenSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceOpenSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[AvailableBalanceOpenSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[AvailableBalanceOpenSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[AvailableBalanceOpenSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[AvailableBalanceOpenSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceOpenSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceOpenSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceOpenSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceOpenSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceOpenSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceOpenSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceOpenSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceOpenSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceOpenSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceOpenSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceOpenSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceOpenSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[AvailableBalanceOpenSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceOpenSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[AvailableBalanceOpenSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[AvailableBalanceOpenSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[AvailableBalanceOpenSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[AvailableBalanceOpenSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceOpenSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceOpenSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceOpenSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[AvailableBalanceOpenSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceOpenSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceOpenSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceOpenTypedDict(TypedDict):
    amount: NotRequired[AvailableBalanceOpenAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[AvailableBalanceOpenSubtotal2TypedDict]]]


class AvailableBalanceOpen(BaseModel):
    amount: Optional[AvailableBalanceOpenAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[AvailableBalanceOpenSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class MovedFromPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class MovedFromPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class MovedFromPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class MovedFromPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class MovedFromPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class MovedFromPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class MovedFromPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class MovedFromPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class MovedFromPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class MovedFromPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[MovedFromPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[MovedFromPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[MovedFromPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[MovedFromPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[MovedFromPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[MovedFromPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[MovedFromPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class MovedFromPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[MovedFromPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[MovedFromPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[MovedFromPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[MovedFromPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[MovedFromPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[MovedFromPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[MovedFromPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class MovedFromPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class MovedFromPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class MovedFromPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class MovedFromPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class MovedFromPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class MovedFromPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class MovedFromPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class MovedFromPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[MovedFromPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[MovedFromPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[MovedFromPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[MovedFromPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[MovedFromPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[MovedFromPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[MovedFromPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[MovedFromPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class MovedFromPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[MovedFromPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[MovedFromPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[MovedFromPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[MovedFromPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[MovedFromPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[MovedFromPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[MovedFromPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[MovedFromPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class MovedFromPendingTypedDict(TypedDict):
    amount: NotRequired[MovedFromPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[MovedFromPendingSubtotal2TypedDict]]]


class MovedFromPending(BaseModel):
    amount: Optional[MovedFromPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[MovedFromPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalFeeType1]
    ]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalMethod1] = (
        UNSET
    )
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[
            AvailableBalanceImmediatelyAvailableSubTotalPrepaymentPartType1
        ],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[AvailableBalanceImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalFeeType2]
    ]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[AvailableBalanceImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalMethod2] = (
        UNSET
    )
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[
            AvailableBalanceImmediatelyAvailableSubtotalPrepaymentPartType2
        ],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[AvailableBalanceImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[AvailableBalanceImmediatelyAvailableSubtotal2TypedDict]]
    ]


class AvailableBalanceImmediatelyAvailable(BaseModel):
    amount: Optional[AvailableBalanceImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[AvailableBalanceImmediatelyAvailableSubtotal2]] = (
        UNSET
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceCloseAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceCloseAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class AvailableBalanceCloseSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceCloseSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceCloseSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceCloseSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceCloseSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceCloseSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceCloseSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceCloseSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceCloseSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[AvailableBalanceCloseSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[AvailableBalanceCloseSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[AvailableBalanceCloseSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[AvailableBalanceCloseSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceCloseSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceCloseSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceCloseSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceCloseSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceCloseSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class AvailableBalanceCloseSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class AvailableBalanceCloseSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class AvailableBalanceCloseSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class AvailableBalanceCloseSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class AvailableBalanceCloseSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class AvailableBalanceCloseSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class AvailableBalanceCloseSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[AvailableBalanceCloseSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[AvailableBalanceCloseSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[AvailableBalanceCloseSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[AvailableBalanceCloseSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[AvailableBalanceCloseSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[AvailableBalanceCloseSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[AvailableBalanceCloseSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[AvailableBalanceCloseSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class AvailableBalanceCloseSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[AvailableBalanceCloseSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[AvailableBalanceCloseSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[AvailableBalanceCloseSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceCloseTypedDict(TypedDict):
    amount: NotRequired[AvailableBalanceCloseAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[AvailableBalanceCloseSubtotal2TypedDict]]]


class AvailableBalanceClose(BaseModel):
    amount: Optional[AvailableBalanceCloseAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[AvailableBalanceCloseSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AvailableBalanceTypedDict(TypedDict):
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: NotRequired[AvailableBalanceOpenTypedDict]
    moved_from_pending: NotRequired[MovedFromPendingTypedDict]
    immediately_available: NotRequired[AvailableBalanceImmediatelyAvailableTypedDict]
    close: NotRequired[AvailableBalanceCloseTypedDict]


class AvailableBalance(BaseModel):
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: Optional[AvailableBalanceOpen] = None

    moved_from_pending: Annotated[
        Optional[MovedFromPending], pydantic.Field(alias="movedFromPending")
    ] = None

    immediately_available: Annotated[
        Optional[AvailableBalanceImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None

    close: Optional[AvailableBalanceClose] = None


class OpenPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class OpenPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class OpenPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class OpenPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class OpenPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class OpenPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class OpenPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class OpenPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class OpenPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class OpenPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[OpenPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[OpenPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[OpenPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[OpenPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[OpenPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[Nullable[OpenPendingSubTotalPrepaymentPartType1]]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[OpenPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class OpenPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[OpenPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[OpenPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[OpenPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[OpenPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[OpenPendingSubTotalFeeType1], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[OpenPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[OpenPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class OpenPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class OpenPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class OpenPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class OpenPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class OpenPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class OpenPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class OpenPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[OpenPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[OpenPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[OpenPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[OpenPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[OpenPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[OpenPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[Nullable[OpenPendingSubtotalPrepaymentPartType2]]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[OpenPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class OpenPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[OpenPendingSubTotal1]], pydantic.Field(alias="sub-totals")
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[OpenPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[OpenPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[OpenPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[OpenPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[OpenPendingSubtotalFeeType2], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[OpenPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[OpenPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenPendingTypedDict(TypedDict):
    amount: NotRequired[OpenPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[OpenPendingSubtotal2TypedDict]]]


class OpenPending(BaseModel):
    amount: Optional[OpenPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[OpenPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class OpenAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class OpenAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class OpenAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class OpenAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class OpenAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class OpenAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class OpenAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class OpenAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class OpenAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[OpenAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[OpenAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[OpenAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[OpenAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[OpenAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[OpenAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[OpenAvailableSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class OpenAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[OpenAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[OpenAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[OpenAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[OpenAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[OpenAvailableSubTotalFeeType1], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[OpenAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[OpenAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class OpenAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class OpenAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class OpenAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class OpenAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class OpenAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class OpenAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class OpenAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[OpenAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[OpenAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[OpenAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[OpenAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[OpenAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[OpenAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[OpenAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[OpenAvailableSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class OpenAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[OpenAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[OpenAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[OpenAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[OpenAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[OpenAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[OpenAvailableSubtotalFeeType2], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[OpenAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[OpenAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenAvailableTypedDict(TypedDict):
    amount: NotRequired[OpenAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[OpenAvailableSubtotal2TypedDict]]]


class OpenAvailable(BaseModel):
    amount: Optional[OpenAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[OpenAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class OpenTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[OpenPendingTypedDict]
    available: NotRequired[OpenAvailableTypedDict]


class Open(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[OpenPending] = None

    available: Optional[OpenAvailable] = None


class ClosePendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ClosePendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ClosePendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ClosePendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ClosePendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ClosePendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ClosePendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ClosePendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ClosePendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ClosePendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ClosePendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ClosePendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[ClosePendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ClosePendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ClosePendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[Nullable[ClosePendingSubTotalPrepaymentPartType1]]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[ClosePendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class ClosePendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ClosePendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ClosePendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ClosePendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ClosePendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ClosePendingSubTotalFeeType1], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ClosePendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ClosePendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ClosePendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ClosePendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ClosePendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ClosePendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ClosePendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ClosePendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ClosePendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ClosePendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[ClosePendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ClosePendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ClosePendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[ClosePendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ClosePendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ClosePendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[Nullable[ClosePendingSubtotalPrepaymentPartType2]]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[ClosePendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class ClosePendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[ClosePendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ClosePendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ClosePendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ClosePendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ClosePendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ClosePendingSubtotalFeeType2], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ClosePendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ClosePendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ClosePendingTypedDict(TypedDict):
    amount: NotRequired[ClosePendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[ClosePendingSubtotal2TypedDict]]]


class ClosePending(BaseModel):
    amount: Optional[ClosePendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[ClosePendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CloseAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CloseAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CloseAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CloseAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CloseAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CloseAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CloseAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CloseAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CloseAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CloseAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CloseAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CloseAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CloseAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CloseAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CloseAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CloseAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CloseAvailableSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class CloseAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CloseAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CloseAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CloseAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CloseAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CloseAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CloseAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CloseAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CloseAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CloseAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CloseAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CloseAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CloseAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CloseAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CloseAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CloseAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[CloseAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CloseAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CloseAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CloseAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CloseAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CloseAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CloseAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CloseAvailableSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class CloseAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CloseAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CloseAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CloseAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CloseAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CloseAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CloseAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CloseAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CloseAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CloseAvailableTypedDict(TypedDict):
    amount: NotRequired[CloseAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[CloseAvailableSubtotal2TypedDict]]]


class CloseAvailable(BaseModel):
    amount: Optional[CloseAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CloseAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CloseTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[ClosePendingTypedDict]
    available: NotRequired[CloseAvailableTypedDict]


class Close(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[ClosePending] = None

    available: Optional[CloseAvailable] = None


class PaymentsPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PaymentsPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PaymentsPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class PaymentsPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[PaymentsPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PaymentsPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[PaymentsPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class PaymentsPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PaymentsPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsPendingTypedDict(TypedDict):
    amount: NotRequired[PaymentsPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[PaymentsPendingSubtotal2TypedDict]]]


class PaymentsPending(BaseModel):
    amount: Optional[PaymentsPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PaymentsPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PaymentsMovedToAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PaymentsMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class PaymentsMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[PaymentsMovedToAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[PaymentsMovedToAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PaymentsMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class PaymentsMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PaymentsMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[PaymentsMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[PaymentsMovedToAvailableSubtotal2TypedDict]]]


class PaymentsMovedToAvailable(BaseModel):
    amount: Optional[PaymentsMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PaymentsMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class PaymentsImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsImmediatelyAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsImmediatelyAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class PaymentsImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class PaymentsImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class PaymentsImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class PaymentsImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class PaymentsImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class PaymentsImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[PaymentsImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[PaymentsImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[PaymentsImmediatelyAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[PaymentsImmediatelyAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[PaymentsImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[PaymentsImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class PaymentsImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[PaymentsImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[PaymentsImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[PaymentsImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class PaymentsImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[PaymentsImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[PaymentsImmediatelyAvailableSubtotal2TypedDict]]
    ]


class PaymentsImmediatelyAvailable(BaseModel):
    amount: Optional[PaymentsImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[PaymentsImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportPaymentsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[PaymentsPendingTypedDict]
    moved_to_available: NotRequired[PaymentsMovedToAvailableTypedDict]
    immediately_available: NotRequired[PaymentsImmediatelyAvailableTypedDict]


class GetBalanceReportPayments(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[PaymentsPending] = None

    moved_to_available: Annotated[
        Optional[PaymentsMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[PaymentsImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class RefundsPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[RefundsPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[RefundsPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class RefundsPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[RefundsPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[RefundsPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[RefundsPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class RefundsPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[RefundsPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsPendingTypedDict(TypedDict):
    amount: NotRequired[RefundsPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[RefundsPendingSubtotal2TypedDict]]]


class RefundsPending(BaseModel):
    amount: Optional[RefundsPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[RefundsPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[RefundsMovedToAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[RefundsMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class RefundsMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[RefundsMovedToAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[RefundsMovedToAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[RefundsMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class RefundsMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[RefundsMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[RefundsMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[RefundsMovedToAvailableSubtotal2TypedDict]]]


class RefundsMovedToAvailable(BaseModel):
    amount: Optional[RefundsMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[RefundsMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class RefundsImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsImmediatelyAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsImmediatelyAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class RefundsImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class RefundsImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class RefundsImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class RefundsImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class RefundsImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class RefundsImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class RefundsImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class RefundsImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[RefundsImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[RefundsImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[RefundsImmediatelyAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[RefundsImmediatelyAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[RefundsImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[RefundsImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class RefundsImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[RefundsImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[RefundsImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[RefundsImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class RefundsImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[RefundsImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[RefundsImmediatelyAvailableSubtotal2TypedDict]]
    ]


class RefundsImmediatelyAvailable(BaseModel):
    amount: Optional[RefundsImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[RefundsImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportRefundsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[RefundsPendingTypedDict]
    moved_to_available: NotRequired[RefundsMovedToAvailableTypedDict]
    immediately_available: NotRequired[RefundsImmediatelyAvailableTypedDict]


class GetBalanceReportRefunds(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[RefundsPending] = None

    moved_to_available: Annotated[
        Optional[RefundsMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[RefundsImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class ChargebacksPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ChargebacksPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[ChargebacksPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ChargebacksPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[ChargebacksPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class ChargebacksPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[ChargebacksPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ChargebacksPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[ChargebacksPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ChargebacksPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[ChargebacksPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class ChargebacksPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[ChargebacksPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksPendingTypedDict(TypedDict):
    amount: NotRequired[ChargebacksPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[ChargebacksPendingSubtotal2TypedDict]]]


class ChargebacksPending(BaseModel):
    amount: Optional[ChargebacksPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[ChargebacksPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ChargebacksMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ChargebacksMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class ChargebacksMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[ChargebacksMovedToAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[ChargebacksMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[ChargebacksMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[ChargebacksMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class ChargebacksMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[ChargebacksMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[ChargebacksMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[ChargebacksMovedToAvailableSubtotal2TypedDict]]
    ]


class ChargebacksMovedToAvailable(BaseModel):
    amount: Optional[ChargebacksMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[ChargebacksMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class ChargebacksImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class ChargebacksImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class ChargebacksImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class ChargebacksImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class ChargebacksImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class ChargebacksImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class ChargebacksImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[ChargebacksImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[ChargebacksImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[ChargebacksImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[ChargebacksImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class ChargebacksImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[ChargebacksImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[ChargebacksImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[ChargebacksImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class ChargebacksImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[ChargebacksImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[ChargebacksImmediatelyAvailableSubtotal2TypedDict]]
    ]


class ChargebacksImmediatelyAvailable(BaseModel):
    amount: Optional[ChargebacksImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[ChargebacksImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportChargebacksTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[ChargebacksPendingTypedDict]
    moved_to_available: NotRequired[ChargebacksMovedToAvailableTypedDict]
    immediately_available: NotRequired[ChargebacksImmediatelyAvailableTypedDict]


class GetBalanceReportChargebacks(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[ChargebacksPending] = None

    moved_to_available: Annotated[
        Optional[ChargebacksMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[ChargebacksImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class CapitalPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CapitalPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CapitalPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class CapitalPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[CapitalPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CapitalPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CapitalPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class CapitalPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CapitalPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalPendingTypedDict(TypedDict):
    amount: NotRequired[CapitalPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[CapitalPendingSubtotal2TypedDict]]]


class CapitalPending(BaseModel):
    amount: Optional[CapitalPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CapitalPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CapitalMovedToAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CapitalMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class CapitalMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[CapitalMovedToAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CapitalMovedToAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CapitalMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class CapitalMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CapitalMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[CapitalMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[CapitalMovedToAvailableSubtotal2TypedDict]]]


class CapitalMovedToAvailable(BaseModel):
    amount: Optional[CapitalMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CapitalMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CapitalImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalImmediatelyAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalImmediatelyAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class CapitalImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CapitalImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CapitalImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CapitalImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CapitalImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CapitalImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CapitalImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CapitalImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[CapitalImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CapitalImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CapitalImmediatelyAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CapitalImmediatelyAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CapitalImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CapitalImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class CapitalImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CapitalImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CapitalImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CapitalImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[CapitalImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[CapitalImmediatelyAvailableSubtotal2TypedDict]]
    ]


class CapitalImmediatelyAvailable(BaseModel):
    amount: Optional[CapitalImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CapitalImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CapitalTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[CapitalPendingTypedDict]
    moved_to_available: NotRequired[CapitalMovedToAvailableTypedDict]
    immediately_available: NotRequired[CapitalImmediatelyAvailableTypedDict]


class Capital(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[CapitalPending] = None

    moved_to_available: Annotated[
        Optional[CapitalMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[CapitalImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class TransfersPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TransfersPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[TransfersPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class TransfersPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[TransfersPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TransfersPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[TransfersPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class TransfersPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TransfersPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersPendingTypedDict(TypedDict):
    amount: NotRequired[TransfersPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[TransfersPendingSubtotal2TypedDict]]]


class TransfersPending(BaseModel):
    amount: Optional[TransfersPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TransfersPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TransfersMovedToAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TransfersMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class TransfersMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[TransfersMovedToAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TransfersMovedToAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TransfersMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class TransfersMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TransfersMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[TransfersMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[TransfersMovedToAvailableSubtotal2TypedDict]]]


class TransfersMovedToAvailable(BaseModel):
    amount: Optional[TransfersMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TransfersMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TransfersImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersImmediatelyAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersImmediatelyAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class TransfersImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TransfersImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TransfersImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TransfersImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TransfersImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TransfersImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TransfersImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TransfersImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[TransfersImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TransfersImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TransfersImmediatelyAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TransfersImmediatelyAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TransfersImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TransfersImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class TransfersImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TransfersImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TransfersImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TransfersImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[TransfersImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[TransfersImmediatelyAvailableSubtotal2TypedDict]]
    ]


class TransfersImmediatelyAvailable(BaseModel):
    amount: Optional[TransfersImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TransfersImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TransfersTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[TransfersPendingTypedDict]
    moved_to_available: NotRequired[TransfersMovedToAvailableTypedDict]
    immediately_available: NotRequired[TransfersImmediatelyAvailableTypedDict]


class Transfers(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[TransfersPending] = None

    moved_to_available: Annotated[
        Optional[TransfersMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[TransfersImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class FeePrepaymentsPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[FeePrepaymentsPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[FeePrepaymentsPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[FeePrepaymentsPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsPendingSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[FeePrepaymentsPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[FeePrepaymentsPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[FeePrepaymentsPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[FeePrepaymentsPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsPendingSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[FeePrepaymentsPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsPendingTypedDict(TypedDict):
    amount: NotRequired[FeePrepaymentsPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[FeePrepaymentsPendingSubtotal2TypedDict]]]


class FeePrepaymentsPending(BaseModel):
    amount: Optional[FeePrepaymentsPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[FeePrepaymentsPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[FeePrepaymentsMovedToAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[FeePrepaymentsMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[FeePrepaymentsMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[FeePrepaymentsMovedToAvailableSubtotal2TypedDict]]
    ]


class FeePrepaymentsMovedToAvailable(BaseModel):
    amount: Optional[FeePrepaymentsMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[FeePrepaymentsMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class FeePrepaymentsImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class FeePrepaymentsImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class FeePrepaymentsImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class FeePrepaymentsImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class FeePrepaymentsImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class FeePrepaymentsImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[FeePrepaymentsImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[FeePrepaymentsImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[FeePrepaymentsImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[FeePrepaymentsImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class FeePrepaymentsImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[FeePrepaymentsImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[FeePrepaymentsImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[FeePrepaymentsImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[FeePrepaymentsImmediatelyAvailableSubtotal2TypedDict]]
    ]


class FeePrepaymentsImmediatelyAvailable(BaseModel):
    amount: Optional[FeePrepaymentsImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[FeePrepaymentsImmediatelyAvailableSubtotal2]] = (
        UNSET
    )

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class FeePrepaymentsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[FeePrepaymentsPendingTypedDict]
    moved_to_available: NotRequired[FeePrepaymentsMovedToAvailableTypedDict]
    immediately_available: NotRequired[FeePrepaymentsImmediatelyAvailableTypedDict]


class FeePrepayments(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[FeePrepaymentsPending] = None

    moved_to_available: Annotated[
        Optional[FeePrepaymentsMovedToAvailable],
        pydantic.Field(alias="movedToAvailable"),
    ] = None

    immediately_available: Annotated[
        Optional[FeePrepaymentsImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class CorrectionsPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CorrectionsPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CorrectionsPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CorrectionsPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CorrectionsPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class CorrectionsPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[CorrectionsPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CorrectionsPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[CorrectionsPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CorrectionsPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[CorrectionsPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class CorrectionsPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CorrectionsPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsPendingTypedDict(TypedDict):
    amount: NotRequired[CorrectionsPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[CorrectionsPendingSubtotal2TypedDict]]]


class CorrectionsPending(BaseModel):
    amount: Optional[CorrectionsPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CorrectionsPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CorrectionsMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CorrectionsMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class CorrectionsMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[CorrectionsMovedToAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[CorrectionsMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[CorrectionsMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CorrectionsMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class CorrectionsMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CorrectionsMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[CorrectionsMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[CorrectionsMovedToAvailableSubtotal2TypedDict]]
    ]


class CorrectionsMovedToAvailable(BaseModel):
    amount: Optional[CorrectionsMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CorrectionsMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class CorrectionsImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubTotalCardIssuer1]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubTotalCardRegion1]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class CorrectionsImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class CorrectionsImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class CorrectionsImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class CorrectionsImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class CorrectionsImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class CorrectionsImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[CorrectionsImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[CorrectionsImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubtotalCardIssuer2]
    ]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubtotalCardRegion2]
    ]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[CorrectionsImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[CorrectionsImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class CorrectionsImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[CorrectionsImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[CorrectionsImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[CorrectionsImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[CorrectionsImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[
        Nullable[List[CorrectionsImmediatelyAvailableSubtotal2TypedDict]]
    ]


class CorrectionsImmediatelyAvailable(BaseModel):
    amount: Optional[CorrectionsImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[CorrectionsImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class CorrectionsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[CorrectionsPendingTypedDict]
    moved_to_available: NotRequired[CorrectionsMovedToAvailableTypedDict]
    immediately_available: NotRequired[CorrectionsImmediatelyAvailableTypedDict]


class Corrections(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[CorrectionsPending] = None

    moved_to_available: Annotated[
        Optional[CorrectionsMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[CorrectionsImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class TopupsPendingAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsPendingAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsPendingSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsPendingSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsPendingSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsPendingSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsPendingSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsPendingSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsPendingSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsPendingSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsPendingSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsPendingSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TopupsPendingSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsPendingSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsPendingSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsPendingSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[TopupsPendingSubTotalTransactionType1]]
    r"""Represents the transaction type"""


class TopupsPendingSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsPendingSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsPendingSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsPendingSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsPendingSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsPendingSubTotalFeeType1], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsPendingSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsPendingSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsPendingSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsPendingSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsPendingSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsPendingSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsPendingSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsPendingSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsPendingSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsPendingSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[TopupsPendingSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsPendingSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsPendingSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TopupsPendingSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsPendingSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsPendingSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsPendingSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[Nullable[TopupsPendingSubtotalTransactionType2]]
    r"""Represents the transaction type"""


class TopupsPendingSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TopupsPendingSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsPendingSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsPendingSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsPendingSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsPendingSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsPendingSubtotalFeeType2], pydantic.Field(alias="feeType")
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsPendingSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsPendingSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsPendingTypedDict(TypedDict):
    amount: NotRequired[TopupsPendingAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[TopupsPendingSubtotal2TypedDict]]]


class TopupsPending(BaseModel):
    amount: Optional[TopupsPendingAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TopupsPendingSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsMovedToAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsMovedToAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsMovedToAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsMovedToAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsMovedToAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsMovedToAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsMovedToAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsMovedToAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsMovedToAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsMovedToAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsMovedToAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsMovedToAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TopupsMovedToAvailableSubTotalCardAudience1]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsMovedToAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsMovedToAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsMovedToAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TopupsMovedToAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class TopupsMovedToAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsMovedToAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsMovedToAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsMovedToAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsMovedToAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsMovedToAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsMovedToAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsMovedToAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsMovedToAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsMovedToAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[Nullable[List[TopupsMovedToAvailableSubTotal1TypedDict]]]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsMovedToAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsMovedToAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[Nullable[TopupsMovedToAvailableSubtotalCardAudience2]]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsMovedToAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsMovedToAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsMovedToAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TopupsMovedToAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class TopupsMovedToAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TopupsMovedToAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsMovedToAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsMovedToAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsMovedToAvailableTypedDict(TypedDict):
    amount: NotRequired[TopupsMovedToAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[TopupsMovedToAvailableSubtotal2TypedDict]]]


class TopupsMovedToAvailable(BaseModel):
    amount: Optional[TopupsMovedToAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TopupsMovedToAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsImmediatelyAvailableAmountTypedDict(TypedDict):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""
    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsImmediatelyAvailableAmount(BaseModel):
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    currency: str
    r"""A three-character ISO 4217 currency code."""

    value: str
    r"""A string containing an exact monetary amount in the given currency."""


class TopupsImmediatelyAvailableSubTotalMethod1(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsImmediatelyAvailableSubTotalCardIssuer1(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsImmediatelyAvailableSubTotalCardAudience1(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsImmediatelyAvailableSubTotalCardRegion1(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsImmediatelyAvailableSubTotalFeeType1(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsImmediatelyAvailableSubTotalPrepaymentPartType1(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsImmediatelyAvailableSubTotalTransactionType1(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsImmediatelyAvailableSubTotal1TypedDict(TypedDict):
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsImmediatelyAvailableSubTotalMethod1]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsImmediatelyAvailableSubTotalCardIssuer1]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubTotalCardAudience1]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsImmediatelyAvailableSubTotalCardRegion1]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsImmediatelyAvailableSubTotalFeeType1]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubTotalPrepaymentPartType1]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubTotalTransactionType1]
    ]
    r"""Represents the transaction type"""


class TopupsImmediatelyAvailableSubTotal1(BaseModel):
    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsImmediatelyAvailableSubTotalMethod1] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalCardIssuer1],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalCardAudience1],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalCardRegion1],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalFeeType1],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalPrepaymentPartType1],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubTotalTransactionType1],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsImmediatelyAvailableSubtotalMethod2(str, Enum):
    r"""Payment type of the transactions"""

    ALMA = "alma"
    BACS = "bacs"
    APPLEPAY = "applepay"
    BANCOMATPAY = "bancomatpay"
    BANCONTACT = "bancontact"
    BANKTRANSFER = "banktransfer"
    BELFIUS = "belfius"
    BILLIE = "billie"
    BIZUM = "bizum"
    BITCOIN = "bitcoin"
    BLIK = "blik"
    CREDITCARD = "creditcard"
    DIRECTDEBIT = "directdebit"
    EPS = "eps"
    GIFTCARD = "giftcard"
    GIROPAY = "giropay"
    GOOGLEPAY = "googlepay"
    IDEAL = "ideal"
    IN3 = "in3"
    INGHOMEPAY = "inghomepay"
    KBC = "kbc"
    KLARNAPAYLATER = "klarnapaylater"
    KLARNAPAYNOW = "klarnapaynow"
    KLARNASLICEIT = "klarnasliceit"
    KLARNA = "klarna"
    MBWAY = "mbway"
    MULTIBANCO = "multibanco"
    MYBANK = "mybank"
    PAYBYBANK = "paybybank"
    PAYCONIQ = "payconiq"
    PAYPAL = "paypal"
    PAYSAFECARD = "paysafecard"
    PRZELEWY24 = "przelewy24"
    RIVERTY = "riverty"
    SATISPAY = "satispay"
    PODIUMCADEAUKAART = "podiumcadeaukaart"
    POINTOFSALE = "pointofsale"
    SOFORT = "sofort"
    SWISH = "swish"
    TRUSTLY = "trustly"
    TWINT = "twint"
    VOUCHER = "voucher"


class TopupsImmediatelyAvailableSubtotalCardIssuer2(str, Enum):
    r"""In case of payments transactions with card, the card issuer will be available"""

    AMEX = "amex"
    MAESTRO = "maestro"
    CARTE_BANCAIRE = "carte-bancaire"
    OTHER = "other"


class TopupsImmediatelyAvailableSubtotalCardAudience2(str, Enum):
    r"""In case of payments trnsactions with card, the card audience will be available."""

    CORPORATE = "corporate"
    OTHER = "other"


class TopupsImmediatelyAvailableSubtotalCardRegion2(str, Enum):
    r"""In case of payments transactions with card, the card region will be available."""

    INTRA_EEA = "intra-eea"
    INTRA_EU = "intra-eu"
    DOMESTIC = "domestic"
    OTHER = "other"


class TopupsImmediatelyAvailableSubtotalFeeType2(str, Enum):
    r"""Present when the transaction represents a fee."""

    PAYMENT_FEE = "payment-fee"
    DIRECT_DEBIT_FAILURE_FEE = "direct-debit-failure-fee"
    UNAUTHORIZED_DIRECT_DEBIT_FEE = "unauthorized-direct-debit-fee"
    BANK_CHARGED_DIRECT_DEBIT_FAILURE_FEE = "bank-charged-direct-debit-failure-fee"
    PARTNER_COMMISSION = "partner-commission"
    APPLICATION_FEE = "application-fee"
    CAPTURE_FEE = "capture-fee"
    REFUND_FEE = "refund-fee"
    CHARGEBACK_FEE = "chargeback-fee"
    PAYMENT_NOTIFICATION_FEE = "payment-notification-fee"
    TRANSFER_NOTIFICATION_FEE = "transfer-notification-fee"
    PAYOUT_FEE = "payout-fee"
    FEE_DISCOUNT = "fee-discount"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    PLATFORM_VOLUME_FEE = "platform-volume-fee"
    PLATFORM_CONNECTED_ORGANIZATIONS_FEE = "platform-connected-organizations-fee"
    BALANCE_CHARGE_FEE = "balance-charge-fee"
    THREEDS_AUTHENTICATION_ATTEMPT_FEE = "3ds-authentication-attempt-fee"
    TERMINAL_MONTHLY_FEE = "terminal-monthly-fee"
    ACCEPTANCE_RISK_FEE = "acceptance-risk-fee"
    TOP_UP_FEE = "top-up-fee"
    PAYMENT_GATEWAY_FEE = "payment-gateway-fee"
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_PROCESSING_FEE = (
        "mastercard-specialty-merchant-program-processing-fee"
    )
    MASTERCARD_SPECIALTY_MERCHANT_PROGRAM_REGISTRATION_FEE = (
        "mastercard-specialty-merchant-program-registration-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_PROCESSING_FEE = (
        "visa-integrity-risk-program-processing-fee"
    )
    VISA_INTEGRITY_RISK_PROGRAM_REGISTRATION_FEE = (
        "visa-integrity-risk-program-registration-fee"
    )
    MINIMUM_INVOICE_AMOUNT_FEE = "minimum-invoice-amount-fee"


class TopupsImmediatelyAvailableSubtotalPrepaymentPartType2(str, Enum):
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    FEE = "fee"
    FEE_REIMBURSEMENT = "fee-reimbursement"
    FEE_DISCOUNT = "fee-discount"
    FEE_VAT = "fee-vat"
    FEE_ROUNDING_COMPENSATION = "fee-rounding-compensation"


class TopupsImmediatelyAvailableSubtotalTransactionType2(str, Enum):
    r"""Represents the transaction type"""

    PAYMENT = "payment"
    SPLIT_PAYMENT = "split-payment"
    FAILED_PAYMENT = "failed-payment"
    FAILED_PLATFORM_SPLIT_PAYMENT = "failed-platform-split-payment"
    FAILED_SPLIT_PAYMENT_COMPENSATION = "failed-split-payment-compensation"
    CAPTURE = "capture"
    SPLIT_TRANSACTION = "split-transaction"
    REFUND = "refund"
    PLATFORM_PAYMENT_REFUND = "platform-payment-refund"
    RETURNED_PLATFORM_PAYMENT_REFUND = "returned-platform-payment-refund"
    REFUND_COMPENSATION = "refund-compensation"
    RETURNED_REFUND_COMPENSATION = "returned-refund-compensation"
    RETURNED_REFUND = "returned-refund"
    CHARGEBACK = "chargeback"
    CHARGEBACK_REVERSAL = "chargeback-reversal"
    CHARGEBACK_COMPENSATION = "chargeback-compensation"
    REVERSED_CHARGEBACK_COMPENSATION = "reversed-chargeback-compensation"
    PLATFORM_PAYMENT_CHARGEBACK = "platform-payment-chargeback"
    REVERSED_PLATFORM_PAYMENT_CHARGEBACK = "reversed-platform-payment-chargeback"
    FEE_PREPAYMENT = "fee-prepayment"
    OUTGOING_TRANSFER = "outgoing-transfer"
    INCOMING_TRANSFER = "incoming-transfer"
    CANCELED_TRANSFER = "canceled-transfer"
    RETURNED_TRANSFER = "returned-transfer"
    BALANCE_RESERVE = "balance-reserve"
    BALANCE_RESERVE_RETURN = "balance-reserve-return"
    INVOICE_ROUNDING_COMPENSATION = "invoice-rounding-compensation"
    ROLLING_RESERVE_HOLD = "rolling-reserve-hold"
    ROLLING_RESERVE_RELEASE = "rolling-reserve-release"
    BALANCE_CORRECTION = "balance-correction"
    REPAYMENT = "repayment"
    LOAN = "loan"
    BALANCE_TOPUP = "balance-topup"
    CASH_COLLATERAL_ISSUANCE_ = "cash-collateral-issuance';"
    CASH_COLLATERAL_RELEASE = "cash-collateral-release"
    PENDING_ROLLING_RESERVE = "pending-rolling-reserve"
    TO_BE_RELEASED_ROLLING_RESERVE = "to-be-released-rolling-reserve"
    HELD_ROLLING_RESERVE = "held-rolling-reserve"
    RELEASED_ROLLING_RESERVE = "released-rolling-reserve"


class TopupsImmediatelyAvailableSubtotal2TypedDict(TypedDict):
    sub_totals: NotRequired[
        Nullable[List[TopupsImmediatelyAvailableSubTotal1TypedDict]]
    ]
    count: NotRequired[int]
    r"""Number of transactions of this type"""
    method: NotRequired[Nullable[TopupsImmediatelyAvailableSubtotalMethod2]]
    r"""Payment type of the transactions"""
    card_issuer: NotRequired[Nullable[TopupsImmediatelyAvailableSubtotalCardIssuer2]]
    r"""In case of payments transactions with card, the card issuer will be available"""
    card_audience: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubtotalCardAudience2]
    ]
    r"""In case of payments trnsactions with card, the card audience will be available."""
    card_region: NotRequired[Nullable[TopupsImmediatelyAvailableSubtotalCardRegion2]]
    r"""In case of payments transactions with card, the card region will be available."""
    fee_type: NotRequired[Nullable[TopupsImmediatelyAvailableSubtotalFeeType2]]
    r"""Present when the transaction represents a fee."""
    prepayment_part_type: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubtotalPrepaymentPartType2]
    ]
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""
    transaction_type: NotRequired[
        Nullable[TopupsImmediatelyAvailableSubtotalTransactionType2]
    ]
    r"""Represents the transaction type"""


class TopupsImmediatelyAvailableSubtotal2(BaseModel):
    sub_totals: Annotated[
        OptionalNullable[List[TopupsImmediatelyAvailableSubTotal1]],
        pydantic.Field(alias="sub-totals"),
    ] = UNSET

    count: Optional[int] = None
    r"""Number of transactions of this type"""

    method: OptionalNullable[TopupsImmediatelyAvailableSubtotalMethod2] = UNSET
    r"""Payment type of the transactions"""

    card_issuer: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalCardIssuer2],
        pydantic.Field(alias="cardIssuer"),
    ] = UNSET
    r"""In case of payments transactions with card, the card issuer will be available"""

    card_audience: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalCardAudience2],
        pydantic.Field(alias="cardAudience"),
    ] = UNSET
    r"""In case of payments trnsactions with card, the card audience will be available."""

    card_region: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalCardRegion2],
        pydantic.Field(alias="cardRegion"),
    ] = UNSET
    r"""In case of payments transactions with card, the card region will be available."""

    fee_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalFeeType2],
        pydantic.Field(alias="feeType"),
    ] = UNSET
    r"""Present when the transaction represents a fee."""

    prepayment_part_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalPrepaymentPartType2],
        pydantic.Field(alias="prepaymentPartType"),
    ] = UNSET
    r"""Prepayment part: fee itself, reimbursement, discount, VAT or rounding compensation."""

    transaction_type: Annotated[
        OptionalNullable[TopupsImmediatelyAvailableSubtotalTransactionType2],
        pydantic.Field(alias="transactionType"),
    ] = UNSET
    r"""Represents the transaction type"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "sub-totals",
            "count",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        nullable_fields = [
            "sub-totals",
            "method",
            "cardIssuer",
            "cardAudience",
            "cardRegion",
            "feeType",
            "prepaymentPartType",
            "transactionType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsImmediatelyAvailableTypedDict(TypedDict):
    amount: NotRequired[TopupsImmediatelyAvailableAmountTypedDict]
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""
    subtotals: NotRequired[Nullable[List[TopupsImmediatelyAvailableSubtotal2TypedDict]]]


class TopupsImmediatelyAvailable(BaseModel):
    amount: Optional[TopupsImmediatelyAvailableAmount] = None
    r"""In v2 endpoints, monetary amounts are represented as objects with a `currency` and `value` field."""

    subtotals: OptionalNullable[List[TopupsImmediatelyAvailableSubtotal2]] = UNSET

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["amount", "subtotals"]
        nullable_fields = ["subtotals"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class TopupsTypedDict(TypedDict):
    r"""Only available on `transaction-categories` grouping."""

    pending: NotRequired[TopupsPendingTypedDict]
    moved_to_available: NotRequired[TopupsMovedToAvailableTypedDict]
    immediately_available: NotRequired[TopupsImmediatelyAvailableTypedDict]


class Topups(BaseModel):
    r"""Only available on `transaction-categories` grouping."""

    pending: Optional[TopupsPending] = None

    moved_to_available: Annotated[
        Optional[TopupsMovedToAvailable], pydantic.Field(alias="movedToAvailable")
    ] = None

    immediately_available: Annotated[
        Optional[TopupsImmediatelyAvailable],
        pydantic.Field(alias="immediatelyAvailable"),
    ] = None


class TotalsTypedDict(TypedDict):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    pending_balance: NotRequired[Nullable[PendingBalanceTypedDict]]
    r"""The pending balance. Only available if grouping is `status-balances`."""
    available_balance: NotRequired[Nullable[AvailableBalanceTypedDict]]
    r"""The available balance. Only available if grouping is `status-balances`."""
    open: NotRequired[OpenTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    close: NotRequired[CloseTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    payments: NotRequired[GetBalanceReportPaymentsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    refunds: NotRequired[GetBalanceReportRefundsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    chargebacks: NotRequired[GetBalanceReportChargebacksTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    capital: NotRequired[CapitalTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    transfers: NotRequired[TransfersTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    fee_prepayments: NotRequired[FeePrepaymentsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    corrections: NotRequired[CorrectionsTypedDict]
    r"""Only available on `transaction-categories` grouping."""
    topups: NotRequired[TopupsTypedDict]
    r"""Only available on `transaction-categories` grouping."""


class Totals(BaseModel):
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    pending_balance: Annotated[
        OptionalNullable[PendingBalance], pydantic.Field(alias="pendingBalance")
    ] = UNSET
    r"""The pending balance. Only available if grouping is `status-balances`."""

    available_balance: Annotated[
        OptionalNullable[AvailableBalance], pydantic.Field(alias="availableBalance")
    ] = UNSET
    r"""The available balance. Only available if grouping is `status-balances`."""

    open: Optional[Open] = None
    r"""Only available on `transaction-categories` grouping."""

    close: Optional[Close] = None
    r"""Only available on `transaction-categories` grouping."""

    payments: Optional[GetBalanceReportPayments] = None
    r"""Only available on `transaction-categories` grouping."""

    refunds: Optional[GetBalanceReportRefunds] = None
    r"""Only available on `transaction-categories` grouping."""

    chargebacks: Optional[GetBalanceReportChargebacks] = None
    r"""Only available on `transaction-categories` grouping."""

    capital: Optional[Capital] = None
    r"""Only available on `transaction-categories` grouping."""

    transfers: Optional[Transfers] = None
    r"""Only available on `transaction-categories` grouping."""

    fee_prepayments: Annotated[
        Optional[FeePrepayments], pydantic.Field(alias="fee-prepayments")
    ] = None
    r"""Only available on `transaction-categories` grouping."""

    corrections: Optional[Corrections] = None
    r"""Only available on `transaction-categories` grouping."""

    topups: Optional[Topups] = None
    r"""Only available on `transaction-categories` grouping."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "pendingBalance",
            "availableBalance",
            "open",
            "close",
            "payments",
            "refunds",
            "chargebacks",
            "capital",
            "transfers",
            "fee-prepayments",
            "corrections",
            "topups",
        ]
        nullable_fields = ["pendingBalance", "availableBalance"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GetBalanceReportSelfTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportSelf(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportDocumentationTypedDict(TypedDict):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""
    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportDocumentation(BaseModel):
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    href: str
    r"""The actual URL string."""

    type: str
    r"""The content type of the page or endpoint the URL points to."""


class GetBalanceReportLinksTypedDict(TypedDict):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: NotRequired[GetBalanceReportSelfTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""
    documentation: NotRequired[GetBalanceReportDocumentationTypedDict]
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceReportLinks(BaseModel):
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""

    self_: Annotated[Optional[GetBalanceReportSelf], pydantic.Field(alias="self")] = (
        None
    )
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""

    documentation: Optional[GetBalanceReportDocumentation] = None
    r"""In v2 endpoints, URLs are commonly represented as objects with an `href` and `type` field."""


class GetBalanceReportResponseTypedDict(TypedDict):
    r"""The balance report object."""

    resource: NotRequired[str]
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this
    endpoint.
    """
    balance_id: NotRequired[str]
    r"""The ID of the balance this report is generated for."""
    time_zone: NotRequired[str]
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""
    from_: NotRequired[str]
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time.
    This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 00:00:00 CET and
    onwards.
    """
    until: NotRequired[str]
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET.
    """
    grouping: NotRequired[GroupingResponse]
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by
    status (e.g. `pending`, `available`), then by direction of movement (e.g. moved from pending to available), then
    by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by direction of
    movement, and then again by other sub-groupings where available.

    Both reporting formats will always contain opening and closing amounts that correspond to the start and end dates
    of the report.
    """
    totals: NotRequired[TotalsTypedDict]
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """
    links: NotRequired[GetBalanceReportLinksTypedDict]
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""


class GetBalanceReportResponse(BaseModel):
    r"""The balance report object."""

    resource: Optional[str] = None
    r"""Indicates the response contains a balance report object. Will always contain the string `balance-report` for this
    endpoint.
    """

    balance_id: Annotated[Optional[str], pydantic.Field(alias="balanceId")] = None
    r"""The ID of the balance this report is generated for."""

    time_zone: Annotated[Optional[str], pydantic.Field(alias="timeZone")] = None
    r"""The time zone used for the from and until parameters. Currently only time zone `Europe/Amsterdam` is supported."""

    from_: Annotated[Optional[str], pydantic.Field(alias="from")] = None
    r"""The start date of the report, in `YYYY-MM-DD` format. The from date is 'inclusive', and in Central European Time.
    This means a report with for example `from=2024-01-01` will include movements of 2024-01-01 00:00:00 CET and
    onwards.
    """

    until: Optional[str] = None
    r"""The end date of the report, in `YYYY-MM-DD` format. The until date is 'exclusive', and in Central European Time.
    This means a report with for example `until=2024-02-01` will include movements up until 2024-01-31 23:59:59 CET.
    """

    grouping: Optional[GroupingResponse] = None
    r"""You can retrieve reports in two different formats. With the `status-balances` format, transactions are grouped by
    status (e.g. `pending`, `available`), then by direction of movement (e.g. moved from pending to available), then
    by transaction type, and then by other sub-groupings where available (e.g. payment method).

    With the `transaction-categories` format, transactions are grouped by transaction type, then by direction of
    movement, and then again by other sub-groupings where available.

    Both reporting formats will always contain opening and closing amounts that correspond to the start and end dates
    of the report.
    """

    totals: Optional[Totals] = None
    r"""Totals are grouped according to the chosen grouping rule. The example response should give a good idea of what a
    typical grouping looks like.

    If grouping `status-balances` is chosen, the main grouping is as follows:

    * `pendingBalance` containing an `open`, `pending`, `movedToAvailable`, and `close` sub-group
    * `availableBalance` containing an `open`, `movedFromPending`, `immediatelyAvailable`, and `close` sub-group

    If grouping `transaction-categories` is chosen, the main grouping is as follows:

    * `open` and `close` groups, each containing a `pending` and `available` sub-group
    * Transaction type groups such as `payments`, `refunds`, `chargebacks`, `capital`, `transfers`, `fee-prepayments`, `corrections`, `topups`
    each containing a `pending`, `movedToAvailable`, and
    `immediatelyAvailable` sub-group

    Each sub-group typically has:

    * An `amount` object containing the group's total amount
    * A `count` integer if relevant (for example, counting the number of refunds)
    * A `subtotals` array containing more sub-group objects if applicable
    """

    links: Annotated[
        Optional[GetBalanceReportLinks], pydantic.Field(alias="_links")
    ] = None
    r"""An object with several relevant URLs. Every URL object will contain an `href` and a `type` field."""
