from . import linalg
from . import ma
from ..array import Array

from .numpy_ufuncs import (
    add,
    subtract,
    multiply,
    divide,
    logaddexp,
    logaddexp2,
    true_divide,
    floor_divide,
    negative,
    power,
    float_power,
    remainder,
    mod,
    conj,
    conjugate,
    exp,
    exp2,
    log,
    log2,
    log10,
    log1p,
    expm1,
    sqrt,
    square,
    cbrt,
    reciprocal,
    sin,
    cos,
    tan,
    arcsin,
    arccos,
    arctan,
    arctan2,
    # hypot,
    sinh,
    cosh,
    tanh,
    arcsinh,
    arccosh,
    arctanh,
    deg2rad,
    rad2deg,
    # bitwise_and,
    # bitwise_or,
    # bitwise_xor,
    # bitwise_not,
    greater,
    greater_equal,
    less,
    less_equal,
    not_equal,
    equal,
    logical_and,
    logical_or,
    logical_xor,
    logical_not,
    maximum,
    minimum,
    fmax,
    fmin,
    isfinite,
    isinf,
    isnan,
    signbit,
    copysign,
    nextafter,
    spacing,
    # ldexp,
    fmod,
    floor,
    ceil,
    trunc,
    degrees,
    radians,
    rint,
    fabs,
    sign,
    absolute,
)

from .numpy_functions import np_funcs

globals().update(np_funcs)

array = Array

__all__ = [
    # Array constructor
    "array",
    # Ufuncs
    "add",
    "subtract",
    "multiply",
    "divide",
    "logaddexp",
    "logaddexp2",
    "true_divide",
    "floor_divide",
    "negative",
    "power",
    "float_power",
    "remainder",
    "mod",
    "conj",
    "conjugate",
    "exp",
    "exp2",
    "log",
    "log2",
    "log10",
    "log1p",
    "expm1",
    "sqrt",
    "square",
    "cbrt",
    "reciprocal",
    "sin",
    "cos",
    "tan",
    "arcsin",
    "arccos",
    "arctan",
    "arctan2",
    # "hypot",
    "sinh",
    "cosh",
    "tanh",
    "arcsinh",
    "arccosh",
    "arctanh",
    "deg2rad",
    "rad2deg",
    # "bitwise_and",
    # "bitwise_or",
    # "bitwise_xor",
    # "bitwise_not",
    "greater",
    "greater_equal",
    "less",
    "less_equal",
    "not_equal",
    "equal",
    "logical_and",
    "logical_or",
    "logical_xor",
    "logical_not",
    "maximum",
    "minimum",
    "fmax",
    "fmin",
    "isfinite",
    "isinf",
    "isnan",
    "signbit",
    "copysign",
    "nextafter",
    "spacing",
    # "ldexp",
    "fmod",
    "floor",
    "ceil",
    "trunc",
    "degrees",
    "radians",
    "rint",
    "fabs",
    "sign",
    "absolute",
    # sub-packages
    "linalg",
    "ma",
]

__all__ += list(np_funcs.keys())
