#!/usr/bin/env node

/**
 * Copyright (c) Microsoft Corporation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
"use strict";

var _child_process = require("child_process");

if (process.env.PW_EXPERIMENTAL_TS_ESM) {
  const NODE_OPTIONS = (process.env.NODE_OPTIONS || '') + ` --experimental-loader=${require.resolve('@playwright/test/lib/experimentalLoader')}`;
  const innerProcess = (0, _child_process.fork)(require.resolve('./innerCli'), process.argv.slice(2), {
    env: { ...process.env,
      NODE_OPTIONS
    }
  });
  innerProcess.on('close', code => {
    if (code !== 0 && code !== null) process.exit(code);
  });
} else {
  require('./innerCli');
}