"""
@generated by mypy-protobuf.  Do not edit manually!
isort:skip_file
"""

import builtins
import collections.abc
import google.protobuf.descriptor
import google.protobuf.field_mask_pb2
import google.protobuf.internal.containers
import google.protobuf.message
import google.protobuf.timestamp_pb2
import sift.metadata.v1.metadata_pb2
import typing

DESCRIPTOR: google.protobuf.descriptor.FileDescriptor

@typing.final
class ReportTemplate(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    NAME_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    ARCHIVED_DATE_FIELD_NUMBER: builtins.int
    CREATED_BY_USER_ID_FIELD_NUMBER: builtins.int
    MODIFIED_BY_USER_ID_FIELD_NUMBER: builtins.int
    CREATED_DATE_FIELD_NUMBER: builtins.int
    MODIFIED_DATE_FIELD_NUMBER: builtins.int
    RULES_FIELD_NUMBER: builtins.int
    TAGS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    IS_ARCHIVED_FIELD_NUMBER: builtins.int
    report_template_id: builtins.str
    organization_id: builtins.str
    client_key: builtins.str
    name: builtins.str
    description: builtins.str
    created_by_user_id: builtins.str
    modified_by_user_id: builtins.str
    is_archived: builtins.bool
    """Whether the report template is archived. This is inferred from whether archived_date is set."""
    @property
    def archived_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def created_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def modified_date(self) -> google.protobuf.timestamp_pb2.Timestamp: ...
    @property
    def rules(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportTemplateRule]: ...
    @property
    def tags(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportTemplateTag]: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]: ...
    def __init__(
        self,
        *,
        report_template_id: builtins.str = ...,
        organization_id: builtins.str = ...,
        client_key: builtins.str | None = ...,
        name: builtins.str = ...,
        description: builtins.str | None = ...,
        archived_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        created_by_user_id: builtins.str = ...,
        modified_by_user_id: builtins.str = ...,
        created_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        modified_date: google.protobuf.timestamp_pb2.Timestamp | None = ...,
        rules: collections.abc.Iterable[global___ReportTemplateRule] | None = ...,
        tags: collections.abc.Iterable[global___ReportTemplateTag] | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
        is_archived: builtins.bool = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_description", b"_description", "archived_date", b"archived_date", "client_key", b"client_key", "created_date", b"created_date", "description", b"description", "modified_date", b"modified_date"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_archived_date", b"_archived_date", "_client_key", b"_client_key", "_description", b"_description", "archived_date", b"archived_date", "client_key", b"client_key", "created_by_user_id", b"created_by_user_id", "created_date", b"created_date", "description", b"description", "is_archived", b"is_archived", "metadata", b"metadata", "modified_by_user_id", b"modified_by_user_id", "modified_date", b"modified_date", "name", b"name", "organization_id", b"organization_id", "report_template_id", b"report_template_id", "rules", b"rules", "tags", b"tags"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_archived_date", b"_archived_date"]) -> typing.Literal["archived_date"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...

global___ReportTemplate = ReportTemplate

@typing.final
class ReportTemplateRule(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_ID_FIELD_NUMBER: builtins.int
    RULE_VERSION_ID_FIELD_NUMBER: builtins.int
    RULE_VERSION_NUMBER_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    rule_id: builtins.str
    rule_version_id: builtins.str
    rule_version_number: builtins.int
    client_key: builtins.str
    def __init__(
        self,
        *,
        rule_id: builtins.str = ...,
        rule_version_id: builtins.str = ...,
        rule_version_number: builtins.int = ...,
        client_key: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "rule_id", b"rule_id", "rule_version_id", b"rule_version_id", "rule_version_number", b"rule_version_number"]) -> None: ...

global___ReportTemplateRule = ReportTemplateRule

@typing.final
class ReportTemplateTag(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    TAG_NAME_FIELD_NUMBER: builtins.int
    tag_name: builtins.str
    def __init__(
        self,
        *,
        tag_name: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["tag_name", b"tag_name"]) -> None: ...

global___ReportTemplateTag = ReportTemplateTag

@typing.final
class GetReportTemplateRequest(google.protobuf.message.Message):
    """The request for a call to `ReportTemplateService_GetReportTemplate` to retrieve a report template.
    If `report_template_id` is provided then all other arguments will be ignored. The argument `report_template_id`
    should not be used together with `client_key`. The `organization_id` argument is only required
    if using `client_key` and the user belongs to multiple organizations.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_ID_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    report_template_id: builtins.str
    client_key: builtins.str
    organization_id: builtins.str
    def __init__(
        self,
        *,
        report_template_id: builtins.str = ...,
        client_key: builtins.str = ...,
        organization_id: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["client_key", b"client_key", "organization_id", b"organization_id", "report_template_id", b"report_template_id"]) -> None: ...

global___GetReportTemplateRequest = GetReportTemplateRequest

@typing.final
class GetReportTemplateResponse(google.protobuf.message.Message):
    """The request of a call to `ReportTemplateService_GetReportTemplate` to retrieve a report template."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def report_template(self) -> global___ReportTemplate: ...
    def __init__(
        self,
        *,
        report_template: global___ReportTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["report_template", b"report_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["report_template", b"report_template"]) -> None: ...

global___GetReportTemplateResponse = GetReportTemplateResponse

@typing.final
class CreateReportTemplateRequest(google.protobuf.message.Message):
    """The request of a call to `ReportTemplateService_CreateReportTemplate` to create a report template."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    NAME_FIELD_NUMBER: builtins.int
    CLIENT_KEY_FIELD_NUMBER: builtins.int
    DESCRIPTION_FIELD_NUMBER: builtins.int
    TAG_NAMES_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    RULE_IDS_FIELD_NUMBER: builtins.int
    RULE_CLIENT_KEYS_FIELD_NUMBER: builtins.int
    METADATA_FIELD_NUMBER: builtins.int
    name: builtins.str
    client_key: builtins.str
    description: builtins.str
    organization_id: builtins.str
    """`organization_id` is only required if your user belongs to multiple organizations"""
    @property
    def tag_names(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    @property
    def rule_ids(self) -> global___CreateReportTemplateRequestRuleIds: ...
    @property
    def rule_client_keys(self) -> global___CreateReportTemplateRequestClientKeys: ...
    @property
    def metadata(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[sift.metadata.v1.metadata_pb2.MetadataValue]: ...
    def __init__(
        self,
        *,
        name: builtins.str = ...,
        client_key: builtins.str | None = ...,
        description: builtins.str | None = ...,
        tag_names: collections.abc.Iterable[builtins.str] | None = ...,
        organization_id: builtins.str = ...,
        rule_ids: global___CreateReportTemplateRequestRuleIds | None = ...,
        rule_client_keys: global___CreateReportTemplateRequestClientKeys | None = ...,
        metadata: collections.abc.Iterable[sift.metadata.v1.metadata_pb2.MetadataValue] | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["_client_key", b"_client_key", "_description", b"_description", "client_key", b"client_key", "description", b"description", "rule_client_keys", b"rule_client_keys", "rule_identifiers", b"rule_identifiers", "rule_ids", b"rule_ids"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["_client_key", b"_client_key", "_description", b"_description", "client_key", b"client_key", "description", b"description", "metadata", b"metadata", "name", b"name", "organization_id", b"organization_id", "rule_client_keys", b"rule_client_keys", "rule_identifiers", b"rule_identifiers", "rule_ids", b"rule_ids", "tag_names", b"tag_names"]) -> None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_client_key", b"_client_key"]) -> typing.Literal["client_key"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["_description", b"_description"]) -> typing.Literal["description"] | None: ...
    @typing.overload
    def WhichOneof(self, oneof_group: typing.Literal["rule_identifiers", b"rule_identifiers"]) -> typing.Literal["rule_ids", "rule_client_keys"] | None: ...

global___CreateReportTemplateRequest = CreateReportTemplateRequest

@typing.final
class CreateReportTemplateRequestRuleIds(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_IDS_FIELD_NUMBER: builtins.int
    @property
    def rule_ids(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_ids: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_ids", b"rule_ids"]) -> None: ...

global___CreateReportTemplateRequestRuleIds = CreateReportTemplateRequestRuleIds

@typing.final
class CreateReportTemplateRequestClientKeys(google.protobuf.message.Message):
    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    RULE_CLIENT_KEYS_FIELD_NUMBER: builtins.int
    @property
    def rule_client_keys(self) -> google.protobuf.internal.containers.RepeatedScalarFieldContainer[builtins.str]: ...
    def __init__(
        self,
        *,
        rule_client_keys: collections.abc.Iterable[builtins.str] | None = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["rule_client_keys", b"rule_client_keys"]) -> None: ...

global___CreateReportTemplateRequestClientKeys = CreateReportTemplateRequestClientKeys

@typing.final
class CreateReportTemplateResponse(google.protobuf.message.Message):
    """The response of a call to `ReportTemplateService_CreateReportTemplate` to create a report template."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def report_template(self) -> global___ReportTemplate: ...
    def __init__(
        self,
        *,
        report_template: global___ReportTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["report_template", b"report_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["report_template", b"report_template"]) -> None: ...

global___CreateReportTemplateResponse = CreateReportTemplateResponse

@typing.final
class ListReportTemplatesRequest(google.protobuf.message.Message):
    """The request for a call to `ReportTemplateService_ListReportTemplates` to retrieve report templates."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    PAGE_SIZE_FIELD_NUMBER: builtins.int
    PAGE_TOKEN_FIELD_NUMBER: builtins.int
    FILTER_FIELD_NUMBER: builtins.int
    ORGANIZATION_ID_FIELD_NUMBER: builtins.int
    INCLUDE_ARCHIVED_FIELD_NUMBER: builtins.int
    ORDER_BY_FIELD_NUMBER: builtins.int
    page_size: builtins.int
    """The maximum number of report templates to return. The service may return fewer than this value.
    If unspecified, at most 50 report templates will be returned. The maximum value is 1000; values above
    1000 will be coerced to 1000. Optional.
    """
    page_token: builtins.str
    """A page token, received from a previous `ListReportTemplates` call.
    Provide this to retrieve the subsequent page.
    When paginating, all other parameters provided to `ListReportTemplates` must match
    the call that provided the page token. Optional.
    """
    filter: builtins.str
    """A [Common Expression Language (CEL)](https://github.com/google/cel-spec) filter string.
    Available fields to filter by are `report_template_id`, `tag_id`, `tag_name`, `client_key`, `metadata`, `name` and 'is_archived'.
    For further information about how to use CELs, please refer to [this guide](https://github.com/google/cel-spec/blob/master/doc/langdef.md#standard-definitions).
    For more information about the fields used for filtering, please refer to [this definition](/docs/api/grpc/protocol-buffers/report_templates#report_template). Optional.
    """
    organization_id: builtins.str
    """This field is only required if your user belongs to multiple organizations."""
    include_archived: builtins.bool
    """Deprecated. Use `filter` instead."""
    order_by: builtins.str
    """How to order the retrieved report templates. Formatted as a comma-separated string i.e. "FIELD_NAME[ desc],...".
    Available fields to order_by are `created_date` and `modified_date`.
    If left empty, items are ordered by `created_date` in descending order (newest-first).
    For more information about the format of this field, read [this](https://google.aip.dev/132#ordering)
    Example: "created_date desc,modified_date"
    """
    def __init__(
        self,
        *,
        page_size: builtins.int = ...,
        page_token: builtins.str = ...,
        filter: builtins.str = ...,
        organization_id: builtins.str = ...,
        include_archived: builtins.bool = ...,
        order_by: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["filter", b"filter", "include_archived", b"include_archived", "order_by", b"order_by", "organization_id", b"organization_id", "page_size", b"page_size", "page_token", b"page_token"]) -> None: ...

global___ListReportTemplatesRequest = ListReportTemplatesRequest

@typing.final
class ListReportTemplatesResponse(google.protobuf.message.Message):
    """The response of a call to `ReportTemplateService_ListReportTemplatesResponse`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATES_FIELD_NUMBER: builtins.int
    NEXT_PAGE_TOKEN_FIELD_NUMBER: builtins.int
    next_page_token: builtins.str
    @property
    def report_templates(self) -> google.protobuf.internal.containers.RepeatedCompositeFieldContainer[global___ReportTemplate]: ...
    def __init__(
        self,
        *,
        report_templates: collections.abc.Iterable[global___ReportTemplate] | None = ...,
        next_page_token: builtins.str = ...,
    ) -> None: ...
    def ClearField(self, field_name: typing.Literal["next_page_token", b"next_page_token", "report_templates", b"report_templates"]) -> None: ...

global___ListReportTemplatesResponse = ListReportTemplatesResponse

@typing.final
class UpdateReportTemplateRequest(google.protobuf.message.Message):
    """The request for a call to `ReportTemplateService_UpdateReportTemplate` to update a report template. When updating
    tags or rules, the update will perform a full replace. Additionally, when updating rules, only the rule ID or the rule client key
    is required, but it is okay to provide both. If some rules contain only client keys and others only rule IDs, they will be consolidated.
    """

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_FIELD_NUMBER: builtins.int
    UPDATE_MASK_FIELD_NUMBER: builtins.int
    @property
    def report_template(self) -> global___ReportTemplate:
        """The report template to update."""

    @property
    def update_mask(self) -> google.protobuf.field_mask_pb2.FieldMask:
        """The list of fields to be updated. The fields available to be updated are `name`, `archived_date`, `is_archived`, `description`, `tags`, `rules`, and `metadata`."""

    def __init__(
        self,
        *,
        report_template: global___ReportTemplate | None = ...,
        update_mask: google.protobuf.field_mask_pb2.FieldMask | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["report_template", b"report_template", "update_mask", b"update_mask"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["report_template", b"report_template", "update_mask", b"update_mask"]) -> None: ...

global___UpdateReportTemplateRequest = UpdateReportTemplateRequest

@typing.final
class UpdateReportTemplateResponse(google.protobuf.message.Message):
    """The response of a call to `ReportTemplateService_UpdateReportTemplate`."""

    DESCRIPTOR: google.protobuf.descriptor.Descriptor

    REPORT_TEMPLATE_FIELD_NUMBER: builtins.int
    @property
    def report_template(self) -> global___ReportTemplate: ...
    def __init__(
        self,
        *,
        report_template: global___ReportTemplate | None = ...,
    ) -> None: ...
    def HasField(self, field_name: typing.Literal["report_template", b"report_template"]) -> builtins.bool: ...
    def ClearField(self, field_name: typing.Literal["report_template", b"report_template"]) -> None: ...

global___UpdateReportTemplateResponse = UpdateReportTemplateResponse
