# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetUserResult',
    'AwaitableGetUserResult',
    'get_user',
    'get_user_output',
]

@pulumi.output_type
class GetUserResult:
    """
    A collection of values returned by getUser.
    """
    def __init__(__self__, email=None, id=None, name=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def email(self) -> Optional[str]:
        return pulumi.get(self, "email")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        return pulumi.get(self, "name")


class AwaitableGetUserResult(GetUserResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetUserResult(
            email=self.email,
            id=self.id,
            name=self.name)


def get_user(email: Optional[str] = None,
             name: Optional[str] = None,
             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetUserResult:
    """
    Use this data source to get information about a user for use in other
    resources.

    ## Required scopes

    This resource requires the following scopes:

    - [users:read](https://api.slack.com/scopes/users:read)
    - [users:read.email](https://api.slack.com/scopes/users:read.email)

    The Slack API methods used by the resource are:

    - [users.lookupByEmail](https://api.slack.com/methods/users.lookupByEmail)
    - [users.list](https://api.slack.com/methods/users.list)

    If you get `missing_scope` errors while using this resource check the scopes against
    the documentation for the methods above.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_slack as slack

    by_name = slack.get_user(name="my-user")
    by_email = slack.get_user(email="my-user@example.com")
    ```


    :param str email: The email of the user
           
           The data source expects exactly one of these fields, you can't set both.
    :param str name: The name of the user
    """
    __args__ = dict()
    __args__['email'] = email
    __args__['name'] = name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('slack:index/getUser:getUser', __args__, opts=opts, typ=GetUserResult).value

    return AwaitableGetUserResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        name=pulumi.get(__ret__, 'name'))


@_utilities.lift_output_func(get_user)
def get_user_output(email: Optional[pulumi.Input[Optional[str]]] = None,
                    name: Optional[pulumi.Input[Optional[str]]] = None,
                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetUserResult]:
    """
    Use this data source to get information about a user for use in other
    resources.

    ## Required scopes

    This resource requires the following scopes:

    - [users:read](https://api.slack.com/scopes/users:read)
    - [users:read.email](https://api.slack.com/scopes/users:read.email)

    The Slack API methods used by the resource are:

    - [users.lookupByEmail](https://api.slack.com/methods/users.lookupByEmail)
    - [users.list](https://api.slack.com/methods/users.list)

    If you get `missing_scope` errors while using this resource check the scopes against
    the documentation for the methods above.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_slack as slack

    by_name = slack.get_user(name="my-user")
    by_email = slack.get_user(email="my-user@example.com")
    ```


    :param str email: The email of the user
           
           The data source expects exactly one of these fields, you can't set both.
    :param str name: The name of the user
    """
    ...
