class ResponseCode:
    OK = 0
    INVALID_TRANSACTION = 1
    PAYER_ACCOUNT_NOT_FOUND = 2
    INVALID_NODE_ACCOUNT = 3
    TRANSACTION_EXPIRED = 4
    INVALID_TRANSACTION_START = 5
    INVALID_TRANSACTION_DURATION = 6
    INVALID_SIGNATURE = 7
    MEMO_TOO_LONG = 8
    INSUFFICIENT_TX_FEE = 9
    INSUFFICIENT_PAYER_BALANCE = 10
    DUPLICATE_TRANSACTION = 11
    BUSY = 12
    NOT_SUPPORTED = 13
    INVALID_FILE_ID = 14
    INVALID_ACCOUNT_ID = 15
    INVALID_CONTRACT_ID = 16
    INVALID_TRANSACTION_ID = 17
    RECEIPT_NOT_FOUND = 18
    RECORD_NOT_FOUND = 19
    INVALID_SOLIDITY_ID = 20
    UNKNOWN = 21
    SUCCESS = 22
    FAIL_INVALID = 23
    FAIL_FEE = 24
    FAIL_BALANCE = 25
    KEY_REQUIRED = 26
    BAD_ENCODING = 27
    INSUFFICIENT_ACCOUNT_BALANCE = 28
    INVALID_SOLIDITY_ADDRESS = 29
    INSUFFICIENT_GAS = 30
    CONTRACT_SIZE_LIMIT_EXCEEDED = 31
    LOCAL_CALL_MODIFICATION_EXCEPTION = 32
    CONTRACT_REVERT_EXECUTED = 33
    CONTRACT_EXECUTION_EXCEPTION = 34
    INVALID_RECEIVING_NODE_ACCOUNT = 35
    MISSING_QUERY_HEADER = 36
    ACCOUNT_UPDATE_FAILED = 37
    INVALID_KEY_ENCODING = 38
    NULL_SOLIDITY_ADDRESS = 39
    CONTRACT_UPDATE_FAILED = 40
    INVALID_QUERY_HEADER = 41
    INVALID_FEE_SUBMITTED = 42
    INVALID_PAYER_SIGNATURE = 43
    KEY_NOT_PROVIDED = 44
    INVALID_EXPIRATION_TIME = 45
    NO_WACL_KEY = 46
    FILE_CONTENT_EMPTY = 47
    INVALID_ACCOUNT_AMOUNTS = 48
    EMPTY_TRANSACTION_BODY = 49
    INVALID_TRANSACTION_BODY = 50
    INVALID_SIGNATURE_TYPE_MISMATCHING_KEY = 51
    INVALID_SIGNATURE_COUNT_MISMATCHING_KEY = 52
    EMPTY_LIVE_HASH_BODY = 53
    EMPTY_LIVE_HASH = 54
    EMPTY_LIVE_HASH_KEYS = 55
    INVALID_LIVE_HASH_SIZE = 56
    EMPTY_QUERY_BODY = 57
    EMPTY_LIVE_HASH_QUERY = 58
    LIVE_HASH_NOT_FOUND = 59
    ACCOUNT_ID_DOES_NOT_EXIST = 60
    LIVE_HASH_ALREADY_EXISTS = 61
    INVALID_FILE_WACL = 62
    SERIALIZATION_FAILED = 63
    TRANSACTION_OVERSIZE = 64
    TRANSACTION_TOO_MANY_LAYERS = 65
    CONTRACT_DELETED = 66
    PLATFORM_NOT_ACTIVE = 67
    KEY_PREFIX_MISMATCH = 68
    PLATFORM_TRANSACTION_NOT_CREATED = 69
    INVALID_RENEWAL_PERIOD = 70
    INVALID_PAYER_ACCOUNT_ID = 71
    ACCOUNT_DELETED = 72
    FILE_DELETED = 73
    ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS = 74
    SETTING_NEGATIVE_ACCOUNT_BALANCE = 75
    OBTAINER_REQUIRED = 76
    OBTAINER_SAME_CONTRACT_ID = 77
    OBTAINER_DOES_NOT_EXIST = 78
    MODIFYING_IMMUTABLE_CONTRACT = 79
    FILE_SYSTEM_EXCEPTION = 80
    AUTORENEW_DURATION_NOT_IN_RANGE = 81
    ERROR_DECODING_BYTESTRING = 82
    CONTRACT_FILE_EMPTY = 83
    CONTRACT_BYTECODE_EMPTY = 84
    INVALID_INITIAL_BALANCE = 85
    INVALID_RECEIVE_RECORD_THRESHOLD = 86   # [Deprecated]
    INVALID_SEND_RECORD_THRESHOLD = 87      # [Deprecated]
    ACCOUNT_IS_NOT_GENESIS_ACCOUNT = 88
    PAYER_ACCOUNT_UNAUTHORIZED = 89
    INVALID_FREEZE_TRANSACTION_BODY = 90
    FREEZE_TRANSACTION_BODY_NOT_FOUND = 91
    TRANSFER_LIST_SIZE_LIMIT_EXCEEDED = 92
    RESULT_SIZE_LIMIT_EXCEEDED = 93
    NOT_SPECIAL_ACCOUNT = 94
    CONTRACT_NEGATIVE_GAS = 95
    CONTRACT_NEGATIVE_VALUE = 96
    INVALID_FEE_FILE = 97
    INVALID_EXCHANGE_RATE_FILE = 98
    INSUFFICIENT_LOCAL_CALL_GAS = 99
    ENTITY_NOT_ALLOWED_TO_DELETE = 100
    AUTHORIZATION_FAILED = 101
    FILE_UPLOADED_PROTO_INVALID = 102
    FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK = 103
    FEE_SCHEDULE_FILE_PART_UPLOADED = 104
    EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED = 105
    MAX_CONTRACT_STORAGE_EXCEEDED = 106
    TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT = 107
    TOTAL_LEDGER_BALANCE_INVALID = 108
    EXPIRATION_REDUCTION_NOT_ALLOWED = 110
    MAX_GAS_LIMIT_EXCEEDED = 111
    MAX_FILE_SIZE_EXCEEDED = 112

    INVALID_TOPIC_ID = 150
    INVALID_ADMIN_KEY = 155
    INVALID_SUBMIT_KEY = 156
    UNAUTHORIZED = 157
    INVALID_TOPIC_MESSAGE = 158
    INVALID_AUTORENEW_ACCOUNT = 159
    AUTORENEW_ACCOUNT_NOT_ALLOWED = 160
    TOPIC_EXPIRED = 162
    INVALID_CHUNK_NUMBER = 163
    INVALID_CHUNK_TRANSACTION_ID = 164
    ACCOUNT_FROZEN_FOR_TOKEN = 165
    TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED = 166
    INVALID_TOKEN_ID = 167
    INVALID_TOKEN_DECIMALS = 168
    INVALID_TOKEN_INITIAL_SUPPLY = 169
    INVALID_TREASURY_ACCOUNT_FOR_TOKEN = 170
    INVALID_TOKEN_SYMBOL = 171
    TOKEN_HAS_NO_FREEZE_KEY = 172
    TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN = 173
    MISSING_TOKEN_SYMBOL = 174
    TOKEN_SYMBOL_TOO_LONG = 175
    ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN = 176
    TOKEN_HAS_NO_KYC_KEY = 177
    INSUFFICIENT_TOKEN_BALANCE = 178
    TOKEN_WAS_DELETED = 179
    TOKEN_HAS_NO_SUPPLY_KEY = 180
    TOKEN_HAS_NO_WIPE_KEY = 181
    INVALID_TOKEN_MINT_AMOUNT = 182
    INVALID_TOKEN_BURN_AMOUNT = 183
    TOKEN_NOT_ASSOCIATED_TO_ACCOUNT = 184
    CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT = 185
    INVALID_KYC_KEY = 186
    INVALID_WIPE_KEY = 187
    INVALID_FREEZE_KEY = 188
    INVALID_SUPPLY_KEY = 189
    MISSING_TOKEN_NAME = 190
    TOKEN_NAME_TOO_LONG = 191
    INVALID_WIPING_AMOUNT = 192
    TOKEN_IS_IMMUTABLE = 193
    TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT = 194
    TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES = 195
    ACCOUNT_IS_TREASURY = 196
    TOKEN_ID_REPEATED_IN_TOKEN_LIST = 197
    TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED = 198
    EMPTY_TOKEN_TRANSFER_BODY = 199
    EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS = 200
    INVALID_SCHEDULE_ID = 201
    SCHEDULE_IS_IMMUTABLE = 202
    INVALID_SCHEDULE_PAYER_ID = 203
    INVALID_SCHEDULE_ACCOUNT_ID = 204
    NO_NEW_VALID_SIGNATURES = 205
    UNRESOLVABLE_REQUIRED_SIGNERS = 206
    SCHEDULED_TRANSACTION_NOT_IN_WHITELIST = 207
    SOME_SIGNATURES_WERE_INVALID = 208
    TRANSACTION_ID_FIELD_NOT_ALLOWED = 209
    IDENTICAL_SCHEDULE_ALREADY_CREATED = 210
    INVALID_ZERO_BYTE_IN_STRING = 211
    SCHEDULE_ALREADY_DELETED = 212
    SCHEDULE_ALREADY_EXECUTED = 213
    MESSAGE_SIZE_TOO_LARGE = 214
    OPERATION_REPEATED_IN_BUCKET_GROUPS = 215
    BUCKET_CAPACITY_OVERFLOW = 216
    NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION = 217
    BUCKET_HAS_NO_THROTTLE_GROUPS = 218
    THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC = 219
    SUCCESS_BUT_MISSING_EXPECTED_OPERATION = 220
    UNPARSEABLE_THROTTLE_DEFINITIONS = 221
    INVALID_THROTTLE_DEFINITIONS = 222
    ACCOUNT_EXPIRED_AND_PENDING_REMOVAL = 223
    INVALID_TOKEN_MAX_SUPPLY = 224
    INVALID_TOKEN_NFT_SERIAL_NUMBER = 225
    INVALID_NFT_ID = 226
    METADATA_TOO_LONG = 227
    BATCH_SIZE_LIMIT_EXCEEDED = 228
    INVALID_QUERY_RANGE = 229
    FRACTION_DIVIDES_BY_ZERO = 230
    INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE = 231
    CUSTOM_FEES_LIST_TOO_LONG = 232
    INVALID_CUSTOM_FEE_COLLECTOR = 233
    INVALID_TOKEN_ID_IN_CUSTOM_FEES = 234
    TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR = 235
    TOKEN_MAX_SUPPLY_REACHED = 236
    SENDER_DOES_NOT_OWN_NFT_SERIAL_NO = 237
    CUSTOM_FEE_NOT_FULLY_SPECIFIED = 238
    CUSTOM_FEE_MUST_BE_POSITIVE = 239
    TOKEN_HAS_NO_FEE_SCHEDULE_KEY = 240
    CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE = 241
    ROYALTY_FRACTION_CANNOT_EXCEED_ONE = 242
    FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT = 243
    CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES = 244
    CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON = 245
    CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON = 246
    INVALID_CUSTOM_FEE_SCHEDULE_KEY = 247
    INVALID_TOKEN_MINT_METADATA = 248
    INVALID_TOKEN_BURN_METADATA = 249
    CURRENT_TREASURY_STILL_OWNS_NFTS = 250
    ACCOUNT_STILL_OWNS_NFTS = 251
    TREASURY_MUST_OWN_BURNED_NFT = 252
    ACCOUNT_DOES_NOT_OWN_WIPED_NFT = 253
    ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON = 254
    MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED = 255
    PAYER_ACCOUNT_DELETED = 256
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH = 257
    CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS = 258
    INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE = 259
    SERIAL_NUMBER_LIMIT_REACHED = 260
    CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE = 261
    NO_REMAINING_AUTOMATIC_ASSOCIATIONS = 262
    EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT = 263
    REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT = 264
    TOKEN_IS_PAUSED = 265
    TOKEN_HAS_NO_PAUSE_KEY = 266
    INVALID_PAUSE_KEY = 267
    FREEZE_UPDATE_FILE_DOES_NOT_EXIST = 268
    FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH = 269
    NO_UPGRADE_HAS_BEEN_PREPARED = 270
    NO_FREEZE_IS_SCHEDULED = 271
    UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE = 272
    FREEZE_START_TIME_MUST_BE_FUTURE = 273
    PREPARED_UPDATE_FILE_IS_IMMUTABLE = 274
    FREEZE_ALREADY_SCHEDULED = 275
    FREEZE_UPGRADE_IN_PROGRESS = 276
    UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED = 277
    UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED = 278
    CONSENSUS_GAS_EXHAUSTED = 279
    REVERTED_SUCCESS = 280
    MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED = 281
    INVALID_ALIAS_KEY = 282
    UNEXPECTED_TOKEN_DECIMALS = 283
    INVALID_PROXY_ACCOUNT_ID = 284         # [Deprecated]
    INVALID_TRANSFER_ACCOUNT_ID = 285
    INVALID_FEE_COLLECTOR_ACCOUNT_ID = 286
    ALIAS_IS_IMMUTABLE = 287
    SPENDER_ACCOUNT_SAME_AS_OWNER = 288
    AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY = 289
    NEGATIVE_ALLOWANCE_AMOUNT = 290
    CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON = 291   # [Deprecated]
    SPENDER_DOES_NOT_HAVE_ALLOWANCE = 292
    AMOUNT_EXCEEDS_ALLOWANCE = 293
    MAX_ALLOWANCES_EXCEEDED = 294
    EMPTY_ALLOWANCES = 295
    SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES = 296   # [Deprecated]
    REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES = 297   # [Deprecated]
    FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES = 298
    NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES = 299
    INVALID_ALLOWANCE_OWNER_ID = 300
    INVALID_ALLOWANCE_SPENDER_ID = 301
    REPEATED_ALLOWANCES_TO_DELETE = 302     # [Deprecated]
    INVALID_DELEGATING_SPENDER = 303
    DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL = 304
    DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL = 305
    SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE = 306
    SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME = 307
    SCHEDULE_FUTURE_THROTTLE_EXCEEDED = 308
    SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED = 309
    INVALID_ETHEREUM_TRANSACTION = 310
    WRONG_CHAIN_ID = 311
    WRONG_NONCE = 312
    ACCESS_LIST_UNSUPPORTED = 313
    SCHEDULE_PENDING_EXPIRATION = 314
    CONTRACT_IS_TOKEN_TREASURY = 315
    CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES = 316
    CONTRACT_EXPIRED_AND_PENDING_REMOVAL = 317
    CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT = 318
    PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION = 319
    PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED = 320
    SELF_STAKING_IS_NOT_ALLOWED = 321
    INVALID_STAKING_ID = 322
    STAKING_NOT_ENABLED = 323
    INVALID_PRNG_RANGE = 324
    MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED = 325
    INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE = 326
    INSUFFICIENT_BALANCES_FOR_STORAGE_RENT = 327
    MAX_CHILD_RECORDS_EXCEEDED = 328
    INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES = 329

    _code_to_name = {
        0: "OK",
        1: "INVALID_TRANSACTION",
        2: "PAYER_ACCOUNT_NOT_FOUND",
        3: "INVALID_NODE_ACCOUNT",
        4: "TRANSACTION_EXPIRED",
        5: "INVALID_TRANSACTION_START",
        6: "INVALID_TRANSACTION_DURATION",
        7: "INVALID_SIGNATURE",
        8: "MEMO_TOO_LONG",
        9: "INSUFFICIENT_TX_FEE",
        10: "INSUFFICIENT_PAYER_BALANCE",
        11: "DUPLICATE_TRANSACTION",
        12: "BUSY",
        13: "NOT_SUPPORTED",
        14: "INVALID_FILE_ID",
        15: "INVALID_ACCOUNT_ID",
        16: "INVALID_CONTRACT_ID",
        17: "INVALID_TRANSACTION_ID",
        18: "RECEIPT_NOT_FOUND",
        19: "RECORD_NOT_FOUND",
        20: "INVALID_SOLIDITY_ID",
        21: "UNKNOWN",
        22: "SUCCESS",
        23: "FAIL_INVALID",
        24: "FAIL_FEE",
        25: "FAIL_BALANCE",
        26: "KEY_REQUIRED",
        27: "BAD_ENCODING",
        28: "INSUFFICIENT_ACCOUNT_BALANCE",
        29: "INVALID_SOLIDITY_ADDRESS",
        30: "INSUFFICIENT_GAS",
        31: "CONTRACT_SIZE_LIMIT_EXCEEDED",
        32: "LOCAL_CALL_MODIFICATION_EXCEPTION",
        33: "CONTRACT_REVERT_EXECUTED",
        34: "CONTRACT_EXECUTION_EXCEPTION",
        35: "INVALID_RECEIVING_NODE_ACCOUNT",
        36: "MISSING_QUERY_HEADER",
        37: "ACCOUNT_UPDATE_FAILED",
        38: "INVALID_KEY_ENCODING",
        39: "NULL_SOLIDITY_ADDRESS",
        40: "CONTRACT_UPDATE_FAILED",
        41: "INVALID_QUERY_HEADER",
        42: "INVALID_FEE_SUBMITTED",
        43: "INVALID_PAYER_SIGNATURE",
        44: "KEY_NOT_PROVIDED",
        45: "INVALID_EXPIRATION_TIME",
        46: "NO_WACL_KEY",
        47: "FILE_CONTENT_EMPTY",
        48: "INVALID_ACCOUNT_AMOUNTS",
        49: "EMPTY_TRANSACTION_BODY",
        50: "INVALID_TRANSACTION_BODY",
        51: "INVALID_SIGNATURE_TYPE_MISMATCHING_KEY",
        52: "INVALID_SIGNATURE_COUNT_MISMATCHING_KEY",
        53: "EMPTY_LIVE_HASH_BODY",
        54: "EMPTY_LIVE_HASH",
        55: "EMPTY_LIVE_HASH_KEYS",
        56: "INVALID_LIVE_HASH_SIZE",
        57: "EMPTY_QUERY_BODY",
        58: "EMPTY_LIVE_HASH_QUERY",
        59: "LIVE_HASH_NOT_FOUND",
        60: "ACCOUNT_ID_DOES_NOT_EXIST",
        61: "LIVE_HASH_ALREADY_EXISTS",
        62: "INVALID_FILE_WACL",
        63: "SERIALIZATION_FAILED",
        64: "TRANSACTION_OVERSIZE",
        65: "TRANSACTION_TOO_MANY_LAYERS",
        66: "CONTRACT_DELETED",
        67: "PLATFORM_NOT_ACTIVE",
        68: "KEY_PREFIX_MISMATCH",
        69: "PLATFORM_TRANSACTION_NOT_CREATED",
        70: "INVALID_RENEWAL_PERIOD",
        71: "INVALID_PAYER_ACCOUNT_ID",
        72: "ACCOUNT_DELETED",
        73: "FILE_DELETED",
        74: "ACCOUNT_REPEATED_IN_ACCOUNT_AMOUNTS",
        75: "SETTING_NEGATIVE_ACCOUNT_BALANCE",
        76: "OBTAINER_REQUIRED",
        77: "OBTAINER_SAME_CONTRACT_ID",
        78: "OBTAINER_DOES_NOT_EXIST",
        79: "MODIFYING_IMMUTABLE_CONTRACT",
        80: "FILE_SYSTEM_EXCEPTION",
        81: "AUTORENEW_DURATION_NOT_IN_RANGE",
        82: "ERROR_DECODING_BYTESTRING",
        83: "CONTRACT_FILE_EMPTY",
        84: "CONTRACT_BYTECODE_EMPTY",
        85: "INVALID_INITIAL_BALANCE",
        86: "INVALID_RECEIVE_RECORD_THRESHOLD",  # [Deprecated]
        87: "INVALID_SEND_RECORD_THRESHOLD",     # [Deprecated]
        88: "ACCOUNT_IS_NOT_GENESIS_ACCOUNT",
        89: "PAYER_ACCOUNT_UNAUTHORIZED",
        90: "INVALID_FREEZE_TRANSACTION_BODY",
        91: "FREEZE_TRANSACTION_BODY_NOT_FOUND",
        92: "TRANSFER_LIST_SIZE_LIMIT_EXCEEDED",
        93: "RESULT_SIZE_LIMIT_EXCEEDED",
        94: "NOT_SPECIAL_ACCOUNT",
        95: "CONTRACT_NEGATIVE_GAS",
        96: "CONTRACT_NEGATIVE_VALUE",
        97: "INVALID_FEE_FILE",
        98: "INVALID_EXCHANGE_RATE_FILE",
        99: "INSUFFICIENT_LOCAL_CALL_GAS",
        100: "ENTITY_NOT_ALLOWED_TO_DELETE",
        101: "AUTHORIZATION_FAILED",
        102: "FILE_UPLOADED_PROTO_INVALID",
        103: "FILE_UPLOADED_PROTO_NOT_SAVED_TO_DISK",
        104: "FEE_SCHEDULE_FILE_PART_UPLOADED",
        105: "EXCHANGE_RATE_CHANGE_LIMIT_EXCEEDED",
        106: "MAX_CONTRACT_STORAGE_EXCEEDED",
        107: "TRANSFER_ACCOUNT_SAME_AS_DELETE_ACCOUNT",
        108: "TOTAL_LEDGER_BALANCE_INVALID",
        110: "EXPIRATION_REDUCTION_NOT_ALLOWED",
        111: "MAX_GAS_LIMIT_EXCEEDED",
        112: "MAX_FILE_SIZE_EXCEEDED",
        150: "INVALID_TOPIC_ID",
        155: "INVALID_ADMIN_KEY",
        156: "INVALID_SUBMIT_KEY",
        157: "UNAUTHORIZED",
        158: "INVALID_TOPIC_MESSAGE",
        159: "INVALID_AUTORENEW_ACCOUNT",
        160: "AUTORENEW_ACCOUNT_NOT_ALLOWED",
        162: "TOPIC_EXPIRED",
        163: "INVALID_CHUNK_NUMBER",
        164: "INVALID_CHUNK_TRANSACTION_ID",
        165: "ACCOUNT_FROZEN_FOR_TOKEN",
        166: "TOKENS_PER_ACCOUNT_LIMIT_EXCEEDED",
        167: "INVALID_TOKEN_ID",
        168: "INVALID_TOKEN_DECIMALS",
        169: "INVALID_TOKEN_INITIAL_SUPPLY",
        170: "INVALID_TREASURY_ACCOUNT_FOR_TOKEN",
        171: "INVALID_TOKEN_SYMBOL",
        172: "TOKEN_HAS_NO_FREEZE_KEY",
        173: "TRANSFERS_NOT_ZERO_SUM_FOR_TOKEN",
        174: "MISSING_TOKEN_SYMBOL",
        175: "TOKEN_SYMBOL_TOO_LONG",
        176: "ACCOUNT_KYC_NOT_GRANTED_FOR_TOKEN",
        177: "TOKEN_HAS_NO_KYC_KEY",
        178: "INSUFFICIENT_TOKEN_BALANCE",
        179: "TOKEN_WAS_DELETED",
        180: "TOKEN_HAS_NO_SUPPLY_KEY",
        181: "TOKEN_HAS_NO_WIPE_KEY",
        182: "INVALID_TOKEN_MINT_AMOUNT",
        183: "INVALID_TOKEN_BURN_AMOUNT",
        184: "TOKEN_NOT_ASSOCIATED_TO_ACCOUNT",
        185: "CANNOT_WIPE_TOKEN_TREASURY_ACCOUNT",
        186: "INVALID_KYC_KEY",
        187: "INVALID_WIPE_KEY",
        188: "INVALID_FREEZE_KEY",
        189: "INVALID_SUPPLY_KEY",
        190: "MISSING_TOKEN_NAME",
        191: "TOKEN_NAME_TOO_LONG",
        192: "INVALID_WIPING_AMOUNT",
        193: "TOKEN_IS_IMMUTABLE",
        194: "TOKEN_ALREADY_ASSOCIATED_TO_ACCOUNT",
        195: "TRANSACTION_REQUIRES_ZERO_TOKEN_BALANCES",
        196: "ACCOUNT_IS_TREASURY",
        197: "TOKEN_ID_REPEATED_IN_TOKEN_LIST",
        198: "TOKEN_TRANSFER_LIST_SIZE_LIMIT_EXCEEDED",
        199: "EMPTY_TOKEN_TRANSFER_BODY",
        200: "EMPTY_TOKEN_TRANSFER_ACCOUNT_AMOUNTS",
        201: "INVALID_SCHEDULE_ID",
        202: "SCHEDULE_IS_IMMUTABLE",
        203: "INVALID_SCHEDULE_PAYER_ID",
        204: "INVALID_SCHEDULE_ACCOUNT_ID",
        205: "NO_NEW_VALID_SIGNATURES",
        206: "UNRESOLVABLE_REQUIRED_SIGNERS",
        207: "SCHEDULED_TRANSACTION_NOT_IN_WHITELIST",
        208: "SOME_SIGNATURES_WERE_INVALID",
        209: "TRANSACTION_ID_FIELD_NOT_ALLOWED",
        210: "IDENTICAL_SCHEDULE_ALREADY_CREATED",
        211: "INVALID_ZERO_BYTE_IN_STRING",
        212: "SCHEDULE_ALREADY_DELETED",
        213: "SCHEDULE_ALREADY_EXECUTED",
        214: "MESSAGE_SIZE_TOO_LARGE",
        215: "OPERATION_REPEATED_IN_BUCKET_GROUPS",
        216: "BUCKET_CAPACITY_OVERFLOW",
        217: "NODE_CAPACITY_NOT_SUFFICIENT_FOR_OPERATION",
        218: "BUCKET_HAS_NO_THROTTLE_GROUPS",
        219: "THROTTLE_GROUP_HAS_ZERO_OPS_PER_SEC",
        220: "SUCCESS_BUT_MISSING_EXPECTED_OPERATION",
        221: "UNPARSEABLE_THROTTLE_DEFINITIONS",
        222: "INVALID_THROTTLE_DEFINITIONS",
        223: "ACCOUNT_EXPIRED_AND_PENDING_REMOVAL",
        224: "INVALID_TOKEN_MAX_SUPPLY",
        225: "INVALID_TOKEN_NFT_SERIAL_NUMBER",
        226: "INVALID_NFT_ID",
        227: "METADATA_TOO_LONG",
        228: "BATCH_SIZE_LIMIT_EXCEEDED",
        229: "INVALID_QUERY_RANGE",
        230: "FRACTION_DIVIDES_BY_ZERO",
        231: "INSUFFICIENT_PAYER_BALANCE_FOR_CUSTOM_FEE",
        232: "CUSTOM_FEES_LIST_TOO_LONG",
        233: "INVALID_CUSTOM_FEE_COLLECTOR",
        234: "INVALID_TOKEN_ID_IN_CUSTOM_FEES",
        235: "TOKEN_NOT_ASSOCIATED_TO_FEE_COLLECTOR",
        236: "TOKEN_MAX_SUPPLY_REACHED",
        237: "SENDER_DOES_NOT_OWN_NFT_SERIAL_NO",
        238: "CUSTOM_FEE_NOT_FULLY_SPECIFIED",
        239: "CUSTOM_FEE_MUST_BE_POSITIVE",
        240: "TOKEN_HAS_NO_FEE_SCHEDULE_KEY",
        241: "CUSTOM_FEE_OUTSIDE_NUMERIC_RANGE",
        242: "ROYALTY_FRACTION_CANNOT_EXCEED_ONE",
        243: "FRACTIONAL_FEE_MAX_AMOUNT_LESS_THAN_MIN_AMOUNT",
        244: "CUSTOM_SCHEDULE_ALREADY_HAS_NO_FEES",
        245: "CUSTOM_FEE_DENOMINATION_MUST_BE_FUNGIBLE_COMMON",
        246: "CUSTOM_FRACTIONAL_FEE_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON",
        247: "INVALID_CUSTOM_FEE_SCHEDULE_KEY",
        248: "INVALID_TOKEN_MINT_METADATA",
        249: "INVALID_TOKEN_BURN_METADATA",
        250: "CURRENT_TREASURY_STILL_OWNS_NFTS",
        251: "ACCOUNT_STILL_OWNS_NFTS",
        252: "TREASURY_MUST_OWN_BURNED_NFT",
        253: "ACCOUNT_DOES_NOT_OWN_WIPED_NFT",
        254: "ACCOUNT_AMOUNT_TRANSFERS_ONLY_ALLOWED_FOR_FUNGIBLE_COMMON",
        255: "MAX_NFTS_IN_PRICE_REGIME_HAVE_BEEN_MINTED",
        256: "PAYER_ACCOUNT_DELETED",
        257: "CUSTOM_FEE_CHARGING_EXCEEDED_MAX_RECURSION_DEPTH",
        258: "CUSTOM_FEE_CHARGING_EXCEEDED_MAX_ACCOUNT_AMOUNTS",
        259: "INSUFFICIENT_SENDER_ACCOUNT_BALANCE_FOR_CUSTOM_FEE",
        260: "SERIAL_NUMBER_LIMIT_REACHED",
        261: "CUSTOM_ROYALTY_FEE_ONLY_ALLOWED_FOR_NON_FUNGIBLE_UNIQUE",
        262: "NO_REMAINING_AUTOMATIC_ASSOCIATIONS",
        263: "EXISTING_AUTOMATIC_ASSOCIATIONS_EXCEED_GIVEN_LIMIT",
        264: "REQUESTED_NUM_AUTOMATIC_ASSOCIATIONS_EXCEEDS_ASSOCIATION_LIMIT",
        265: "TOKEN_IS_PAUSED",
        266: "TOKEN_HAS_NO_PAUSE_KEY",
        267: "INVALID_PAUSE_KEY",
        268: "FREEZE_UPDATE_FILE_DOES_NOT_EXIST",
        269: "FREEZE_UPDATE_FILE_HASH_DOES_NOT_MATCH",
        270: "NO_UPGRADE_HAS_BEEN_PREPARED",
        271: "NO_FREEZE_IS_SCHEDULED",
        272: "UPDATE_FILE_HASH_CHANGED_SINCE_PREPARE_UPGRADE",
        273: "FREEZE_START_TIME_MUST_BE_FUTURE",
        274: "PREPARED_UPDATE_FILE_IS_IMMUTABLE",
        275: "FREEZE_ALREADY_SCHEDULED",
        276: "FREEZE_UPGRADE_IN_PROGRESS",
        277: "UPDATE_FILE_ID_DOES_NOT_MATCH_PREPARED",
        278: "UPDATE_FILE_HASH_DOES_NOT_MATCH_PREPARED",
        279: "CONSENSUS_GAS_EXHAUSTED",
        280: "REVERTED_SUCCESS",
        281: "MAX_STORAGE_IN_PRICE_REGIME_HAS_BEEN_USED",
        282: "INVALID_ALIAS_KEY",
        283: "UNEXPECTED_TOKEN_DECIMALS",
        284: "INVALID_PROXY_ACCOUNT_ID",  # [Deprecated]
        285: "INVALID_TRANSFER_ACCOUNT_ID",
        286: "INVALID_FEE_COLLECTOR_ACCOUNT_ID",
        287: "ALIAS_IS_IMMUTABLE",
        288: "SPENDER_ACCOUNT_SAME_AS_OWNER",
        289: "AMOUNT_EXCEEDS_TOKEN_MAX_SUPPLY",
        290: "NEGATIVE_ALLOWANCE_AMOUNT",
        291: "CANNOT_APPROVE_FOR_ALL_FUNGIBLE_COMMON",  # [Deprecated]
        292: "SPENDER_DOES_NOT_HAVE_ALLOWANCE",
        293: "AMOUNT_EXCEEDS_ALLOWANCE",
        294: "MAX_ALLOWANCES_EXCEEDED",
        295: "EMPTY_ALLOWANCES",
        296: "SPENDER_ACCOUNT_REPEATED_IN_ALLOWANCES",  # [Deprecated]
        297: "REPEATED_SERIAL_NUMS_IN_NFT_ALLOWANCES",  # [Deprecated]
        298: "FUNGIBLE_TOKEN_IN_NFT_ALLOWANCES",
        299: "NFT_IN_FUNGIBLE_TOKEN_ALLOWANCES",
        300: "INVALID_ALLOWANCE_OWNER_ID",
        301: "INVALID_ALLOWANCE_SPENDER_ID",
        302: "REPEATED_ALLOWANCES_TO_DELETE",  # [Deprecated]
        303: "INVALID_DELEGATING_SPENDER",
        304: "DELEGATING_SPENDER_CANNOT_GRANT_APPROVE_FOR_ALL",
        305: "DELEGATING_SPENDER_DOES_NOT_HAVE_APPROVE_FOR_ALL",
        306: "SCHEDULE_EXPIRATION_TIME_TOO_FAR_IN_FUTURE",
        307: "SCHEDULE_EXPIRATION_TIME_MUST_BE_HIGHER_THAN_CONSENSUS_TIME",
        308: "SCHEDULE_FUTURE_THROTTLE_EXCEEDED",
        309: "SCHEDULE_FUTURE_GAS_LIMIT_EXCEEDED",
        310: "INVALID_ETHEREUM_TRANSACTION",
        311: "WRONG_CHAIN_ID",
        312: "WRONG_NONCE",
        313: "ACCESS_LIST_UNSUPPORTED",
        314: "SCHEDULE_PENDING_EXPIRATION",
        315: "CONTRACT_IS_TOKEN_TREASURY",
        316: "CONTRACT_HAS_NON_ZERO_TOKEN_BALANCES",
        317: "CONTRACT_EXPIRED_AND_PENDING_REMOVAL",
        318: "CONTRACT_HAS_NO_AUTO_RENEW_ACCOUNT",
        319: "PERMANENT_REMOVAL_REQUIRES_SYSTEM_INITIATION",
        320: "PROXY_ACCOUNT_ID_FIELD_IS_DEPRECATED",
        321: "SELF_STAKING_IS_NOT_ALLOWED",
        322: "INVALID_STAKING_ID",
        323: "STAKING_NOT_ENABLED",
        324: "INVALID_PRNG_RANGE",
        325: "MAX_ENTITIES_IN_PRICE_REGIME_HAVE_BEEN_CREATED",
        326: "INVALID_FULL_PREFIX_SIGNATURE_FOR_PRECOMPILE",
        327: "INSUFFICIENT_BALANCES_FOR_STORAGE_RENT",
        328: "MAX_CHILD_RECORDS_EXCEEDED",
        329: "INSUFFICIENT_BALANCES_FOR_RENEWAL_FEES",
    }

    @classmethod
    def get_name(cls, code):
        """
        Return the name of the response code if available.
        If not, return UNKNOWN_CODE_<code>.
        """
        return cls._code_to_name.get(code, f"UNKNOWN_CODE_{code}")
