from setuptools import setup, find_packages

with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setup(
    name="xwolfpython",
    version="1.0.0",
    author="xwolfpython",
    author_email="",
    description="An unofficial Python API for WOLF instant messaging platform",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/masamesa/WOLFApi-TS",
    packages=find_packages(),
    classifiers=[
        "Development Status :: 4 - Beta",
        "Intended Audience :: Developers",
        "Topic :: Software Development :: Libraries :: Python Modules",
        "Topic :: Communications :: Chat",
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3",
        "Programming Language :: Python :: 3.7",
        "Programming Language :: Python :: 3.8",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Programming Language :: Python :: 3.11",
        "Programming Language :: Python :: 3.12",
    ],
    python_requires=">=3.7",
    install_requires=[
        "python-socketio[client]>=5.0.0",
        "requests>=2.25.0",
    ],
    keywords="wolf, messaging, chat, api, instant-messaging, palringo",
    project_urls={
        "Bug Reports": "https://github.com/masamesa/WOLFApi-TS/issues",
        "Source": "https://github.com/masamesa/WOLFApi-TS",
    },
)
