from typing import Optional
from .network.client import Client
from .types.types import DeviceType, OnlineState


class WolfClient:
    def __init__(self, url: Optional[str] = None):
        self._client = Client(url)
        self.command_character: Optional[str] = None

    @property
    def Info(self):
        return self._client.info

    @property
    def Action(self):
        return self._client.actions

    @property
    def Messaging(self):
        return self._client.messaging

    @property
    def On(self):
        return self._client.on

    def login(
        self,
        email: str,
        password: str,
        device_type: DeviceType = DeviceType.WEB,
        state: OnlineState = OnlineState.AWAY,
        type_: str = 'email'
    ):
        self._client.login(email, password, device_type, state, type_)

    def logout(self):
        self._client.logout()

    def update_state(self, state: OnlineState):
        self._client.update_state(state)
