# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['AnalyticsInstanceArgs', 'AnalyticsInstance']

@pulumi.input_type
class AnalyticsInstanceArgs:
    def __init__(__self__, *,
                 capacity: pulumi.Input['AnalyticsInstanceCapacityArgs'],
                 compartment_id: pulumi.Input[str],
                 feature_set: pulumi.Input[str],
                 idcs_access_token: pulumi.Input[str],
                 license_type: pulumi.Input[str],
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_notification: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AnalyticsInstance resource.
        :param pulumi.Input['AnalyticsInstanceCapacityArgs'] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[str] feature_set: Analytics feature set.
        :param pulumi.Input[str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Optional description.
        :param pulumi.Input[str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        :param pulumi.Input[str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        AnalyticsInstanceArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacity=capacity,
            compartment_id=compartment_id,
            feature_set=feature_set,
            idcs_access_token=idcs_access_token,
            license_type=license_type,
            defined_tags=defined_tags,
            description=description,
            email_notification=email_notification,
            freeform_tags=freeform_tags,
            kms_key_id=kms_key_id,
            name=name,
            network_endpoint_details=network_endpoint_details,
            state=state,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacity: pulumi.Input['AnalyticsInstanceCapacityArgs'],
             compartment_id: pulumi.Input[str],
             feature_set: pulumi.Input[str],
             idcs_access_token: pulumi.Input[str],
             license_type: pulumi.Input[str],
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             email_notification: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
             state: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'featureSet' in kwargs:
            feature_set = kwargs['featureSet']
        if 'idcsAccessToken' in kwargs:
            idcs_access_token = kwargs['idcsAccessToken']
        if 'licenseType' in kwargs:
            license_type = kwargs['licenseType']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'emailNotification' in kwargs:
            email_notification = kwargs['emailNotification']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'networkEndpointDetails' in kwargs:
            network_endpoint_details = kwargs['networkEndpointDetails']

        _setter("capacity", capacity)
        _setter("compartment_id", compartment_id)
        _setter("feature_set", feature_set)
        _setter("idcs_access_token", idcs_access_token)
        _setter("license_type", license_type)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if email_notification is not None:
            _setter("email_notification", email_notification)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if name is not None:
            _setter("name", name)
        if network_endpoint_details is not None:
            _setter("network_endpoint_details", network_endpoint_details)
        if state is not None:
            _setter("state", state)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Input['AnalyticsInstanceCapacityArgs']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: pulumi.Input['AnalyticsInstanceCapacityArgs']):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> pulumi.Input[str]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: pulumi.Input[str]):
        pulumi.set(self, "feature_set", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Input[str]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Input[str]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


@pulumi.input_type
class _AnalyticsInstanceState:
    def __init__(__self__, *,
                 capacity: Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_notification: Optional[pulumi.Input[str]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
                 service_url: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AnalyticsInstance resources.
        :param pulumi.Input['AnalyticsInstanceCapacityArgs'] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Optional description.
        :param pulumi.Input[str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        :param pulumi.Input[str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs'] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[str] service_url: URL of the Analytics service.
        :param pulumi.Input[str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        _AnalyticsInstanceState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            capacity=capacity,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            email_notification=email_notification,
            feature_set=feature_set,
            freeform_tags=freeform_tags,
            idcs_access_token=idcs_access_token,
            kms_key_id=kms_key_id,
            license_type=license_type,
            name=name,
            network_endpoint_details=network_endpoint_details,
            service_url=service_url,
            state=state,
            time_created=time_created,
            time_updated=time_updated,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             capacity: Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             description: Optional[pulumi.Input[str]] = None,
             email_notification: Optional[pulumi.Input[str]] = None,
             feature_set: Optional[pulumi.Input[str]] = None,
             freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
             idcs_access_token: Optional[pulumi.Input[str]] = None,
             kms_key_id: Optional[pulumi.Input[str]] = None,
             license_type: Optional[pulumi.Input[str]] = None,
             name: Optional[pulumi.Input[str]] = None,
             network_endpoint_details: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']] = None,
             service_url: Optional[pulumi.Input[str]] = None,
             state: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'emailNotification' in kwargs:
            email_notification = kwargs['emailNotification']
        if 'featureSet' in kwargs:
            feature_set = kwargs['featureSet']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'idcsAccessToken' in kwargs:
            idcs_access_token = kwargs['idcsAccessToken']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'licenseType' in kwargs:
            license_type = kwargs['licenseType']
        if 'networkEndpointDetails' in kwargs:
            network_endpoint_details = kwargs['networkEndpointDetails']
        if 'serviceUrl' in kwargs:
            service_url = kwargs['serviceUrl']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']

        if capacity is not None:
            _setter("capacity", capacity)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if description is not None:
            _setter("description", description)
        if email_notification is not None:
            _setter("email_notification", email_notification)
        if feature_set is not None:
            _setter("feature_set", feature_set)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if idcs_access_token is not None:
            _setter("idcs_access_token", idcs_access_token)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if license_type is not None:
            _setter("license_type", license_type)
        if name is not None:
            _setter("name", name)
        if network_endpoint_details is not None:
            _setter("network_endpoint_details", network_endpoint_details)
        if service_url is not None:
            _setter("service_url", service_url)
        if state is not None:
            _setter("state", state)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)

    @property
    @pulumi.getter
    def capacity(self) -> Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']]:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @capacity.setter
    def capacity(self, value: Optional[pulumi.Input['AnalyticsInstanceCapacityArgs']]):
        pulumi.set(self, "capacity", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @defined_tags.setter
    def defined_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "defined_tags", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @email_notification.setter
    def email_notification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "email_notification", value)

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> Optional[pulumi.Input[str]]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @feature_set.setter
    def feature_set(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "feature_set", value)

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[pulumi.Input[Mapping[str, Any]]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @freeform_tags.setter
    def freeform_tags(self, value: Optional[pulumi.Input[Mapping[str, Any]]]):
        pulumi.set(self, "freeform_tags", value)

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> Optional[pulumi.Input[str]]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @idcs_access_token.setter
    def idcs_access_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "idcs_access_token", value)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @kms_key_id.setter
    def kms_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "kms_key_id", value)

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @license_type.setter
    def license_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "license_type", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @network_endpoint_details.setter
    def network_endpoint_details(self, value: Optional[pulumi.Input['AnalyticsInstanceNetworkEndpointDetailsArgs']]):
        pulumi.set(self, "network_endpoint_details", value)

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> Optional[pulumi.Input[str]]:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @service_url.setter
    def service_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "service_url", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)


class AnalyticsInstance(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceCapacityArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_notification: Optional[pulumi.Input[str]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_endpoint_details: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceNetworkEndpointDetailsArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

        Create a new AnalyticsInstance in the specified compartment. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance = oci.analytics.AnalyticsInstance("testAnalyticsInstance",
            capacity=oci.analytics.AnalyticsInstanceCapacityArgs(
                capacity_type=var["analytics_instance_capacity_capacity_type"],
                capacity_value=var["analytics_instance_capacity_capacity_value"],
            ),
            compartment_id=var["compartment_id"],
            feature_set=var["analytics_instance_feature_set"],
            idcs_access_token=var["analytics_instance_idcs_access_token"],
            license_type=var["analytics_instance_license_type"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["analytics_instance_description"],
            email_notification=var["analytics_instance_email_notification"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            network_endpoint_details=oci.analytics.AnalyticsInstanceNetworkEndpointDetailsArgs(
                network_endpoint_type=var["analytics_instance_network_endpoint_details_network_endpoint_type"],
                network_security_group_ids=var["analytics_instance_network_endpoint_details_network_security_group_ids"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vcn_id=oci_core_vcn["test_vcn"]["id"],
                whitelisted_ips=var["analytics_instance_network_endpoint_details_whitelisted_ips"],
                whitelisted_services=var["analytics_instance_network_endpoint_details_whitelisted_services"],
                whitelisted_vcns=[oci.analytics.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcnArgs(
                    id=var["analytics_instance_network_endpoint_details_whitelisted_vcns_id"],
                    whitelisted_ips=var["analytics_instance_network_endpoint_details_whitelisted_vcns_whitelisted_ips"],
                )],
            ))
        ```

        ## Import

        AnalyticsInstances can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Analytics/analyticsInstance:AnalyticsInstance test_analytics_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AnalyticsInstanceCapacityArgs']] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Optional description.
        :param pulumi.Input[str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        :param pulumi.Input[str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input[pulumi.InputType['AnalyticsInstanceNetworkEndpointDetailsArgs']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnalyticsInstanceArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Analytics Instance resource in Oracle Cloud Infrastructure Analytics service.

        Create a new AnalyticsInstance in the specified compartment. The operation is long-running
        and creates a new WorkRequest.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_analytics_instance = oci.analytics.AnalyticsInstance("testAnalyticsInstance",
            capacity=oci.analytics.AnalyticsInstanceCapacityArgs(
                capacity_type=var["analytics_instance_capacity_capacity_type"],
                capacity_value=var["analytics_instance_capacity_capacity_value"],
            ),
            compartment_id=var["compartment_id"],
            feature_set=var["analytics_instance_feature_set"],
            idcs_access_token=var["analytics_instance_idcs_access_token"],
            license_type=var["analytics_instance_license_type"],
            defined_tags={
                "Operations.CostCenter": "42",
            },
            description=var["analytics_instance_description"],
            email_notification=var["analytics_instance_email_notification"],
            freeform_tags={
                "Department": "Finance",
            },
            kms_key_id=oci_kms_key["test_key"]["id"],
            network_endpoint_details=oci.analytics.AnalyticsInstanceNetworkEndpointDetailsArgs(
                network_endpoint_type=var["analytics_instance_network_endpoint_details_network_endpoint_type"],
                network_security_group_ids=var["analytics_instance_network_endpoint_details_network_security_group_ids"],
                subnet_id=oci_core_subnet["test_subnet"]["id"],
                vcn_id=oci_core_vcn["test_vcn"]["id"],
                whitelisted_ips=var["analytics_instance_network_endpoint_details_whitelisted_ips"],
                whitelisted_services=var["analytics_instance_network_endpoint_details_whitelisted_services"],
                whitelisted_vcns=[oci.analytics.AnalyticsInstanceNetworkEndpointDetailsWhitelistedVcnArgs(
                    id=var["analytics_instance_network_endpoint_details_whitelisted_vcns_id"],
                    whitelisted_ips=var["analytics_instance_network_endpoint_details_whitelisted_vcns_whitelisted_ips"],
                )],
            ))
        ```

        ## Import

        AnalyticsInstances can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Analytics/analyticsInstance:AnalyticsInstance test_analytics_instance "id"
        ```

        :param str resource_name: The name of the resource.
        :param AnalyticsInstanceArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnalyticsInstanceArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AnalyticsInstanceArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 capacity: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceCapacityArgs']]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 email_notification: Optional[pulumi.Input[str]] = None,
                 feature_set: Optional[pulumi.Input[str]] = None,
                 freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
                 idcs_access_token: Optional[pulumi.Input[str]] = None,
                 kms_key_id: Optional[pulumi.Input[str]] = None,
                 license_type: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 network_endpoint_details: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceNetworkEndpointDetailsArgs']]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnalyticsInstanceArgs.__new__(AnalyticsInstanceArgs)

            if capacity is not None and not isinstance(capacity, AnalyticsInstanceCapacityArgs):
                capacity = capacity or {}
                def _setter(key, value):
                    capacity[key] = value
                AnalyticsInstanceCapacityArgs._configure(_setter, **capacity)
            if capacity is None and not opts.urn:
                raise TypeError("Missing required property 'capacity'")
            __props__.__dict__["capacity"] = capacity
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["defined_tags"] = defined_tags
            __props__.__dict__["description"] = description
            __props__.__dict__["email_notification"] = email_notification
            if feature_set is None and not opts.urn:
                raise TypeError("Missing required property 'feature_set'")
            __props__.__dict__["feature_set"] = feature_set
            __props__.__dict__["freeform_tags"] = freeform_tags
            if idcs_access_token is None and not opts.urn:
                raise TypeError("Missing required property 'idcs_access_token'")
            __props__.__dict__["idcs_access_token"] = None if idcs_access_token is None else pulumi.Output.secret(idcs_access_token)
            __props__.__dict__["kms_key_id"] = kms_key_id
            if license_type is None and not opts.urn:
                raise TypeError("Missing required property 'license_type'")
            __props__.__dict__["license_type"] = license_type
            __props__.__dict__["name"] = name
            if network_endpoint_details is not None and not isinstance(network_endpoint_details, AnalyticsInstanceNetworkEndpointDetailsArgs):
                network_endpoint_details = network_endpoint_details or {}
                def _setter(key, value):
                    network_endpoint_details[key] = value
                AnalyticsInstanceNetworkEndpointDetailsArgs._configure(_setter, **network_endpoint_details)
            __props__.__dict__["network_endpoint_details"] = network_endpoint_details
            __props__.__dict__["state"] = state
            __props__.__dict__["service_url"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["idcsAccessToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(AnalyticsInstance, __self__).__init__(
            'oci:Analytics/analyticsInstance:AnalyticsInstance',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            capacity: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceCapacityArgs']]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            defined_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            description: Optional[pulumi.Input[str]] = None,
            email_notification: Optional[pulumi.Input[str]] = None,
            feature_set: Optional[pulumi.Input[str]] = None,
            freeform_tags: Optional[pulumi.Input[Mapping[str, Any]]] = None,
            idcs_access_token: Optional[pulumi.Input[str]] = None,
            kms_key_id: Optional[pulumi.Input[str]] = None,
            license_type: Optional[pulumi.Input[str]] = None,
            name: Optional[pulumi.Input[str]] = None,
            network_endpoint_details: Optional[pulumi.Input[pulumi.InputType['AnalyticsInstanceNetworkEndpointDetailsArgs']]] = None,
            service_url: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None) -> 'AnalyticsInstance':
        """
        Get an existing AnalyticsInstance resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['AnalyticsInstanceCapacityArgs']] capacity: Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Mapping[str, Any]] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param pulumi.Input[str] description: (Updatable) Optional description.
        :param pulumi.Input[str] email_notification: (Updatable) Email address receiving notifications.
        :param pulumi.Input[str] feature_set: Analytics feature set.
        :param pulumi.Input[Mapping[str, Any]] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param pulumi.Input[str] idcs_access_token: IDCS access token identifying a stripe and service administrator user.
        :param pulumi.Input[str] kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        :param pulumi.Input[str] license_type: (Updatable) The license used for the service.
        :param pulumi.Input[str] name: The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        :param pulumi.Input[pulumi.InputType['AnalyticsInstanceNetworkEndpointDetailsArgs']] network_endpoint_details: Base representation of a network endpoint.
        :param pulumi.Input[str] service_url: URL of the Analytics service.
        :param pulumi.Input[str] state: (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] time_created: The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        :param pulumi.Input[str] time_updated: The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnalyticsInstanceState.__new__(_AnalyticsInstanceState)

        __props__.__dict__["capacity"] = capacity
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["defined_tags"] = defined_tags
        __props__.__dict__["description"] = description
        __props__.__dict__["email_notification"] = email_notification
        __props__.__dict__["feature_set"] = feature_set
        __props__.__dict__["freeform_tags"] = freeform_tags
        __props__.__dict__["idcs_access_token"] = idcs_access_token
        __props__.__dict__["kms_key_id"] = kms_key_id
        __props__.__dict__["license_type"] = license_type
        __props__.__dict__["name"] = name
        __props__.__dict__["network_endpoint_details"] = network_endpoint_details
        __props__.__dict__["service_url"] = service_url
        __props__.__dict__["state"] = state
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        return AnalyticsInstance(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def capacity(self) -> pulumi.Output['outputs.AnalyticsInstanceCapacity']:
        """
        Service instance capacity metadata (e.g.: OLPU count, number of users, ...etc...).
        """
        return pulumi.get(self, "capacity")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> pulumi.Output[str]:
        """
        (Updatable) Optional description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="emailNotification")
    def email_notification(self) -> pulumi.Output[str]:
        """
        (Updatable) Email address receiving notifications.
        """
        return pulumi.get(self, "email_notification")

    @property
    @pulumi.getter(name="featureSet")
    def feature_set(self) -> pulumi.Output[str]:
        """
        Analytics feature set.
        """
        return pulumi.get(self, "feature_set")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> pulumi.Output[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="idcsAccessToken")
    def idcs_access_token(self) -> pulumi.Output[str]:
        """
        IDCS access token identifying a stripe and service administrator user.
        """
        return pulumi.get(self, "idcs_access_token")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> pulumi.Output[Optional[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the Oracle Cloud Infrastructure Vault Key encrypting the customer data stored in this Analytics instance. Omitting this value or specifying an empty string (i.e. "") indicates to use Oracle managed default encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="licenseType")
    def license_type(self) -> pulumi.Output[str]:
        """
        (Updatable) The license used for the service.
        """
        return pulumi.get(self, "license_type")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The name of the Analytics instance. This name must be unique in the tenancy and cannot be changed.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkEndpointDetails")
    def network_endpoint_details(self) -> pulumi.Output['outputs.AnalyticsInstanceNetworkEndpointDetails']:
        """
        Base representation of a network endpoint.
        """
        return pulumi.get(self, "network_endpoint_details")

    @property
    @pulumi.getter(name="serviceUrl")
    def service_url(self) -> pulumi.Output[str]:
        """
        URL of the Analytics service.
        """
        return pulumi.get(self, "service_url")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        (Updatable) The target state for the Analytics Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The date and time the instance was created, in the format defined by RFC3339.  Example: `2016-08-25T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The date and time the instance was last updated (in the format defined by RFC3339). This timestamp represents updates made through this API. External events do not influence it.
        """
        return pulumi.get(self, "time_updated")

