# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AnnouncementSubscriptionsActionsChangeCompartmentArgs', 'AnnouncementSubscriptionsActionsChangeCompartment']

@pulumi.input_type
class AnnouncementSubscriptionsActionsChangeCompartmentArgs:
    def __init__(__self__, *,
                 announcement_subscription_id: pulumi.Input[str],
                 compartment_id: pulumi.Input[str]):
        """
        The set of arguments for constructing a AnnouncementSubscriptionsActionsChangeCompartment resource.
        :param pulumi.Input[str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        AnnouncementSubscriptionsActionsChangeCompartmentArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            announcement_subscription_id=announcement_subscription_id,
            compartment_id=compartment_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             announcement_subscription_id: pulumi.Input[str],
             compartment_id: pulumi.Input[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'announcementSubscriptionId' in kwargs:
            announcement_subscription_id = kwargs['announcementSubscriptionId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        _setter("announcement_subscription_id", announcement_subscription_id)
        _setter("compartment_id", compartment_id)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> pulumi.Input[str]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @announcement_subscription_id.setter
    def announcement_subscription_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "announcement_subscription_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)


@pulumi.input_type
class _AnnouncementSubscriptionsActionsChangeCompartmentState:
    def __init__(__self__, *,
                 announcement_subscription_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AnnouncementSubscriptionsActionsChangeCompartment resources.
        :param pulumi.Input[str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _AnnouncementSubscriptionsActionsChangeCompartmentState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            announcement_subscription_id=announcement_subscription_id,
            compartment_id=compartment_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             announcement_subscription_id: Optional[pulumi.Input[str]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'announcementSubscriptionId' in kwargs:
            announcement_subscription_id = kwargs['announcementSubscriptionId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']

        if announcement_subscription_id is not None:
            _setter("announcement_subscription_id", announcement_subscription_id)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @announcement_subscription_id.setter
    def announcement_subscription_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "announcement_subscription_id", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)


class AnnouncementSubscriptionsActionsChangeCompartment(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 announcement_subscription_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the Announcement Subscriptions Actions Change Compartment resource in Oracle Cloud Infrastructure Announcements Service service.

        Moves the specified announcement subscription from one compartment to another compartment. When provided, If-Match is checked against ETag values of the resource.

        This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_announcement_subscriptions_actions_change_compartment = oci.announcements_service.AnnouncementSubscriptionsActionsChangeCompartment("testAnnouncementSubscriptionsActionsChangeCompartment",
            announcement_subscription_id=oci_announcements_service_announcement_subscription["test_announcement_subscription"]["id"],
            compartment_id=var["compartment_id"])
        ```

        ## Import

        AnnouncementSubscriptionsActionsChangeCompartment can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AnnouncementsService/announcementSubscriptionsActionsChangeCompartment:AnnouncementSubscriptionsActionsChangeCompartment test_announcement_subscriptions_actions_change_compartment "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AnnouncementSubscriptionsActionsChangeCompartmentArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Announcement Subscriptions Actions Change Compartment resource in Oracle Cloud Infrastructure Announcements Service service.

        Moves the specified announcement subscription from one compartment to another compartment. When provided, If-Match is checked against ETag values of the resource.

        This call is subject to an Announcements limit that applies to the total number of requests across all read or write operations. Announcements might throttle this call to reject an otherwise valid request when the total rate of operations exceeds 20 requests per second for a given user. The service might also throttle this call to reject an otherwise valid request when the total rate of operations exceeds 100 requests per second for a given tenancy.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_announcement_subscriptions_actions_change_compartment = oci.announcements_service.AnnouncementSubscriptionsActionsChangeCompartment("testAnnouncementSubscriptionsActionsChangeCompartment",
            announcement_subscription_id=oci_announcements_service_announcement_subscription["test_announcement_subscription"]["id"],
            compartment_id=var["compartment_id"])
        ```

        ## Import

        AnnouncementSubscriptionsActionsChangeCompartment can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:AnnouncementsService/announcementSubscriptionsActionsChangeCompartment:AnnouncementSubscriptionsActionsChangeCompartment test_announcement_subscriptions_actions_change_compartment "id"
        ```

        :param str resource_name: The name of the resource.
        :param AnnouncementSubscriptionsActionsChangeCompartmentArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AnnouncementSubscriptionsActionsChangeCompartmentArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AnnouncementSubscriptionsActionsChangeCompartmentArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 announcement_subscription_id: Optional[pulumi.Input[str]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AnnouncementSubscriptionsActionsChangeCompartmentArgs.__new__(AnnouncementSubscriptionsActionsChangeCompartmentArgs)

            if announcement_subscription_id is None and not opts.urn:
                raise TypeError("Missing required property 'announcement_subscription_id'")
            __props__.__dict__["announcement_subscription_id"] = announcement_subscription_id
            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
        super(AnnouncementSubscriptionsActionsChangeCompartment, __self__).__init__(
            'oci:AnnouncementsService/announcementSubscriptionsActionsChangeCompartment:AnnouncementSubscriptionsActionsChangeCompartment',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            announcement_subscription_id: Optional[pulumi.Input[str]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None) -> 'AnnouncementSubscriptionsActionsChangeCompartment':
        """
        Get an existing AnnouncementSubscriptionsActionsChangeCompartment resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] announcement_subscription_id: The OCID of the announcement subscription.
        :param pulumi.Input[str] compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AnnouncementSubscriptionsActionsChangeCompartmentState.__new__(_AnnouncementSubscriptionsActionsChangeCompartmentState)

        __props__.__dict__["announcement_subscription_id"] = announcement_subscription_id
        __props__.__dict__["compartment_id"] = compartment_id
        return AnnouncementSubscriptionsActionsChangeCompartment(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="announcementSubscriptionId")
    def announcement_subscription_id(self) -> pulumi.Output[str]:
        """
        The OCID of the announcement subscription.
        """
        return pulumi.get(self, "announcement_subscription_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment into which you want to move the announcement subscription. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "compartment_id")

