# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'ContainerRepositoryReadme',
    'GetContainerImageLayerResult',
    'GetContainerImageVersionResult',
    'GetContainerImagesContainerImageCollectionResult',
    'GetContainerImagesContainerImageCollectionItemResult',
    'GetContainerImagesContainerImageCollectionItemLayerResult',
    'GetContainerImagesContainerImageCollectionItemVersionResult',
    'GetContainerImagesFilterResult',
    'GetContainerRepositoriesContainerRepositoryCollectionResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemResult',
    'GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult',
    'GetContainerRepositoriesFilterResult',
    'GetContainerRepositoryReadmeResult',
    'GetContainerSignaturesContainerImageSignatureCollectionResult',
    'GetContainerSignaturesContainerImageSignatureCollectionItemResult',
    'GetContainerSignaturesFilterResult',
    'GetGenericArtifactsFilterResult',
    'GetGenericArtifactsGenericArtifactCollectionResult',
    'GetGenericArtifactsGenericArtifactCollectionItemResult',
    'GetRepositoriesFilterResult',
    'GetRepositoriesRepositoryCollectionResult',
    'GetRepositoriesRepositoryCollectionItemResult',
]

@pulumi.output_type
class ContainerRepositoryReadme(dict):
    def __init__(__self__, *,
                 content: str,
                 format: str):
        """
        :param str content: (Updatable) Readme content. Avoid entering confidential information.
        :param str format: (Updatable) Readme format. Supported formats are text/plain and text/markdown.
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ContainerRepositoryReadme._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            format=format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             format: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("content", content)
        _setter("format", format)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        (Updatable) Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        (Updatable) Readme format. Supported formats are text/plain and text/markdown.


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerImageLayerResult(dict):
    def __init__(__self__, *,
                 digest: str,
                 size_in_bytes: str,
                 time_created: str):
        """
        :param str digest: The sha256 digest of the image layer.
        :param str size_in_bytes: The size of the layer in bytes.
        :param str time_created: The creation time of the version.
        """
        GetContainerImageLayerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            digest=digest,
            size_in_bytes=size_in_bytes,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             digest: str,
             size_in_bytes: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("digest", digest)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImageVersionResult(dict):
    def __init__(__self__, *,
                 created_by: str,
                 time_created: str,
                 version: str):
        """
        :param str created_by: The OCID of the user or principal that pushed the version.
        :param str time_created: The creation time of the version.
        :param str version: The version name.
        """
        GetContainerImageVersionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            created_by=created_by,
            time_created=time_created,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             created_by: str,
             time_created: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("created_by", created_by)
        _setter("time_created", time_created)
        _setter("version", version)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version name.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult'],
                 remaining_items_count: int):
        GetContainerImagesContainerImageCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            remaining_items_count=remaining_items_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult'],
             remaining_items_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'remainingItemsCount' in kwargs:
            remaining_items_count = kwargs['remainingItemsCount']

        _setter("items", items)
        _setter("remaining_items_count", remaining_items_count)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 created_by: str,
                 defined_tags: Mapping[str, Any],
                 digest: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 layers: Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult'],
                 layers_size_in_bytes: str,
                 manifest_size_in_bytes: int,
                 pull_count: str,
                 repository_id: str,
                 repository_name: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_last_pulled: str,
                 version: str,
                 versions: Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param str created_by: The OCID of the user or principal that pushed the version.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str digest: The sha256 digest of the image layer.
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        :param Sequence['GetContainerImagesContainerImageCollectionItemLayerArgs'] layers: Layers of which the image is composed, ordered by the layer digest.
        :param str layers_size_in_bytes: The total size of the container image layers in bytes.
        :param int manifest_size_in_bytes: The size of the container image manifest in bytes.
        :param str pull_count: Total number of pulls.
        :param str repository_id: A filter to return container images only for the specified container repository OCID.
        :param str repository_name: A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        :param str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, Any] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The creation time of the version.
        :param str time_last_pulled: An RFC 3339 timestamp indicating when the image was last pulled.
        :param str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        :param Sequence['GetContainerImagesContainerImageCollectionItemVersionArgs'] versions: The versions associated with this image.
        """
        GetContainerImagesContainerImageCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            digest=digest,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            layers=layers,
            layers_size_in_bytes=layers_size_in_bytes,
            manifest_size_in_bytes=manifest_size_in_bytes,
            pull_count=pull_count,
            repository_id=repository_id,
            repository_name=repository_name,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_last_pulled=time_last_pulled,
            version=version,
            versions=versions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             created_by: str,
             defined_tags: Mapping[str, Any],
             digest: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             layers: Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult'],
             layers_size_in_bytes: str,
             manifest_size_in_bytes: int,
             pull_count: str,
             repository_id: str,
             repository_name: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_last_pulled: str,
             version: str,
             versions: Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'layersSizeInBytes' in kwargs:
            layers_size_in_bytes = kwargs['layersSizeInBytes']
        if 'manifestSizeInBytes' in kwargs:
            manifest_size_in_bytes = kwargs['manifestSizeInBytes']
        if 'pullCount' in kwargs:
            pull_count = kwargs['pullCount']
        if 'repositoryId' in kwargs:
            repository_id = kwargs['repositoryId']
        if 'repositoryName' in kwargs:
            repository_name = kwargs['repositoryName']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeLastPulled' in kwargs:
            time_last_pulled = kwargs['timeLastPulled']

        _setter("compartment_id", compartment_id)
        _setter("created_by", created_by)
        _setter("defined_tags", defined_tags)
        _setter("digest", digest)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("layers", layers)
        _setter("layers_size_in_bytes", layers_size_in_bytes)
        _setter("manifest_size_in_bytes", manifest_size_in_bytes)
        _setter("pull_count", pull_count)
        _setter("repository_id", repository_id)
        _setter("repository_name", repository_name)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_last_pulled", time_last_pulled)
        _setter("version", version)
        _setter("versions", versions)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image.  Example: `ocid1.containerimage.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def layers(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemLayerResult']:
        """
        Layers of which the image is composed, ordered by the layer digest.
        """
        return pulumi.get(self, "layers")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> str:
        """
        The total size of the container image layers in bytes.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter(name="manifestSizeInBytes")
    def manifest_size_in_bytes(self) -> int:
        """
        The size of the container image manifest in bytes.
        """
        return pulumi.get(self, "manifest_size_in_bytes")

    @property
    @pulumi.getter(name="pullCount")
    def pull_count(self) -> str:
        """
        Total number of pulls.
        """
        return pulumi.get(self, "pull_count")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        A filter to return container images only for the specified container repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter(name="repositoryName")
    def repository_name(self) -> str:
        """
        A filter to return container images or container image signatures that match the repository name.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "repository_name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastPulled")
    def time_last_pulled(self) -> str:
        """
        An RFC 3339 timestamp indicating when the image was last pulled.
        """
        return pulumi.get(self, "time_last_pulled")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetContainerImagesContainerImageCollectionItemVersionResult']:
        """
        The versions associated with this image.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemLayerResult(dict):
    def __init__(__self__, *,
                 digest: str,
                 size_in_bytes: str,
                 time_created: str):
        """
        :param str digest: The sha256 digest of the image layer.
        :param str size_in_bytes: The size of the layer in bytes.
        :param str time_created: The creation time of the version.
        """
        GetContainerImagesContainerImageCollectionItemLayerResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            digest=digest,
            size_in_bytes=size_in_bytes,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             digest: str,
             size_in_bytes: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("digest", digest)
        _setter("size_in_bytes", size_in_bytes)
        _setter("time_created", time_created)

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        The sha256 digest of the image layer.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        The size of the layer in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerImagesContainerImageCollectionItemVersionResult(dict):
    def __init__(__self__, *,
                 created_by: str,
                 time_created: str,
                 version: str):
        """
        :param str created_by: The OCID of the user or principal that pushed the version.
        :param str time_created: The creation time of the version.
        :param str version: A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        GetContainerImagesContainerImageCollectionItemVersionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            created_by=created_by,
            time_created=time_created,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             created_by: str,
             time_created: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("created_by", created_by)
        _setter("time_created", time_created)
        _setter("version", version)

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The OCID of the user or principal that pushed the version.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The creation time of the version.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        A filter to return container images that match the version.  Example: `foo` or `foo*`
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetContainerImagesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetContainerImagesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 image_count: int,
                 items: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult'],
                 layer_count: int,
                 layers_size_in_bytes: str,
                 remaining_items_count: int,
                 repository_count: int):
        """
        :param int image_count: Total number of images.
        :param int layer_count: Total number of layers.
        :param str layers_size_in_bytes: Total storage in bytes consumed by layers.
        """
        GetContainerRepositoriesContainerRepositoryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_count=image_count,
            items=items,
            layer_count=layer_count,
            layers_size_in_bytes=layers_size_in_bytes,
            remaining_items_count=remaining_items_count,
            repository_count=repository_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_count: int,
             items: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult'],
             layer_count: int,
             layers_size_in_bytes: str,
             remaining_items_count: int,
             repository_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageCount' in kwargs:
            image_count = kwargs['imageCount']
        if 'layerCount' in kwargs:
            layer_count = kwargs['layerCount']
        if 'layersSizeInBytes' in kwargs:
            layers_size_in_bytes = kwargs['layersSizeInBytes']
        if 'remainingItemsCount' in kwargs:
            remaining_items_count = kwargs['remainingItemsCount']
        if 'repositoryCount' in kwargs:
            repository_count = kwargs['repositoryCount']

        _setter("image_count", image_count)
        _setter("items", items)
        _setter("layer_count", layer_count)
        _setter("layers_size_in_bytes", layers_size_in_bytes)
        _setter("remaining_items_count", remaining_items_count)
        _setter("repository_count", repository_count)

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> int:
        return pulumi.get(self, "remaining_items_count")

    @property
    @pulumi.getter(name="repositoryCount")
    def repository_count(self) -> int:
        return pulumi.get(self, "repository_count")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 billable_size_in_gbs: str,
                 compartment_id: str,
                 created_by: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 image_count: int,
                 is_immutable: bool,
                 is_public: bool,
                 layer_count: int,
                 layers_size_in_bytes: str,
                 namespace: str,
                 readmes: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult'],
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 time_last_pushed: str):
        """
        :param str billable_size_in_gbs: Total storage size in GBs that will be charged.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        :param int image_count: Total number of images.
        :param bool is_immutable: Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        :param bool is_public: A filter to return resources that match the isPublic value.
        :param int layer_count: Total number of layers.
        :param str layers_size_in_bytes: Total storage in bytes consumed by layers.
        :param str namespace: The tenancy namespace used in the container repository path.
        :param Sequence['GetContainerRepositoriesContainerRepositoryCollectionItemReadmeArgs'] readmes: Container repository readme.
        :param str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param Mapping[str, Any] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param str time_last_pushed: An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        GetContainerRepositoriesContainerRepositoryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            billable_size_in_gbs=billable_size_in_gbs,
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            image_count=image_count,
            is_immutable=is_immutable,
            is_public=is_public,
            layer_count=layer_count,
            layers_size_in_bytes=layers_size_in_bytes,
            namespace=namespace,
            readmes=readmes,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_last_pushed=time_last_pushed,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             billable_size_in_gbs: str,
             compartment_id: str,
             created_by: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             image_count: int,
             is_immutable: bool,
             is_public: bool,
             layer_count: int,
             layers_size_in_bytes: str,
             namespace: str,
             readmes: Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult'],
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             time_last_pushed: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'billableSizeInGbs' in kwargs:
            billable_size_in_gbs = kwargs['billableSizeInGbs']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'imageCount' in kwargs:
            image_count = kwargs['imageCount']
        if 'isImmutable' in kwargs:
            is_immutable = kwargs['isImmutable']
        if 'isPublic' in kwargs:
            is_public = kwargs['isPublic']
        if 'layerCount' in kwargs:
            layer_count = kwargs['layerCount']
        if 'layersSizeInBytes' in kwargs:
            layers_size_in_bytes = kwargs['layersSizeInBytes']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeLastPushed' in kwargs:
            time_last_pushed = kwargs['timeLastPushed']

        _setter("billable_size_in_gbs", billable_size_in_gbs)
        _setter("compartment_id", compartment_id)
        _setter("created_by", created_by)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("image_count", image_count)
        _setter("is_immutable", is_immutable)
        _setter("is_public", is_public)
        _setter("layer_count", layer_count)
        _setter("layers_size_in_bytes", layers_size_in_bytes)
        _setter("namespace", namespace)
        _setter("readmes", readmes)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("time_last_pushed", time_last_pushed)

    @property
    @pulumi.getter(name="billableSizeInGbs")
    def billable_size_in_gbs(self) -> str:
        """
        Total storage size in GBs that will be charged.
        """
        return pulumi.get(self, "billable_size_in_gbs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container repository.  Example: `ocid1.containerrepo.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageCount")
    def image_count(self) -> int:
        """
        Total number of images.
        """
        return pulumi.get(self, "image_count")

    @property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> bool:
        """
        Whether the repository is immutable. Images cannot be overwritten in an immutable repository.
        """
        return pulumi.get(self, "is_immutable")

    @property
    @pulumi.getter(name="isPublic")
    def is_public(self) -> bool:
        """
        A filter to return resources that match the isPublic value.
        """
        return pulumi.get(self, "is_public")

    @property
    @pulumi.getter(name="layerCount")
    def layer_count(self) -> int:
        """
        Total number of layers.
        """
        return pulumi.get(self, "layer_count")

    @property
    @pulumi.getter(name="layersSizeInBytes")
    def layers_size_in_bytes(self) -> str:
        """
        Total storage in bytes consumed by layers.
        """
        return pulumi.get(self, "layers_size_in_bytes")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The tenancy namespace used in the container repository path.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def readmes(self) -> Sequence['outputs.GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult']:
        """
        Container repository readme.
        """
        return pulumi.get(self, "readmes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeLastPushed")
    def time_last_pushed(self) -> str:
        """
        An RFC 3339 timestamp indicating when an image was last pushed to the repository.
        """
        return pulumi.get(self, "time_last_pushed")


@pulumi.output_type
class GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult(dict):
    def __init__(__self__, *,
                 content: str,
                 format: str):
        """
        :param str content: Readme content. Avoid entering confidential information.
        :param str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        GetContainerRepositoriesContainerRepositoryCollectionItemReadmeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            format=format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             format: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("content", content)
        _setter("format", format)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetContainerRepositoriesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetContainerRepositoryReadmeResult(dict):
    def __init__(__self__, *,
                 content: str,
                 format: str):
        """
        :param str content: Readme content. Avoid entering confidential information.
        :param str format: Readme format. Supported formats are text/plain and text/markdown.
        """
        GetContainerRepositoryReadmeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            content=content,
            format=format,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             content: str,
             format: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("content", content)
        _setter("format", format)

    @property
    @pulumi.getter
    def content(self) -> str:
        """
        Readme content. Avoid entering confidential information.
        """
        return pulumi.get(self, "content")

    @property
    @pulumi.getter
    def format(self) -> str:
        """
        Readme format. Supported formats are text/plain and text/markdown.
        """
        return pulumi.get(self, "format")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult'],
                 remaining_items_count: int):
        GetContainerSignaturesContainerImageSignatureCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
            remaining_items_count=remaining_items_count,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult'],
             remaining_items_count: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'remainingItemsCount' in kwargs:
            remaining_items_count = kwargs['remainingItemsCount']

        _setter("items", items)
        _setter("remaining_items_count", remaining_items_count)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetContainerSignaturesContainerImageSignatureCollectionItemResult']:
        return pulumi.get(self, "items")

    @property
    @pulumi.getter(name="remainingItemsCount")
    def remaining_items_count(self) -> int:
        return pulumi.get(self, "remaining_items_count")


@pulumi.output_type
class GetContainerSignaturesContainerImageSignatureCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 created_by: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 image_id: str,
                 kms_key_id: str,
                 kms_key_version_id: str,
                 message: str,
                 signature: str,
                 signing_algorithm: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param str created_by: The id of the user or principal that created the resource.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        :param str image_id: A filter to return a container image summary only for the specified container image OCID.
        :param str kms_key_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param str kms_key_version_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        :param str message: The base64 encoded signature payload that was signed.
        :param str signature: The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        :param str signing_algorithm: The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        :param str state: The current state of the container image signature.
        :param Mapping[str, Any] system_tags: The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: An RFC 3339 timestamp indicating when the image was created.
        """
        GetContainerSignaturesContainerImageSignatureCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            created_by=created_by,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            image_id=image_id,
            kms_key_id=kms_key_id,
            kms_key_version_id=kms_key_version_id,
            message=message,
            signature=signature,
            signing_algorithm=signing_algorithm,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             created_by: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             image_id: str,
             kms_key_id: str,
             kms_key_version_id: str,
             message: str,
             signature: str,
             signing_algorithm: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'createdBy' in kwargs:
            created_by = kwargs['createdBy']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'kmsKeyVersionId' in kwargs:
            kms_key_version_id = kwargs['kmsKeyVersionId']
        if 'signingAlgorithm' in kwargs:
            signing_algorithm = kwargs['signingAlgorithm']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("compartment_id", compartment_id)
        _setter("created_by", created_by)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("image_id", image_id)
        _setter("kms_key_id", kms_key_id)
        _setter("kms_key_version_id", kms_key_version_id)
        _setter("message", message)
        _setter("signature", signature)
        _setter("signing_algorithm", signing_algorithm)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="createdBy")
    def created_by(self) -> str:
        """
        The id of the user or principal that created the resource.
        """
        return pulumi.get(self, "created_by")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the container image signature.  Example: `ocid1.containerimagesignature.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        A filter to return a container image summary only for the specified container image OCID.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kmsKeyVersionId")
    def kms_key_version_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the kmsKeyVersionId used to sign the container image.  Example: `ocid1.keyversion.oc1..exampleuniqueID`
        """
        return pulumi.get(self, "kms_key_version_id")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The base64 encoded signature payload that was signed.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def signature(self) -> str:
        """
        The signature of the message field using the kmsKeyId, the kmsKeyVersionId, and the signingAlgorithm.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter(name="signingAlgorithm")
    def signing_algorithm(self) -> str:
        """
        The algorithm to be used for signing. These are the only supported signing algorithms for container images.
        """
        return pulumi.get(self, "signing_algorithm")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the container image signature.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        The system tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC 3339 timestamp indicating when the image was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetContainerSignaturesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetContainerSignaturesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetGenericArtifactsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']):
        GetGenericArtifactsGenericArtifactCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetGenericArtifactsGenericArtifactCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetGenericArtifactsGenericArtifactCollectionItemResult(dict):
    def __init__(__self__, *,
                 artifact_id: str,
                 artifact_path: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 repository_id: str,
                 sha256: str,
                 size_in_bytes: str,
                 state: str,
                 time_created: str,
                 version: str):
        """
        :param str artifact_path: Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return the resources for the specified OCID.
        :param str repository_id: A filter to return the artifacts only for the specified repository OCID.
        :param str sha256: Filter results by a specified SHA256 digest for the artifact.
        :param str size_in_bytes: The size of the artifact in bytes.
        :param str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param str time_created: An RFC 3339 timestamp indicating when the repository was created.
        :param str version: Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        GetGenericArtifactsGenericArtifactCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            artifact_id=artifact_id,
            artifact_path=artifact_path,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            repository_id=repository_id,
            sha256=sha256,
            size_in_bytes=size_in_bytes,
            state=state,
            time_created=time_created,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             artifact_id: str,
             artifact_path: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             repository_id: str,
             sha256: str,
             size_in_bytes: str,
             state: str,
             time_created: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'artifactId' in kwargs:
            artifact_id = kwargs['artifactId']
        if 'artifactPath' in kwargs:
            artifact_path = kwargs['artifactPath']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'repositoryId' in kwargs:
            repository_id = kwargs['repositoryId']
        if 'sizeInBytes' in kwargs:
            size_in_bytes = kwargs['sizeInBytes']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("artifact_id", artifact_id)
        _setter("artifact_path", artifact_path)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("repository_id", repository_id)
        _setter("sha256", sha256)
        _setter("size_in_bytes", size_in_bytes)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("version", version)

    @property
    @pulumi.getter(name="artifactId")
    def artifact_id(self) -> str:
        return pulumi.get(self, "artifact_id")

    @property
    @pulumi.getter(name="artifactPath")
    def artifact_path(self) -> str:
        """
        Filter results by a prefix for the `artifactPath` and and return artifacts that begin with the specified prefix in their path.
        """
        return pulumi.get(self, "artifact_path")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="repositoryId")
    def repository_id(self) -> str:
        """
        A filter to return the artifacts only for the specified repository OCID.
        """
        return pulumi.get(self, "repository_id")

    @property
    @pulumi.getter
    def sha256(self) -> str:
        """
        Filter results by a specified SHA256 digest for the artifact.
        """
        return pulumi.get(self, "sha256")

    @property
    @pulumi.getter(name="sizeInBytes")
    def size_in_bytes(self) -> str:
        """
        The size of the artifact in bytes.
        """
        return pulumi.get(self, "size_in_bytes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Filter results by a prefix for `version` and return artifacts that that begin with the specified prefix in their version.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetRepositoriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetRepositoriesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionResult(dict):
    def __init__(__self__, *,
                 items: Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']):
        GetRepositoriesRepositoryCollectionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            items=items,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             items: Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("items", items)

    @property
    @pulumi.getter
    def items(self) -> Sequence['outputs.GetRepositoriesRepositoryCollectionItemResult']:
        return pulumi.get(self, "items")


@pulumi.output_type
class GetRepositoriesRepositoryCollectionItemResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 is_immutable: bool,
                 repository_type: str,
                 state: str,
                 time_created: str):
        """
        :param str compartment_id: The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        :param str description: The repository description.
        :param str display_name: A filter to return only resources that match the given display name exactly.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        :param str id: A filter to return the resources for the specified OCID.
        :param bool is_immutable: A filter to return resources that match the isImmutable value.
        :param str repository_type: The repository's supported artifact type.
        :param str state: A filter to return only resources that match the given lifecycle state name exactly.
        :param str time_created: An RFC 3339 timestamp indicating when the repository was created.
        """
        GetRepositoriesRepositoryCollectionItemResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            description=description,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            is_immutable=is_immutable,
            repository_type=repository_type,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             description: str,
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             is_immutable: bool,
             repository_type: str,
             state: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isImmutable' in kwargs:
            is_immutable = kwargs['isImmutable']
        if 'repositoryType' in kwargs:
            repository_type = kwargs['repositoryType']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("is_immutable", is_immutable)
        _setter("repository_type", repository_type)
        _setter("state", state)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The [OCID](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/identifiers.htm) of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The repository description.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A filter to return only resources that match the given display name exactly.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm).  Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        A filter to return the resources for the specified OCID.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="isImmutable")
    def is_immutable(self) -> bool:
        """
        A filter to return resources that match the isImmutable value.
        """
        return pulumi.get(self, "is_immutable")

    @property
    @pulumi.getter(name="repositoryType")
    def repository_type(self) -> str:
        """
        The repository's supported artifact type.
        """
        return pulumi.get(self, "repository_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A filter to return only resources that match the given lifecycle state name exactly.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        An RFC 3339 timestamp indicating when the repository was created.
        """
        return pulumi.get(self, "time_created")


