# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TargetAssetArgs', 'TargetAsset']

@pulumi.input_type
class TargetAssetArgs:
    def __init__(__self__, *,
                 is_excluded_from_execution: pulumi.Input[bool],
                 migration_plan_id: pulumi.Input[str],
                 preferred_shape_type: pulumi.Input[str],
                 type: pulumi.Input[str],
                 user_spec: pulumi.Input['TargetAssetUserSpecArgs'],
                 block_volumes_performance: Optional[pulumi.Input[int]] = None,
                 ms_license: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TargetAsset resource.
        :param pulumi.Input[bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[str] type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param pulumi.Input['TargetAssetUserSpecArgs'] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[str] ms_license: (Updatable) Microsoft license for the VM configuration.
        """
        TargetAssetArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_excluded_from_execution=is_excluded_from_execution,
            migration_plan_id=migration_plan_id,
            preferred_shape_type=preferred_shape_type,
            type=type,
            user_spec=user_spec,
            block_volumes_performance=block_volumes_performance,
            ms_license=ms_license,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_excluded_from_execution: pulumi.Input[bool],
             migration_plan_id: pulumi.Input[str],
             preferred_shape_type: pulumi.Input[str],
             type: pulumi.Input[str],
             user_spec: pulumi.Input['TargetAssetUserSpecArgs'],
             block_volumes_performance: Optional[pulumi.Input[int]] = None,
             ms_license: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isExcludedFromExecution' in kwargs:
            is_excluded_from_execution = kwargs['isExcludedFromExecution']
        if 'migrationPlanId' in kwargs:
            migration_plan_id = kwargs['migrationPlanId']
        if 'preferredShapeType' in kwargs:
            preferred_shape_type = kwargs['preferredShapeType']
        if 'userSpec' in kwargs:
            user_spec = kwargs['userSpec']
        if 'blockVolumesPerformance' in kwargs:
            block_volumes_performance = kwargs['blockVolumesPerformance']
        if 'msLicense' in kwargs:
            ms_license = kwargs['msLicense']

        _setter("is_excluded_from_execution", is_excluded_from_execution)
        _setter("migration_plan_id", migration_plan_id)
        _setter("preferred_shape_type", preferred_shape_type)
        _setter("type", type)
        _setter("user_spec", user_spec)
        if block_volumes_performance is not None:
            _setter("block_volumes_performance", block_volumes_performance)
        if ms_license is not None:
            _setter("ms_license", ms_license)

    @property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> pulumi.Input[bool]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @is_excluded_from_execution.setter
    def is_excluded_from_execution(self, value: pulumi.Input[bool]):
        pulumi.set(self, "is_excluded_from_execution", value)

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> pulumi.Input[str]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @migration_plan_id.setter
    def migration_plan_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "migration_plan_id", value)

    @property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> pulumi.Input[str]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @preferred_shape_type.setter
    def preferred_shape_type(self, value: pulumi.Input[str]):
        pulumi.set(self, "preferred_shape_type", value)

    @property
    @pulumi.getter
    def type(self) -> pulumi.Input[str]:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: pulumi.Input[str]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> pulumi.Input['TargetAssetUserSpecArgs']:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

    @user_spec.setter
    def user_spec(self, value: pulumi.Input['TargetAssetUserSpecArgs']):
        pulumi.set(self, "user_spec", value)

    @property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @block_volumes_performance.setter
    def block_volumes_performance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_volumes_performance", value)

    @property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @ms_license.setter
    def ms_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ms_license", value)


@pulumi.input_type
class _TargetAssetState:
    def __init__(__self__, *,
                 block_volumes_performance: Optional[pulumi.Input[int]] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 compatibility_messages: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]] = None,
                 created_resource_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 estimated_costs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[bool]] = None,
                 lifecycle_details: Optional[pulumi.Input[str]] = None,
                 migration_assets: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]] = None,
                 migration_plan_id: Optional[pulumi.Input[str]] = None,
                 ms_license: Optional[pulumi.Input[str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[str]] = None,
                 recommended_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]] = None,
                 state: Optional[pulumi.Input[str]] = None,
                 test_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]] = None,
                 time_assessed: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_updated: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_spec: Optional[pulumi.Input['TargetAssetUserSpecArgs']] = None):
        """
        Input properties used for looking up and filtering TargetAsset resources.
        :param pulumi.Input[int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]] compatibility_messages: Messages about the compatibility issues.
        :param pulumi.Input[str] created_resource_id: Created resource identifier
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]] estimated_costs: Cost estimation description
        :param pulumi.Input[bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]] migration_assets: Description of the migration asset.
        :param pulumi.Input[str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]] recommended_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[str] state: The current state of the target asset.
        :param pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]] test_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[str] time_assessed: The time when the assessment was done. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_created: The time when the target asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the target asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param pulumi.Input['TargetAssetUserSpecArgs'] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        _TargetAssetState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            block_volumes_performance=block_volumes_performance,
            compartment_id=compartment_id,
            compatibility_messages=compatibility_messages,
            created_resource_id=created_resource_id,
            display_name=display_name,
            estimated_costs=estimated_costs,
            is_excluded_from_execution=is_excluded_from_execution,
            lifecycle_details=lifecycle_details,
            migration_assets=migration_assets,
            migration_plan_id=migration_plan_id,
            ms_license=ms_license,
            preferred_shape_type=preferred_shape_type,
            recommended_specs=recommended_specs,
            state=state,
            test_specs=test_specs,
            time_assessed=time_assessed,
            time_created=time_created,
            time_updated=time_updated,
            type=type,
            user_spec=user_spec,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             block_volumes_performance: Optional[pulumi.Input[int]] = None,
             compartment_id: Optional[pulumi.Input[str]] = None,
             compatibility_messages: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]] = None,
             created_resource_id: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             estimated_costs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]] = None,
             is_excluded_from_execution: Optional[pulumi.Input[bool]] = None,
             lifecycle_details: Optional[pulumi.Input[str]] = None,
             migration_assets: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]] = None,
             migration_plan_id: Optional[pulumi.Input[str]] = None,
             ms_license: Optional[pulumi.Input[str]] = None,
             preferred_shape_type: Optional[pulumi.Input[str]] = None,
             recommended_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]] = None,
             state: Optional[pulumi.Input[str]] = None,
             test_specs: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]] = None,
             time_assessed: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_updated: Optional[pulumi.Input[str]] = None,
             type: Optional[pulumi.Input[str]] = None,
             user_spec: Optional[pulumi.Input['TargetAssetUserSpecArgs']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'blockVolumesPerformance' in kwargs:
            block_volumes_performance = kwargs['blockVolumesPerformance']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'compatibilityMessages' in kwargs:
            compatibility_messages = kwargs['compatibilityMessages']
        if 'createdResourceId' in kwargs:
            created_resource_id = kwargs['createdResourceId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'estimatedCosts' in kwargs:
            estimated_costs = kwargs['estimatedCosts']
        if 'isExcludedFromExecution' in kwargs:
            is_excluded_from_execution = kwargs['isExcludedFromExecution']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'migrationAssets' in kwargs:
            migration_assets = kwargs['migrationAssets']
        if 'migrationPlanId' in kwargs:
            migration_plan_id = kwargs['migrationPlanId']
        if 'msLicense' in kwargs:
            ms_license = kwargs['msLicense']
        if 'preferredShapeType' in kwargs:
            preferred_shape_type = kwargs['preferredShapeType']
        if 'recommendedSpecs' in kwargs:
            recommended_specs = kwargs['recommendedSpecs']
        if 'testSpecs' in kwargs:
            test_specs = kwargs['testSpecs']
        if 'timeAssessed' in kwargs:
            time_assessed = kwargs['timeAssessed']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'userSpec' in kwargs:
            user_spec = kwargs['userSpec']

        if block_volumes_performance is not None:
            _setter("block_volumes_performance", block_volumes_performance)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if compatibility_messages is not None:
            _setter("compatibility_messages", compatibility_messages)
        if created_resource_id is not None:
            _setter("created_resource_id", created_resource_id)
        if display_name is not None:
            _setter("display_name", display_name)
        if estimated_costs is not None:
            _setter("estimated_costs", estimated_costs)
        if is_excluded_from_execution is not None:
            _setter("is_excluded_from_execution", is_excluded_from_execution)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if migration_assets is not None:
            _setter("migration_assets", migration_assets)
        if migration_plan_id is not None:
            _setter("migration_plan_id", migration_plan_id)
        if ms_license is not None:
            _setter("ms_license", ms_license)
        if preferred_shape_type is not None:
            _setter("preferred_shape_type", preferred_shape_type)
        if recommended_specs is not None:
            _setter("recommended_specs", recommended_specs)
        if state is not None:
            _setter("state", state)
        if test_specs is not None:
            _setter("test_specs", test_specs)
        if time_assessed is not None:
            _setter("time_assessed", time_assessed)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if type is not None:
            _setter("type", type)
        if user_spec is not None:
            _setter("user_spec", user_spec)

    @property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> Optional[pulumi.Input[int]]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @block_volumes_performance.setter
    def block_volumes_performance(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "block_volumes_performance", value)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="compatibilityMessages")
    def compatibility_messages(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]]:
        """
        Messages about the compatibility issues.
        """
        return pulumi.get(self, "compatibility_messages")

    @compatibility_messages.setter
    def compatibility_messages(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetCompatibilityMessageArgs']]]]):
        pulumi.set(self, "compatibility_messages", value)

    @property
    @pulumi.getter(name="createdResourceId")
    def created_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Created resource identifier
        """
        return pulumi.get(self, "created_resource_id")

    @created_resource_id.setter
    def created_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "created_resource_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="estimatedCosts")
    def estimated_costs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]]:
        """
        Cost estimation description
        """
        return pulumi.get(self, "estimated_costs")

    @estimated_costs.setter
    def estimated_costs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetEstimatedCostArgs']]]]):
        pulumi.set(self, "estimated_costs", value)

    @property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> Optional[pulumi.Input[bool]]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @is_excluded_from_execution.setter
    def is_excluded_from_execution(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_excluded_from_execution", value)

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[pulumi.Input[str]]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @lifecycle_details.setter
    def lifecycle_details(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "lifecycle_details", value)

    @property
    @pulumi.getter(name="migrationAssets")
    def migration_assets(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]]:
        """
        Description of the migration asset.
        """
        return pulumi.get(self, "migration_assets")

    @migration_assets.setter
    def migration_assets(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetMigrationAssetArgs']]]]):
        pulumi.set(self, "migration_assets", value)

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> Optional[pulumi.Input[str]]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @migration_plan_id.setter
    def migration_plan_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "migration_plan_id", value)

    @property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @ms_license.setter
    def ms_license(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ms_license", value)

    @property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @preferred_shape_type.setter
    def preferred_shape_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "preferred_shape_type", value)

    @property
    @pulumi.getter(name="recommendedSpecs")
    def recommended_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "recommended_specs")

    @recommended_specs.setter
    def recommended_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetRecommendedSpecArgs']]]]):
        pulumi.set(self, "recommended_specs", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)

    @property
    @pulumi.getter(name="testSpecs")
    def test_specs(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "test_specs")

    @test_specs.setter
    def test_specs(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TargetAssetTestSpecArgs']]]]):
        pulumi.set(self, "test_specs", value)

    @property
    @pulumi.getter(name="timeAssessed")
    def time_assessed(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the assessment was done. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_assessed")

    @time_assessed.setter
    def time_assessed(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_assessed", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the target asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[pulumi.Input[str]]:
        """
        The time when the target asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @time_updated.setter
    def time_updated(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_updated", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)

    @property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> Optional[pulumi.Input['TargetAssetUserSpecArgs']]:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

    @user_spec.setter
    def user_spec(self, value: Optional[pulumi.Input['TargetAssetUserSpecArgs']]):
        pulumi.set(self, "user_spec", value)


class TargetAsset(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_volumes_performance: Optional[pulumi.Input[int]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[bool]] = None,
                 migration_plan_id: Optional[pulumi.Input[str]] = None,
                 ms_license: Optional[pulumi.Input[str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_spec: Optional[pulumi.Input[pulumi.InputType['TargetAssetUserSpecArgs']]] = None,
                 __props__=None):
        """
        This resource provides the Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a target asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_asset = oci.cloud_migrations.TargetAsset("testTargetAsset",
            is_excluded_from_execution=var["target_asset_is_excluded_from_execution"],
            migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"],
            preferred_shape_type=var["target_asset_preferred_shape_type"],
            type=var["target_asset_type"],
            user_spec=oci.cloud_migrations.TargetAssetUserSpecArgs(
                agent_config=oci.cloud_migrations.TargetAssetUserSpecAgentConfigArgs(
                    are_all_plugins_disabled=var["target_asset_user_spec_agent_config_are_all_plugins_disabled"],
                    is_management_disabled=var["target_asset_user_spec_agent_config_is_management_disabled"],
                    is_monitoring_disabled=var["target_asset_user_spec_agent_config_is_monitoring_disabled"],
                    plugins_configs=[oci.cloud_migrations.TargetAssetUserSpecAgentConfigPluginsConfigArgs(
                        desired_state=var["target_asset_user_spec_agent_config_plugins_config_desired_state"],
                        name=var["target_asset_user_spec_agent_config_plugins_config_name"],
                    )],
                ),
                availability_domain=var["target_asset_user_spec_availability_domain"],
                capacity_reservation_id=oci_cloud_migrations_capacity_reservation["test_capacity_reservation"]["id"],
                compartment_id=var["compartment_id"],
                create_vnic_details=oci.cloud_migrations.TargetAssetUserSpecCreateVnicDetailsArgs(
                    assign_private_dns_record=var["target_asset_user_spec_create_vnic_details_assign_private_dns_record"],
                    assign_public_ip=var["target_asset_user_spec_create_vnic_details_assign_public_ip"],
                    defined_tags={
                        "foo-namespace.bar-key": "value",
                    },
                    display_name=var["target_asset_user_spec_create_vnic_details_display_name"],
                    freeform_tags={
                        "bar-key": "value",
                    },
                    hostname_label=var["target_asset_user_spec_create_vnic_details_hostname_label"],
                    nsg_ids=var["target_asset_user_spec_create_vnic_details_nsg_ids"],
                    private_ip=var["target_asset_user_spec_create_vnic_details_private_ip"],
                    skip_source_dest_check=var["target_asset_user_spec_create_vnic_details_skip_source_dest_check"],
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    vlan_id=oci_core_vlan["test_vlan"]["id"],
                ),
                dedicated_vm_host_id=oci_core_dedicated_vm_host["test_dedicated_vm_host"]["id"],
                defined_tags={
                    "foo-namespace.bar-key": "value",
                },
                display_name=var["target_asset_user_spec_display_name"],
                fault_domain=var["target_asset_user_spec_fault_domain"],
                freeform_tags={
                    "bar-key": "value",
                },
                hostname_label=var["target_asset_user_spec_hostname_label"],
                instance_options=oci.cloud_migrations.TargetAssetUserSpecInstanceOptionsArgs(
                    are_legacy_imds_endpoints_disabled=var["target_asset_user_spec_instance_options_are_legacy_imds_endpoints_disabled"],
                ),
                ipxe_script=var["target_asset_user_spec_ipxe_script"],
                is_pv_encryption_in_transit_enabled=var["target_asset_user_spec_is_pv_encryption_in_transit_enabled"],
                preemptible_instance_config=oci.cloud_migrations.TargetAssetUserSpecPreemptibleInstanceConfigArgs(
                    preemption_action=oci.cloud_migrations.TargetAssetUserSpecPreemptibleInstanceConfigPreemptionActionArgs(
                        type=var["target_asset_user_spec_preemptible_instance_config_preemption_action_type"],
                        preserve_boot_volume=var["target_asset_user_spec_preemptible_instance_config_preemption_action_preserve_boot_volume"],
                    ),
                ),
                shape=var["target_asset_user_spec_shape"],
                shape_config=oci.cloud_migrations.TargetAssetUserSpecShapeConfigArgs(
                    baseline_ocpu_utilization=var["target_asset_user_spec_shape_config_baseline_ocpu_utilization"],
                    memory_in_gbs=var["target_asset_user_spec_shape_config_memory_in_gbs"],
                    ocpus=var["target_asset_user_spec_shape_config_ocpus"],
                ),
                source_details=oci.cloud_migrations.TargetAssetUserSpecSourceDetailsArgs(
                    source_type=var["target_asset_user_spec_source_details_source_type"],
                    boot_volume_id=oci_core_boot_volume["test_boot_volume"]["id"],
                    boot_volume_size_in_gbs=var["target_asset_user_spec_source_details_boot_volume_size_in_gbs"],
                    boot_volume_vpus_per_gb=var["target_asset_user_spec_source_details_boot_volume_vpus_per_gb"],
                    image_id=oci_core_image["test_image"]["id"],
                    kms_key_id=oci_kms_key["test_key"]["id"],
                ),
            ),
            block_volumes_performance=var["target_asset_block_volumes_performance"],
            ms_license=var["target_asset_ms_license"])
        ```

        ## Import

        TargetAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/targetAsset:TargetAsset test_target_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[str] type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param pulumi.Input[pulumi.InputType['TargetAssetUserSpecArgs']] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TargetAssetArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the Target Asset resource in Oracle Cloud Infrastructure Cloud Migrations service.

        Creates a target asset.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_target_asset = oci.cloud_migrations.TargetAsset("testTargetAsset",
            is_excluded_from_execution=var["target_asset_is_excluded_from_execution"],
            migration_plan_id=oci_cloud_migrations_migration_plan["test_migration_plan"]["id"],
            preferred_shape_type=var["target_asset_preferred_shape_type"],
            type=var["target_asset_type"],
            user_spec=oci.cloud_migrations.TargetAssetUserSpecArgs(
                agent_config=oci.cloud_migrations.TargetAssetUserSpecAgentConfigArgs(
                    are_all_plugins_disabled=var["target_asset_user_spec_agent_config_are_all_plugins_disabled"],
                    is_management_disabled=var["target_asset_user_spec_agent_config_is_management_disabled"],
                    is_monitoring_disabled=var["target_asset_user_spec_agent_config_is_monitoring_disabled"],
                    plugins_configs=[oci.cloud_migrations.TargetAssetUserSpecAgentConfigPluginsConfigArgs(
                        desired_state=var["target_asset_user_spec_agent_config_plugins_config_desired_state"],
                        name=var["target_asset_user_spec_agent_config_plugins_config_name"],
                    )],
                ),
                availability_domain=var["target_asset_user_spec_availability_domain"],
                capacity_reservation_id=oci_cloud_migrations_capacity_reservation["test_capacity_reservation"]["id"],
                compartment_id=var["compartment_id"],
                create_vnic_details=oci.cloud_migrations.TargetAssetUserSpecCreateVnicDetailsArgs(
                    assign_private_dns_record=var["target_asset_user_spec_create_vnic_details_assign_private_dns_record"],
                    assign_public_ip=var["target_asset_user_spec_create_vnic_details_assign_public_ip"],
                    defined_tags={
                        "foo-namespace.bar-key": "value",
                    },
                    display_name=var["target_asset_user_spec_create_vnic_details_display_name"],
                    freeform_tags={
                        "bar-key": "value",
                    },
                    hostname_label=var["target_asset_user_spec_create_vnic_details_hostname_label"],
                    nsg_ids=var["target_asset_user_spec_create_vnic_details_nsg_ids"],
                    private_ip=var["target_asset_user_spec_create_vnic_details_private_ip"],
                    skip_source_dest_check=var["target_asset_user_spec_create_vnic_details_skip_source_dest_check"],
                    subnet_id=oci_core_subnet["test_subnet"]["id"],
                    vlan_id=oci_core_vlan["test_vlan"]["id"],
                ),
                dedicated_vm_host_id=oci_core_dedicated_vm_host["test_dedicated_vm_host"]["id"],
                defined_tags={
                    "foo-namespace.bar-key": "value",
                },
                display_name=var["target_asset_user_spec_display_name"],
                fault_domain=var["target_asset_user_spec_fault_domain"],
                freeform_tags={
                    "bar-key": "value",
                },
                hostname_label=var["target_asset_user_spec_hostname_label"],
                instance_options=oci.cloud_migrations.TargetAssetUserSpecInstanceOptionsArgs(
                    are_legacy_imds_endpoints_disabled=var["target_asset_user_spec_instance_options_are_legacy_imds_endpoints_disabled"],
                ),
                ipxe_script=var["target_asset_user_spec_ipxe_script"],
                is_pv_encryption_in_transit_enabled=var["target_asset_user_spec_is_pv_encryption_in_transit_enabled"],
                preemptible_instance_config=oci.cloud_migrations.TargetAssetUserSpecPreemptibleInstanceConfigArgs(
                    preemption_action=oci.cloud_migrations.TargetAssetUserSpecPreemptibleInstanceConfigPreemptionActionArgs(
                        type=var["target_asset_user_spec_preemptible_instance_config_preemption_action_type"],
                        preserve_boot_volume=var["target_asset_user_spec_preemptible_instance_config_preemption_action_preserve_boot_volume"],
                    ),
                ),
                shape=var["target_asset_user_spec_shape"],
                shape_config=oci.cloud_migrations.TargetAssetUserSpecShapeConfigArgs(
                    baseline_ocpu_utilization=var["target_asset_user_spec_shape_config_baseline_ocpu_utilization"],
                    memory_in_gbs=var["target_asset_user_spec_shape_config_memory_in_gbs"],
                    ocpus=var["target_asset_user_spec_shape_config_ocpus"],
                ),
                source_details=oci.cloud_migrations.TargetAssetUserSpecSourceDetailsArgs(
                    source_type=var["target_asset_user_spec_source_details_source_type"],
                    boot_volume_id=oci_core_boot_volume["test_boot_volume"]["id"],
                    boot_volume_size_in_gbs=var["target_asset_user_spec_source_details_boot_volume_size_in_gbs"],
                    boot_volume_vpus_per_gb=var["target_asset_user_spec_source_details_boot_volume_vpus_per_gb"],
                    image_id=oci_core_image["test_image"]["id"],
                    kms_key_id=oci_kms_key["test_key"]["id"],
                ),
            ),
            block_volumes_performance=var["target_asset_block_volumes_performance"],
            ms_license=var["target_asset_ms_license"])
        ```

        ## Import

        TargetAssets can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:CloudMigrations/targetAsset:TargetAsset test_target_asset "id"
        ```

        :param str resource_name: The name of the resource.
        :param TargetAssetArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TargetAssetArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            TargetAssetArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 block_volumes_performance: Optional[pulumi.Input[int]] = None,
                 is_excluded_from_execution: Optional[pulumi.Input[bool]] = None,
                 migration_plan_id: Optional[pulumi.Input[str]] = None,
                 ms_license: Optional[pulumi.Input[str]] = None,
                 preferred_shape_type: Optional[pulumi.Input[str]] = None,
                 type: Optional[pulumi.Input[str]] = None,
                 user_spec: Optional[pulumi.Input[pulumi.InputType['TargetAssetUserSpecArgs']]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TargetAssetArgs.__new__(TargetAssetArgs)

            __props__.__dict__["block_volumes_performance"] = block_volumes_performance
            if is_excluded_from_execution is None and not opts.urn:
                raise TypeError("Missing required property 'is_excluded_from_execution'")
            __props__.__dict__["is_excluded_from_execution"] = is_excluded_from_execution
            if migration_plan_id is None and not opts.urn:
                raise TypeError("Missing required property 'migration_plan_id'")
            __props__.__dict__["migration_plan_id"] = migration_plan_id
            __props__.__dict__["ms_license"] = ms_license
            if preferred_shape_type is None and not opts.urn:
                raise TypeError("Missing required property 'preferred_shape_type'")
            __props__.__dict__["preferred_shape_type"] = preferred_shape_type
            if type is None and not opts.urn:
                raise TypeError("Missing required property 'type'")
            __props__.__dict__["type"] = type
            if user_spec is not None and not isinstance(user_spec, TargetAssetUserSpecArgs):
                user_spec = user_spec or {}
                def _setter(key, value):
                    user_spec[key] = value
                TargetAssetUserSpecArgs._configure(_setter, **user_spec)
            if user_spec is None and not opts.urn:
                raise TypeError("Missing required property 'user_spec'")
            __props__.__dict__["user_spec"] = user_spec
            __props__.__dict__["compartment_id"] = None
            __props__.__dict__["compatibility_messages"] = None
            __props__.__dict__["created_resource_id"] = None
            __props__.__dict__["display_name"] = None
            __props__.__dict__["estimated_costs"] = None
            __props__.__dict__["lifecycle_details"] = None
            __props__.__dict__["migration_assets"] = None
            __props__.__dict__["recommended_specs"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["test_specs"] = None
            __props__.__dict__["time_assessed"] = None
            __props__.__dict__["time_created"] = None
            __props__.__dict__["time_updated"] = None
        super(TargetAsset, __self__).__init__(
            'oci:CloudMigrations/targetAsset:TargetAsset',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            block_volumes_performance: Optional[pulumi.Input[int]] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            compatibility_messages: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetCompatibilityMessageArgs']]]]] = None,
            created_resource_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            estimated_costs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetEstimatedCostArgs']]]]] = None,
            is_excluded_from_execution: Optional[pulumi.Input[bool]] = None,
            lifecycle_details: Optional[pulumi.Input[str]] = None,
            migration_assets: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetMigrationAssetArgs']]]]] = None,
            migration_plan_id: Optional[pulumi.Input[str]] = None,
            ms_license: Optional[pulumi.Input[str]] = None,
            preferred_shape_type: Optional[pulumi.Input[str]] = None,
            recommended_specs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetRecommendedSpecArgs']]]]] = None,
            state: Optional[pulumi.Input[str]] = None,
            test_specs: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetTestSpecArgs']]]]] = None,
            time_assessed: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_updated: Optional[pulumi.Input[str]] = None,
            type: Optional[pulumi.Input[str]] = None,
            user_spec: Optional[pulumi.Input[pulumi.InputType['TargetAssetUserSpecArgs']]] = None) -> 'TargetAsset':
        """
        Get an existing TargetAsset resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[int] block_volumes_performance: (Updatable) Performance of the block volumes.
        :param pulumi.Input[str] compartment_id: (Updatable) The OCID of the compartment.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetCompatibilityMessageArgs']]]] compatibility_messages: Messages about the compatibility issues.
        :param pulumi.Input[str] created_resource_id: Created resource identifier
        :param pulumi.Input[str] display_name: (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetEstimatedCostArgs']]]] estimated_costs: Cost estimation description
        :param pulumi.Input[bool] is_excluded_from_execution: (Updatable) A boolean indicating whether the asset should be migrated.
        :param pulumi.Input[str] lifecycle_details: A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetMigrationAssetArgs']]]] migration_assets: Description of the migration asset.
        :param pulumi.Input[str] migration_plan_id: OCID of the associated migration plan.
        :param pulumi.Input[str] ms_license: (Updatable) Microsoft license for the VM configuration.
        :param pulumi.Input[str] preferred_shape_type: (Updatable) Preferred VM shape type that you provide.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetRecommendedSpecArgs']]]] recommended_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[str] state: The current state of the target asset.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['TargetAssetTestSpecArgs']]]] test_specs: Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        :param pulumi.Input[str] time_assessed: The time when the assessment was done. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_created: The time when the target asset was created. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] time_updated: The time when the target asset was updated. An RFC3339 formatted datetime string.
        :param pulumi.Input[str] type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param pulumi.Input[pulumi.InputType['TargetAssetUserSpecArgs']] user_spec: (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TargetAssetState.__new__(_TargetAssetState)

        __props__.__dict__["block_volumes_performance"] = block_volumes_performance
        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["compatibility_messages"] = compatibility_messages
        __props__.__dict__["created_resource_id"] = created_resource_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["estimated_costs"] = estimated_costs
        __props__.__dict__["is_excluded_from_execution"] = is_excluded_from_execution
        __props__.__dict__["lifecycle_details"] = lifecycle_details
        __props__.__dict__["migration_assets"] = migration_assets
        __props__.__dict__["migration_plan_id"] = migration_plan_id
        __props__.__dict__["ms_license"] = ms_license
        __props__.__dict__["preferred_shape_type"] = preferred_shape_type
        __props__.__dict__["recommended_specs"] = recommended_specs
        __props__.__dict__["state"] = state
        __props__.__dict__["test_specs"] = test_specs
        __props__.__dict__["time_assessed"] = time_assessed
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_updated"] = time_updated
        __props__.__dict__["type"] = type
        __props__.__dict__["user_spec"] = user_spec
        return TargetAsset(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="blockVolumesPerformance")
    def block_volumes_performance(self) -> pulumi.Output[int]:
        """
        (Updatable) Performance of the block volumes.
        """
        return pulumi.get(self, "block_volumes_performance")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        (Updatable) The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="compatibilityMessages")
    def compatibility_messages(self) -> pulumi.Output[Sequence['outputs.TargetAssetCompatibilityMessage']]:
        """
        Messages about the compatibility issues.
        """
        return pulumi.get(self, "compatibility_messages")

    @property
    @pulumi.getter(name="createdResourceId")
    def created_resource_id(self) -> pulumi.Output[str]:
        """
        Created resource identifier
        """
        return pulumi.get(self, "created_resource_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        (Updatable) A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedCosts")
    def estimated_costs(self) -> pulumi.Output[Sequence['outputs.TargetAssetEstimatedCost']]:
        """
        Cost estimation description
        """
        return pulumi.get(self, "estimated_costs")

    @property
    @pulumi.getter(name="isExcludedFromExecution")
    def is_excluded_from_execution(self) -> pulumi.Output[bool]:
        """
        (Updatable) A boolean indicating whether the asset should be migrated.
        """
        return pulumi.get(self, "is_excluded_from_execution")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> pulumi.Output[str]:
        """
        A message describing the current state in more detail. For example, it can be used to provide actionable information for a resource in Failed state.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="migrationAssets")
    def migration_assets(self) -> pulumi.Output[Sequence['outputs.TargetAssetMigrationAsset']]:
        """
        Description of the migration asset.
        """
        return pulumi.get(self, "migration_assets")

    @property
    @pulumi.getter(name="migrationPlanId")
    def migration_plan_id(self) -> pulumi.Output[str]:
        """
        OCID of the associated migration plan.
        """
        return pulumi.get(self, "migration_plan_id")

    @property
    @pulumi.getter(name="msLicense")
    def ms_license(self) -> pulumi.Output[str]:
        """
        (Updatable) Microsoft license for the VM configuration.
        """
        return pulumi.get(self, "ms_license")

    @property
    @pulumi.getter(name="preferredShapeType")
    def preferred_shape_type(self) -> pulumi.Output[str]:
        """
        (Updatable) Preferred VM shape type that you provide.
        """
        return pulumi.get(self, "preferred_shape_type")

    @property
    @pulumi.getter(name="recommendedSpecs")
    def recommended_specs(self) -> pulumi.Output[Sequence['outputs.TargetAssetRecommendedSpec']]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "recommended_specs")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The current state of the target asset.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="testSpecs")
    def test_specs(self) -> pulumi.Output[Sequence['outputs.TargetAssetTestSpec']]:
        """
        Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "test_specs")

    @property
    @pulumi.getter(name="timeAssessed")
    def time_assessed(self) -> pulumi.Output[str]:
        """
        The time when the assessment was done. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_assessed")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        The time when the target asset was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> pulumi.Output[str]:
        """
        The time when the target asset was updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def type(self) -> pulumi.Output[str]:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="userSpec")
    def user_spec(self) -> pulumi.Output['outputs.TargetAssetUserSpec']:
        """
        (Updatable) Instance launch details. Use the `sourceDetails` parameter to specify whether a boot volume or an image should be used to launch a new instance.
        """
        return pulumi.get(self, "user_spec")

