# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs

__all__ = [
    'AddonAddonError',
    'AddonConfiguration',
    'ClusterClusterPodNetworkOption',
    'ClusterEndpoint',
    'ClusterEndpointConfig',
    'ClusterImagePolicyConfig',
    'ClusterImagePolicyConfigKeyDetail',
    'ClusterMetadata',
    'ClusterOptions',
    'ClusterOptionsAddOns',
    'ClusterOptionsAdmissionControllerOptions',
    'ClusterOptionsKubernetesNetworkConfig',
    'ClusterOptionsPersistentVolumeConfig',
    'ClusterOptionsServiceLbConfig',
    'ContainerInstanceContainer',
    'ContainerInstanceContainerHealthCheck',
    'ContainerInstanceContainerHealthCheckHeader',
    'ContainerInstanceContainerResourceConfig',
    'ContainerInstanceContainerSecurityContext',
    'ContainerInstanceContainerVolumeMount',
    'ContainerInstanceDnsConfig',
    'ContainerInstanceImagePullSecret',
    'ContainerInstanceShapeConfig',
    'ContainerInstanceVnic',
    'ContainerInstanceVolume',
    'ContainerInstanceVolumeConfig',
    'NodePoolInitialNodeLabel',
    'NodePoolNode',
    'NodePoolNodeConfigDetails',
    'NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails',
    'NodePoolNodeConfigDetailsPlacementConfig',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig',
    'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction',
    'NodePoolNodeError',
    'NodePoolNodeEvictionNodePoolSettings',
    'NodePoolNodePoolCyclingDetails',
    'NodePoolNodeShapeConfig',
    'NodePoolNodeSource',
    'NodePoolNodeSourceDetails',
    'VirtualNodePoolInitialVirtualNodeLabel',
    'VirtualNodePoolPlacementConfiguration',
    'VirtualNodePoolPodConfiguration',
    'VirtualNodePoolTaint',
    'VirtualNodePoolVirtualNodeTags',
    'GetAddonAddonErrorResult',
    'GetAddonConfigurationResult',
    'GetAddonOptionsAddonOptionResult',
    'GetAddonOptionsAddonOptionVersionResult',
    'GetAddonOptionsAddonOptionVersionConfigurationResult',
    'GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult',
    'GetAddonOptionsFilterResult',
    'GetAddonsAddonResult',
    'GetAddonsAddonAddonErrorResult',
    'GetAddonsAddonConfigurationResult',
    'GetAddonsFilterResult',
    'GetClusterOptionClusterPodNetworkOptionResult',
    'GetClusterWorkloadMappingsFilterResult',
    'GetClusterWorkloadMappingsWorkloadMappingResult',
    'GetClustersClusterResult',
    'GetClustersClusterClusterPodNetworkOptionResult',
    'GetClustersClusterEndpointResult',
    'GetClustersClusterEndpointConfigResult',
    'GetClustersClusterImagePolicyConfigResult',
    'GetClustersClusterImagePolicyConfigKeyDetailResult',
    'GetClustersClusterMetadataResult',
    'GetClustersClusterOptionResult',
    'GetClustersClusterOptionAddOnResult',
    'GetClustersClusterOptionAdmissionControllerOptionResult',
    'GetClustersClusterOptionKubernetesNetworkConfigResult',
    'GetClustersClusterOptionPersistentVolumeConfigResult',
    'GetClustersClusterOptionServiceLbConfigResult',
    'GetClustersFilterResult',
    'GetNodePoolInitialNodeLabelResult',
    'GetNodePoolNodeResult',
    'GetNodePoolNodeConfigDetailResult',
    'GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult',
    'GetNodePoolNodeConfigDetailPlacementConfigResult',
    'GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult',
    'GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult',
    'GetNodePoolNodeErrorResult',
    'GetNodePoolNodeEvictionNodePoolSettingResult',
    'GetNodePoolNodePoolCyclingDetailResult',
    'GetNodePoolNodeShapeConfigResult',
    'GetNodePoolNodeSourceResult',
    'GetNodePoolNodeSourceDetailResult',
    'GetNodePoolOptionSourceResult',
    'GetNodePoolsFilterResult',
    'GetNodePoolsNodePoolResult',
    'GetNodePoolsNodePoolInitialNodeLabelResult',
    'GetNodePoolsNodePoolNodeResult',
    'GetNodePoolsNodePoolNodeConfigDetailResult',
    'GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult',
    'GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult',
    'GetNodePoolsNodePoolNodeErrorResult',
    'GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult',
    'GetNodePoolsNodePoolNodePoolCyclingDetailResult',
    'GetNodePoolsNodePoolNodeShapeConfigResult',
    'GetNodePoolsNodePoolNodeSourceResult',
    'GetNodePoolsNodePoolNodeSourceDetailResult',
    'GetPodShapesFilterResult',
    'GetPodShapesPodShapeResult',
    'GetPodShapesPodShapeMemoryOptionResult',
    'GetPodShapesPodShapeNetworkBandwidthOptionResult',
    'GetPodShapesPodShapeOcpuOptionResult',
    'GetVirtualNodePoolInitialVirtualNodeLabelResult',
    'GetVirtualNodePoolPlacementConfigurationResult',
    'GetVirtualNodePoolPodConfigurationResult',
    'GetVirtualNodePoolTaintResult',
    'GetVirtualNodePoolVirtualNodeTagResult',
    'GetVirtualNodePoolsFilterResult',
    'GetVirtualNodePoolsVirtualNodePoolResult',
    'GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult',
    'GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult',
    'GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult',
    'GetVirtualNodePoolsVirtualNodePoolTaintResult',
    'GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult',
    'GetWorkRequestErrorsFilterResult',
    'GetWorkRequestErrorsWorkRequestErrorResult',
    'GetWorkRequestLogEntriesFilterResult',
    'GetWorkRequestLogEntriesWorkRequestLogEntryResult',
    'GetWorkRequestsFilterResult',
    'GetWorkRequestsWorkRequestResult',
    'GetWorkRequestsWorkRequestResourceResult',
]

@pulumi.output_type
class AddonAddonError(dict):
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string of the upstream error.
        :param str status: The status of the HTTP response encountered in the upstream error.
        """
        AddonAddonError._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: Optional[str] = None,
             message: Optional[str] = None,
             status: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if code is not None:
            _setter("code", code)
        if message is not None:
            _setter("message", message)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class AddonConfiguration(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: (Updatable) configuration key name
        :param str value: (Updatable) configuration value name
        """
        AddonConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ClusterClusterPodNetworkOption(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniType":
            suggest = "cni_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterClusterPodNetworkOption. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterClusterPodNetworkOption.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterClusterPodNetworkOption.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni_type: str):
        """
        :param str cni_type: The CNI used by the node pools of this cluster
        """
        ClusterClusterPodNetworkOption._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']

        _setter("cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class ClusterEndpoint(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "privateEndpoint":
            suggest = "private_endpoint"
        elif key == "publicEndpoint":
            suggest = "public_endpoint"
        elif key == "vcnHostnameEndpoint":
            suggest = "vcn_hostname_endpoint"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpoint. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpoint.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kubernetes: Optional[str] = None,
                 private_endpoint: Optional[str] = None,
                 public_endpoint: Optional[str] = None,
                 vcn_hostname_endpoint: Optional[str] = None):
        """
        :param str kubernetes: The non-native networking Kubernetes API server endpoint.
        :param str private_endpoint: The private native networking Kubernetes API server endpoint.
        :param str public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param str vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        ClusterEndpoint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kubernetes=kubernetes,
            private_endpoint=private_endpoint,
            public_endpoint=public_endpoint,
            vcn_hostname_endpoint=vcn_hostname_endpoint,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kubernetes: Optional[str] = None,
             private_endpoint: Optional[str] = None,
             public_endpoint: Optional[str] = None,
             vcn_hostname_endpoint: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateEndpoint' in kwargs:
            private_endpoint = kwargs['privateEndpoint']
        if 'publicEndpoint' in kwargs:
            public_endpoint = kwargs['publicEndpoint']
        if 'vcnHostnameEndpoint' in kwargs:
            vcn_hostname_endpoint = kwargs['vcnHostnameEndpoint']

        if kubernetes is not None:
            _setter("kubernetes", kubernetes)
        if private_endpoint is not None:
            _setter("private_endpoint", private_endpoint)
        if public_endpoint is not None:
            _setter("public_endpoint", public_endpoint)
        if vcn_hostname_endpoint is not None:
            _setter("vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def kubernetes(self) -> Optional[str]:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> Optional[str]:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> Optional[str]:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> Optional[str]:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")


@pulumi.output_type
class ClusterEndpointConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "isPublicIpEnabled":
            suggest = "is_public_ip_enabled"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterEndpointConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterEndpointConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterEndpointConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 is_public_ip_enabled: Optional[bool] = None,
                 nsg_ids: Optional[Sequence[str]] = None):
        """
        :param str subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        :param bool is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param Sequence[str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        ClusterEndpointConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            subnet_id=subnet_id,
            is_public_ip_enabled=is_public_ip_enabled,
            nsg_ids=nsg_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             subnet_id: str,
             is_public_ip_enabled: Optional[bool] = None,
             nsg_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'isPublicIpEnabled' in kwargs:
            is_public_ip_enabled = kwargs['isPublicIpEnabled']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']

        _setter("subnet_id", subnet_id)
        if is_public_ip_enabled is not None:
            _setter("is_public_ip_enabled", is_public_ip_enabled)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> Optional[bool]:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class ClusterImagePolicyConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPolicyEnabled":
            suggest = "is_policy_enabled"
        elif key == "keyDetails":
            suggest = "key_details"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterImagePolicyConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterImagePolicyConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterImagePolicyConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_policy_enabled: Optional[bool] = None,
                 key_details: Optional[Sequence['outputs.ClusterImagePolicyConfigKeyDetail']] = None):
        """
        :param bool is_policy_enabled: (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param Sequence['ClusterImagePolicyConfigKeyDetailArgs'] key_details: (Updatable) A list of KMS key details.
        """
        ClusterImagePolicyConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_policy_enabled=is_policy_enabled,
            key_details=key_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_policy_enabled: Optional[bool] = None,
             key_details: Optional[Sequence['outputs.ClusterImagePolicyConfigKeyDetail']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPolicyEnabled' in kwargs:
            is_policy_enabled = kwargs['isPolicyEnabled']
        if 'keyDetails' in kwargs:
            key_details = kwargs['keyDetails']

        if is_policy_enabled is not None:
            _setter("is_policy_enabled", is_policy_enabled)
        if key_details is not None:
            _setter("key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> Optional[bool]:
        """
        (Updatable) Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Optional[Sequence['outputs.ClusterImagePolicyConfigKeyDetail']]:
        """
        (Updatable) A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class ClusterImagePolicyConfigKeyDetail(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKeyId":
            suggest = "kms_key_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterImagePolicyConfigKeyDetail. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterImagePolicyConfigKeyDetail.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterImagePolicyConfigKeyDetail.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key_id: Optional[str] = None):
        """
        :param str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        ClusterImagePolicyConfigKeyDetail._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption. When used, `kubernetesVersion` must be at least `v1.13.0`.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class ClusterMetadata(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "createdByUserId":
            suggest = "created_by_user_id"
        elif key == "createdByWorkRequestId":
            suggest = "created_by_work_request_id"
        elif key == "deletedByUserId":
            suggest = "deleted_by_user_id"
        elif key == "deletedByWorkRequestId":
            suggest = "deleted_by_work_request_id"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeCredentialExpiration":
            suggest = "time_credential_expiration"
        elif key == "timeDeleted":
            suggest = "time_deleted"
        elif key == "timeUpdated":
            suggest = "time_updated"
        elif key == "updatedByUserId":
            suggest = "updated_by_user_id"
        elif key == "updatedByWorkRequestId":
            suggest = "updated_by_work_request_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMetadata. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMetadata.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMetadata.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 created_by_user_id: Optional[str] = None,
                 created_by_work_request_id: Optional[str] = None,
                 deleted_by_user_id: Optional[str] = None,
                 deleted_by_work_request_id: Optional[str] = None,
                 time_created: Optional[str] = None,
                 time_credential_expiration: Optional[str] = None,
                 time_deleted: Optional[str] = None,
                 time_updated: Optional[str] = None,
                 updated_by_user_id: Optional[str] = None,
                 updated_by_work_request_id: Optional[str] = None):
        """
        :param str created_by_user_id: The user who created the cluster.
        :param str created_by_work_request_id: The OCID of the work request which created the cluster.
        :param str deleted_by_user_id: The user who deleted the cluster.
        :param str deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param str time_created: The time the cluster was created.
        :param str time_credential_expiration: The time until which the cluster credential is valid.
        :param str time_deleted: The time the cluster was deleted.
        :param str time_updated: The time the cluster was updated.
        :param str updated_by_user_id: The user who updated the cluster.
        :param str updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        ClusterMetadata._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            created_by_user_id=created_by_user_id,
            created_by_work_request_id=created_by_work_request_id,
            deleted_by_user_id=deleted_by_user_id,
            deleted_by_work_request_id=deleted_by_work_request_id,
            time_created=time_created,
            time_credential_expiration=time_credential_expiration,
            time_deleted=time_deleted,
            time_updated=time_updated,
            updated_by_user_id=updated_by_user_id,
            updated_by_work_request_id=updated_by_work_request_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             created_by_user_id: Optional[str] = None,
             created_by_work_request_id: Optional[str] = None,
             deleted_by_user_id: Optional[str] = None,
             deleted_by_work_request_id: Optional[str] = None,
             time_created: Optional[str] = None,
             time_credential_expiration: Optional[str] = None,
             time_deleted: Optional[str] = None,
             time_updated: Optional[str] = None,
             updated_by_user_id: Optional[str] = None,
             updated_by_work_request_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'createdByUserId' in kwargs:
            created_by_user_id = kwargs['createdByUserId']
        if 'createdByWorkRequestId' in kwargs:
            created_by_work_request_id = kwargs['createdByWorkRequestId']
        if 'deletedByUserId' in kwargs:
            deleted_by_user_id = kwargs['deletedByUserId']
        if 'deletedByWorkRequestId' in kwargs:
            deleted_by_work_request_id = kwargs['deletedByWorkRequestId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeCredentialExpiration' in kwargs:
            time_credential_expiration = kwargs['timeCredentialExpiration']
        if 'timeDeleted' in kwargs:
            time_deleted = kwargs['timeDeleted']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'updatedByUserId' in kwargs:
            updated_by_user_id = kwargs['updatedByUserId']
        if 'updatedByWorkRequestId' in kwargs:
            updated_by_work_request_id = kwargs['updatedByWorkRequestId']

        if created_by_user_id is not None:
            _setter("created_by_user_id", created_by_user_id)
        if created_by_work_request_id is not None:
            _setter("created_by_work_request_id", created_by_work_request_id)
        if deleted_by_user_id is not None:
            _setter("deleted_by_user_id", deleted_by_user_id)
        if deleted_by_work_request_id is not None:
            _setter("deleted_by_work_request_id", deleted_by_work_request_id)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_credential_expiration is not None:
            _setter("time_credential_expiration", time_credential_expiration)
        if time_deleted is not None:
            _setter("time_deleted", time_deleted)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if updated_by_user_id is not None:
            _setter("updated_by_user_id", updated_by_user_id)
        if updated_by_work_request_id is not None:
            _setter("updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> Optional[str]:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> Optional[str]:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> Optional[str]:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> Optional[str]:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> Optional[str]:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> Optional[str]:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> Optional[str]:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> Optional[str]:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")


@pulumi.output_type
class ClusterOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addOns":
            suggest = "add_ons"
        elif key == "admissionControllerOptions":
            suggest = "admission_controller_options"
        elif key == "kubernetesNetworkConfig":
            suggest = "kubernetes_network_config"
        elif key == "persistentVolumeConfig":
            suggest = "persistent_volume_config"
        elif key == "serviceLbConfig":
            suggest = "service_lb_config"
        elif key == "serviceLbSubnetIds":
            suggest = "service_lb_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 add_ons: Optional['outputs.ClusterOptionsAddOns'] = None,
                 admission_controller_options: Optional['outputs.ClusterOptionsAdmissionControllerOptions'] = None,
                 kubernetes_network_config: Optional['outputs.ClusterOptionsKubernetesNetworkConfig'] = None,
                 persistent_volume_config: Optional['outputs.ClusterOptionsPersistentVolumeConfig'] = None,
                 service_lb_config: Optional['outputs.ClusterOptionsServiceLbConfig'] = None,
                 service_lb_subnet_ids: Optional[Sequence[str]] = None):
        """
        :param 'ClusterOptionsAddOnsArgs' add_ons: Configurable cluster add-ons
        :param 'ClusterOptionsAdmissionControllerOptionsArgs' admission_controller_options: (Updatable) Configurable cluster admission controllers
        :param 'ClusterOptionsKubernetesNetworkConfigArgs' kubernetes_network_config: Network configuration for Kubernetes.
        :param 'ClusterOptionsPersistentVolumeConfigArgs' persistent_volume_config: (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param 'ClusterOptionsServiceLbConfigArgs' service_lb_config: (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        :param Sequence[str] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        ClusterOptions._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            add_ons=add_ons,
            admission_controller_options=admission_controller_options,
            kubernetes_network_config=kubernetes_network_config,
            persistent_volume_config=persistent_volume_config,
            service_lb_config=service_lb_config,
            service_lb_subnet_ids=service_lb_subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             add_ons: Optional['outputs.ClusterOptionsAddOns'] = None,
             admission_controller_options: Optional['outputs.ClusterOptionsAdmissionControllerOptions'] = None,
             kubernetes_network_config: Optional['outputs.ClusterOptionsKubernetesNetworkConfig'] = None,
             persistent_volume_config: Optional['outputs.ClusterOptionsPersistentVolumeConfig'] = None,
             service_lb_config: Optional['outputs.ClusterOptionsServiceLbConfig'] = None,
             service_lb_subnet_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'addOns' in kwargs:
            add_ons = kwargs['addOns']
        if 'admissionControllerOptions' in kwargs:
            admission_controller_options = kwargs['admissionControllerOptions']
        if 'kubernetesNetworkConfig' in kwargs:
            kubernetes_network_config = kwargs['kubernetesNetworkConfig']
        if 'persistentVolumeConfig' in kwargs:
            persistent_volume_config = kwargs['persistentVolumeConfig']
        if 'serviceLbConfig' in kwargs:
            service_lb_config = kwargs['serviceLbConfig']
        if 'serviceLbSubnetIds' in kwargs:
            service_lb_subnet_ids = kwargs['serviceLbSubnetIds']

        if add_ons is not None:
            _setter("add_ons", add_ons)
        if admission_controller_options is not None:
            _setter("admission_controller_options", admission_controller_options)
        if kubernetes_network_config is not None:
            _setter("kubernetes_network_config", kubernetes_network_config)
        if persistent_volume_config is not None:
            _setter("persistent_volume_config", persistent_volume_config)
        if service_lb_config is not None:
            _setter("service_lb_config", service_lb_config)
        if service_lb_subnet_ids is not None:
            _setter("service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Optional['outputs.ClusterOptionsAddOns']:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Optional['outputs.ClusterOptionsAdmissionControllerOptions']:
        """
        (Updatable) Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @property
    @pulumi.getter(name="kubernetesNetworkConfig")
    def kubernetes_network_config(self) -> Optional['outputs.ClusterOptionsKubernetesNetworkConfig']:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_config")

    @property
    @pulumi.getter(name="persistentVolumeConfig")
    def persistent_volume_config(self) -> Optional['outputs.ClusterOptionsPersistentVolumeConfig']:
        """
        (Updatable) Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_config")

    @property
    @pulumi.getter(name="serviceLbConfig")
    def service_lb_config(self) -> Optional['outputs.ClusterOptionsServiceLbConfig']:
        """
        (Updatable) Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_config")

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Optional[Sequence[str]]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")


@pulumi.output_type
class ClusterOptionsAddOns(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isKubernetesDashboardEnabled":
            suggest = "is_kubernetes_dashboard_enabled"
        elif key == "isTillerEnabled":
            suggest = "is_tiller_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsAddOns. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsAddOns.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsAddOns.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: Optional[bool] = None,
                 is_tiller_enabled: Optional[bool] = None):
        """
        :param bool is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param bool is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        ClusterOptionsAddOns._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_kubernetes_dashboard_enabled=is_kubernetes_dashboard_enabled,
            is_tiller_enabled=is_tiller_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_kubernetes_dashboard_enabled: Optional[bool] = None,
             is_tiller_enabled: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isKubernetesDashboardEnabled' in kwargs:
            is_kubernetes_dashboard_enabled = kwargs['isKubernetesDashboardEnabled']
        if 'isTillerEnabled' in kwargs:
            is_tiller_enabled = kwargs['isTillerEnabled']

        if is_kubernetes_dashboard_enabled is not None:
            _setter("is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        if is_tiller_enabled is not None:
            _setter("is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> Optional[bool]:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> Optional[bool]:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")


@pulumi.output_type
class ClusterOptionsAdmissionControllerOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPodSecurityPolicyEnabled":
            suggest = "is_pod_security_policy_enabled"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsAdmissionControllerOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsAdmissionControllerOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsAdmissionControllerOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_pod_security_policy_enabled: Optional[bool] = None):
        """
        :param bool is_pod_security_policy_enabled: (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        ClusterOptionsAdmissionControllerOptions._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_pod_security_policy_enabled=is_pod_security_policy_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_pod_security_policy_enabled: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPodSecurityPolicyEnabled' in kwargs:
            is_pod_security_policy_enabled = kwargs['isPodSecurityPolicyEnabled']

        if is_pod_security_policy_enabled is not None:
            _setter("is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> Optional[bool]:
        """
        (Updatable) Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")


@pulumi.output_type
class ClusterOptionsKubernetesNetworkConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "podsCidr":
            suggest = "pods_cidr"
        elif key == "servicesCidr":
            suggest = "services_cidr"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsKubernetesNetworkConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsKubernetesNetworkConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsKubernetesNetworkConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 pods_cidr: Optional[str] = None,
                 services_cidr: Optional[str] = None):
        """
        :param str pods_cidr: The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        :param str services_cidr: The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        ClusterOptionsKubernetesNetworkConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pods_cidr=pods_cidr,
            services_cidr=services_cidr,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pods_cidr: Optional[str] = None,
             services_cidr: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'podsCidr' in kwargs:
            pods_cidr = kwargs['podsCidr']
        if 'servicesCidr' in kwargs:
            services_cidr = kwargs['servicesCidr']

        if pods_cidr is not None:
            _setter("pods_cidr", pods_cidr)
        if services_cidr is not None:
            _setter("services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> Optional[str]:
        """
        The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        """
        return pulumi.get(self, "pods_cidr")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> Optional[str]:
        """
        The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        return pulumi.get(self, "services_cidr")


@pulumi.output_type
class ClusterOptionsPersistentVolumeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsPersistentVolumeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsPersistentVolumeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsPersistentVolumeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        ClusterOptionsPersistentVolumeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Optional[Mapping[str, Any]] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class ClusterOptionsServiceLbConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterOptionsServiceLbConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterOptionsServiceLbConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterOptionsServiceLbConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        ClusterOptionsServiceLbConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Optional[Mapping[str, Any]] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class ContainerInstanceContainer(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageUrl":
            suggest = "image_url"
        elif key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "compartmentId":
            suggest = "compartment_id"
        elif key == "containerId":
            suggest = "container_id"
        elif key == "containerInstanceId":
            suggest = "container_instance_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "environmentVariables":
            suggest = "environment_variables"
        elif key == "exitCode":
            suggest = "exit_code"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "healthChecks":
            suggest = "health_checks"
        elif key == "isResourcePrincipalDisabled":
            suggest = "is_resource_principal_disabled"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "resourceConfig":
            suggest = "resource_config"
        elif key == "securityContext":
            suggest = "security_context"
        elif key == "systemTags":
            suggest = "system_tags"
        elif key == "timeCreated":
            suggest = "time_created"
        elif key == "timeTerminated":
            suggest = "time_terminated"
        elif key == "timeUpdated":
            suggest = "time_updated"
        elif key == "volumeMounts":
            suggest = "volume_mounts"
        elif key == "workingDirectory":
            suggest = "working_directory"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainer. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainer.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainer.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_url: str,
                 arguments: Optional[Sequence[str]] = None,
                 availability_domain: Optional[str] = None,
                 commands: Optional[Sequence[str]] = None,
                 compartment_id: Optional[str] = None,
                 container_id: Optional[str] = None,
                 container_instance_id: Optional[str] = None,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 display_name: Optional[str] = None,
                 environment_variables: Optional[Mapping[str, Any]] = None,
                 exit_code: Optional[int] = None,
                 fault_domain: Optional[str] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 health_checks: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheck']] = None,
                 is_resource_principal_disabled: Optional[bool] = None,
                 lifecycle_details: Optional[str] = None,
                 resource_config: Optional['outputs.ContainerInstanceContainerResourceConfig'] = None,
                 security_context: Optional['outputs.ContainerInstanceContainerSecurityContext'] = None,
                 state: Optional[str] = None,
                 system_tags: Optional[Mapping[str, Any]] = None,
                 time_created: Optional[str] = None,
                 time_terminated: Optional[str] = None,
                 time_updated: Optional[str] = None,
                 volume_mounts: Optional[Sequence['outputs.ContainerInstanceContainerVolumeMount']] = None,
                 working_directory: Optional[str] = None):
        """
        :param str image_url: A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.
               
               If no registry is provided, will default the registry to public docker hub `docker.io/library`.
               
               The registry used for container image must be reachable over the Container Instance's VNIC.
        :param Sequence[str] arguments: A list of string arguments for a container's ENTRYPOINT process.
               
               Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.
               
               The total size of all arguments combined must be 64 KB or smaller.
        :param str availability_domain: The availability domain where the container instance runs.
        :param Sequence[str] commands: The list of strings that will be simplified to a single command for checking the status of the container.
        :param str compartment_id: (Updatable) The compartment OCID.
        :param str container_id: The OCID of the container.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param str display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param Mapping[str, Any] environment_variables: A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.
               
               The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        :param str fault_domain: The fault domain where the container instance runs.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param Sequence['ContainerInstanceContainerHealthCheckArgs'] health_checks: list of container health checks to check container status and take appropriate action if container status is failed. There are three types of health checks that we currently support HTTP, TCP, and Command.
        :param bool is_resource_principal_disabled: Determines if the container will have access to the container instance resource principal.
               
               This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        :param str lifecycle_details: A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        :param 'ContainerInstanceContainerResourceConfigArgs' resource_config: The size and amount of resources available to the container.
        :param 'ContainerInstanceContainerSecurityContextArgs' security_context: Security context for container.
        :param str state: (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        :param str time_created: The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param str time_updated: The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        :param Sequence['ContainerInstanceContainerVolumeMountArgs'] volume_mounts: List of the volume mounts.
        :param str working_directory: The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        ContainerInstanceContainer._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_url=image_url,
            arguments=arguments,
            availability_domain=availability_domain,
            commands=commands,
            compartment_id=compartment_id,
            container_id=container_id,
            container_instance_id=container_instance_id,
            defined_tags=defined_tags,
            display_name=display_name,
            environment_variables=environment_variables,
            exit_code=exit_code,
            fault_domain=fault_domain,
            freeform_tags=freeform_tags,
            health_checks=health_checks,
            is_resource_principal_disabled=is_resource_principal_disabled,
            lifecycle_details=lifecycle_details,
            resource_config=resource_config,
            security_context=security_context,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            time_terminated=time_terminated,
            time_updated=time_updated,
            volume_mounts=volume_mounts,
            working_directory=working_directory,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_url: str,
             arguments: Optional[Sequence[str]] = None,
             availability_domain: Optional[str] = None,
             commands: Optional[Sequence[str]] = None,
             compartment_id: Optional[str] = None,
             container_id: Optional[str] = None,
             container_instance_id: Optional[str] = None,
             defined_tags: Optional[Mapping[str, Any]] = None,
             display_name: Optional[str] = None,
             environment_variables: Optional[Mapping[str, Any]] = None,
             exit_code: Optional[int] = None,
             fault_domain: Optional[str] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             health_checks: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheck']] = None,
             is_resource_principal_disabled: Optional[bool] = None,
             lifecycle_details: Optional[str] = None,
             resource_config: Optional['outputs.ContainerInstanceContainerResourceConfig'] = None,
             security_context: Optional['outputs.ContainerInstanceContainerSecurityContext'] = None,
             state: Optional[str] = None,
             system_tags: Optional[Mapping[str, Any]] = None,
             time_created: Optional[str] = None,
             time_terminated: Optional[str] = None,
             time_updated: Optional[str] = None,
             volume_mounts: Optional[Sequence['outputs.ContainerInstanceContainerVolumeMount']] = None,
             working_directory: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageUrl' in kwargs:
            image_url = kwargs['imageUrl']
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'containerId' in kwargs:
            container_id = kwargs['containerId']
        if 'containerInstanceId' in kwargs:
            container_instance_id = kwargs['containerInstanceId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'environmentVariables' in kwargs:
            environment_variables = kwargs['environmentVariables']
        if 'exitCode' in kwargs:
            exit_code = kwargs['exitCode']
        if 'faultDomain' in kwargs:
            fault_domain = kwargs['faultDomain']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'healthChecks' in kwargs:
            health_checks = kwargs['healthChecks']
        if 'isResourcePrincipalDisabled' in kwargs:
            is_resource_principal_disabled = kwargs['isResourcePrincipalDisabled']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'resourceConfig' in kwargs:
            resource_config = kwargs['resourceConfig']
        if 'securityContext' in kwargs:
            security_context = kwargs['securityContext']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeTerminated' in kwargs:
            time_terminated = kwargs['timeTerminated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'volumeMounts' in kwargs:
            volume_mounts = kwargs['volumeMounts']
        if 'workingDirectory' in kwargs:
            working_directory = kwargs['workingDirectory']

        _setter("image_url", image_url)
        if arguments is not None:
            _setter("arguments", arguments)
        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if commands is not None:
            _setter("commands", commands)
        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if container_id is not None:
            _setter("container_id", container_id)
        if container_instance_id is not None:
            _setter("container_instance_id", container_instance_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if environment_variables is not None:
            _setter("environment_variables", environment_variables)
        if exit_code is not None:
            _setter("exit_code", exit_code)
        if fault_domain is not None:
            _setter("fault_domain", fault_domain)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if health_checks is not None:
            _setter("health_checks", health_checks)
        if is_resource_principal_disabled is not None:
            _setter("is_resource_principal_disabled", is_resource_principal_disabled)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if resource_config is not None:
            _setter("resource_config", resource_config)
        if security_context is not None:
            _setter("security_context", security_context)
        if state is not None:
            _setter("state", state)
        if system_tags is not None:
            _setter("system_tags", system_tags)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_terminated is not None:
            _setter("time_terminated", time_terminated)
        if time_updated is not None:
            _setter("time_updated", time_updated)
        if volume_mounts is not None:
            _setter("volume_mounts", volume_mounts)
        if working_directory is not None:
            _setter("working_directory", working_directory)

    @property
    @pulumi.getter(name="imageUrl")
    def image_url(self) -> str:
        """
        A URL identifying the image that the container runs in, such as docker.io/library/busybox:latest. If you do not provide a tag, the tag will default to latest.

        If no registry is provided, will default the registry to public docker hub `docker.io/library`.

        The registry used for container image must be reachable over the Container Instance's VNIC.
        """
        return pulumi.get(self, "image_url")

    @property
    @pulumi.getter
    def arguments(self) -> Optional[Sequence[str]]:
        """
        A list of string arguments for a container's ENTRYPOINT process.

        Many containers use an ENTRYPOINT process pointing to a shell (/bin/bash). For those containers, this argument list specifies the main command in the container process.

        The total size of all arguments combined must be 64 KB or smaller.
        """
        return pulumi.get(self, "arguments")

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        The availability domain where the container instance runs.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        The list of strings that will be simplified to a single command for checking the status of the container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[str]:
        """
        (Updatable) The compartment OCID.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="containerId")
    def container_id(self) -> Optional[str]:
        """
        The OCID of the container.
        """
        return pulumi.get(self, "container_id")

    @property
    @pulumi.getter(name="containerInstanceId")
    def container_instance_id(self) -> Optional[str]:
        return pulumi.get(self, "container_instance_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="environmentVariables")
    def environment_variables(self) -> Optional[Mapping[str, Any]]:
        """
        A map of additional environment variables to set in the environment of the container's ENTRYPOINT process. These variables are in addition to any variables already defined in the container's image.

        The total size of all environment variables combined, name and values, must be 64 KB or smaller.
        """
        return pulumi.get(self, "environment_variables")

    @property
    @pulumi.getter(name="exitCode")
    def exit_code(self) -> Optional[int]:
        return pulumi.get(self, "exit_code")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[str]:
        """
        The fault domain where the container instance runs.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="healthChecks")
    def health_checks(self) -> Optional[Sequence['outputs.ContainerInstanceContainerHealthCheck']]:
        """
        list of container health checks to check container status and take appropriate action if container status is failed. There are three types of health checks that we currently support HTTP, TCP, and Command.
        """
        return pulumi.get(self, "health_checks")

    @property
    @pulumi.getter(name="isResourcePrincipalDisabled")
    def is_resource_principal_disabled(self) -> Optional[bool]:
        """
        Determines if the container will have access to the container instance resource principal.

        This method utilizes resource principal version 2.2. For information on how to use the exposed resource principal elements, see https://docs.oracle.com/en-us/iaas/Content/API/Concepts/sdk_authentication_methods.htm#sdk_authentication_methods_resource_principal.
        """
        return pulumi.get(self, "is_resource_principal_disabled")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[str]:
        """
        A message that describes the current state of the container in more detail. Can be used to provide actionable information.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="resourceConfig")
    def resource_config(self) -> Optional['outputs.ContainerInstanceContainerResourceConfig']:
        """
        The size and amount of resources available to the container.
        """
        return pulumi.get(self, "resource_config")

    @property
    @pulumi.getter(name="securityContext")
    def security_context(self) -> Optional['outputs.ContainerInstanceContainerSecurityContext']:
        """
        Security context for container.
        """
        return pulumi.get(self, "security_context")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        (Updatable) The target state for the Container Instance. Could be set to `ACTIVE` or `INACTIVE`. 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`.
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[str]:
        """
        The time the container instance was created, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeTerminated")
    def time_terminated(self) -> Optional[str]:
        return pulumi.get(self, "time_terminated")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> Optional[str]:
        """
        The time the container instance was updated, in the format defined by [RFC 3339](https://tools.ietf.org/rfc/rfc3339).
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="volumeMounts")
    def volume_mounts(self) -> Optional[Sequence['outputs.ContainerInstanceContainerVolumeMount']]:
        """
        List of the volume mounts.
        """
        return pulumi.get(self, "volume_mounts")

    @property
    @pulumi.getter(name="workingDirectory")
    def working_directory(self) -> Optional[str]:
        """
        The working directory within the container's filesystem for the container process. If not specified, the default working directory from the image is used.
        """
        return pulumi.get(self, "working_directory")


@pulumi.output_type
class ContainerInstanceContainerHealthCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "healthCheckType":
            suggest = "health_check_type"
        elif key == "failureAction":
            suggest = "failure_action"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelayInSeconds":
            suggest = "initial_delay_in_seconds"
        elif key == "intervalInSeconds":
            suggest = "interval_in_seconds"
        elif key == "statusDetails":
            suggest = "status_details"
        elif key == "successThreshold":
            suggest = "success_threshold"
        elif key == "timeoutInSeconds":
            suggest = "timeout_in_seconds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerHealthCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerHealthCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerHealthCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 health_check_type: str,
                 commands: Optional[Sequence[str]] = None,
                 failure_action: Optional[str] = None,
                 failure_threshold: Optional[int] = None,
                 headers: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheckHeader']] = None,
                 initial_delay_in_seconds: Optional[int] = None,
                 interval_in_seconds: Optional[int] = None,
                 name: Optional[str] = None,
                 path: Optional[str] = None,
                 port: Optional[int] = None,
                 status: Optional[str] = None,
                 status_details: Optional[str] = None,
                 success_threshold: Optional[int] = None,
                 timeout_in_seconds: Optional[int] = None):
        """
        :param str health_check_type: Container health check type.
        :param Sequence[str] commands: The list of strings that will be simplified to a single command for checking the status of the container.
        :param str failure_action: The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        :param int failure_threshold: Number of consecutive failures at which we consider the check failed.
        :param Sequence['ContainerInstanceContainerHealthCheckHeaderArgs'] headers: Container health check HTTP headers.
        :param int initial_delay_in_seconds: The initial delay in seconds before start checking container health status.
        :param int interval_in_seconds: Number of seconds between two consecutive runs for checking container health.
        :param str name: The name of the volume. This must be unique within a single container instance.
        :param str path: (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        :param int port: Container health check HTTP port.
        :param int success_threshold: Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        :param int timeout_in_seconds: Length of waiting time in seconds before marking health check failed.
        """
        ContainerInstanceContainerHealthCheck._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            health_check_type=health_check_type,
            commands=commands,
            failure_action=failure_action,
            failure_threshold=failure_threshold,
            headers=headers,
            initial_delay_in_seconds=initial_delay_in_seconds,
            interval_in_seconds=interval_in_seconds,
            name=name,
            path=path,
            port=port,
            status=status,
            status_details=status_details,
            success_threshold=success_threshold,
            timeout_in_seconds=timeout_in_seconds,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             health_check_type: str,
             commands: Optional[Sequence[str]] = None,
             failure_action: Optional[str] = None,
             failure_threshold: Optional[int] = None,
             headers: Optional[Sequence['outputs.ContainerInstanceContainerHealthCheckHeader']] = None,
             initial_delay_in_seconds: Optional[int] = None,
             interval_in_seconds: Optional[int] = None,
             name: Optional[str] = None,
             path: Optional[str] = None,
             port: Optional[int] = None,
             status: Optional[str] = None,
             status_details: Optional[str] = None,
             success_threshold: Optional[int] = None,
             timeout_in_seconds: Optional[int] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'healthCheckType' in kwargs:
            health_check_type = kwargs['healthCheckType']
        if 'failureAction' in kwargs:
            failure_action = kwargs['failureAction']
        if 'failureThreshold' in kwargs:
            failure_threshold = kwargs['failureThreshold']
        if 'initialDelayInSeconds' in kwargs:
            initial_delay_in_seconds = kwargs['initialDelayInSeconds']
        if 'intervalInSeconds' in kwargs:
            interval_in_seconds = kwargs['intervalInSeconds']
        if 'statusDetails' in kwargs:
            status_details = kwargs['statusDetails']
        if 'successThreshold' in kwargs:
            success_threshold = kwargs['successThreshold']
        if 'timeoutInSeconds' in kwargs:
            timeout_in_seconds = kwargs['timeoutInSeconds']

        _setter("health_check_type", health_check_type)
        if commands is not None:
            _setter("commands", commands)
        if failure_action is not None:
            _setter("failure_action", failure_action)
        if failure_threshold is not None:
            _setter("failure_threshold", failure_threshold)
        if headers is not None:
            _setter("headers", headers)
        if initial_delay_in_seconds is not None:
            _setter("initial_delay_in_seconds", initial_delay_in_seconds)
        if interval_in_seconds is not None:
            _setter("interval_in_seconds", interval_in_seconds)
        if name is not None:
            _setter("name", name)
        if path is not None:
            _setter("path", path)
        if port is not None:
            _setter("port", port)
        if status is not None:
            _setter("status", status)
        if status_details is not None:
            _setter("status_details", status_details)
        if success_threshold is not None:
            _setter("success_threshold", success_threshold)
        if timeout_in_seconds is not None:
            _setter("timeout_in_seconds", timeout_in_seconds)

    @property
    @pulumi.getter(name="healthCheckType")
    def health_check_type(self) -> str:
        """
        Container health check type.
        """
        return pulumi.get(self, "health_check_type")

    @property
    @pulumi.getter
    def commands(self) -> Optional[Sequence[str]]:
        """
        The list of strings that will be simplified to a single command for checking the status of the container.
        """
        return pulumi.get(self, "commands")

    @property
    @pulumi.getter(name="failureAction")
    def failure_action(self) -> Optional[str]:
        """
        The action will be triggered when the container health check fails. There are two types of action: KILL or NONE. The default action is KILL. If failure action is KILL, the container will be subject to the container restart policy.
        """
        return pulumi.get(self, "failure_action")

    @property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[int]:
        """
        Number of consecutive failures at which we consider the check failed.
        """
        return pulumi.get(self, "failure_threshold")

    @property
    @pulumi.getter
    def headers(self) -> Optional[Sequence['outputs.ContainerInstanceContainerHealthCheckHeader']]:
        """
        Container health check HTTP headers.
        """
        return pulumi.get(self, "headers")

    @property
    @pulumi.getter(name="initialDelayInSeconds")
    def initial_delay_in_seconds(self) -> Optional[int]:
        """
        The initial delay in seconds before start checking container health status.
        """
        return pulumi.get(self, "initial_delay_in_seconds")

    @property
    @pulumi.getter(name="intervalInSeconds")
    def interval_in_seconds(self) -> Optional[int]:
        """
        Number of seconds between two consecutive runs for checking container health.
        """
        return pulumi.get(self, "interval_in_seconds")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        return pulumi.get(self, "path")

    @property
    @pulumi.getter
    def port(self) -> Optional[int]:
        """
        Container health check HTTP port.
        """
        return pulumi.get(self, "port")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="statusDetails")
    def status_details(self) -> Optional[str]:
        return pulumi.get(self, "status_details")

    @property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[int]:
        """
        Number of consecutive successes at which we consider the check succeeded again after it was in failure state.
        """
        return pulumi.get(self, "success_threshold")

    @property
    @pulumi.getter(name="timeoutInSeconds")
    def timeout_in_seconds(self) -> Optional[int]:
        """
        Length of waiting time in seconds before marking health check failed.
        """
        return pulumi.get(self, "timeout_in_seconds")


@pulumi.output_type
class ContainerInstanceContainerHealthCheckHeader(dict):
    def __init__(__self__, *,
                 name: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str name: The name of the volume. This must be unique within a single container instance.
        :param str value: Container HTTP header value.
        """
        ContainerInstanceContainerHealthCheckHeader._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if name is not None:
            _setter("name", name)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        Container HTTP header value.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class ContainerInstanceContainerResourceConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryLimitInGbs":
            suggest = "memory_limit_in_gbs"
        elif key == "vcpusLimit":
            suggest = "vcpus_limit"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerResourceConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerResourceConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerResourceConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_limit_in_gbs: Optional[float] = None,
                 vcpus_limit: Optional[float] = None):
        """
        :param float memory_limit_in_gbs: The maximum amount of memory that can be consumed by the container's process.
               
               If you do not set a value, then the process may use all available memory on the instance.
        :param float vcpus_limit: The maximum amount of CPUs that can be consumed by the container's process.
               
               If you do not set a value, then the process can use all available CPU resources on the instance.
               
               CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.
               
               A container with a 2.0 vcpusLimit could consume up to 100% of the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        ContainerInstanceContainerResourceConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_limit_in_gbs=memory_limit_in_gbs,
            vcpus_limit=vcpus_limit,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_limit_in_gbs: Optional[float] = None,
             vcpus_limit: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryLimitInGbs' in kwargs:
            memory_limit_in_gbs = kwargs['memoryLimitInGbs']
        if 'vcpusLimit' in kwargs:
            vcpus_limit = kwargs['vcpusLimit']

        if memory_limit_in_gbs is not None:
            _setter("memory_limit_in_gbs", memory_limit_in_gbs)
        if vcpus_limit is not None:
            _setter("vcpus_limit", vcpus_limit)

    @property
    @pulumi.getter(name="memoryLimitInGbs")
    def memory_limit_in_gbs(self) -> Optional[float]:
        """
        The maximum amount of memory that can be consumed by the container's process.

        If you do not set a value, then the process may use all available memory on the instance.
        """
        return pulumi.get(self, "memory_limit_in_gbs")

    @property
    @pulumi.getter(name="vcpusLimit")
    def vcpus_limit(self) -> Optional[float]:
        """
        The maximum amount of CPUs that can be consumed by the container's process.

        If you do not set a value, then the process can use all available CPU resources on the instance.

        CPU usage is defined in terms of logical CPUs. This means that the maximum possible value on an E3 ContainerInstance with 1 OCPU is 2.0.

        A container with a 2.0 vcpusLimit could consume up to 100% of the CPU resources available on the container instance. Values can be fractional. A value of "1.5" means that the container can consume at most the equivalent of 1 and a half logical CPUs worth of CPU capacity.
        """
        return pulumi.get(self, "vcpus_limit")


@pulumi.output_type
class ContainerInstanceContainerSecurityContext(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isNonRootUserCheckEnabled":
            suggest = "is_non_root_user_check_enabled"
        elif key == "isRootFileSystemReadonly":
            suggest = "is_root_file_system_readonly"
        elif key == "runAsGroup":
            suggest = "run_as_group"
        elif key == "runAsUser":
            suggest = "run_as_user"
        elif key == "securityContextType":
            suggest = "security_context_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerSecurityContext. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerSecurityContext.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerSecurityContext.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_non_root_user_check_enabled: Optional[bool] = None,
                 is_root_file_system_readonly: Optional[bool] = None,
                 run_as_group: Optional[int] = None,
                 run_as_user: Optional[int] = None,
                 security_context_type: Optional[str] = None):
        """
        :param bool is_non_root_user_check_enabled: Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        :param bool is_root_file_system_readonly: Determines if the container will have a read-only root file system. Default value is false.
        :param int run_as_group: The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        :param int run_as_user: The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        :param str security_context_type: The type of security context
        """
        ContainerInstanceContainerSecurityContext._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_non_root_user_check_enabled=is_non_root_user_check_enabled,
            is_root_file_system_readonly=is_root_file_system_readonly,
            run_as_group=run_as_group,
            run_as_user=run_as_user,
            security_context_type=security_context_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_non_root_user_check_enabled: Optional[bool] = None,
             is_root_file_system_readonly: Optional[bool] = None,
             run_as_group: Optional[int] = None,
             run_as_user: Optional[int] = None,
             security_context_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isNonRootUserCheckEnabled' in kwargs:
            is_non_root_user_check_enabled = kwargs['isNonRootUserCheckEnabled']
        if 'isRootFileSystemReadonly' in kwargs:
            is_root_file_system_readonly = kwargs['isRootFileSystemReadonly']
        if 'runAsGroup' in kwargs:
            run_as_group = kwargs['runAsGroup']
        if 'runAsUser' in kwargs:
            run_as_user = kwargs['runAsUser']
        if 'securityContextType' in kwargs:
            security_context_type = kwargs['securityContextType']

        if is_non_root_user_check_enabled is not None:
            _setter("is_non_root_user_check_enabled", is_non_root_user_check_enabled)
        if is_root_file_system_readonly is not None:
            _setter("is_root_file_system_readonly", is_root_file_system_readonly)
        if run_as_group is not None:
            _setter("run_as_group", run_as_group)
        if run_as_user is not None:
            _setter("run_as_user", run_as_user)
        if security_context_type is not None:
            _setter("security_context_type", security_context_type)

    @property
    @pulumi.getter(name="isNonRootUserCheckEnabled")
    def is_non_root_user_check_enabled(self) -> Optional[bool]:
        """
        Indicates if the container must run as a non-root user. If true, the service validates the container image at runtime to ensure that it is not going to run with UID 0 (root) and fails the container instance creation if the validation fails.
        """
        return pulumi.get(self, "is_non_root_user_check_enabled")

    @property
    @pulumi.getter(name="isRootFileSystemReadonly")
    def is_root_file_system_readonly(self) -> Optional[bool]:
        """
        Determines if the container will have a read-only root file system. Default value is false.
        """
        return pulumi.get(self, "is_root_file_system_readonly")

    @property
    @pulumi.getter(name="runAsGroup")
    def run_as_group(self) -> Optional[int]:
        """
        The group ID (GID) to run the entrypoint process of the container. Uses runtime default if not provided.
        """
        return pulumi.get(self, "run_as_group")

    @property
    @pulumi.getter(name="runAsUser")
    def run_as_user(self) -> Optional[int]:
        """
        The user ID (UID) to run the entrypoint process of the container. Defaults to user specified UID in container image metadata if not provided. This must be provided if runAsGroup is provided.
        """
        return pulumi.get(self, "run_as_user")

    @property
    @pulumi.getter(name="securityContextType")
    def security_context_type(self) -> Optional[str]:
        """
        The type of security context
        """
        return pulumi.get(self, "security_context_type")


@pulumi.output_type
class ContainerInstanceContainerVolumeMount(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "mountPath":
            suggest = "mount_path"
        elif key == "volumeName":
            suggest = "volume_name"
        elif key == "isReadOnly":
            suggest = "is_read_only"
        elif key == "subPath":
            suggest = "sub_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceContainerVolumeMount. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceContainerVolumeMount.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceContainerVolumeMount.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 mount_path: str,
                 volume_name: str,
                 is_read_only: Optional[bool] = None,
                 partition: Optional[int] = None,
                 sub_path: Optional[str] = None):
        """
        :param str mount_path: The volume access path.
        :param str volume_name: The name of the volume. Avoid entering confidential information.
        :param bool is_read_only: Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        :param int partition: If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        :param str sub_path: A subpath inside the referenced volume.
        """
        ContainerInstanceContainerVolumeMount._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            mount_path=mount_path,
            volume_name=volume_name,
            is_read_only=is_read_only,
            partition=partition,
            sub_path=sub_path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             mount_path: str,
             volume_name: str,
             is_read_only: Optional[bool] = None,
             partition: Optional[int] = None,
             sub_path: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'mountPath' in kwargs:
            mount_path = kwargs['mountPath']
        if 'volumeName' in kwargs:
            volume_name = kwargs['volumeName']
        if 'isReadOnly' in kwargs:
            is_read_only = kwargs['isReadOnly']
        if 'subPath' in kwargs:
            sub_path = kwargs['subPath']

        _setter("mount_path", mount_path)
        _setter("volume_name", volume_name)
        if is_read_only is not None:
            _setter("is_read_only", is_read_only)
        if partition is not None:
            _setter("partition", partition)
        if sub_path is not None:
            _setter("sub_path", sub_path)

    @property
    @pulumi.getter(name="mountPath")
    def mount_path(self) -> str:
        """
        The volume access path.
        """
        return pulumi.get(self, "mount_path")

    @property
    @pulumi.getter(name="volumeName")
    def volume_name(self) -> str:
        """
        The name of the volume. Avoid entering confidential information.
        """
        return pulumi.get(self, "volume_name")

    @property
    @pulumi.getter(name="isReadOnly")
    def is_read_only(self) -> Optional[bool]:
        """
        Whether the volume was mounted in read-only mode. By default, the volume is not read-only.
        """
        return pulumi.get(self, "is_read_only")

    @property
    @pulumi.getter
    def partition(self) -> Optional[int]:
        """
        If there is more than one partition in the volume, reference this number of partitions. Here is an example: Number  Start   End     Size    File system  Name                  Flags 1      1049kB  106MB   105MB   fat16        EFI System Partition  boot, esp 2      106MB   1180MB  1074MB  xfs 3      1180MB  50.0GB  48.8GB                                     lvm
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="subPath")
    def sub_path(self) -> Optional[str]:
        """
        A subpath inside the referenced volume.
        """
        return pulumi.get(self, "sub_path")


@pulumi.output_type
class ContainerInstanceDnsConfig(dict):
    def __init__(__self__, *,
                 nameservers: Optional[Sequence[str]] = None,
                 options: Optional[Sequence[str]] = None,
                 searches: Optional[Sequence[str]] = None):
        """
        :param Sequence[str] nameservers: IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        :param Sequence[str] options: Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        :param Sequence[str] searches: Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        ContainerInstanceDnsConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nameservers=nameservers,
            options=options,
            searches=searches,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nameservers: Optional[Sequence[str]] = None,
             options: Optional[Sequence[str]] = None,
             searches: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if nameservers is not None:
            _setter("nameservers", nameservers)
        if options is not None:
            _setter("options", options)
        if searches is not None:
            _setter("searches", searches)

    @property
    @pulumi.getter
    def nameservers(self) -> Optional[Sequence[str]]:
        """
        IP address of a name server that the resolver should query, either an IPv4 address (in dot notation), or an IPv6 address in colon (and possibly dot) notation. If null, uses nameservers from subnet dhcpDnsOptions.
        """
        return pulumi.get(self, "nameservers")

    @property
    @pulumi.getter
    def options(self) -> Optional[Sequence[str]]:
        """
        Options allows certain internal resolver variables to be modified. Options are a list of objects in https://man7.org/linux/man-pages/man5/resolv.conf.5.html. Examples: ["ndots:n", "edns0"].
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def searches(self) -> Optional[Sequence[str]]:
        """
        Search list for host-name lookup. If null, we will use searches from subnet dhcpDnsOptios.
        """
        return pulumi.get(self, "searches")


@pulumi.output_type
class ContainerInstanceImagePullSecret(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "registryEndpoint":
            suggest = "registry_endpoint"
        elif key == "secretType":
            suggest = "secret_type"
        elif key == "secretId":
            suggest = "secret_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceImagePullSecret. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceImagePullSecret.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceImagePullSecret.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 registry_endpoint: str,
                 secret_type: str,
                 password: Optional[str] = None,
                 secret_id: Optional[str] = None,
                 username: Optional[str] = None):
        """
        :param str registry_endpoint: The registry endpoint of the container image.
        :param str secret_type: The type of ImagePullSecret.
        :param str password: The password which should be used with the registry for authentication. The value is expected in base64 format.
        :param str secret_id: The OCID of the secret for registry credentials.
        :param str username: The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        ContainerInstanceImagePullSecret._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            registry_endpoint=registry_endpoint,
            secret_type=secret_type,
            password=password,
            secret_id=secret_id,
            username=username,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             registry_endpoint: str,
             secret_type: str,
             password: Optional[str] = None,
             secret_id: Optional[str] = None,
             username: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'registryEndpoint' in kwargs:
            registry_endpoint = kwargs['registryEndpoint']
        if 'secretType' in kwargs:
            secret_type = kwargs['secretType']
        if 'secretId' in kwargs:
            secret_id = kwargs['secretId']

        _setter("registry_endpoint", registry_endpoint)
        _setter("secret_type", secret_type)
        if password is not None:
            _setter("password", password)
        if secret_id is not None:
            _setter("secret_id", secret_id)
        if username is not None:
            _setter("username", username)

    @property
    @pulumi.getter(name="registryEndpoint")
    def registry_endpoint(self) -> str:
        """
        The registry endpoint of the container image.
        """
        return pulumi.get(self, "registry_endpoint")

    @property
    @pulumi.getter(name="secretType")
    def secret_type(self) -> str:
        """
        The type of ImagePullSecret.
        """
        return pulumi.get(self, "secret_type")

    @property
    @pulumi.getter
    def password(self) -> Optional[str]:
        """
        The password which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "password")

    @property
    @pulumi.getter(name="secretId")
    def secret_id(self) -> Optional[str]:
        """
        The OCID of the secret for registry credentials.
        """
        return pulumi.get(self, "secret_id")

    @property
    @pulumi.getter
    def username(self) -> Optional[str]:
        """
        The username which should be used with the registry for authentication. The value is expected in base64 format.
        """
        return pulumi.get(self, "username")


@pulumi.output_type
class ContainerInstanceShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"
        elif key == "networkingBandwidthInGbps":
            suggest = "networking_bandwidth_in_gbps"
        elif key == "processorDescription":
            suggest = "processor_description"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ocpus: float,
                 memory_in_gbs: Optional[float] = None,
                 networking_bandwidth_in_gbps: Optional[float] = None,
                 processor_description: Optional[str] = None):
        """
        :param float ocpus: The total number of OCPUs available to the container instance.
        :param float memory_in_gbs: The total amount of memory available to the container instance (GB).
        :param float networking_bandwidth_in_gbps: The networking bandwidth available to the container instance, in gigabits per second.
        :param str processor_description: A short description of the container instance's processor (CPU).
        """
        ContainerInstanceShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            ocpus=ocpus,
            memory_in_gbs=memory_in_gbs,
            networking_bandwidth_in_gbps=networking_bandwidth_in_gbps,
            processor_description=processor_description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             ocpus: float,
             memory_in_gbs: Optional[float] = None,
             networking_bandwidth_in_gbps: Optional[float] = None,
             processor_description: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']
        if 'networkingBandwidthInGbps' in kwargs:
            networking_bandwidth_in_gbps = kwargs['networkingBandwidthInGbps']
        if 'processorDescription' in kwargs:
            processor_description = kwargs['processorDescription']

        _setter("ocpus", ocpus)
        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if networking_bandwidth_in_gbps is not None:
            _setter("networking_bandwidth_in_gbps", networking_bandwidth_in_gbps)
        if processor_description is not None:
            _setter("processor_description", processor_description)

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs available to the container instance.
        """
        return pulumi.get(self, "ocpus")

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        The total amount of memory available to the container instance (GB).
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter(name="networkingBandwidthInGbps")
    def networking_bandwidth_in_gbps(self) -> Optional[float]:
        """
        The networking bandwidth available to the container instance, in gigabits per second.
        """
        return pulumi.get(self, "networking_bandwidth_in_gbps")

    @property
    @pulumi.getter(name="processorDescription")
    def processor_description(self) -> Optional[str]:
        """
        A short description of the container instance's processor (CPU).
        """
        return pulumi.get(self, "processor_description")


@pulumi.output_type
class ContainerInstanceVnic(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "displayName":
            suggest = "display_name"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "hostnameLabel":
            suggest = "hostname_label"
        elif key == "isPublicIpAssigned":
            suggest = "is_public_ip_assigned"
        elif key == "nsgIds":
            suggest = "nsg_ids"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "skipSourceDestCheck":
            suggest = "skip_source_dest_check"
        elif key == "vnicId":
            suggest = "vnic_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVnic. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVnic.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVnic.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 subnet_id: str,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 display_name: Optional[str] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 hostname_label: Optional[str] = None,
                 is_public_ip_assigned: Optional[bool] = None,
                 nsg_ids: Optional[Sequence[str]] = None,
                 private_ip: Optional[str] = None,
                 skip_source_dest_check: Optional[bool] = None,
                 vnic_id: Optional[str] = None):
        """
        :param str subnet_id: The OCID of the subnet to create the VNIC in.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        :param str display_name: A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        :param Mapping[str, Any] freeform_tags: Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        :param str hostname_label: The hostname for the VNIC's primary private IP. Used for DNS.
        :param bool is_public_ip_assigned: Whether the VNIC should be assigned a public IP address.
        :param Sequence[str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        :param str private_ip: A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        :param bool skip_source_dest_check: Whether the source/destination check is disabled on the VNIC.
        :param str vnic_id: The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        ContainerInstanceVnic._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            subnet_id=subnet_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            hostname_label=hostname_label,
            is_public_ip_assigned=is_public_ip_assigned,
            nsg_ids=nsg_ids,
            private_ip=private_ip,
            skip_source_dest_check=skip_source_dest_check,
            vnic_id=vnic_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             subnet_id: str,
             defined_tags: Optional[Mapping[str, Any]] = None,
             display_name: Optional[str] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             hostname_label: Optional[str] = None,
             is_public_ip_assigned: Optional[bool] = None,
             nsg_ids: Optional[Sequence[str]] = None,
             private_ip: Optional[str] = None,
             skip_source_dest_check: Optional[bool] = None,
             vnic_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'hostnameLabel' in kwargs:
            hostname_label = kwargs['hostnameLabel']
        if 'isPublicIpAssigned' in kwargs:
            is_public_ip_assigned = kwargs['isPublicIpAssigned']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']
        if 'skipSourceDestCheck' in kwargs:
            skip_source_dest_check = kwargs['skipSourceDestCheck']
        if 'vnicId' in kwargs:
            vnic_id = kwargs['vnicId']

        _setter("subnet_id", subnet_id)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if display_name is not None:
            _setter("display_name", display_name)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if hostname_label is not None:
            _setter("hostname_label", hostname_label)
        if is_public_ip_assigned is not None:
            _setter("is_public_ip_assigned", is_public_ip_assigned)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)
        if private_ip is not None:
            _setter("private_ip", private_ip)
        if skip_source_dest_check is not None:
            _setter("skip_source_dest_check", skip_source_dest_check)
        if vnic_id is not None:
            _setter("vnic_id", vnic_id)

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet to create the VNIC in.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"foo-namespace.bar-key": "value"}`.
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        A user-friendly name for the VNIC. Does not have to be unique. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        Simple key-value pair that is applied without any predefined name, type or scope. Exists for cross-compatibility only. Example: `{"bar-key": "value"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="hostnameLabel")
    def hostname_label(self) -> Optional[str]:
        """
        The hostname for the VNIC's primary private IP. Used for DNS.
        """
        return pulumi.get(self, "hostname_label")

    @property
    @pulumi.getter(name="isPublicIpAssigned")
    def is_public_ip_assigned(self) -> Optional[bool]:
        """
        Whether the VNIC should be assigned a public IP address.
        """
        return pulumi.get(self, "is_public_ip_assigned")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        A list of the OCIDs of the network security groups (NSGs) to add the VNIC to.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        A private IP address of your choice to assign to the VNIC. Must be an available IP address within the subnet's CIDR.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="skipSourceDestCheck")
    def skip_source_dest_check(self) -> Optional[bool]:
        """
        Whether the source/destination check is disabled on the VNIC.
        """
        return pulumi.get(self, "skip_source_dest_check")

    @property
    @pulumi.getter(name="vnicId")
    def vnic_id(self) -> Optional[str]:
        """
        The identifier of the virtual network interface card (VNIC) over which the containers accessing this network can communicate with the larger virtual cloud network.
        """
        return pulumi.get(self, "vnic_id")


@pulumi.output_type
class ContainerInstanceVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "volumeType":
            suggest = "volume_type"
        elif key == "backingStore":
            suggest = "backing_store"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 volume_type: str,
                 backing_store: Optional[str] = None,
                 configs: Optional[Sequence['outputs.ContainerInstanceVolumeConfig']] = None):
        """
        :param str name: The name of the volume. This must be unique within a single container instance.
        :param str volume_type: The type of volume.
        :param str backing_store: The volume type of the empty directory, can be either File Storage or Memory.
        :param Sequence['ContainerInstanceVolumeConfigArgs'] configs: Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        ContainerInstanceVolume._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            volume_type=volume_type,
            backing_store=backing_store,
            configs=configs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             volume_type: str,
             backing_store: Optional[str] = None,
             configs: Optional[Sequence['outputs.ContainerInstanceVolumeConfig']] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'volumeType' in kwargs:
            volume_type = kwargs['volumeType']
        if 'backingStore' in kwargs:
            backing_store = kwargs['backingStore']

        _setter("name", name)
        _setter("volume_type", volume_type)
        if backing_store is not None:
            _setter("backing_store", backing_store)
        if configs is not None:
            _setter("configs", configs)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the volume. This must be unique within a single container instance.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> str:
        """
        The type of volume.
        """
        return pulumi.get(self, "volume_type")

    @property
    @pulumi.getter(name="backingStore")
    def backing_store(self) -> Optional[str]:
        """
        The volume type of the empty directory, can be either File Storage or Memory.
        """
        return pulumi.get(self, "backing_store")

    @property
    @pulumi.getter
    def configs(self) -> Optional[Sequence['outputs.ContainerInstanceVolumeConfig']]:
        """
        Contains key value pairs which can be mounted as individual files inside the container. The value needs to be base64 encoded. It is decoded to plain text before the mount.
        """
        return pulumi.get(self, "configs")


@pulumi.output_type
class ContainerInstanceVolumeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "fileName":
            suggest = "file_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContainerInstanceVolumeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContainerInstanceVolumeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContainerInstanceVolumeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 data: Optional[str] = None,
                 file_name: Optional[str] = None,
                 path: Optional[str] = None):
        """
        :param str data: The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        :param str file_name: The name of the file. The fileName should be unique across the volume.
        :param str path: (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        ContainerInstanceVolumeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            data=data,
            file_name=file_name,
            path=path,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             data: Optional[str] = None,
             file_name: Optional[str] = None,
             path: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'fileName' in kwargs:
            file_name = kwargs['fileName']

        if data is not None:
            _setter("data", data)
        if file_name is not None:
            _setter("file_name", file_name)
        if path is not None:
            _setter("path", path)

    @property
    @pulumi.getter
    def data(self) -> Optional[str]:
        """
        The base64 encoded contents of the file. The contents are decoded to plain text before mounted as a file to a container inside container instance.
        """
        return pulumi.get(self, "data")

    @property
    @pulumi.getter(name="fileName")
    def file_name(self) -> Optional[str]:
        """
        The name of the file. The fileName should be unique across the volume.
        """
        return pulumi.get(self, "file_name")

    @property
    @pulumi.getter
    def path(self) -> Optional[str]:
        """
        (Optional) Relative path for this file inside the volume mount directory. By default, the file is presented at the root of the volume mount path.
        """
        return pulumi.get(self, "path")


@pulumi.output_type
class NodePoolInitialNodeLabel(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: (Updatable) The key of the pair.
        :param str value: (Updatable) The value of the pair.
        """
        NodePoolInitialNodeLabel._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class NodePoolNode(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "faultDomain":
            suggest = "fault_domain"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "kubernetesVersion":
            suggest = "kubernetes_version"
        elif key == "lifecycleDetails":
            suggest = "lifecycle_details"
        elif key == "nodePoolId":
            suggest = "node_pool_id"
        elif key == "privateIp":
            suggest = "private_ip"
        elif key == "publicIp":
            suggest = "public_ip"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNode. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNode.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNode.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: Optional[str] = None,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 errors: Optional[Sequence['outputs.NodePoolNodeError']] = None,
                 fault_domain: Optional[str] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 id: Optional[str] = None,
                 kubernetes_version: Optional[str] = None,
                 lifecycle_details: Optional[str] = None,
                 name: Optional[str] = None,
                 node_pool_id: Optional[str] = None,
                 private_ip: Optional[str] = None,
                 public_ip: Optional[str] = None,
                 state: Optional[str] = None,
                 subnet_id: Optional[str] = None):
        """
        :param str availability_domain: (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param Mapping[str, Any] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['NodePoolNodeErrorArgs'] errors: An error that may be associated with the node.
        :param str fault_domain: The fault domain of this node.
        :param Mapping[str, Any] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the compute instance backing this node.
        :param str kubernetes_version: (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        :param str lifecycle_details: Details about the state of the node.
        :param str name: (Updatable) The name of the node pool. Avoid entering confidential information.
        :param str node_pool_id: The OCID of the node pool to which this node belongs.
        :param str private_ip: The private IP address of this node.
        :param str public_ip: The public IP address of this node.
        :param str state: The state of the nodepool.
        :param str subnet_id: (Updatable) The OCID of the subnet in which to place nodes.
        """
        NodePoolNode._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            defined_tags=defined_tags,
            errors=errors,
            fault_domain=fault_domain,
            freeform_tags=freeform_tags,
            id=id,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            name=name,
            node_pool_id=node_pool_id,
            private_ip=private_ip,
            public_ip=public_ip,
            state=state,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: Optional[str] = None,
             defined_tags: Optional[Mapping[str, Any]] = None,
             errors: Optional[Sequence['outputs.NodePoolNodeError']] = None,
             fault_domain: Optional[str] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             id: Optional[str] = None,
             kubernetes_version: Optional[str] = None,
             lifecycle_details: Optional[str] = None,
             name: Optional[str] = None,
             node_pool_id: Optional[str] = None,
             private_ip: Optional[str] = None,
             public_ip: Optional[str] = None,
             state: Optional[str] = None,
             subnet_id: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'faultDomain' in kwargs:
            fault_domain = kwargs['faultDomain']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nodePoolId' in kwargs:
            node_pool_id = kwargs['nodePoolId']
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']
        if 'publicIp' in kwargs:
            public_ip = kwargs['publicIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        if availability_domain is not None:
            _setter("availability_domain", availability_domain)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if errors is not None:
            _setter("errors", errors)
        if fault_domain is not None:
            _setter("fault_domain", fault_domain)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if id is not None:
            _setter("id", id)
        if kubernetes_version is not None:
            _setter("kubernetes_version", kubernetes_version)
        if lifecycle_details is not None:
            _setter("lifecycle_details", lifecycle_details)
        if name is not None:
            _setter("name", name)
        if node_pool_id is not None:
            _setter("node_pool_id", node_pool_id)
        if private_ip is not None:
            _setter("private_ip", private_ip)
        if public_ip is not None:
            _setter("public_ip", public_ip)
        if state is not None:
            _setter("state", state)
        if subnet_id is not None:
            _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> Optional[str]:
        """
        (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Optional[Sequence['outputs.NodePoolNodeError']]:
        """
        An error that may be associated with the node.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> Optional[str]:
        """
        The fault domain of this node.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> Optional[str]:
        """
        The OCID of the compute instance backing this node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> Optional[str]:
        """
        (Updatable) The version of Kubernetes to install on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> Optional[str]:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> Optional[str]:
        """
        (Updatable) The name of the node pool. Avoid entering confidential information.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> Optional[str]:
        """
        The OCID of the node pool to which this node belongs.
        """
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> Optional[str]:
        """
        The private IP address of this node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> Optional[str]:
        """
        The public IP address of this node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class NodePoolNodeConfigDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "placementConfigs":
            suggest = "placement_configs"
        elif key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"
        elif key == "isPvEncryptionInTransitEnabled":
            suggest = "is_pv_encryption_in_transit_enabled"
        elif key == "kmsKeyId":
            suggest = "kms_key_id"
        elif key == "nodePoolPodNetworkOptionDetails":
            suggest = "node_pool_pod_network_option_details"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 placement_configs: Sequence['outputs.NodePoolNodeConfigDetailsPlacementConfig'],
                 size: int,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None,
                 is_pv_encryption_in_transit_enabled: Optional[bool] = None,
                 kms_key_id: Optional[str] = None,
                 node_pool_pod_network_option_details: Optional['outputs.NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails'] = None,
                 nsg_ids: Optional[Sequence[str]] = None):
        """
        :param Sequence['NodePoolNodeConfigDetailsPlacementConfigArgs'] placement_configs: (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
               
               To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        :param int size: (Updatable) The number of nodes that should be in the node pool.
        :param Mapping[str, Any] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param bool is_pv_encryption_in_transit_enabled: (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param str kms_key_id: (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        :param 'NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetailsArgs' node_pool_pod_network_option_details: (Updatable) The CNI related configuration of pods in the node pool.
        :param Sequence[str] nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        NodePoolNodeConfigDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            placement_configs=placement_configs,
            size=size,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_pv_encryption_in_transit_enabled=is_pv_encryption_in_transit_enabled,
            kms_key_id=kms_key_id,
            node_pool_pod_network_option_details=node_pool_pod_network_option_details,
            nsg_ids=nsg_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             placement_configs: Sequence['outputs.NodePoolNodeConfigDetailsPlacementConfig'],
             size: int,
             defined_tags: Optional[Mapping[str, Any]] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             is_pv_encryption_in_transit_enabled: Optional[bool] = None,
             kms_key_id: Optional[str] = None,
             node_pool_pod_network_option_details: Optional['outputs.NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails'] = None,
             nsg_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'placementConfigs' in kwargs:
            placement_configs = kwargs['placementConfigs']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPvEncryptionInTransitEnabled' in kwargs:
            is_pv_encryption_in_transit_enabled = kwargs['isPvEncryptionInTransitEnabled']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'nodePoolPodNetworkOptionDetails' in kwargs:
            node_pool_pod_network_option_details = kwargs['nodePoolPodNetworkOptionDetails']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']

        _setter("placement_configs", placement_configs)
        _setter("size", size)
        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)
        if is_pv_encryption_in_transit_enabled is not None:
            _setter("is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        if kms_key_id is not None:
            _setter("kms_key_id", kms_key_id)
        if node_pool_pod_network_option_details is not None:
            _setter("node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.NodePoolNodeConfigDetailsPlacementConfig']:
        """
        (Updatable) The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.

        To use the node pool with a regional subnet, provide a placement configuration for each availability domain, and include the regional subnet in each placement configuration.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        (Updatable) The number of nodes that should be in the node pool.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> Optional[bool]:
        """
        (Updatable) Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Optional['outputs.NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails']:
        """
        (Updatable) The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cniType":
            suggest = "cni_type"
        elif key == "maxPodsPerNode":
            suggest = "max_pods_per_node"
        elif key == "podNsgIds":
            suggest = "pod_nsg_ids"
        elif key == "podSubnetIds":
            suggest = "pod_subnet_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cni_type: str,
                 max_pods_per_node: Optional[int] = None,
                 pod_nsg_ids: Optional[Sequence[str]] = None,
                 pod_subnet_ids: Optional[Sequence[str]] = None):
        """
        :param str cni_type: (Updatable) The CNI plugin used by this node pool
        :param int max_pods_per_node: (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[str] pod_nsg_ids: (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[str] pod_subnet_ids: (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        NodePoolNodeConfigDetailsNodePoolPodNetworkOptionDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
            max_pods_per_node=max_pods_per_node,
            pod_nsg_ids=pod_nsg_ids,
            pod_subnet_ids=pod_subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             max_pods_per_node: Optional[int] = None,
             pod_nsg_ids: Optional[Sequence[str]] = None,
             pod_subnet_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']
        if 'maxPodsPerNode' in kwargs:
            max_pods_per_node = kwargs['maxPodsPerNode']
        if 'podNsgIds' in kwargs:
            pod_nsg_ids = kwargs['podNsgIds']
        if 'podSubnetIds' in kwargs:
            pod_subnet_ids = kwargs['podSubnetIds']

        _setter("cni_type", cni_type)
        if max_pods_per_node is not None:
            _setter("max_pods_per_node", max_pods_per_node)
        if pod_nsg_ids is not None:
            _setter("pod_nsg_ids", pod_nsg_ids)
        if pod_subnet_ids is not None:
            _setter("pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        (Updatable) The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> Optional[int]:
        """
        (Updatable) The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Optional[Sequence[str]]:
        """
        (Updatable) The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Optional[Sequence[str]]:
        """
        (Updatable) The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "subnetId":
            suggest = "subnet_id"
        elif key == "capacityReservationId":
            suggest = "capacity_reservation_id"
        elif key == "faultDomains":
            suggest = "fault_domains"
        elif key == "preemptibleNodeConfig":
            suggest = "preemptible_node_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: str,
                 subnet_id: str,
                 capacity_reservation_id: Optional[str] = None,
                 fault_domains: Optional[Sequence[str]] = None,
                 preemptible_node_config: Optional['outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig'] = None):
        """
        :param str availability_domain: (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param str subnet_id: (Updatable) The OCID of the subnet in which to place nodes.
        :param str capacity_reservation_id: (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[str] fault_domains: (Updatable) A list of fault domains in which to place nodes.
        :param 'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigArgs' preemptible_node_config: (Updatable) Configuration options for preemptible nodes.
        """
        NodePoolNodeConfigDetailsPlacementConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            subnet_id=subnet_id,
            capacity_reservation_id=capacity_reservation_id,
            fault_domains=fault_domains,
            preemptible_node_config=preemptible_node_config,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             subnet_id: str,
             capacity_reservation_id: Optional[str] = None,
             fault_domains: Optional[Sequence[str]] = None,
             preemptible_node_config: Optional['outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig'] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'capacityReservationId' in kwargs:
            capacity_reservation_id = kwargs['capacityReservationId']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'preemptibleNodeConfig' in kwargs:
            preemptible_node_config = kwargs['preemptibleNodeConfig']

        _setter("availability_domain", availability_domain)
        _setter("subnet_id", subnet_id)
        if capacity_reservation_id is not None:
            _setter("capacity_reservation_id", capacity_reservation_id)
        if fault_domains is not None:
            _setter("fault_domains", fault_domains)
        if preemptible_node_config is not None:
            _setter("preemptible_node_config", preemptible_node_config)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        (Updatable) The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        (Updatable) The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Optional[Sequence[str]]:
        """
        (Updatable) A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfig")
    def preemptible_node_config(self) -> Optional['outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig']:
        """
        (Updatable) Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_config")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "preemptionAction":
            suggest = "preemption_action"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 preemption_action: 'outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction'):
        """
        :param 'NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionActionArgs' preemption_action: (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            preemption_action=preemption_action,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             preemption_action: 'outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction',
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'preemptionAction' in kwargs:
            preemption_action = kwargs['preemptionAction']

        _setter("preemption_action", preemption_action)

    @property
    @pulumi.getter(name="preemptionAction")
    def preemption_action(self) -> 'outputs.NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction':
        """
        (Updatable) The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_action")


@pulumi.output_type
class NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isPreserveBootVolume":
            suggest = "is_preserve_boot_volume"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 type: str,
                 is_preserve_boot_volume: Optional[bool] = None):
        """
        :param str type: (Updatable) The type of action to run when the instance is interrupted for eviction.
        :param bool is_preserve_boot_volume: (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        NodePoolNodeConfigDetailsPlacementConfigPreemptibleNodeConfigPreemptionAction._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            type=type,
            is_preserve_boot_volume=is_preserve_boot_volume,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             type: str,
             is_preserve_boot_volume: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPreserveBootVolume' in kwargs:
            is_preserve_boot_volume = kwargs['isPreserveBootVolume']

        _setter("type", type)
        if is_preserve_boot_volume is not None:
            _setter("is_preserve_boot_volume", is_preserve_boot_volume)

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        (Updatable) The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> Optional[bool]:
        """
        (Updatable) Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")


@pulumi.output_type
class NodePoolNodeError(dict):
    def __init__(__self__, *,
                 code: Optional[str] = None,
                 message: Optional[str] = None,
                 status: Optional[str] = None):
        """
        :param str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string of the upstream error.
        :param str status: The status of the HTTP response encountered in the upstream error.
        """
        NodePoolNodeError._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: Optional[str] = None,
             message: Optional[str] = None,
             status: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if code is not None:
            _setter("code", code)
        if message is not None:
            _setter("message", message)
        if status is not None:
            _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> Optional[str]:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> Optional[str]:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> Optional[str]:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class NodePoolNodeEvictionNodePoolSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "evictionGraceDuration":
            suggest = "eviction_grace_duration"
        elif key == "isForceDeleteAfterGraceDuration":
            suggest = "is_force_delete_after_grace_duration"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeEvictionNodePoolSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeEvictionNodePoolSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeEvictionNodePoolSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 eviction_grace_duration: Optional[str] = None,
                 is_force_delete_after_grace_duration: Optional[bool] = None):
        """
        :param str eviction_grace_duration: (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param bool is_force_delete_after_grace_duration: (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        NodePoolNodeEvictionNodePoolSettings._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            eviction_grace_duration=eviction_grace_duration,
            is_force_delete_after_grace_duration=is_force_delete_after_grace_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             eviction_grace_duration: Optional[str] = None,
             is_force_delete_after_grace_duration: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'evictionGraceDuration' in kwargs:
            eviction_grace_duration = kwargs['evictionGraceDuration']
        if 'isForceDeleteAfterGraceDuration' in kwargs:
            is_force_delete_after_grace_duration = kwargs['isForceDeleteAfterGraceDuration']

        if eviction_grace_duration is not None:
            _setter("eviction_grace_duration", eviction_grace_duration)
        if is_force_delete_after_grace_duration is not None:
            _setter("is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> Optional[str]:
        """
        (Updatable) Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> Optional[bool]:
        """
        (Updatable) If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class NodePoolNodePoolCyclingDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "isNodeCyclingEnabled":
            suggest = "is_node_cycling_enabled"
        elif key == "maximumSurge":
            suggest = "maximum_surge"
        elif key == "maximumUnavailable":
            suggest = "maximum_unavailable"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodePoolCyclingDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodePoolCyclingDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodePoolCyclingDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 is_node_cycling_enabled: Optional[bool] = None,
                 maximum_surge: Optional[str] = None,
                 maximum_unavailable: Optional[str] = None):
        """
        :param bool is_node_cycling_enabled: (Updatable) If nodes in the nodepool will be cycled to have new changes.
        :param str maximum_surge: (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param str maximum_unavailable: (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        NodePoolNodePoolCyclingDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_node_cycling_enabled=is_node_cycling_enabled,
            maximum_surge=maximum_surge,
            maximum_unavailable=maximum_unavailable,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_node_cycling_enabled: Optional[bool] = None,
             maximum_surge: Optional[str] = None,
             maximum_unavailable: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isNodeCyclingEnabled' in kwargs:
            is_node_cycling_enabled = kwargs['isNodeCyclingEnabled']
        if 'maximumSurge' in kwargs:
            maximum_surge = kwargs['maximumSurge']
        if 'maximumUnavailable' in kwargs:
            maximum_unavailable = kwargs['maximumUnavailable']

        if is_node_cycling_enabled is not None:
            _setter("is_node_cycling_enabled", is_node_cycling_enabled)
        if maximum_surge is not None:
            _setter("maximum_surge", maximum_surge)
        if maximum_unavailable is not None:
            _setter("maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> Optional[bool]:
        """
        (Updatable) If nodes in the nodepool will be cycled to have new changes.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> Optional[str]:
        """
        (Updatable) Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> Optional[str]:
        """
        (Updatable) Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class NodePoolNodeShapeConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "memoryInGbs":
            suggest = "memory_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeShapeConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeShapeConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeShapeConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 memory_in_gbs: Optional[float] = None,
                 ocpus: Optional[float] = None):
        """
        :param float memory_in_gbs: (Updatable) The total amount of memory available to each node, in gigabytes.
        :param float ocpus: (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        NodePoolNodeShapeConfig._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: Optional[float] = None,
             ocpus: Optional[float] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        if memory_in_gbs is not None:
            _setter("memory_in_gbs", memory_in_gbs)
        if ocpus is not None:
            _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> Optional[float]:
        """
        (Updatable) The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> Optional[float]:
        """
        (Updatable) The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class NodePoolNodeSource(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "sourceName":
            suggest = "source_name"
        elif key == "sourceType":
            suggest = "source_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeSource. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeSource.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeSource.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: Optional[str] = None,
                 source_name: Optional[str] = None,
                 source_type: Optional[str] = None):
        """
        :param str image_id: (Updatable) The OCID of the image used to boot the node.
        :param str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param str source_type: (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        NodePoolNodeSource._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_id=image_id,
            source_name=source_name,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_id: Optional[str] = None,
             source_name: Optional[str] = None,
             source_type: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceName' in kwargs:
            source_name = kwargs['sourceName']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        if image_id is not None:
            _setter("image_id", image_id)
        if source_name is not None:
            _setter("source_name", source_name)
        if source_type is not None:
            _setter("source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> Optional[str]:
        """
        (Updatable) The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> Optional[str]:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> Optional[str]:
        """
        (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class NodePoolNodeSourceDetails(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageId":
            suggest = "image_id"
        elif key == "sourceType":
            suggest = "source_type"
        elif key == "bootVolumeSizeInGbs":
            suggest = "boot_volume_size_in_gbs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodePoolNodeSourceDetails. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodePoolNodeSourceDetails.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodePoolNodeSourceDetails.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_id: str,
                 source_type: str,
                 boot_volume_size_in_gbs: Optional[str] = None):
        """
        :param str image_id: (Updatable) The OCID of the image used to boot the node.
        :param str source_type: (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        :param str boot_volume_size_in_gbs: (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        NodePoolNodeSourceDetails._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_id=image_id,
            source_type=source_type,
            boot_volume_size_in_gbs=boot_volume_size_in_gbs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_id: str,
             source_type: str,
             boot_volume_size_in_gbs: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']
        if 'bootVolumeSizeInGbs' in kwargs:
            boot_volume_size_in_gbs = kwargs['bootVolumeSizeInGbs']

        _setter("image_id", image_id)
        _setter("source_type", source_type)
        if boot_volume_size_in_gbs is not None:
            _setter("boot_volume_size_in_gbs", boot_volume_size_in_gbs)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        (Updatable) The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        (Updatable) The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> Optional[str]:
        """
        (Updatable) The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")


@pulumi.output_type
class VirtualNodePoolInitialVirtualNodeLabel(dict):
    def __init__(__self__, *,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str key: (Updatable) The key of the pair.
        :param str value: (Updatable) The value of the pair.
        """
        VirtualNodePoolInitialVirtualNodeLabel._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if key is not None:
            _setter("key", key)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualNodePoolPlacementConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "availabilityDomain":
            suggest = "availability_domain"
        elif key == "faultDomains":
            suggest = "fault_domains"
        elif key == "subnetId":
            suggest = "subnet_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolPlacementConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolPlacementConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolPlacementConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 availability_domain: str,
                 fault_domains: Sequence[str],
                 subnet_id: str):
        """
        :param str availability_domain: (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[str] fault_domains: (Updatable) The fault domain of this virtual node.
        :param str subnet_id: (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        VirtualNodePoolPlacementConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            fault_domains=fault_domains,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             fault_domains: Sequence[str],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("fault_domains", fault_domains)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        (Updatable) The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        """
        (Updatable) The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class VirtualNodePoolPodConfiguration(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "subnetId":
            suggest = "subnet_id"
        elif key == "nsgIds":
            suggest = "nsg_ids"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolPodConfiguration. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolPodConfiguration.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolPodConfiguration.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 shape: str,
                 subnet_id: str,
                 nsg_ids: Optional[Sequence[str]] = None):
        """
        :param str shape: (Updatable) Shape of the pods.
        :param str subnet_id: (Updatable) The regional subnet where pods' VNIC will be placed.
        :param Sequence[str] nsg_ids: (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        VirtualNodePoolPodConfiguration._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            shape=shape,
            subnet_id=subnet_id,
            nsg_ids=nsg_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             shape: str,
             subnet_id: str,
             nsg_ids: Optional[Sequence[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']

        _setter("shape", shape)
        _setter("subnet_id", subnet_id)
        if nsg_ids is not None:
            _setter("nsg_ids", nsg_ids)

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        (Updatable) Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        (Updatable) The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Optional[Sequence[str]]:
        """
        (Updatable) List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")


@pulumi.output_type
class VirtualNodePoolTaint(dict):
    def __init__(__self__, *,
                 effect: Optional[str] = None,
                 key: Optional[str] = None,
                 value: Optional[str] = None):
        """
        :param str effect: (Updatable) The effect of the pair.
        :param str key: (Updatable) The key of the pair.
        :param str value: (Updatable) The value of the pair.
        """
        VirtualNodePoolTaint._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            effect=effect,
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             effect: Optional[str] = None,
             key: Optional[str] = None,
             value: Optional[str] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        if effect is not None:
            _setter("effect", effect)
        if key is not None:
            _setter("key", key)
        if value is not None:
            _setter("value", value)

    @property
    @pulumi.getter
    def effect(self) -> Optional[str]:
        """
        (Updatable) The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> Optional[str]:
        """
        (Updatable) The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> Optional[str]:
        """
        (Updatable) The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class VirtualNodePoolVirtualNodeTags(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "definedTags":
            suggest = "defined_tags"
        elif key == "freeformTags":
            suggest = "freeform_tags"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in VirtualNodePoolVirtualNodeTags. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        VirtualNodePoolVirtualNodeTags.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        VirtualNodePoolVirtualNodeTags.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 defined_tags: Optional[Mapping[str, Any]] = None,
                 freeform_tags: Optional[Mapping[str, Any]] = None):
        """
        :param Mapping[str, Any] defined_tags: (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        VirtualNodePoolVirtualNodeTags._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Optional[Mapping[str, Any]] = None,
             freeform_tags: Optional[Mapping[str, Any]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        if defined_tags is not None:
            _setter("defined_tags", defined_tags)
        if freeform_tags is not None:
            _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Optional[Mapping[str, Any]]:
        """
        (Updatable) Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetAddonAddonErrorResult(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 status: str):
        """
        :param str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string of the upstream error.
        :param str status: The status of the HTTP response encountered in the upstream error.
        """
        GetAddonAddonErrorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             message: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("code", code)
        _setter("message", message)
        _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAddonConfigurationResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: configuration key name
        :param str value: configuration value name
        """
        GetAddonConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonOptionsAddonOptionResult(dict):
    def __init__(__self__, *,
                 addon_group: str,
                 addon_schema_version: str,
                 defined_tags: Mapping[str, Any],
                 description: str,
                 freeform_tags: Mapping[str, Any],
                 is_essential: bool,
                 name: str,
                 state: str,
                 system_tags: Mapping[str, Any],
                 time_created: str,
                 versions: Sequence['outputs.GetAddonOptionsAddonOptionVersionResult']):
        """
        :param str addon_group: Addon group info, a namespace concept that groups addons with similar functionalities.
        :param str addon_schema_version: Addon definition schema version to validate addon.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str description: Information about the addon version.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param bool is_essential: Is it an essential addon for cluster operation or not.
        :param str name: Name of the addon and it would be unique.
        :param str state: The life cycle state of the addon.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param str time_created: The time the work request was created.
        :param Sequence['GetAddonOptionsAddonOptionVersionArgs'] versions: The resources this work request affects.
        """
        GetAddonOptionsAddonOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            addon_group=addon_group,
            addon_schema_version=addon_schema_version,
            defined_tags=defined_tags,
            description=description,
            freeform_tags=freeform_tags,
            is_essential=is_essential,
            name=name,
            state=state,
            system_tags=system_tags,
            time_created=time_created,
            versions=versions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             addon_group: str,
             addon_schema_version: str,
             defined_tags: Mapping[str, Any],
             description: str,
             freeform_tags: Mapping[str, Any],
             is_essential: bool,
             name: str,
             state: str,
             system_tags: Mapping[str, Any],
             time_created: str,
             versions: Sequence['outputs.GetAddonOptionsAddonOptionVersionResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'addonGroup' in kwargs:
            addon_group = kwargs['addonGroup']
        if 'addonSchemaVersion' in kwargs:
            addon_schema_version = kwargs['addonSchemaVersion']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isEssential' in kwargs:
            is_essential = kwargs['isEssential']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("addon_group", addon_group)
        _setter("addon_schema_version", addon_schema_version)
        _setter("defined_tags", defined_tags)
        _setter("description", description)
        _setter("freeform_tags", freeform_tags)
        _setter("is_essential", is_essential)
        _setter("name", name)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("time_created", time_created)
        _setter("versions", versions)

    @property
    @pulumi.getter(name="addonGroup")
    def addon_group(self) -> str:
        """
        Addon group info, a namespace concept that groups addons with similar functionalities.
        """
        return pulumi.get(self, "addon_group")

    @property
    @pulumi.getter(name="addonSchemaVersion")
    def addon_schema_version(self) -> str:
        """
        Addon definition schema version to validate addon.
        """
        return pulumi.get(self, "addon_schema_version")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isEssential")
    def is_essential(self) -> bool:
        """
        Is it an essential addon for cluster operation or not.
        """
        return pulumi.get(self, "is_essential")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the addon and it would be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The life cycle state of the addon.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the work request was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def versions(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionResult']:
        """
        The resources this work request affects.
        """
        return pulumi.get(self, "versions")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionResult(dict):
    def __init__(__self__, *,
                 configurations: Sequence['outputs.GetAddonOptionsAddonOptionVersionConfigurationResult'],
                 description: str,
                 kubernetes_version_filters: Sequence['outputs.GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult'],
                 status: str,
                 version_number: str):
        """
        :param Sequence['GetAddonOptionsAddonOptionVersionConfigurationArgs'] configurations: Addon version configuration details.
        :param str description: Information about the addon version.
        :param Sequence['GetAddonOptionsAddonOptionVersionKubernetesVersionFilterArgs'] kubernetes_version_filters: The range of kubernetes versions an addon can be configured.
        :param str status: Current state of the addon, only active will be visible to customer, visibility of versions in other status will be filtered  based on limits property.
        :param str version_number: Version number, need be comparable within an addon.
        """
        GetAddonOptionsAddonOptionVersionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            configurations=configurations,
            description=description,
            kubernetes_version_filters=kubernetes_version_filters,
            status=status,
            version_number=version_number,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             configurations: Sequence['outputs.GetAddonOptionsAddonOptionVersionConfigurationResult'],
             description: str,
             kubernetes_version_filters: Sequence['outputs.GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult'],
             status: str,
             version_number: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kubernetesVersionFilters' in kwargs:
            kubernetes_version_filters = kwargs['kubernetesVersionFilters']
        if 'versionNumber' in kwargs:
            version_number = kwargs['versionNumber']

        _setter("configurations", configurations)
        _setter("description", description)
        _setter("kubernetes_version_filters", kubernetes_version_filters)
        _setter("status", status)
        _setter("version_number", version_number)

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionConfigurationResult']:
        """
        Addon version configuration details.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="kubernetesVersionFilters")
    def kubernetes_version_filters(self) -> Sequence['outputs.GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult']:
        """
        The range of kubernetes versions an addon can be configured.
        """
        return pulumi.get(self, "kubernetes_version_filters")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        Current state of the addon, only active will be visible to customer, visibility of versions in other status will be filtered  based on limits property.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="versionNumber")
    def version_number(self) -> str:
        """
        Version number, need be comparable within an addon.
        """
        return pulumi.get(self, "version_number")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionConfigurationResult(dict):
    def __init__(__self__, *,
                 description: str,
                 display_name: str,
                 is_required: bool,
                 key: str,
                 value: str):
        """
        :param str description: Information about the addon version.
        :param str display_name: Display name of addon version.
        :param bool is_required: If the the configuration is required or not.
        :param str key: Addon configuration key
        :param str value: Addon configuration value
        """
        GetAddonOptionsAddonOptionVersionConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            description=description,
            display_name=display_name,
            is_required=is_required,
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             description: str,
             display_name: str,
             is_required: bool,
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'isRequired' in kwargs:
            is_required = kwargs['isRequired']

        _setter("description", description)
        _setter("display_name", display_name)
        _setter("is_required", is_required)
        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Information about the addon version.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of addon version.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="isRequired")
    def is_required(self) -> bool:
        """
        If the the configuration is required or not.
        """
        return pulumi.get(self, "is_required")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Addon configuration key
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Addon configuration value
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult(dict):
    def __init__(__self__, *,
                 exact_kubernetes_versions: Sequence[str],
                 maximum_version: str,
                 minimal_version: str):
        """
        :param Sequence[str] exact_kubernetes_versions: The exact version of kubernetes that are compatible.
        :param str maximum_version: The latest kubernetes version.
        :param str minimal_version: The earliest kubernetes version.
        """
        GetAddonOptionsAddonOptionVersionKubernetesVersionFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            exact_kubernetes_versions=exact_kubernetes_versions,
            maximum_version=maximum_version,
            minimal_version=minimal_version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             exact_kubernetes_versions: Sequence[str],
             maximum_version: str,
             minimal_version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'exactKubernetesVersions' in kwargs:
            exact_kubernetes_versions = kwargs['exactKubernetesVersions']
        if 'maximumVersion' in kwargs:
            maximum_version = kwargs['maximumVersion']
        if 'minimalVersion' in kwargs:
            minimal_version = kwargs['minimalVersion']

        _setter("exact_kubernetes_versions", exact_kubernetes_versions)
        _setter("maximum_version", maximum_version)
        _setter("minimal_version", minimal_version)

    @property
    @pulumi.getter(name="exactKubernetesVersions")
    def exact_kubernetes_versions(self) -> Sequence[str]:
        """
        The exact version of kubernetes that are compatible.
        """
        return pulumi.get(self, "exact_kubernetes_versions")

    @property
    @pulumi.getter(name="maximumVersion")
    def maximum_version(self) -> str:
        """
        The latest kubernetes version.
        """
        return pulumi.get(self, "maximum_version")

    @property
    @pulumi.getter(name="minimalVersion")
    def minimal_version(self) -> str:
        """
        The earliest kubernetes version.
        """
        return pulumi.get(self, "minimal_version")


@pulumi.output_type
class GetAddonOptionsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: Name of the addon and it would be unique.
        """
        GetAddonOptionsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Name of the addon and it would be unique.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetAddonsAddonResult(dict):
    def __init__(__self__, *,
                 addon_errors: Sequence['outputs.GetAddonsAddonAddonErrorResult'],
                 addon_name: str,
                 cluster_id: str,
                 configurations: Sequence['outputs.GetAddonsAddonConfigurationResult'],
                 current_installed_version: str,
                 remove_addon_resources_on_delete: bool,
                 state: str,
                 time_created: str,
                 version: str):
        """
        :param Sequence['GetAddonsAddonAddonErrorArgs'] addon_errors: The error info of the addon.
        :param str addon_name: The name of the addon.
        :param str cluster_id: The OCID of the cluster.
        :param Sequence['GetAddonsAddonConfigurationArgs'] configurations: Addon configuration details.
        :param str current_installed_version: current installed version of the addon
        :param str state: The state of the addon.
        :param str time_created: The time the cluster was created.
        :param str version: selected addon version, or null indicates autoUpdate
        """
        GetAddonsAddonResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            addon_errors=addon_errors,
            addon_name=addon_name,
            cluster_id=cluster_id,
            configurations=configurations,
            current_installed_version=current_installed_version,
            remove_addon_resources_on_delete=remove_addon_resources_on_delete,
            state=state,
            time_created=time_created,
            version=version,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             addon_errors: Sequence['outputs.GetAddonsAddonAddonErrorResult'],
             addon_name: str,
             cluster_id: str,
             configurations: Sequence['outputs.GetAddonsAddonConfigurationResult'],
             current_installed_version: str,
             remove_addon_resources_on_delete: bool,
             state: str,
             time_created: str,
             version: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'addonErrors' in kwargs:
            addon_errors = kwargs['addonErrors']
        if 'addonName' in kwargs:
            addon_name = kwargs['addonName']
        if 'clusterId' in kwargs:
            cluster_id = kwargs['clusterId']
        if 'currentInstalledVersion' in kwargs:
            current_installed_version = kwargs['currentInstalledVersion']
        if 'removeAddonResourcesOnDelete' in kwargs:
            remove_addon_resources_on_delete = kwargs['removeAddonResourcesOnDelete']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("addon_errors", addon_errors)
        _setter("addon_name", addon_name)
        _setter("cluster_id", cluster_id)
        _setter("configurations", configurations)
        _setter("current_installed_version", current_installed_version)
        _setter("remove_addon_resources_on_delete", remove_addon_resources_on_delete)
        _setter("state", state)
        _setter("time_created", time_created)
        _setter("version", version)

    @property
    @pulumi.getter(name="addonErrors")
    def addon_errors(self) -> Sequence['outputs.GetAddonsAddonAddonErrorResult']:
        """
        The error info of the addon.
        """
        return pulumi.get(self, "addon_errors")

    @property
    @pulumi.getter(name="addonName")
    def addon_name(self) -> str:
        """
        The name of the addon.
        """
        return pulumi.get(self, "addon_name")

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter
    def configurations(self) -> Sequence['outputs.GetAddonsAddonConfigurationResult']:
        """
        Addon configuration details.
        """
        return pulumi.get(self, "configurations")

    @property
    @pulumi.getter(name="currentInstalledVersion")
    def current_installed_version(self) -> str:
        """
        current installed version of the addon
        """
        return pulumi.get(self, "current_installed_version")

    @property
    @pulumi.getter(name="removeAddonResourcesOnDelete")
    def remove_addon_resources_on_delete(self) -> bool:
        return pulumi.get(self, "remove_addon_resources_on_delete")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the addon.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        selected addon version, or null indicates autoUpdate
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class GetAddonsAddonAddonErrorResult(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 status: str):
        """
        :param str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string of the upstream error.
        :param str status: The status of the HTTP response encountered in the upstream error.
        """
        GetAddonsAddonAddonErrorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             message: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("code", code)
        _setter("message", message)
        _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetAddonsAddonConfigurationResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: configuration key name
        :param str value: configuration value name
        """
        GetAddonsAddonConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        configuration key name
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        configuration value name
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetAddonsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetAddonsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetClusterOptionClusterPodNetworkOptionResult(dict):
    def __init__(__self__, *,
                 cni_type: str):
        """
        :param str cni_type: The CNI used by the node pools of this cluster
        """
        GetClusterOptionClusterPodNetworkOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']

        _setter("cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class GetClusterWorkloadMappingsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetClusterWorkloadMappingsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetClusterWorkloadMappingsWorkloadMappingResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 mapped_compartment_id: str,
                 mapped_tenancy_id: str,
                 namespace: str,
                 state: str,
                 time_created: str):
        """
        :param str cluster_id: The OCID of the cluster.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The ocid of the workloadMapping.
        :param str mapped_compartment_id: The OCID of the mapped customer compartment.
        :param str mapped_tenancy_id: The OCID of the mapped customer tenancy.
        :param str namespace: The namespace of the workloadMapping.
        :param str state: The state of the workloadMapping.
        :param str time_created: The time the cluster was created.
        """
        GetClusterWorkloadMappingsWorkloadMappingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cluster_id=cluster_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            mapped_compartment_id=mapped_compartment_id,
            mapped_tenancy_id=mapped_tenancy_id,
            namespace=namespace,
            state=state,
            time_created=time_created,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cluster_id: str,
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             mapped_compartment_id: str,
             mapped_tenancy_id: str,
             namespace: str,
             state: str,
             time_created: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clusterId' in kwargs:
            cluster_id = kwargs['clusterId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'mappedCompartmentId' in kwargs:
            mapped_compartment_id = kwargs['mappedCompartmentId']
        if 'mappedTenancyId' in kwargs:
            mapped_tenancy_id = kwargs['mappedTenancyId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']

        _setter("cluster_id", cluster_id)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("mapped_compartment_id", mapped_compartment_id)
        _setter("mapped_tenancy_id", mapped_tenancy_id)
        _setter("namespace", namespace)
        _setter("state", state)
        _setter("time_created", time_created)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The ocid of the workloadMapping.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="mappedCompartmentId")
    def mapped_compartment_id(self) -> str:
        """
        The OCID of the mapped customer compartment.
        """
        return pulumi.get(self, "mapped_compartment_id")

    @property
    @pulumi.getter(name="mappedTenancyId")
    def mapped_tenancy_id(self) -> str:
        """
        The OCID of the mapped customer tenancy.
        """
        return pulumi.get(self, "mapped_tenancy_id")

    @property
    @pulumi.getter
    def namespace(self) -> str:
        """
        The namespace of the workloadMapping.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the workloadMapping.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")


@pulumi.output_type
class GetClustersClusterResult(dict):
    def __init__(__self__, *,
                 available_kubernetes_upgrades: Sequence[str],
                 cluster_pod_network_options: Sequence['outputs.GetClustersClusterClusterPodNetworkOptionResult'],
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 endpoint_configs: Sequence['outputs.GetClustersClusterEndpointConfigResult'],
                 endpoints: Sequence['outputs.GetClustersClusterEndpointResult'],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 image_policy_configs: Sequence['outputs.GetClustersClusterImagePolicyConfigResult'],
                 kms_key_id: str,
                 kubernetes_version: str,
                 lifecycle_details: str,
                 metadatas: Sequence['outputs.GetClustersClusterMetadataResult'],
                 name: str,
                 options: Sequence['outputs.GetClustersClusterOptionResult'],
                 state: str,
                 type: str,
                 vcn_id: str):
        """
        :param Sequence[str] available_kubernetes_upgrades: Available Kubernetes versions to which the clusters masters may be upgraded.
        :param Sequence['GetClustersClusterClusterPodNetworkOptionArgs'] cluster_pod_network_options: Available CNIs and network options for existing and new node pools of the cluster
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['GetClustersClusterEndpointConfigArgs'] endpoint_configs: The network configuration for access to the Cluster control plane.
        :param Sequence['GetClustersClusterEndpointArgs'] endpoints: Endpoints served up by the cluster masters.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the cluster.
        :param Sequence['GetClustersClusterImagePolicyConfigArgs'] image_policy_configs: The image verification policy for signature validation.
        :param str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        :param str kubernetes_version: The version of Kubernetes running on the cluster masters.
        :param str lifecycle_details: Details about the state of the cluster masters.
        :param Sequence['GetClustersClusterMetadataArgs'] metadatas: Metadata about the cluster.
        :param str name: The name to filter on.
        :param Sequence['GetClustersClusterOptionArgs'] options: Optional attributes for the cluster.
        :param str state: A cluster lifecycle state to filter on. Can have multiple parameters of this name.
        :param str type: Type of cluster. Values can be BASIC_CLUSTER or ENHANCED_CLUSTER. For more information, see [Cluster Types](https://docs.cloud.oracle.com/iaas/Content/ContEng/Tasks/contengcomparingenhancedwithbasicclusters_topic.htm)
        :param str vcn_id: The OCID of the virtual cloud network (VCN) in which the cluster exists.
        """
        GetClustersClusterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            available_kubernetes_upgrades=available_kubernetes_upgrades,
            cluster_pod_network_options=cluster_pod_network_options,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            endpoint_configs=endpoint_configs,
            endpoints=endpoints,
            freeform_tags=freeform_tags,
            id=id,
            image_policy_configs=image_policy_configs,
            kms_key_id=kms_key_id,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            metadatas=metadatas,
            name=name,
            options=options,
            state=state,
            type=type,
            vcn_id=vcn_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             available_kubernetes_upgrades: Sequence[str],
             cluster_pod_network_options: Sequence['outputs.GetClustersClusterClusterPodNetworkOptionResult'],
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             endpoint_configs: Sequence['outputs.GetClustersClusterEndpointConfigResult'],
             endpoints: Sequence['outputs.GetClustersClusterEndpointResult'],
             freeform_tags: Mapping[str, Any],
             id: str,
             image_policy_configs: Sequence['outputs.GetClustersClusterImagePolicyConfigResult'],
             kms_key_id: str,
             kubernetes_version: str,
             lifecycle_details: str,
             metadatas: Sequence['outputs.GetClustersClusterMetadataResult'],
             name: str,
             options: Sequence['outputs.GetClustersClusterOptionResult'],
             state: str,
             type: str,
             vcn_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availableKubernetesUpgrades' in kwargs:
            available_kubernetes_upgrades = kwargs['availableKubernetesUpgrades']
        if 'clusterPodNetworkOptions' in kwargs:
            cluster_pod_network_options = kwargs['clusterPodNetworkOptions']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'endpointConfigs' in kwargs:
            endpoint_configs = kwargs['endpointConfigs']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'imagePolicyConfigs' in kwargs:
            image_policy_configs = kwargs['imagePolicyConfigs']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'vcnId' in kwargs:
            vcn_id = kwargs['vcnId']

        _setter("available_kubernetes_upgrades", available_kubernetes_upgrades)
        _setter("cluster_pod_network_options", cluster_pod_network_options)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("endpoint_configs", endpoint_configs)
        _setter("endpoints", endpoints)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("image_policy_configs", image_policy_configs)
        _setter("kms_key_id", kms_key_id)
        _setter("kubernetes_version", kubernetes_version)
        _setter("lifecycle_details", lifecycle_details)
        _setter("metadatas", metadatas)
        _setter("name", name)
        _setter("options", options)
        _setter("state", state)
        _setter("type", type)
        _setter("vcn_id", vcn_id)

    @property
    @pulumi.getter(name="availableKubernetesUpgrades")
    def available_kubernetes_upgrades(self) -> Sequence[str]:
        """
        Available Kubernetes versions to which the clusters masters may be upgraded.
        """
        return pulumi.get(self, "available_kubernetes_upgrades")

    @property
    @pulumi.getter(name="clusterPodNetworkOptions")
    def cluster_pod_network_options(self) -> Sequence['outputs.GetClustersClusterClusterPodNetworkOptionResult']:
        """
        Available CNIs and network options for existing and new node pools of the cluster
        """
        return pulumi.get(self, "cluster_pod_network_options")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="endpointConfigs")
    def endpoint_configs(self) -> Sequence['outputs.GetClustersClusterEndpointConfigResult']:
        """
        The network configuration for access to the Cluster control plane.
        """
        return pulumi.get(self, "endpoint_configs")

    @property
    @pulumi.getter
    def endpoints(self) -> Sequence['outputs.GetClustersClusterEndpointResult']:
        """
        Endpoints served up by the cluster masters.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="imagePolicyConfigs")
    def image_policy_configs(self) -> Sequence['outputs.GetClustersClusterImagePolicyConfigResult']:
        """
        The image verification policy for signature validation.
        """
        return pulumi.get(self, "image_policy_configs")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        """
        The version of Kubernetes running on the cluster masters.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the state of the cluster masters.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def metadatas(self) -> Sequence['outputs.GetClustersClusterMetadataResult']:
        """
        Metadata about the cluster.
        """
        return pulumi.get(self, "metadatas")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def options(self) -> Sequence['outputs.GetClustersClusterOptionResult']:
        """
        Optional attributes for the cluster.
        """
        return pulumi.get(self, "options")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A cluster lifecycle state to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        Type of cluster. Values can be BASIC_CLUSTER or ENHANCED_CLUSTER. For more information, see [Cluster Types](https://docs.cloud.oracle.com/iaas/Content/ContEng/Tasks/contengcomparingenhancedwithbasicclusters_topic.htm)
        """
        return pulumi.get(self, "type")

    @property
    @pulumi.getter(name="vcnId")
    def vcn_id(self) -> str:
        """
        The OCID of the virtual cloud network (VCN) in which the cluster exists.
        """
        return pulumi.get(self, "vcn_id")


@pulumi.output_type
class GetClustersClusterClusterPodNetworkOptionResult(dict):
    def __init__(__self__, *,
                 cni_type: str):
        """
        :param str cni_type: The CNI used by the node pools of this cluster
        """
        GetClustersClusterClusterPodNetworkOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']

        _setter("cni_type", cni_type)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        The CNI used by the node pools of this cluster
        """
        return pulumi.get(self, "cni_type")


@pulumi.output_type
class GetClustersClusterEndpointResult(dict):
    def __init__(__self__, *,
                 kubernetes: str,
                 private_endpoint: str,
                 public_endpoint: str,
                 vcn_hostname_endpoint: str):
        """
        :param str kubernetes: The non-native networking Kubernetes API server endpoint.
        :param str private_endpoint: The private native networking Kubernetes API server endpoint.
        :param str public_endpoint: The public native networking Kubernetes API server endpoint, if one was requested.
        :param str vcn_hostname_endpoint: The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        GetClustersClusterEndpointResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kubernetes=kubernetes,
            private_endpoint=private_endpoint,
            public_endpoint=public_endpoint,
            vcn_hostname_endpoint=vcn_hostname_endpoint,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kubernetes: str,
             private_endpoint: str,
             public_endpoint: str,
             vcn_hostname_endpoint: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'privateEndpoint' in kwargs:
            private_endpoint = kwargs['privateEndpoint']
        if 'publicEndpoint' in kwargs:
            public_endpoint = kwargs['publicEndpoint']
        if 'vcnHostnameEndpoint' in kwargs:
            vcn_hostname_endpoint = kwargs['vcnHostnameEndpoint']

        _setter("kubernetes", kubernetes)
        _setter("private_endpoint", private_endpoint)
        _setter("public_endpoint", public_endpoint)
        _setter("vcn_hostname_endpoint", vcn_hostname_endpoint)

    @property
    @pulumi.getter
    def kubernetes(self) -> str:
        """
        The non-native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "kubernetes")

    @property
    @pulumi.getter(name="privateEndpoint")
    def private_endpoint(self) -> str:
        """
        The private native networking Kubernetes API server endpoint.
        """
        return pulumi.get(self, "private_endpoint")

    @property
    @pulumi.getter(name="publicEndpoint")
    def public_endpoint(self) -> str:
        """
        The public native networking Kubernetes API server endpoint, if one was requested.
        """
        return pulumi.get(self, "public_endpoint")

    @property
    @pulumi.getter(name="vcnHostnameEndpoint")
    def vcn_hostname_endpoint(self) -> str:
        """
        The FQDN assigned to the Kubernetes API private endpoint. Example: 'https://yourVcnHostnameEndpoint'
        """
        return pulumi.get(self, "vcn_hostname_endpoint")


@pulumi.output_type
class GetClustersClusterEndpointConfigResult(dict):
    def __init__(__self__, *,
                 is_public_ip_enabled: bool,
                 nsg_ids: Sequence[str],
                 subnet_id: str):
        """
        :param bool is_public_ip_enabled: Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        :param Sequence[str] nsg_ids: A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param str subnet_id: The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        GetClustersClusterEndpointConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_public_ip_enabled=is_public_ip_enabled,
            nsg_ids=nsg_ids,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_public_ip_enabled: bool,
             nsg_ids: Sequence[str],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPublicIpEnabled' in kwargs:
            is_public_ip_enabled = kwargs['isPublicIpEnabled']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("is_public_ip_enabled", is_public_ip_enabled)
        _setter("nsg_ids", nsg_ids)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="isPublicIpEnabled")
    def is_public_ip_enabled(self) -> bool:
        """
        Whether the cluster should be assigned a public IP address. Defaults to false. If set to true on a private subnet, the cluster provisioning will fail.
        """
        return pulumi.get(self, "is_public_ip_enabled")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        A list of the OCIDs of the network security groups (NSGs) to apply to the cluster endpoint. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the regional subnet in which to place the Cluster endpoint.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetClustersClusterImagePolicyConfigResult(dict):
    def __init__(__self__, *,
                 is_policy_enabled: bool,
                 key_details: Sequence['outputs.GetClustersClusterImagePolicyConfigKeyDetailResult']):
        """
        :param bool is_policy_enabled: Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        :param Sequence['GetClustersClusterImagePolicyConfigKeyDetailArgs'] key_details: A list of KMS key details.
        """
        GetClustersClusterImagePolicyConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_policy_enabled=is_policy_enabled,
            key_details=key_details,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_policy_enabled: bool,
             key_details: Sequence['outputs.GetClustersClusterImagePolicyConfigKeyDetailResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPolicyEnabled' in kwargs:
            is_policy_enabled = kwargs['isPolicyEnabled']
        if 'keyDetails' in kwargs:
            key_details = kwargs['keyDetails']

        _setter("is_policy_enabled", is_policy_enabled)
        _setter("key_details", key_details)

    @property
    @pulumi.getter(name="isPolicyEnabled")
    def is_policy_enabled(self) -> bool:
        """
        Whether the image verification policy is enabled. Defaults to false. If set to true, the images will be verified against the policy at runtime.
        """
        return pulumi.get(self, "is_policy_enabled")

    @property
    @pulumi.getter(name="keyDetails")
    def key_details(self) -> Sequence['outputs.GetClustersClusterImagePolicyConfigKeyDetailResult']:
        """
        A list of KMS key details.
        """
        return pulumi.get(self, "key_details")


@pulumi.output_type
class GetClustersClusterImagePolicyConfigKeyDetailResult(dict):
    def __init__(__self__, *,
                 kms_key_id: str):
        """
        :param str kms_key_id: The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        GetClustersClusterImagePolicyConfigKeyDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            kms_key_id=kms_key_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             kms_key_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']

        _setter("kms_key_id", kms_key_id)

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the KMS key to be used as the master encryption key for Kubernetes secret encryption.
        """
        return pulumi.get(self, "kms_key_id")


@pulumi.output_type
class GetClustersClusterMetadataResult(dict):
    def __init__(__self__, *,
                 created_by_user_id: str,
                 created_by_work_request_id: str,
                 deleted_by_user_id: str,
                 deleted_by_work_request_id: str,
                 time_created: str,
                 time_credential_expiration: str,
                 time_deleted: str,
                 time_updated: str,
                 updated_by_user_id: str,
                 updated_by_work_request_id: str):
        """
        :param str created_by_user_id: The user who created the cluster.
        :param str created_by_work_request_id: The OCID of the work request which created the cluster.
        :param str deleted_by_user_id: The user who deleted the cluster.
        :param str deleted_by_work_request_id: The OCID of the work request which deleted the cluster.
        :param str time_created: The time the cluster was created.
        :param str time_credential_expiration: The time until which the cluster credential is valid.
        :param str time_deleted: The time the cluster was deleted.
        :param str time_updated: The time the cluster was updated.
        :param str updated_by_user_id: The user who updated the cluster.
        :param str updated_by_work_request_id: The OCID of the work request which updated the cluster.
        """
        GetClustersClusterMetadataResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            created_by_user_id=created_by_user_id,
            created_by_work_request_id=created_by_work_request_id,
            deleted_by_user_id=deleted_by_user_id,
            deleted_by_work_request_id=deleted_by_work_request_id,
            time_created=time_created,
            time_credential_expiration=time_credential_expiration,
            time_deleted=time_deleted,
            time_updated=time_updated,
            updated_by_user_id=updated_by_user_id,
            updated_by_work_request_id=updated_by_work_request_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             created_by_user_id: str,
             created_by_work_request_id: str,
             deleted_by_user_id: str,
             deleted_by_work_request_id: str,
             time_created: str,
             time_credential_expiration: str,
             time_deleted: str,
             time_updated: str,
             updated_by_user_id: str,
             updated_by_work_request_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'createdByUserId' in kwargs:
            created_by_user_id = kwargs['createdByUserId']
        if 'createdByWorkRequestId' in kwargs:
            created_by_work_request_id = kwargs['createdByWorkRequestId']
        if 'deletedByUserId' in kwargs:
            deleted_by_user_id = kwargs['deletedByUserId']
        if 'deletedByWorkRequestId' in kwargs:
            deleted_by_work_request_id = kwargs['deletedByWorkRequestId']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeCredentialExpiration' in kwargs:
            time_credential_expiration = kwargs['timeCredentialExpiration']
        if 'timeDeleted' in kwargs:
            time_deleted = kwargs['timeDeleted']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'updatedByUserId' in kwargs:
            updated_by_user_id = kwargs['updatedByUserId']
        if 'updatedByWorkRequestId' in kwargs:
            updated_by_work_request_id = kwargs['updatedByWorkRequestId']

        _setter("created_by_user_id", created_by_user_id)
        _setter("created_by_work_request_id", created_by_work_request_id)
        _setter("deleted_by_user_id", deleted_by_user_id)
        _setter("deleted_by_work_request_id", deleted_by_work_request_id)
        _setter("time_created", time_created)
        _setter("time_credential_expiration", time_credential_expiration)
        _setter("time_deleted", time_deleted)
        _setter("time_updated", time_updated)
        _setter("updated_by_user_id", updated_by_user_id)
        _setter("updated_by_work_request_id", updated_by_work_request_id)

    @property
    @pulumi.getter(name="createdByUserId")
    def created_by_user_id(self) -> str:
        """
        The user who created the cluster.
        """
        return pulumi.get(self, "created_by_user_id")

    @property
    @pulumi.getter(name="createdByWorkRequestId")
    def created_by_work_request_id(self) -> str:
        """
        The OCID of the work request which created the cluster.
        """
        return pulumi.get(self, "created_by_work_request_id")

    @property
    @pulumi.getter(name="deletedByUserId")
    def deleted_by_user_id(self) -> str:
        """
        The user who deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_user_id")

    @property
    @pulumi.getter(name="deletedByWorkRequestId")
    def deleted_by_work_request_id(self) -> str:
        """
        The OCID of the work request which deleted the cluster.
        """
        return pulumi.get(self, "deleted_by_work_request_id")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the cluster was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeCredentialExpiration")
    def time_credential_expiration(self) -> str:
        """
        The time until which the cluster credential is valid.
        """
        return pulumi.get(self, "time_credential_expiration")

    @property
    @pulumi.getter(name="timeDeleted")
    def time_deleted(self) -> str:
        """
        The time the cluster was deleted.
        """
        return pulumi.get(self, "time_deleted")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the cluster was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="updatedByUserId")
    def updated_by_user_id(self) -> str:
        """
        The user who updated the cluster.
        """
        return pulumi.get(self, "updated_by_user_id")

    @property
    @pulumi.getter(name="updatedByWorkRequestId")
    def updated_by_work_request_id(self) -> str:
        """
        The OCID of the work request which updated the cluster.
        """
        return pulumi.get(self, "updated_by_work_request_id")


@pulumi.output_type
class GetClustersClusterOptionResult(dict):
    def __init__(__self__, *,
                 add_ons: Sequence['outputs.GetClustersClusterOptionAddOnResult'],
                 admission_controller_options: Sequence['outputs.GetClustersClusterOptionAdmissionControllerOptionResult'],
                 kubernetes_network_configs: Sequence['outputs.GetClustersClusterOptionKubernetesNetworkConfigResult'],
                 persistent_volume_configs: Sequence['outputs.GetClustersClusterOptionPersistentVolumeConfigResult'],
                 service_lb_configs: Sequence['outputs.GetClustersClusterOptionServiceLbConfigResult'],
                 service_lb_subnet_ids: Sequence[str]):
        """
        :param Sequence['GetClustersClusterOptionAddOnArgs'] add_ons: Configurable cluster add-ons
        :param Sequence['GetClustersClusterOptionAdmissionControllerOptionArgs'] admission_controller_options: Configurable cluster admission controllers
        :param Sequence['GetClustersClusterOptionKubernetesNetworkConfigArgs'] kubernetes_network_configs: Network configuration for Kubernetes.
        :param Sequence['GetClustersClusterOptionPersistentVolumeConfigArgs'] persistent_volume_configs: Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        :param Sequence['GetClustersClusterOptionServiceLbConfigArgs'] service_lb_configs: Configuration to be applied to load balancers created by Kubernetes services
        :param Sequence[str] service_lb_subnet_ids: The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        GetClustersClusterOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            add_ons=add_ons,
            admission_controller_options=admission_controller_options,
            kubernetes_network_configs=kubernetes_network_configs,
            persistent_volume_configs=persistent_volume_configs,
            service_lb_configs=service_lb_configs,
            service_lb_subnet_ids=service_lb_subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             add_ons: Sequence['outputs.GetClustersClusterOptionAddOnResult'],
             admission_controller_options: Sequence['outputs.GetClustersClusterOptionAdmissionControllerOptionResult'],
             kubernetes_network_configs: Sequence['outputs.GetClustersClusterOptionKubernetesNetworkConfigResult'],
             persistent_volume_configs: Sequence['outputs.GetClustersClusterOptionPersistentVolumeConfigResult'],
             service_lb_configs: Sequence['outputs.GetClustersClusterOptionServiceLbConfigResult'],
             service_lb_subnet_ids: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'addOns' in kwargs:
            add_ons = kwargs['addOns']
        if 'admissionControllerOptions' in kwargs:
            admission_controller_options = kwargs['admissionControllerOptions']
        if 'kubernetesNetworkConfigs' in kwargs:
            kubernetes_network_configs = kwargs['kubernetesNetworkConfigs']
        if 'persistentVolumeConfigs' in kwargs:
            persistent_volume_configs = kwargs['persistentVolumeConfigs']
        if 'serviceLbConfigs' in kwargs:
            service_lb_configs = kwargs['serviceLbConfigs']
        if 'serviceLbSubnetIds' in kwargs:
            service_lb_subnet_ids = kwargs['serviceLbSubnetIds']

        _setter("add_ons", add_ons)
        _setter("admission_controller_options", admission_controller_options)
        _setter("kubernetes_network_configs", kubernetes_network_configs)
        _setter("persistent_volume_configs", persistent_volume_configs)
        _setter("service_lb_configs", service_lb_configs)
        _setter("service_lb_subnet_ids", service_lb_subnet_ids)

    @property
    @pulumi.getter(name="addOns")
    def add_ons(self) -> Sequence['outputs.GetClustersClusterOptionAddOnResult']:
        """
        Configurable cluster add-ons
        """
        return pulumi.get(self, "add_ons")

    @property
    @pulumi.getter(name="admissionControllerOptions")
    def admission_controller_options(self) -> Sequence['outputs.GetClustersClusterOptionAdmissionControllerOptionResult']:
        """
        Configurable cluster admission controllers
        """
        return pulumi.get(self, "admission_controller_options")

    @property
    @pulumi.getter(name="kubernetesNetworkConfigs")
    def kubernetes_network_configs(self) -> Sequence['outputs.GetClustersClusterOptionKubernetesNetworkConfigResult']:
        """
        Network configuration for Kubernetes.
        """
        return pulumi.get(self, "kubernetes_network_configs")

    @property
    @pulumi.getter(name="persistentVolumeConfigs")
    def persistent_volume_configs(self) -> Sequence['outputs.GetClustersClusterOptionPersistentVolumeConfigResult']:
        """
        Configuration to be applied to block volumes created by Kubernetes Persistent Volume Claims (PVC)
        """
        return pulumi.get(self, "persistent_volume_configs")

    @property
    @pulumi.getter(name="serviceLbConfigs")
    def service_lb_configs(self) -> Sequence['outputs.GetClustersClusterOptionServiceLbConfigResult']:
        """
        Configuration to be applied to load balancers created by Kubernetes services
        """
        return pulumi.get(self, "service_lb_configs")

    @property
    @pulumi.getter(name="serviceLbSubnetIds")
    def service_lb_subnet_ids(self) -> Sequence[str]:
        """
        The OCIDs of the subnets used for Kubernetes services load balancers.
        """
        return pulumi.get(self, "service_lb_subnet_ids")


@pulumi.output_type
class GetClustersClusterOptionAddOnResult(dict):
    def __init__(__self__, *,
                 is_kubernetes_dashboard_enabled: bool,
                 is_tiller_enabled: bool):
        """
        :param bool is_kubernetes_dashboard_enabled: Whether or not to enable the Kubernetes Dashboard add-on.
        :param bool is_tiller_enabled: Whether or not to enable the Tiller add-on.
        """
        GetClustersClusterOptionAddOnResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_kubernetes_dashboard_enabled=is_kubernetes_dashboard_enabled,
            is_tiller_enabled=is_tiller_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_kubernetes_dashboard_enabled: bool,
             is_tiller_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isKubernetesDashboardEnabled' in kwargs:
            is_kubernetes_dashboard_enabled = kwargs['isKubernetesDashboardEnabled']
        if 'isTillerEnabled' in kwargs:
            is_tiller_enabled = kwargs['isTillerEnabled']

        _setter("is_kubernetes_dashboard_enabled", is_kubernetes_dashboard_enabled)
        _setter("is_tiller_enabled", is_tiller_enabled)

    @property
    @pulumi.getter(name="isKubernetesDashboardEnabled")
    def is_kubernetes_dashboard_enabled(self) -> bool:
        """
        Whether or not to enable the Kubernetes Dashboard add-on.
        """
        return pulumi.get(self, "is_kubernetes_dashboard_enabled")

    @property
    @pulumi.getter(name="isTillerEnabled")
    def is_tiller_enabled(self) -> bool:
        """
        Whether or not to enable the Tiller add-on.
        """
        return pulumi.get(self, "is_tiller_enabled")


@pulumi.output_type
class GetClustersClusterOptionAdmissionControllerOptionResult(dict):
    def __init__(__self__, *,
                 is_pod_security_policy_enabled: bool):
        """
        :param bool is_pod_security_policy_enabled: Whether or not to enable the Pod Security Policy admission controller.
        """
        GetClustersClusterOptionAdmissionControllerOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_pod_security_policy_enabled=is_pod_security_policy_enabled,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_pod_security_policy_enabled: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPodSecurityPolicyEnabled' in kwargs:
            is_pod_security_policy_enabled = kwargs['isPodSecurityPolicyEnabled']

        _setter("is_pod_security_policy_enabled", is_pod_security_policy_enabled)

    @property
    @pulumi.getter(name="isPodSecurityPolicyEnabled")
    def is_pod_security_policy_enabled(self) -> bool:
        """
        Whether or not to enable the Pod Security Policy admission controller.
        """
        return pulumi.get(self, "is_pod_security_policy_enabled")


@pulumi.output_type
class GetClustersClusterOptionKubernetesNetworkConfigResult(dict):
    def __init__(__self__, *,
                 pods_cidr: str,
                 services_cidr: str):
        """
        :param str pods_cidr: The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        :param str services_cidr: The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        GetClustersClusterOptionKubernetesNetworkConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            pods_cidr=pods_cidr,
            services_cidr=services_cidr,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             pods_cidr: str,
             services_cidr: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'podsCidr' in kwargs:
            pods_cidr = kwargs['podsCidr']
        if 'servicesCidr' in kwargs:
            services_cidr = kwargs['servicesCidr']

        _setter("pods_cidr", pods_cidr)
        _setter("services_cidr", services_cidr)

    @property
    @pulumi.getter(name="podsCidr")
    def pods_cidr(self) -> str:
        """
        The CIDR block for Kubernetes pods. Optional, defaults to 10.244.0.0/16.
        """
        return pulumi.get(self, "pods_cidr")

    @property
    @pulumi.getter(name="servicesCidr")
    def services_cidr(self) -> str:
        """
        The CIDR block for Kubernetes services. Optional, defaults to 10.96.0.0/16.
        """
        return pulumi.get(self, "services_cidr")


@pulumi.output_type
class GetClustersClusterOptionPersistentVolumeConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any]):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        GetClustersClusterOptionPersistentVolumeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClustersClusterOptionServiceLbConfigResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any]):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        GetClustersClusterOptionServiceLbConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetClustersFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        GetClustersFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNodePoolInitialNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetNodePoolInitialNodeLabelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 defined_tags: Mapping[str, Any],
                 errors: Sequence['outputs.GetNodePoolNodeErrorResult'],
                 fault_domain: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 kubernetes_version: str,
                 lifecycle_details: str,
                 name: str,
                 node_pool_id: str,
                 private_ip: str,
                 public_ip: str,
                 state: str,
                 subnet_id: str):
        """
        :param str availability_domain: The name of the availability domain in which this node is placed.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Sequence['GetNodePoolNodeErrorArgs'] errors: An error that may be associated with the node.
        :param str fault_domain: The fault domain of this node.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the compute instance backing this node.
        :param str kubernetes_version: The version of Kubernetes this node is running.
        :param str lifecycle_details: Details about the state of the node.
        :param str name: The name of the node.
        :param str node_pool_id: The OCID of the node pool.
        :param str private_ip: The private IP address of this node.
        :param str public_ip: The public IP address of this node.
        :param str state: The state of the nodepool.
        :param str subnet_id: The OCID of the subnet in which this node is placed.
        """
        GetNodePoolNodeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            defined_tags=defined_tags,
            errors=errors,
            fault_domain=fault_domain,
            freeform_tags=freeform_tags,
            id=id,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            name=name,
            node_pool_id=node_pool_id,
            private_ip=private_ip,
            public_ip=public_ip,
            state=state,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             defined_tags: Mapping[str, Any],
             errors: Sequence['outputs.GetNodePoolNodeErrorResult'],
             fault_domain: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             kubernetes_version: str,
             lifecycle_details: str,
             name: str,
             node_pool_id: str,
             private_ip: str,
             public_ip: str,
             state: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'faultDomain' in kwargs:
            fault_domain = kwargs['faultDomain']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nodePoolId' in kwargs:
            node_pool_id = kwargs['nodePoolId']
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']
        if 'publicIp' in kwargs:
            public_ip = kwargs['publicIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("defined_tags", defined_tags)
        _setter("errors", errors)
        _setter("fault_domain", fault_domain)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("kubernetes_version", kubernetes_version)
        _setter("lifecycle_details", lifecycle_details)
        _setter("name", name)
        _setter("node_pool_id", node_pool_id)
        _setter("private_ip", private_ip)
        _setter("public_ip", public_ip)
        _setter("state", state)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain in which this node is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GetNodePoolNodeErrorResult']:
        """
        An error that may be associated with the node.
        """
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> str:
        """
        The fault domain of this node.
        """
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the compute instance backing this node.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        """
        The version of Kubernetes this node is running.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the state of the node.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the node.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        """
        The private IP address of this node.
        """
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        """
        The public IP address of this node.
        """
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the nodepool.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet in which this node is placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolNodeConfigDetailResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 is_pv_encryption_in_transit_enabled: bool,
                 kms_key_id: str,
                 node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
                 nsg_ids: Sequence[str],
                 placement_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigResult'],
                 size: int):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param bool is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param str kms_key_id: The OCID of the Key Management Service key assigned to the boot volume.
        :param Sequence['GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailArgs'] node_pool_pod_network_option_details: The CNI related configuration of pods in the node pool.
        :param Sequence[str] nsg_ids: The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigArgs'] placement_configs: The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        :param int size: The number of nodes in the node pool.
        """
        GetNodePoolNodeConfigDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_pv_encryption_in_transit_enabled=is_pv_encryption_in_transit_enabled,
            kms_key_id=kms_key_id,
            node_pool_pod_network_option_details=node_pool_pod_network_option_details,
            nsg_ids=nsg_ids,
            placement_configs=placement_configs,
            size=size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             is_pv_encryption_in_transit_enabled: bool,
             kms_key_id: str,
             node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
             nsg_ids: Sequence[str],
             placement_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigResult'],
             size: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPvEncryptionInTransitEnabled' in kwargs:
            is_pv_encryption_in_transit_enabled = kwargs['isPvEncryptionInTransitEnabled']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'nodePoolPodNetworkOptionDetails' in kwargs:
            node_pool_pod_network_option_details = kwargs['nodePoolPodNetworkOptionDetails']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'placementConfigs' in kwargs:
            placement_configs = kwargs['placementConfigs']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        _setter("kms_key_id", kms_key_id)
        _setter("node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        _setter("nsg_ids", nsg_ids)
        _setter("placement_configs", placement_configs)
        _setter("size", size)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> bool:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult']:
        """
        The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigResult']:
        """
        The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The number of nodes in the node pool.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult(dict):
    def __init__(__self__, *,
                 cni_type: str,
                 max_pods_per_node: int,
                 pod_nsg_ids: Sequence[str],
                 pod_subnet_ids: Sequence[str]):
        """
        :param str cni_type: The CNI plugin used by this node pool
        :param int max_pods_per_node: The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[str] pod_nsg_ids: The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[str] pod_subnet_ids: The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        GetNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
            max_pods_per_node=max_pods_per_node,
            pod_nsg_ids=pod_nsg_ids,
            pod_subnet_ids=pod_subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             max_pods_per_node: int,
             pod_nsg_ids: Sequence[str],
             pod_subnet_ids: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']
        if 'maxPodsPerNode' in kwargs:
            max_pods_per_node = kwargs['maxPodsPerNode']
        if 'podNsgIds' in kwargs:
            pod_nsg_ids = kwargs['podNsgIds']
        if 'podSubnetIds' in kwargs:
            pod_subnet_ids = kwargs['podSubnetIds']

        _setter("cni_type", cni_type)
        _setter("max_pods_per_node", max_pods_per_node)
        _setter("pod_nsg_ids", pod_nsg_ids)
        _setter("pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> int:
        """
        The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Sequence[str]:
        """
        The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 capacity_reservation_id: str,
                 fault_domains: Sequence[str],
                 preemptible_node_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
                 subnet_id: str):
        """
        :param str availability_domain: The name of the availability domain in which this node is placed.
        :param str capacity_reservation_id: The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[str] fault_domains: A list of fault domains in which to place nodes.
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigArgs'] preemptible_node_configs: Configuration options for preemptible nodes.
        :param str subnet_id: The OCID of the subnet in which this node is placed.
        """
        GetNodePoolNodeConfigDetailPlacementConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            capacity_reservation_id=capacity_reservation_id,
            fault_domains=fault_domains,
            preemptible_node_configs=preemptible_node_configs,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             capacity_reservation_id: str,
             fault_domains: Sequence[str],
             preemptible_node_configs: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'capacityReservationId' in kwargs:
            capacity_reservation_id = kwargs['capacityReservationId']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'preemptibleNodeConfigs' in kwargs:
            preemptible_node_configs = kwargs['preemptibleNodeConfigs']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("capacity_reservation_id", capacity_reservation_id)
        _setter("fault_domains", fault_domains)
        _setter("preemptible_node_configs", preemptible_node_configs)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The name of the availability domain in which this node is placed.
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        """
        A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfigs")
    def preemptible_node_configs(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult']:
        """
        Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_configs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet in which this node is placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult(dict):
    def __init__(__self__, *,
                 preemption_actions: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']):
        """
        :param Sequence['GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionArgs'] preemption_actions: The action to run when the preemptible node is interrupted for eviction.
        """
        GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            preemption_actions=preemption_actions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             preemption_actions: Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'preemptionActions' in kwargs:
            preemption_actions = kwargs['preemptionActions']

        _setter("preemption_actions", preemption_actions)

    @property
    @pulumi.getter(name="preemptionActions")
    def preemption_actions(self) -> Sequence['outputs.GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']:
        """
        The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_actions")


@pulumi.output_type
class GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult(dict):
    def __init__(__self__, *,
                 is_preserve_boot_volume: bool,
                 type: str):
        """
        :param bool is_preserve_boot_volume: Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param str type: The type of action to run when the instance is interrupted for eviction.
        """
        GetNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_preserve_boot_volume=is_preserve_boot_volume,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_preserve_boot_volume: bool,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPreserveBootVolume' in kwargs:
            is_preserve_boot_volume = kwargs['isPreserveBootVolume']

        _setter("is_preserve_boot_volume", is_preserve_boot_volume)
        _setter("type", type)

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> bool:
        """
        Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolNodeErrorResult(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 status: str):
        """
        :param str code: A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string of the upstream error.
        :param str status: The status of the HTTP response encountered in the upstream error.
        """
        GetNodePoolNodeErrorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             message: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("code", code)
        _setter("message", message)
        _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A short error code that defines the upstream error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable error string of the upstream error.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        The status of the HTTP response encountered in the upstream error.
        """
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNodePoolNodeEvictionNodePoolSettingResult(dict):
    def __init__(__self__, *,
                 eviction_grace_duration: str,
                 is_force_delete_after_grace_duration: bool):
        """
        :param str eviction_grace_duration: Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param bool is_force_delete_after_grace_duration: If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        GetNodePoolNodeEvictionNodePoolSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            eviction_grace_duration=eviction_grace_duration,
            is_force_delete_after_grace_duration=is_force_delete_after_grace_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             eviction_grace_duration: str,
             is_force_delete_after_grace_duration: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'evictionGraceDuration' in kwargs:
            eviction_grace_duration = kwargs['evictionGraceDuration']
        if 'isForceDeleteAfterGraceDuration' in kwargs:
            is_force_delete_after_grace_duration = kwargs['isForceDeleteAfterGraceDuration']

        _setter("eviction_grace_duration", eviction_grace_duration)
        _setter("is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> str:
        """
        Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> bool:
        """
        If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class GetNodePoolNodePoolCyclingDetailResult(dict):
    def __init__(__self__, *,
                 is_node_cycling_enabled: bool,
                 maximum_surge: str,
                 maximum_unavailable: str):
        """
        :param bool is_node_cycling_enabled: If nodes in the nodepool will be cycled to have new changes.
        :param str maximum_surge: Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param str maximum_unavailable: Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        GetNodePoolNodePoolCyclingDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_node_cycling_enabled=is_node_cycling_enabled,
            maximum_surge=maximum_surge,
            maximum_unavailable=maximum_unavailable,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_node_cycling_enabled: bool,
             maximum_surge: str,
             maximum_unavailable: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isNodeCyclingEnabled' in kwargs:
            is_node_cycling_enabled = kwargs['isNodeCyclingEnabled']
        if 'maximumSurge' in kwargs:
            maximum_surge = kwargs['maximumSurge']
        if 'maximumUnavailable' in kwargs:
            maximum_unavailable = kwargs['maximumUnavailable']

        _setter("is_node_cycling_enabled", is_node_cycling_enabled)
        _setter("maximum_surge", maximum_surge)
        _setter("maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> bool:
        """
        If nodes in the nodepool will be cycled to have new changes.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> str:
        """
        Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> str:
        """
        Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class GetNodePoolNodeShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The total amount of memory available to each node, in gigabytes.
        :param float ocpus: The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetNodePoolNodeShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetNodePoolNodeSourceResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 source_name: str,
                 source_type: str):
        """
        :param str image_id: The OCID of the image used to boot the node.
        :param str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        GetNodePoolNodeSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_id=image_id,
            source_name=source_name,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_id: str,
             source_name: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceName' in kwargs:
            source_name = kwargs['sourceName']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("image_id", image_id)
        _setter("source_name", source_name)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolNodeSourceDetailResult(dict):
    def __init__(__self__, *,
                 boot_volume_size_in_gbs: str,
                 image_id: str,
                 source_type: str):
        """
        :param str boot_volume_size_in_gbs: The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        :param str image_id: The OCID of the image used to boot the node.
        :param str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        GetNodePoolNodeSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            boot_volume_size_in_gbs=boot_volume_size_in_gbs,
            image_id=image_id,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             boot_volume_size_in_gbs: str,
             image_id: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bootVolumeSizeInGbs' in kwargs:
            boot_volume_size_in_gbs = kwargs['bootVolumeSizeInGbs']
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("boot_volume_size_in_gbs", boot_volume_size_in_gbs)
        _setter("image_id", image_id)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> str:
        """
        The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolOptionSourceResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 source_name: str,
                 source_type: str):
        """
        :param str image_id: The OCID of the image.
        :param str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param str source_type: The source type of this option. `IMAGE` means the OCID is of an image.
        """
        GetNodePoolOptionSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_id=image_id,
            source_name=source_name,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_id: str,
             source_name: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceName' in kwargs:
            source_name = kwargs['sourceName']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("image_id", image_id)
        _setter("source_name", source_name)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the image.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source type of this option. `IMAGE` means the OCID is of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        GetNodePoolsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetNodePoolsNodePoolResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 initial_node_labels: Sequence['outputs.GetNodePoolsNodePoolInitialNodeLabelResult'],
                 kubernetes_version: str,
                 lifecycle_details: str,
                 name: str,
                 node_config_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailResult'],
                 node_eviction_node_pool_settings: Sequence['outputs.GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult'],
                 node_image_id: str,
                 node_image_name: str,
                 node_metadata: Mapping[str, Any],
                 node_pool_cycling_details: Sequence['outputs.GetNodePoolsNodePoolNodePoolCyclingDetailResult'],
                 node_pool_id: str,
                 node_shape: str,
                 node_shape_configs: Sequence['outputs.GetNodePoolsNodePoolNodeShapeConfigResult'],
                 node_source_details: Sequence['outputs.GetNodePoolsNodePoolNodeSourceDetailResult'],
                 node_sources: Sequence['outputs.GetNodePoolsNodePoolNodeSourceResult'],
                 nodes: Sequence['outputs.GetNodePoolsNodePoolNodeResult'],
                 quantity_per_subnet: int,
                 ssh_public_key: str,
                 state: str,
                 subnet_ids: Sequence[str]):
        """
        :param str cluster_id: The OCID of the cluster.
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the node pool.
        :param Sequence['GetNodePoolsNodePoolInitialNodeLabelArgs'] initial_node_labels: A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        :param str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param str lifecycle_details: Details about the state of the nodepool.
        :param str name: The name to filter on.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailArgs'] node_config_details: The configuration of nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeEvictionNodePoolSettingArgs'] node_eviction_node_pool_settings: Node Eviction Details configuration
        :param str node_image_id: Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        :param str node_image_name: Deprecated. see `nodeSource`. The name of the image running on the nodes in the node pool.
        :param Mapping[str, Any] node_metadata: A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        :param Sequence['GetNodePoolsNodePoolNodePoolCyclingDetailArgs'] node_pool_cycling_details: Node Pool Cycling Details
        :param str node_shape: The name of the node shape of the nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeShapeConfigArgs'] node_shape_configs: The shape configuration of the nodes.
        :param Sequence['GetNodePoolsNodePoolNodeSourceDetailArgs'] node_source_details: Source running on the nodes in the node pool.
        :param Sequence['GetNodePoolsNodePoolNodeSourceArgs'] node_sources: Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        :param int quantity_per_subnet: The number of nodes in each subnet.
        :param str ssh_public_key: The SSH public key on each node in the node pool on launch.
        :param str state: A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        :param Sequence[str] subnet_ids: The OCIDs of the subnets in which to place nodes for this node pool.
        """
        GetNodePoolsNodePoolResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cluster_id=cluster_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            id=id,
            initial_node_labels=initial_node_labels,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            name=name,
            node_config_details=node_config_details,
            node_eviction_node_pool_settings=node_eviction_node_pool_settings,
            node_image_id=node_image_id,
            node_image_name=node_image_name,
            node_metadata=node_metadata,
            node_pool_cycling_details=node_pool_cycling_details,
            node_pool_id=node_pool_id,
            node_shape=node_shape,
            node_shape_configs=node_shape_configs,
            node_source_details=node_source_details,
            node_sources=node_sources,
            nodes=nodes,
            quantity_per_subnet=quantity_per_subnet,
            ssh_public_key=ssh_public_key,
            state=state,
            subnet_ids=subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cluster_id: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             id: str,
             initial_node_labels: Sequence['outputs.GetNodePoolsNodePoolInitialNodeLabelResult'],
             kubernetes_version: str,
             lifecycle_details: str,
             name: str,
             node_config_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailResult'],
             node_eviction_node_pool_settings: Sequence['outputs.GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult'],
             node_image_id: str,
             node_image_name: str,
             node_metadata: Mapping[str, Any],
             node_pool_cycling_details: Sequence['outputs.GetNodePoolsNodePoolNodePoolCyclingDetailResult'],
             node_pool_id: str,
             node_shape: str,
             node_shape_configs: Sequence['outputs.GetNodePoolsNodePoolNodeShapeConfigResult'],
             node_source_details: Sequence['outputs.GetNodePoolsNodePoolNodeSourceDetailResult'],
             node_sources: Sequence['outputs.GetNodePoolsNodePoolNodeSourceResult'],
             nodes: Sequence['outputs.GetNodePoolsNodePoolNodeResult'],
             quantity_per_subnet: int,
             ssh_public_key: str,
             state: str,
             subnet_ids: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clusterId' in kwargs:
            cluster_id = kwargs['clusterId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'initialNodeLabels' in kwargs:
            initial_node_labels = kwargs['initialNodeLabels']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nodeConfigDetails' in kwargs:
            node_config_details = kwargs['nodeConfigDetails']
        if 'nodeEvictionNodePoolSettings' in kwargs:
            node_eviction_node_pool_settings = kwargs['nodeEvictionNodePoolSettings']
        if 'nodeImageId' in kwargs:
            node_image_id = kwargs['nodeImageId']
        if 'nodeImageName' in kwargs:
            node_image_name = kwargs['nodeImageName']
        if 'nodeMetadata' in kwargs:
            node_metadata = kwargs['nodeMetadata']
        if 'nodePoolCyclingDetails' in kwargs:
            node_pool_cycling_details = kwargs['nodePoolCyclingDetails']
        if 'nodePoolId' in kwargs:
            node_pool_id = kwargs['nodePoolId']
        if 'nodeShape' in kwargs:
            node_shape = kwargs['nodeShape']
        if 'nodeShapeConfigs' in kwargs:
            node_shape_configs = kwargs['nodeShapeConfigs']
        if 'nodeSourceDetails' in kwargs:
            node_source_details = kwargs['nodeSourceDetails']
        if 'nodeSources' in kwargs:
            node_sources = kwargs['nodeSources']
        if 'quantityPerSubnet' in kwargs:
            quantity_per_subnet = kwargs['quantityPerSubnet']
        if 'sshPublicKey' in kwargs:
            ssh_public_key = kwargs['sshPublicKey']
        if 'subnetIds' in kwargs:
            subnet_ids = kwargs['subnetIds']

        _setter("cluster_id", cluster_id)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("initial_node_labels", initial_node_labels)
        _setter("kubernetes_version", kubernetes_version)
        _setter("lifecycle_details", lifecycle_details)
        _setter("name", name)
        _setter("node_config_details", node_config_details)
        _setter("node_eviction_node_pool_settings", node_eviction_node_pool_settings)
        _setter("node_image_id", node_image_id)
        _setter("node_image_name", node_image_name)
        _setter("node_metadata", node_metadata)
        _setter("node_pool_cycling_details", node_pool_cycling_details)
        _setter("node_pool_id", node_pool_id)
        _setter("node_shape", node_shape)
        _setter("node_shape_configs", node_shape_configs)
        _setter("node_source_details", node_source_details)
        _setter("node_sources", node_sources)
        _setter("nodes", nodes)
        _setter("quantity_per_subnet", quantity_per_subnet)
        _setter("ssh_public_key", ssh_public_key)
        _setter("state", state)
        _setter("subnet_ids", subnet_ids)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialNodeLabels")
    def initial_node_labels(self) -> Sequence['outputs.GetNodePoolsNodePoolInitialNodeLabelResult']:
        """
        A list of key/value pairs to add to nodes after they join the Kubernetes cluster.
        """
        return pulumi.get(self, "initial_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the state of the nodepool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodeConfigDetails")
    def node_config_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailResult']:
        """
        The configuration of nodes in the node pool.
        """
        return pulumi.get(self, "node_config_details")

    @property
    @pulumi.getter(name="nodeEvictionNodePoolSettings")
    def node_eviction_node_pool_settings(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult']:
        """
        Node Eviction Details configuration
        """
        return pulumi.get(self, "node_eviction_node_pool_settings")

    @property
    @pulumi.getter(name="nodeImageId")
    def node_image_id(self) -> str:
        """
        Deprecated. see `nodeSource`. The OCID of the image running on the nodes in the node pool.
        """
        warnings.warn("""The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
        pulumi.log.warn("""node_image_id is deprecated: The 'node_image_id' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")

        return pulumi.get(self, "node_image_id")

    @property
    @pulumi.getter(name="nodeImageName")
    def node_image_name(self) -> str:
        """
        Deprecated. see `nodeSource`. The name of the image running on the nodes in the node pool.
        """
        warnings.warn("""The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""", DeprecationWarning)
        pulumi.log.warn("""node_image_name is deprecated: The 'node_image_name' field has been deprecated. Please use 'node_source_details' instead. If both fields are specified, then 'node_source_details' will be used.""")

        return pulumi.get(self, "node_image_name")

    @property
    @pulumi.getter(name="nodeMetadata")
    def node_metadata(self) -> Mapping[str, Any]:
        """
        A list of key/value pairs to add to each underlying Oracle Cloud Infrastructure instance in the node pool on launch.
        """
        return pulumi.get(self, "node_metadata")

    @property
    @pulumi.getter(name="nodePoolCyclingDetails")
    def node_pool_cycling_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodePoolCyclingDetailResult']:
        """
        Node Pool Cycling Details
        """
        return pulumi.get(self, "node_pool_cycling_details")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> str:
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="nodeShape")
    def node_shape(self) -> str:
        """
        The name of the node shape of the nodes in the node pool.
        """
        return pulumi.get(self, "node_shape")

    @property
    @pulumi.getter(name="nodeShapeConfigs")
    def node_shape_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeShapeConfigResult']:
        """
        The shape configuration of the nodes.
        """
        return pulumi.get(self, "node_shape_configs")

    @property
    @pulumi.getter(name="nodeSourceDetails")
    def node_source_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeSourceDetailResult']:
        """
        Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_source_details")

    @property
    @pulumi.getter(name="nodeSources")
    def node_sources(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeSourceResult']:
        """
        Deprecated. see `nodeSourceDetails`. Source running on the nodes in the node pool.
        """
        return pulumi.get(self, "node_sources")

    @property
    @pulumi.getter
    def nodes(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeResult']:
        return pulumi.get(self, "nodes")

    @property
    @pulumi.getter(name="quantityPerSubnet")
    def quantity_per_subnet(self) -> int:
        """
        The number of nodes in each subnet.
        """
        return pulumi.get(self, "quantity_per_subnet")

    @property
    @pulumi.getter(name="sshPublicKey")
    def ssh_public_key(self) -> str:
        """
        The SSH public key on each node in the node pool on launch.
        """
        return pulumi.get(self, "ssh_public_key")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetIds")
    def subnet_ids(self) -> Sequence[str]:
        """
        The OCIDs of the subnets in which to place nodes for this node pool.
        """
        return pulumi.get(self, "subnet_ids")


@pulumi.output_type
class GetNodePoolsNodePoolInitialNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetNodePoolsNodePoolInitialNodeLabelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetNodePoolsNodePoolNodeResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 defined_tags: Mapping[str, Any],
                 errors: Sequence['outputs.GetNodePoolsNodePoolNodeErrorResult'],
                 fault_domain: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 kubernetes_version: str,
                 lifecycle_details: str,
                 name: str,
                 node_pool_id: str,
                 private_ip: str,
                 public_ip: str,
                 state: str,
                 subnet_id: str):
        """
        :param str availability_domain: The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the node pool.
        :param str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param str lifecycle_details: Details about the state of the nodepool.
        :param str name: The name to filter on.
        :param str state: A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        :param str subnet_id: The OCID of the subnet in which to place nodes.
        """
        GetNodePoolsNodePoolNodeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            defined_tags=defined_tags,
            errors=errors,
            fault_domain=fault_domain,
            freeform_tags=freeform_tags,
            id=id,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            name=name,
            node_pool_id=node_pool_id,
            private_ip=private_ip,
            public_ip=public_ip,
            state=state,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             defined_tags: Mapping[str, Any],
             errors: Sequence['outputs.GetNodePoolsNodePoolNodeErrorResult'],
             fault_domain: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             kubernetes_version: str,
             lifecycle_details: str,
             name: str,
             node_pool_id: str,
             private_ip: str,
             public_ip: str,
             state: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'faultDomain' in kwargs:
            fault_domain = kwargs['faultDomain']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nodePoolId' in kwargs:
            node_pool_id = kwargs['nodePoolId']
        if 'privateIp' in kwargs:
            private_ip = kwargs['privateIp']
        if 'publicIp' in kwargs:
            public_ip = kwargs['publicIp']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("defined_tags", defined_tags)
        _setter("errors", errors)
        _setter("fault_domain", fault_domain)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("kubernetes_version", kubernetes_version)
        _setter("lifecycle_details", lifecycle_details)
        _setter("name", name)
        _setter("node_pool_id", node_pool_id)
        _setter("private_ip", private_ip)
        _setter("public_ip", public_ip)
        _setter("state", state)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter
    def errors(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeErrorResult']:
        return pulumi.get(self, "errors")

    @property
    @pulumi.getter(name="faultDomain")
    def fault_domain(self) -> str:
        return pulumi.get(self, "fault_domain")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the state of the nodepool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="nodePoolId")
    def node_pool_id(self) -> str:
        return pulumi.get(self, "node_pool_id")

    @property
    @pulumi.getter(name="privateIp")
    def private_ip(self) -> str:
        return pulumi.get(self, "private_ip")

    @property
    @pulumi.getter(name="publicIp")
    def public_ip(self) -> str:
        return pulumi.get(self, "public_ip")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A list of nodepool lifecycle states on which to filter on, matching any of the list items (OR logic). eg. [ACTIVE, DELETING]
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any],
                 is_pv_encryption_in_transit_enabled: bool,
                 kms_key_id: str,
                 node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
                 nsg_ids: Sequence[str],
                 placement_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult'],
                 size: int):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param bool is_pv_encryption_in_transit_enabled: Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        :param str kms_key_id: The OCID of the Key Management Service key assigned to the boot volume.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailArgs'] node_pool_pod_network_option_details: The CNI related configuration of pods in the node pool.
        :param Sequence[str] nsg_ids: The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigArgs'] placement_configs: The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        :param int size: The number of nodes in the node pool.
        """
        GetNodePoolsNodePoolNodeConfigDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
            is_pv_encryption_in_transit_enabled=is_pv_encryption_in_transit_enabled,
            kms_key_id=kms_key_id,
            node_pool_pod_network_option_details=node_pool_pod_network_option_details,
            nsg_ids=nsg_ids,
            placement_configs=placement_configs,
            size=size,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             is_pv_encryption_in_transit_enabled: bool,
             kms_key_id: str,
             node_pool_pod_network_option_details: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult'],
             nsg_ids: Sequence[str],
             placement_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult'],
             size: int,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'isPvEncryptionInTransitEnabled' in kwargs:
            is_pv_encryption_in_transit_enabled = kwargs['isPvEncryptionInTransitEnabled']
        if 'kmsKeyId' in kwargs:
            kms_key_id = kwargs['kmsKeyId']
        if 'nodePoolPodNetworkOptionDetails' in kwargs:
            node_pool_pod_network_option_details = kwargs['nodePoolPodNetworkOptionDetails']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'placementConfigs' in kwargs:
            placement_configs = kwargs['placementConfigs']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)
        _setter("is_pv_encryption_in_transit_enabled", is_pv_encryption_in_transit_enabled)
        _setter("kms_key_id", kms_key_id)
        _setter("node_pool_pod_network_option_details", node_pool_pod_network_option_details)
        _setter("nsg_ids", nsg_ids)
        _setter("placement_configs", placement_configs)
        _setter("size", size)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter(name="isPvEncryptionInTransitEnabled")
    def is_pv_encryption_in_transit_enabled(self) -> bool:
        """
        Whether to enable in-transit encryption for the data volume's paravirtualized attachment. This field applies to both block volumes and boot volumes. The default value is false.
        """
        return pulumi.get(self, "is_pv_encryption_in_transit_enabled")

    @property
    @pulumi.getter(name="kmsKeyId")
    def kms_key_id(self) -> str:
        """
        The OCID of the Key Management Service key assigned to the boot volume.
        """
        return pulumi.get(self, "kms_key_id")

    @property
    @pulumi.getter(name="nodePoolPodNetworkOptionDetails")
    def node_pool_pod_network_option_details(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult']:
        """
        The CNI related configuration of pods in the node pool.
        """
        return pulumi.get(self, "node_pool_pod_network_option_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the Network Security Group(s) to associate nodes for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigs")
    def placement_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult']:
        """
        The placement configurations for the node pool. Provide one placement configuration for each availability domain in which you intend to launch a node.
        """
        return pulumi.get(self, "placement_configs")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The number of nodes in the node pool.
        """
        return pulumi.get(self, "size")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult(dict):
    def __init__(__self__, *,
                 cni_type: str,
                 max_pods_per_node: int,
                 pod_nsg_ids: Sequence[str],
                 pod_subnet_ids: Sequence[str]):
        """
        :param str cni_type: The CNI plugin used by this node pool
        :param int max_pods_per_node: The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        :param Sequence[str] pod_nsg_ids: The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        :param Sequence[str] pod_subnet_ids: The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        GetNodePoolsNodePoolNodeConfigDetailNodePoolPodNetworkOptionDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cni_type=cni_type,
            max_pods_per_node=max_pods_per_node,
            pod_nsg_ids=pod_nsg_ids,
            pod_subnet_ids=pod_subnet_ids,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cni_type: str,
             max_pods_per_node: int,
             pod_nsg_ids: Sequence[str],
             pod_subnet_ids: Sequence[str],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'cniType' in kwargs:
            cni_type = kwargs['cniType']
        if 'maxPodsPerNode' in kwargs:
            max_pods_per_node = kwargs['maxPodsPerNode']
        if 'podNsgIds' in kwargs:
            pod_nsg_ids = kwargs['podNsgIds']
        if 'podSubnetIds' in kwargs:
            pod_subnet_ids = kwargs['podSubnetIds']

        _setter("cni_type", cni_type)
        _setter("max_pods_per_node", max_pods_per_node)
        _setter("pod_nsg_ids", pod_nsg_ids)
        _setter("pod_subnet_ids", pod_subnet_ids)

    @property
    @pulumi.getter(name="cniType")
    def cni_type(self) -> str:
        """
        The CNI plugin used by this node pool
        """
        return pulumi.get(self, "cni_type")

    @property
    @pulumi.getter(name="maxPodsPerNode")
    def max_pods_per_node(self) -> int:
        """
        The max number of pods per node in the node pool. This value will be limited by the number of VNICs attachable to the node pool shape
        """
        return pulumi.get(self, "max_pods_per_node")

    @property
    @pulumi.getter(name="podNsgIds")
    def pod_nsg_ids(self) -> Sequence[str]:
        """
        The OCIDs of the Network Security Group(s) to associate pods for this node pool with. For more information about NSGs, see [NetworkSecurityGroup](https://docs.cloud.oracle.com/iaas/api/#/en/iaas/20160918/NetworkSecurityGroup/).
        """
        return pulumi.get(self, "pod_nsg_ids")

    @property
    @pulumi.getter(name="podSubnetIds")
    def pod_subnet_ids(self) -> Sequence[str]:
        """
        The OCIDs of the subnets in which to place pods for this node pool. This can be one of the node pool subnet IDs
        """
        return pulumi.get(self, "pod_subnet_ids")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 capacity_reservation_id: str,
                 fault_domains: Sequence[str],
                 preemptible_node_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
                 subnet_id: str):
        """
        :param str availability_domain: The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        :param str capacity_reservation_id: The OCID of the compute capacity reservation in which to place the compute instance.
        :param Sequence[str] fault_domains: A list of fault domains in which to place nodes.
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigArgs'] preemptible_node_configs: Configuration options for preemptible nodes.
        :param str subnet_id: The OCID of the subnet in which to place nodes.
        """
        GetNodePoolsNodePoolNodeConfigDetailPlacementConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            capacity_reservation_id=capacity_reservation_id,
            fault_domains=fault_domains,
            preemptible_node_configs=preemptible_node_configs,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             capacity_reservation_id: str,
             fault_domains: Sequence[str],
             preemptible_node_configs: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult'],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'capacityReservationId' in kwargs:
            capacity_reservation_id = kwargs['capacityReservationId']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'preemptibleNodeConfigs' in kwargs:
            preemptible_node_configs = kwargs['preemptibleNodeConfigs']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("capacity_reservation_id", capacity_reservation_id)
        _setter("fault_domains", fault_domains)
        _setter("preemptible_node_configs", preemptible_node_configs)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain in which to place nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="capacityReservationId")
    def capacity_reservation_id(self) -> str:
        """
        The OCID of the compute capacity reservation in which to place the compute instance.
        """
        return pulumi.get(self, "capacity_reservation_id")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        """
        A list of fault domains in which to place nodes.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="preemptibleNodeConfigs")
    def preemptible_node_configs(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult']:
        """
        Configuration options for preemptible nodes.
        """
        return pulumi.get(self, "preemptible_node_configs")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The OCID of the subnet in which to place nodes.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult(dict):
    def __init__(__self__, *,
                 preemption_actions: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']):
        """
        :param Sequence['GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionArgs'] preemption_actions: The action to run when the preemptible node is interrupted for eviction.
        """
        GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            preemption_actions=preemption_actions,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             preemption_actions: Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'preemptionActions' in kwargs:
            preemption_actions = kwargs['preemptionActions']

        _setter("preemption_actions", preemption_actions)

    @property
    @pulumi.getter(name="preemptionActions")
    def preemption_actions(self) -> Sequence['outputs.GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult']:
        """
        The action to run when the preemptible node is interrupted for eviction.
        """
        return pulumi.get(self, "preemption_actions")


@pulumi.output_type
class GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult(dict):
    def __init__(__self__, *,
                 is_preserve_boot_volume: bool,
                 type: str):
        """
        :param bool is_preserve_boot_volume: Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        :param str type: The type of action to run when the instance is interrupted for eviction.
        """
        GetNodePoolsNodePoolNodeConfigDetailPlacementConfigPreemptibleNodeConfigPreemptionActionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_preserve_boot_volume=is_preserve_boot_volume,
            type=type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_preserve_boot_volume: bool,
             type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isPreserveBootVolume' in kwargs:
            is_preserve_boot_volume = kwargs['isPreserveBootVolume']

        _setter("is_preserve_boot_volume", is_preserve_boot_volume)
        _setter("type", type)

    @property
    @pulumi.getter(name="isPreserveBootVolume")
    def is_preserve_boot_volume(self) -> bool:
        """
        Whether to preserve the boot volume that was used to launch the preemptible instance when the instance is terminated. Defaults to false if not specified.
        """
        return pulumi.get(self, "is_preserve_boot_volume")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of action to run when the instance is interrupted for eviction.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class GetNodePoolsNodePoolNodeErrorResult(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 status: str):
        GetNodePoolsNodePoolNodeErrorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            status=status,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             message: str,
             status: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("code", code)
        _setter("message", message)
        _setter("status", status)

    @property
    @pulumi.getter
    def code(self) -> str:
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def status(self) -> str:
        return pulumi.get(self, "status")


@pulumi.output_type
class GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult(dict):
    def __init__(__self__, *,
                 eviction_grace_duration: str,
                 is_force_delete_after_grace_duration: bool):
        """
        :param str eviction_grace_duration: Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        :param bool is_force_delete_after_grace_duration: If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        GetNodePoolsNodePoolNodeEvictionNodePoolSettingResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            eviction_grace_duration=eviction_grace_duration,
            is_force_delete_after_grace_duration=is_force_delete_after_grace_duration,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             eviction_grace_duration: str,
             is_force_delete_after_grace_duration: bool,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'evictionGraceDuration' in kwargs:
            eviction_grace_duration = kwargs['evictionGraceDuration']
        if 'isForceDeleteAfterGraceDuration' in kwargs:
            is_force_delete_after_grace_duration = kwargs['isForceDeleteAfterGraceDuration']

        _setter("eviction_grace_duration", eviction_grace_duration)
        _setter("is_force_delete_after_grace_duration", is_force_delete_after_grace_duration)

    @property
    @pulumi.getter(name="evictionGraceDuration")
    def eviction_grace_duration(self) -> str:
        """
        Duration after which OKE will give up eviction of the pods on the node. PT0M will indicate you want to delete the node without cordon and drain. Default PT60M, Min PT0M, Max: PT60M. Format ISO 8601 e.g PT30M
        """
        return pulumi.get(self, "eviction_grace_duration")

    @property
    @pulumi.getter(name="isForceDeleteAfterGraceDuration")
    def is_force_delete_after_grace_duration(self) -> bool:
        """
        If the underlying compute instance should be deleted if you cannot evict all the pods in grace period
        """
        return pulumi.get(self, "is_force_delete_after_grace_duration")


@pulumi.output_type
class GetNodePoolsNodePoolNodePoolCyclingDetailResult(dict):
    def __init__(__self__, *,
                 is_node_cycling_enabled: bool,
                 maximum_surge: str,
                 maximum_unavailable: str):
        """
        :param bool is_node_cycling_enabled: If nodes in the nodepool will be cycled to have new changes.
        :param str maximum_surge: Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        :param str maximum_unavailable: Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        GetNodePoolsNodePoolNodePoolCyclingDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            is_node_cycling_enabled=is_node_cycling_enabled,
            maximum_surge=maximum_surge,
            maximum_unavailable=maximum_unavailable,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             is_node_cycling_enabled: bool,
             maximum_surge: str,
             maximum_unavailable: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'isNodeCyclingEnabled' in kwargs:
            is_node_cycling_enabled = kwargs['isNodeCyclingEnabled']
        if 'maximumSurge' in kwargs:
            maximum_surge = kwargs['maximumSurge']
        if 'maximumUnavailable' in kwargs:
            maximum_unavailable = kwargs['maximumUnavailable']

        _setter("is_node_cycling_enabled", is_node_cycling_enabled)
        _setter("maximum_surge", maximum_surge)
        _setter("maximum_unavailable", maximum_unavailable)

    @property
    @pulumi.getter(name="isNodeCyclingEnabled")
    def is_node_cycling_enabled(self) -> bool:
        """
        If nodes in the nodepool will be cycled to have new changes.
        """
        return pulumi.get(self, "is_node_cycling_enabled")

    @property
    @pulumi.getter(name="maximumSurge")
    def maximum_surge(self) -> str:
        """
        Maximum additional new compute instances that would be temporarily created and added to nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 1, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_surge")

    @property
    @pulumi.getter(name="maximumUnavailable")
    def maximum_unavailable(self) -> str:
        """
        Maximum active nodes that would be terminated from nodepool during the cycling nodepool process. OKE supports both integer and percentage input. Defaults to 0, Ranges from 0 to Nodepool size or 0% to 100%
        """
        return pulumi.get(self, "maximum_unavailable")


@pulumi.output_type
class GetNodePoolsNodePoolNodeShapeConfigResult(dict):
    def __init__(__self__, *,
                 memory_in_gbs: float,
                 ocpus: float):
        """
        :param float memory_in_gbs: The total amount of memory available to each node, in gigabytes.
        :param float ocpus: The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        GetNodePoolsNodePoolNodeShapeConfigResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_in_gbs=memory_in_gbs,
            ocpus=ocpus,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_in_gbs: float,
             ocpus: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryInGbs' in kwargs:
            memory_in_gbs = kwargs['memoryInGbs']

        _setter("memory_in_gbs", memory_in_gbs)
        _setter("ocpus", ocpus)

    @property
    @pulumi.getter(name="memoryInGbs")
    def memory_in_gbs(self) -> float:
        """
        The total amount of memory available to each node, in gigabytes.
        """
        return pulumi.get(self, "memory_in_gbs")

    @property
    @pulumi.getter
    def ocpus(self) -> float:
        """
        The total number of OCPUs available to each node in the node pool. See [here](https://docs.cloud.oracle.com/en-us/iaas/api/#/en/iaas/20160918/Shape/) for details.
        """
        return pulumi.get(self, "ocpus")


@pulumi.output_type
class GetNodePoolsNodePoolNodeSourceResult(dict):
    def __init__(__self__, *,
                 image_id: str,
                 source_name: str,
                 source_type: str):
        """
        :param str image_id: The OCID of the image used to boot the node.
        :param str source_name: The user-friendly name of the entity corresponding to the OCID.
        :param str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        GetNodePoolsNodePoolNodeSourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            image_id=image_id,
            source_name=source_name,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             image_id: str,
             source_name: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceName' in kwargs:
            source_name = kwargs['sourceName']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("image_id", image_id)
        _setter("source_name", source_name)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceName")
    def source_name(self) -> str:
        """
        The user-friendly name of the entity corresponding to the OCID.
        """
        return pulumi.get(self, "source_name")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetNodePoolsNodePoolNodeSourceDetailResult(dict):
    def __init__(__self__, *,
                 boot_volume_size_in_gbs: str,
                 image_id: str,
                 source_type: str):
        """
        :param str boot_volume_size_in_gbs: The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        :param str image_id: The OCID of the image used to boot the node.
        :param str source_type: The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        GetNodePoolsNodePoolNodeSourceDetailResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            boot_volume_size_in_gbs=boot_volume_size_in_gbs,
            image_id=image_id,
            source_type=source_type,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             boot_volume_size_in_gbs: str,
             image_id: str,
             source_type: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'bootVolumeSizeInGbs' in kwargs:
            boot_volume_size_in_gbs = kwargs['bootVolumeSizeInGbs']
        if 'imageId' in kwargs:
            image_id = kwargs['imageId']
        if 'sourceType' in kwargs:
            source_type = kwargs['sourceType']

        _setter("boot_volume_size_in_gbs", boot_volume_size_in_gbs)
        _setter("image_id", image_id)
        _setter("source_type", source_type)

    @property
    @pulumi.getter(name="bootVolumeSizeInGbs")
    def boot_volume_size_in_gbs(self) -> str:
        """
        The size of the boot volume in GBs. Minimum value is 50 GB. See [here](https://docs.cloud.oracle.com/en-us/iaas/Content/Block/Concepts/bootvolumes.htm) for max custom boot volume sizing and OS-specific requirements.
        """
        return pulumi.get(self, "boot_volume_size_in_gbs")

    @property
    @pulumi.getter(name="imageId")
    def image_id(self) -> str:
        """
        The OCID of the image used to boot the node.
        """
        return pulumi.get(self, "image_id")

    @property
    @pulumi.getter(name="sourceType")
    def source_type(self) -> str:
        """
        The source type for the node. Use `IMAGE` when specifying an OCID of an image.
        """
        return pulumi.get(self, "source_type")


@pulumi.output_type
class GetPodShapesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        GetPodShapesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetPodShapesPodShapeResult(dict):
    def __init__(__self__, *,
                 memory_options: Sequence['outputs.GetPodShapesPodShapeMemoryOptionResult'],
                 name: str,
                 network_bandwidth_options: Sequence['outputs.GetPodShapesPodShapeNetworkBandwidthOptionResult'],
                 ocpu_options: Sequence['outputs.GetPodShapesPodShapeOcpuOptionResult'],
                 processor_description: str):
        """
        :param Sequence['GetPodShapesPodShapeMemoryOptionArgs'] memory_options: ShapeMemoryOptions.
        :param str name: The name to filter on.
        :param Sequence['GetPodShapesPodShapeNetworkBandwidthOptionArgs'] network_bandwidth_options: ShapeNetworkBandwidthOptions.
        :param Sequence['GetPodShapesPodShapeOcpuOptionArgs'] ocpu_options: Options for OCPU shape.
        :param str processor_description: A short description of the VM's processor (CPU).
        """
        GetPodShapesPodShapeResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            memory_options=memory_options,
            name=name,
            network_bandwidth_options=network_bandwidth_options,
            ocpu_options=ocpu_options,
            processor_description=processor_description,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             memory_options: Sequence['outputs.GetPodShapesPodShapeMemoryOptionResult'],
             name: str,
             network_bandwidth_options: Sequence['outputs.GetPodShapesPodShapeNetworkBandwidthOptionResult'],
             ocpu_options: Sequence['outputs.GetPodShapesPodShapeOcpuOptionResult'],
             processor_description: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'memoryOptions' in kwargs:
            memory_options = kwargs['memoryOptions']
        if 'networkBandwidthOptions' in kwargs:
            network_bandwidth_options = kwargs['networkBandwidthOptions']
        if 'ocpuOptions' in kwargs:
            ocpu_options = kwargs['ocpuOptions']
        if 'processorDescription' in kwargs:
            processor_description = kwargs['processorDescription']

        _setter("memory_options", memory_options)
        _setter("name", name)
        _setter("network_bandwidth_options", network_bandwidth_options)
        _setter("ocpu_options", ocpu_options)
        _setter("processor_description", processor_description)

    @property
    @pulumi.getter(name="memoryOptions")
    def memory_options(self) -> Sequence['outputs.GetPodShapesPodShapeMemoryOptionResult']:
        """
        ShapeMemoryOptions.
        """
        return pulumi.get(self, "memory_options")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="networkBandwidthOptions")
    def network_bandwidth_options(self) -> Sequence['outputs.GetPodShapesPodShapeNetworkBandwidthOptionResult']:
        """
        ShapeNetworkBandwidthOptions.
        """
        return pulumi.get(self, "network_bandwidth_options")

    @property
    @pulumi.getter(name="ocpuOptions")
    def ocpu_options(self) -> Sequence['outputs.GetPodShapesPodShapeOcpuOptionResult']:
        """
        Options for OCPU shape.
        """
        return pulumi.get(self, "ocpu_options")

    @property
    @pulumi.getter(name="processorDescription")
    def processor_description(self) -> str:
        """
        A short description of the VM's processor (CPU).
        """
        return pulumi.get(self, "processor_description")


@pulumi.output_type
class GetPodShapesPodShapeMemoryOptionResult(dict):
    def __init__(__self__, *,
                 default_per_ocpu_in_gbs: float,
                 max_in_gbs: float,
                 max_per_ocpu_in_gbs: float,
                 min_in_gbs: float,
                 min_per_ocpu_in_gbs: float):
        """
        :param float default_per_ocpu_in_gbs: The default amount of memory per OCPU available for this shape, in gigabytes.
        :param float max_in_gbs: The maximum amount of memory, in gigabytes.
        :param float max_per_ocpu_in_gbs: The maximum amount of memory per OCPU available for this shape, in gigabytes.
        :param float min_in_gbs: The minimum amount of memory, in gigabytes.
        :param float min_per_ocpu_in_gbs: The minimum amount of memory per OCPU available for this shape, in gigabytes.
        """
        GetPodShapesPodShapeMemoryOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_per_ocpu_in_gbs=default_per_ocpu_in_gbs,
            max_in_gbs=max_in_gbs,
            max_per_ocpu_in_gbs=max_per_ocpu_in_gbs,
            min_in_gbs=min_in_gbs,
            min_per_ocpu_in_gbs=min_per_ocpu_in_gbs,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_per_ocpu_in_gbs: float,
             max_in_gbs: float,
             max_per_ocpu_in_gbs: float,
             min_in_gbs: float,
             min_per_ocpu_in_gbs: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultPerOcpuInGbs' in kwargs:
            default_per_ocpu_in_gbs = kwargs['defaultPerOcpuInGbs']
        if 'maxInGbs' in kwargs:
            max_in_gbs = kwargs['maxInGbs']
        if 'maxPerOcpuInGbs' in kwargs:
            max_per_ocpu_in_gbs = kwargs['maxPerOcpuInGbs']
        if 'minInGbs' in kwargs:
            min_in_gbs = kwargs['minInGbs']
        if 'minPerOcpuInGbs' in kwargs:
            min_per_ocpu_in_gbs = kwargs['minPerOcpuInGbs']

        _setter("default_per_ocpu_in_gbs", default_per_ocpu_in_gbs)
        _setter("max_in_gbs", max_in_gbs)
        _setter("max_per_ocpu_in_gbs", max_per_ocpu_in_gbs)
        _setter("min_in_gbs", min_in_gbs)
        _setter("min_per_ocpu_in_gbs", min_per_ocpu_in_gbs)

    @property
    @pulumi.getter(name="defaultPerOcpuInGbs")
    def default_per_ocpu_in_gbs(self) -> float:
        """
        The default amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "default_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="maxInGbs")
    def max_in_gbs(self) -> float:
        """
        The maximum amount of memory, in gigabytes.
        """
        return pulumi.get(self, "max_in_gbs")

    @property
    @pulumi.getter(name="maxPerOcpuInGbs")
    def max_per_ocpu_in_gbs(self) -> float:
        """
        The maximum amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "max_per_ocpu_in_gbs")

    @property
    @pulumi.getter(name="minInGbs")
    def min_in_gbs(self) -> float:
        """
        The minimum amount of memory, in gigabytes.
        """
        return pulumi.get(self, "min_in_gbs")

    @property
    @pulumi.getter(name="minPerOcpuInGbs")
    def min_per_ocpu_in_gbs(self) -> float:
        """
        The minimum amount of memory per OCPU available for this shape, in gigabytes.
        """
        return pulumi.get(self, "min_per_ocpu_in_gbs")


@pulumi.output_type
class GetPodShapesPodShapeNetworkBandwidthOptionResult(dict):
    def __init__(__self__, *,
                 default_per_ocpu_in_gbps: float,
                 max_in_gbps: float,
                 min_in_gbps: float):
        """
        :param float default_per_ocpu_in_gbps: The default amount of networking bandwidth per OCPU, in gigabits per second.
        :param float max_in_gbps: The maximum amount of networking bandwidth, in gigabits per second.
        :param float min_in_gbps: The minimum amount of networking bandwidth, in gigabits per second.
        """
        GetPodShapesPodShapeNetworkBandwidthOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            default_per_ocpu_in_gbps=default_per_ocpu_in_gbps,
            max_in_gbps=max_in_gbps,
            min_in_gbps=min_in_gbps,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             default_per_ocpu_in_gbps: float,
             max_in_gbps: float,
             min_in_gbps: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'defaultPerOcpuInGbps' in kwargs:
            default_per_ocpu_in_gbps = kwargs['defaultPerOcpuInGbps']
        if 'maxInGbps' in kwargs:
            max_in_gbps = kwargs['maxInGbps']
        if 'minInGbps' in kwargs:
            min_in_gbps = kwargs['minInGbps']

        _setter("default_per_ocpu_in_gbps", default_per_ocpu_in_gbps)
        _setter("max_in_gbps", max_in_gbps)
        _setter("min_in_gbps", min_in_gbps)

    @property
    @pulumi.getter(name="defaultPerOcpuInGbps")
    def default_per_ocpu_in_gbps(self) -> float:
        """
        The default amount of networking bandwidth per OCPU, in gigabits per second.
        """
        return pulumi.get(self, "default_per_ocpu_in_gbps")

    @property
    @pulumi.getter(name="maxInGbps")
    def max_in_gbps(self) -> float:
        """
        The maximum amount of networking bandwidth, in gigabits per second.
        """
        return pulumi.get(self, "max_in_gbps")

    @property
    @pulumi.getter(name="minInGbps")
    def min_in_gbps(self) -> float:
        """
        The minimum amount of networking bandwidth, in gigabits per second.
        """
        return pulumi.get(self, "min_in_gbps")


@pulumi.output_type
class GetPodShapesPodShapeOcpuOptionResult(dict):
    def __init__(__self__, *,
                 max: float,
                 min: float):
        """
        :param float max: The maximum number of OCPUs.
        :param float min: The minimum number of OCPUs.
        """
        GetPodShapesPodShapeOcpuOptionResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            max=max,
            min=min,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             max: float,
             min: float,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("max", max)
        _setter("min", min)

    @property
    @pulumi.getter
    def max(self) -> float:
        """
        The maximum number of OCPUs.
        """
        return pulumi.get(self, "max")

    @property
    @pulumi.getter
    def min(self) -> float:
        """
        The minimum number of OCPUs.
        """
        return pulumi.get(self, "min")


@pulumi.output_type
class GetVirtualNodePoolInitialVirtualNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetVirtualNodePoolInitialVirtualNodeLabelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolPlacementConfigurationResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 fault_domains: Sequence[str],
                 subnet_id: str):
        """
        :param str availability_domain: The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[str] fault_domains: The fault domain of this virtual node.
        :param str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        GetVirtualNodePoolPlacementConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            fault_domains=fault_domains,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             fault_domains: Sequence[str],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("fault_domains", fault_domains)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        """
        The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolPodConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 shape: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param str shape: Shape of the pods.
        :param str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        GetVirtualNodePoolPodConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            shape=shape,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Sequence[str],
             shape: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("nsg_ids", nsg_ids)
        _setter("shape", shape)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: The effect of the pair.
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetVirtualNodePoolTaintResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            effect=effect,
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             effect: str,
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("effect", effect)
        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolVirtualNodeTagResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any]):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        GetVirtualNodePoolVirtualNodeTagResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetVirtualNodePoolsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        """
        :param str name: The name to filter on.
        """
        GetVirtualNodePoolsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name to filter on.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolResult(dict):
    def __init__(__self__, *,
                 cluster_id: str,
                 compartment_id: str,
                 defined_tags: Mapping[str, Any],
                 display_name: str,
                 freeform_tags: Mapping[str, Any],
                 id: str,
                 initial_virtual_node_labels: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult'],
                 kubernetes_version: str,
                 lifecycle_details: str,
                 nsg_ids: Sequence[str],
                 placement_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult'],
                 pod_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult'],
                 size: int,
                 state: str,
                 system_tags: Mapping[str, Any],
                 taints: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolTaintResult'],
                 time_created: str,
                 time_updated: str,
                 virtual_node_pool_id: str,
                 virtual_node_tags: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult']):
        """
        :param str cluster_id: The OCID of the cluster.
        :param str compartment_id: The OCID of the compartment.
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param str display_name: Display name of the virtual node pool. This is a non-unique value.
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        :param str id: The OCID of the virtual node pool.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelArgs'] initial_virtual_node_labels: Initial labels that will be added to the Kubernetes Virtual Node object when it registers. This is the same as virtualNodePool resources.
        :param str kubernetes_version: The version of Kubernetes running on the nodes in the node pool.
        :param str lifecycle_details: Details about the state of the Virtual Node Pool.
        :param Sequence[str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationArgs'] placement_configurations: The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolPodConfigurationArgs'] pod_configurations: The pod configuration for pods run on virtual nodes of this virtual node pool.
        :param int size: The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        :param str state: A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
        :param Mapping[str, Any] system_tags: Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolTaintArgs'] taints: A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        :param str time_created: The time the virtual node pool was created.
        :param str time_updated: The time the virtual node pool was updated.
        :param Sequence['GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagArgs'] virtual_node_tags: The tags associated to the virtual nodes in this virtual node pool.
        """
        GetVirtualNodePoolsVirtualNodePoolResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            cluster_id=cluster_id,
            compartment_id=compartment_id,
            defined_tags=defined_tags,
            display_name=display_name,
            freeform_tags=freeform_tags,
            id=id,
            initial_virtual_node_labels=initial_virtual_node_labels,
            kubernetes_version=kubernetes_version,
            lifecycle_details=lifecycle_details,
            nsg_ids=nsg_ids,
            placement_configurations=placement_configurations,
            pod_configurations=pod_configurations,
            size=size,
            state=state,
            system_tags=system_tags,
            taints=taints,
            time_created=time_created,
            time_updated=time_updated,
            virtual_node_pool_id=virtual_node_pool_id,
            virtual_node_tags=virtual_node_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             cluster_id: str,
             compartment_id: str,
             defined_tags: Mapping[str, Any],
             display_name: str,
             freeform_tags: Mapping[str, Any],
             id: str,
             initial_virtual_node_labels: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult'],
             kubernetes_version: str,
             lifecycle_details: str,
             nsg_ids: Sequence[str],
             placement_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult'],
             pod_configurations: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult'],
             size: int,
             state: str,
             system_tags: Mapping[str, Any],
             taints: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolTaintResult'],
             time_created: str,
             time_updated: str,
             virtual_node_pool_id: str,
             virtual_node_tags: Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult'],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'clusterId' in kwargs:
            cluster_id = kwargs['clusterId']
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']
        if 'initialVirtualNodeLabels' in kwargs:
            initial_virtual_node_labels = kwargs['initialVirtualNodeLabels']
        if 'kubernetesVersion' in kwargs:
            kubernetes_version = kwargs['kubernetesVersion']
        if 'lifecycleDetails' in kwargs:
            lifecycle_details = kwargs['lifecycleDetails']
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'placementConfigurations' in kwargs:
            placement_configurations = kwargs['placementConfigurations']
        if 'podConfigurations' in kwargs:
            pod_configurations = kwargs['podConfigurations']
        if 'systemTags' in kwargs:
            system_tags = kwargs['systemTags']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeUpdated' in kwargs:
            time_updated = kwargs['timeUpdated']
        if 'virtualNodePoolId' in kwargs:
            virtual_node_pool_id = kwargs['virtualNodePoolId']
        if 'virtualNodeTags' in kwargs:
            virtual_node_tags = kwargs['virtualNodeTags']

        _setter("cluster_id", cluster_id)
        _setter("compartment_id", compartment_id)
        _setter("defined_tags", defined_tags)
        _setter("display_name", display_name)
        _setter("freeform_tags", freeform_tags)
        _setter("id", id)
        _setter("initial_virtual_node_labels", initial_virtual_node_labels)
        _setter("kubernetes_version", kubernetes_version)
        _setter("lifecycle_details", lifecycle_details)
        _setter("nsg_ids", nsg_ids)
        _setter("placement_configurations", placement_configurations)
        _setter("pod_configurations", pod_configurations)
        _setter("size", size)
        _setter("state", state)
        _setter("system_tags", system_tags)
        _setter("taints", taints)
        _setter("time_created", time_created)
        _setter("time_updated", time_updated)
        _setter("virtual_node_pool_id", virtual_node_pool_id)
        _setter("virtual_node_tags", virtual_node_tags)

    @property
    @pulumi.getter(name="clusterId")
    def cluster_id(self) -> str:
        """
        The OCID of the cluster.
        """
        return pulumi.get(self, "cluster_id")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        Display name of the virtual node pool. This is a non-unique value.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the virtual node pool.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="initialVirtualNodeLabels")
    def initial_virtual_node_labels(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult']:
        """
        Initial labels that will be added to the Kubernetes Virtual Node object when it registers. This is the same as virtualNodePool resources.
        """
        return pulumi.get(self, "initial_virtual_node_labels")

    @property
    @pulumi.getter(name="kubernetesVersion")
    def kubernetes_version(self) -> str:
        """
        The version of Kubernetes running on the nodes in the node pool.
        """
        return pulumi.get(self, "kubernetes_version")

    @property
    @pulumi.getter(name="lifecycleDetails")
    def lifecycle_details(self) -> str:
        """
        Details about the state of the Virtual Node Pool.
        """
        return pulumi.get(self, "lifecycle_details")

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter(name="placementConfigurations")
    def placement_configurations(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult']:
        """
        The list of placement configurations which determines where Virtual Nodes will be provisioned across as it relates to the subnet and availability domains. The size attribute determines how many we evenly spread across these placement configurations
        """
        return pulumi.get(self, "placement_configurations")

    @property
    @pulumi.getter(name="podConfigurations")
    def pod_configurations(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult']:
        """
        The pod configuration for pods run on virtual nodes of this virtual node pool.
        """
        return pulumi.get(self, "pod_configurations")

    @property
    @pulumi.getter
    def size(self) -> int:
        """
        The number of Virtual Nodes that should be in the Virtual Node Pool. The placement configurations determine where these virtual nodes are placed.
        """
        return pulumi.get(self, "size")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A virtual node pool lifecycle state to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, Any]:
        """
        Usage of system tag keys. These predefined keys are scoped to namespaces. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter
    def taints(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolTaintResult']:
        """
        A taint is a collection of <key, value, effect>. These taints will be applied to the Virtual Nodes of this Virtual Node Pool for Kubernetes scheduling.
        """
        return pulumi.get(self, "taints")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time the virtual node pool was created.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time the virtual node pool was updated.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter(name="virtualNodePoolId")
    def virtual_node_pool_id(self) -> str:
        return pulumi.get(self, "virtual_node_pool_id")

    @property
    @pulumi.getter(name="virtualNodeTags")
    def virtual_node_tags(self) -> Sequence['outputs.GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult']:
        """
        The tags associated to the virtual nodes in this virtual node pool.
        """
        return pulumi.get(self, "virtual_node_tags")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult(dict):
    def __init__(__self__, *,
                 key: str,
                 value: str):
        """
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetVirtualNodePoolsVirtualNodePoolInitialVirtualNodeLabelResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult(dict):
    def __init__(__self__, *,
                 availability_domain: str,
                 fault_domains: Sequence[str],
                 subnet_id: str):
        """
        :param str availability_domain: The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        :param Sequence[str] fault_domains: The fault domain of this virtual node.
        :param str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        GetVirtualNodePoolsVirtualNodePoolPlacementConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            availability_domain=availability_domain,
            fault_domains=fault_domains,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             availability_domain: str,
             fault_domains: Sequence[str],
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'availabilityDomain' in kwargs:
            availability_domain = kwargs['availabilityDomain']
        if 'faultDomains' in kwargs:
            fault_domains = kwargs['faultDomains']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("availability_domain", availability_domain)
        _setter("fault_domains", fault_domains)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="availabilityDomain")
    def availability_domain(self) -> str:
        """
        The availability domain in which to place virtual nodes. Example: `Uocm:PHX-AD-1`
        """
        return pulumi.get(self, "availability_domain")

    @property
    @pulumi.getter(name="faultDomains")
    def fault_domains(self) -> Sequence[str]:
        """
        The fault domain of this virtual node.
        """
        return pulumi.get(self, "fault_domains")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult(dict):
    def __init__(__self__, *,
                 nsg_ids: Sequence[str],
                 shape: str,
                 subnet_id: str):
        """
        :param Sequence[str] nsg_ids: List of network security group IDs applied to the Pod VNIC.
        :param str shape: Shape of the pods.
        :param str subnet_id: The regional subnet where pods' VNIC will be placed.
        """
        GetVirtualNodePoolsVirtualNodePoolPodConfigurationResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            nsg_ids=nsg_ids,
            shape=shape,
            subnet_id=subnet_id,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             nsg_ids: Sequence[str],
             shape: str,
             subnet_id: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'nsgIds' in kwargs:
            nsg_ids = kwargs['nsgIds']
        if 'subnetId' in kwargs:
            subnet_id = kwargs['subnetId']

        _setter("nsg_ids", nsg_ids)
        _setter("shape", shape)
        _setter("subnet_id", subnet_id)

    @property
    @pulumi.getter(name="nsgIds")
    def nsg_ids(self) -> Sequence[str]:
        """
        List of network security group IDs applied to the Pod VNIC.
        """
        return pulumi.get(self, "nsg_ids")

    @property
    @pulumi.getter
    def shape(self) -> str:
        """
        Shape of the pods.
        """
        return pulumi.get(self, "shape")

    @property
    @pulumi.getter(name="subnetId")
    def subnet_id(self) -> str:
        """
        The regional subnet where pods' VNIC will be placed.
        """
        return pulumi.get(self, "subnet_id")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolTaintResult(dict):
    def __init__(__self__, *,
                 effect: str,
                 key: str,
                 value: str):
        """
        :param str effect: The effect of the pair.
        :param str key: The key of the pair.
        :param str value: The value of the pair.
        """
        GetVirtualNodePoolsVirtualNodePoolTaintResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            effect=effect,
            key=key,
            value=value,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             effect: str,
             key: str,
             value: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("effect", effect)
        _setter("key", key)
        _setter("value", value)

    @property
    @pulumi.getter
    def effect(self) -> str:
        """
        The effect of the pair.
        """
        return pulumi.get(self, "effect")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        The key of the pair.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        The value of the pair.
        """
        return pulumi.get(self, "value")


@pulumi.output_type
class GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult(dict):
    def __init__(__self__, *,
                 defined_tags: Mapping[str, Any],
                 freeform_tags: Mapping[str, Any]):
        """
        :param Mapping[str, Any] defined_tags: Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        :param Mapping[str, Any] freeform_tags: Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        GetVirtualNodePoolsVirtualNodePoolVirtualNodeTagResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            defined_tags=defined_tags,
            freeform_tags=freeform_tags,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             defined_tags: Mapping[str, Any],
             freeform_tags: Mapping[str, Any],
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'definedTags' in kwargs:
            defined_tags = kwargs['definedTags']
        if 'freeformTags' in kwargs:
            freeform_tags = kwargs['freeformTags']

        _setter("defined_tags", defined_tags)
        _setter("freeform_tags", freeform_tags)

    @property
    @pulumi.getter(name="definedTags")
    def defined_tags(self) -> Mapping[str, Any]:
        """
        Defined tags for this resource. Each key is predefined and scoped to a namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Operations.CostCenter": "42"}`
        """
        return pulumi.get(self, "defined_tags")

    @property
    @pulumi.getter(name="freeformTags")
    def freeform_tags(self) -> Mapping[str, Any]:
        """
        Free-form tags for this resource. Each tag is a simple key-value pair with no predefined name, type, or namespace. For more information, see [Resource Tags](https://docs.cloud.oracle.com/iaas/Content/General/Concepts/resourcetags.htm). Example: `{"Department": "Finance"}`
        """
        return pulumi.get(self, "freeform_tags")


@pulumi.output_type
class GetWorkRequestErrorsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetWorkRequestErrorsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestErrorsWorkRequestErrorResult(dict):
    def __init__(__self__, *,
                 code: str,
                 message: str,
                 timestamp: str):
        """
        :param str code: A short error code that defines the error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        :param str message: A human-readable error string.
        :param str timestamp: The date and time the error occurred.
        """
        GetWorkRequestErrorsWorkRequestErrorResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            code=code,
            message=message,
            timestamp=timestamp,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             code: str,
             message: str,
             timestamp: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("code", code)
        _setter("message", message)
        _setter("timestamp", timestamp)

    @property
    @pulumi.getter
    def code(self) -> str:
        """
        A short error code that defines the error, meant for programmatic parsing. See [API Errors](https://docs.cloud.oracle.com/iaas/Content/API/References/apierrors.htm).
        """
        return pulumi.get(self, "code")

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        A human-readable error string.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        The date and time the error occurred.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetWorkRequestLogEntriesFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetWorkRequestLogEntriesFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestLogEntriesWorkRequestLogEntryResult(dict):
    def __init__(__self__, *,
                 message: str,
                 timestamp: str):
        """
        :param str message: The description of an action that occurred.
        :param str timestamp: The date and time the log entry occurred.
        """
        GetWorkRequestLogEntriesWorkRequestLogEntryResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            message=message,
            timestamp=timestamp,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             message: str,
             timestamp: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("message", message)
        _setter("timestamp", timestamp)

    @property
    @pulumi.getter
    def message(self) -> str:
        """
        The description of an action that occurred.
        """
        return pulumi.get(self, "message")

    @property
    @pulumi.getter
    def timestamp(self) -> str:
        """
        The date and time the log entry occurred.
        """
        return pulumi.get(self, "timestamp")


@pulumi.output_type
class GetWorkRequestsFilterResult(dict):
    def __init__(__self__, *,
                 name: str,
                 values: Sequence[str],
                 regex: Optional[bool] = None):
        GetWorkRequestsFilterResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            name=name,
            values=values,
            regex=regex,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             name: str,
             values: Sequence[str],
             regex: Optional[bool] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):

        _setter("name", name)
        _setter("values", values)
        if regex is not None:
            _setter("regex", regex)

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        return pulumi.get(self, "values")

    @property
    @pulumi.getter
    def regex(self) -> Optional[bool]:
        return pulumi.get(self, "regex")


@pulumi.output_type
class GetWorkRequestsWorkRequestResult(dict):
    def __init__(__self__, *,
                 compartment_id: str,
                 id: str,
                 operation_type: str,
                 resources: Sequence['outputs.GetWorkRequestsWorkRequestResourceResult'],
                 status: str,
                 time_accepted: str,
                 time_finished: str,
                 time_started: str):
        """
        :param str compartment_id: The OCID of the compartment.
        :param str id: The OCID of the work request.
        :param str operation_type: The type of work the work request is doing.
        :param Sequence['GetWorkRequestsWorkRequestResourceArgs'] resources: The resources this work request affects.
        :param str status: A work request status to filter on. Can have multiple parameters of this name.
        :param str time_accepted: The time the work request was accepted.
        :param str time_finished: The time the work request was finished.
        :param str time_started: The time the work request was started.
        """
        GetWorkRequestsWorkRequestResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            id=id,
            operation_type=operation_type,
            resources=resources,
            status=status,
            time_accepted=time_accepted,
            time_finished=time_finished,
            time_started=time_started,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: str,
             id: str,
             operation_type: str,
             resources: Sequence['outputs.GetWorkRequestsWorkRequestResourceResult'],
             status: str,
             time_accepted: str,
             time_finished: str,
             time_started: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'operationType' in kwargs:
            operation_type = kwargs['operationType']
        if 'timeAccepted' in kwargs:
            time_accepted = kwargs['timeAccepted']
        if 'timeFinished' in kwargs:
            time_finished = kwargs['timeFinished']
        if 'timeStarted' in kwargs:
            time_started = kwargs['timeStarted']

        _setter("compartment_id", compartment_id)
        _setter("id", id)
        _setter("operation_type", operation_type)
        _setter("resources", resources)
        _setter("status", status)
        _setter("time_accepted", time_accepted)
        _setter("time_finished", time_finished)
        _setter("time_started", time_started)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        The OCID of the compartment.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The OCID of the work request.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="operationType")
    def operation_type(self) -> str:
        """
        The type of work the work request is doing.
        """
        return pulumi.get(self, "operation_type")

    @property
    @pulumi.getter
    def resources(self) -> Sequence['outputs.GetWorkRequestsWorkRequestResourceResult']:
        """
        The resources this work request affects.
        """
        return pulumi.get(self, "resources")

    @property
    @pulumi.getter
    def status(self) -> str:
        """
        A work request status to filter on. Can have multiple parameters of this name.
        """
        return pulumi.get(self, "status")

    @property
    @pulumi.getter(name="timeAccepted")
    def time_accepted(self) -> str:
        """
        The time the work request was accepted.
        """
        return pulumi.get(self, "time_accepted")

    @property
    @pulumi.getter(name="timeFinished")
    def time_finished(self) -> str:
        """
        The time the work request was finished.
        """
        return pulumi.get(self, "time_finished")

    @property
    @pulumi.getter(name="timeStarted")
    def time_started(self) -> str:
        """
        The time the work request was started.
        """
        return pulumi.get(self, "time_started")


@pulumi.output_type
class GetWorkRequestsWorkRequestResourceResult(dict):
    def __init__(__self__, *,
                 action_type: str,
                 entity_type: str,
                 entity_uri: str,
                 identifier: str):
        """
        :param str action_type: The way in which this resource was affected by the work tracked by the work request.
        :param str entity_type: The resource type the work request affects.
        :param str entity_uri: The URI path on which the user can issue a GET request to access the resource metadata.
        :param str identifier: The OCID of the resource the work request affects.
        """
        GetWorkRequestsWorkRequestResourceResult._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            action_type=action_type,
            entity_type=entity_type,
            entity_uri=entity_uri,
            identifier=identifier,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             action_type: str,
             entity_type: str,
             entity_uri: str,
             identifier: str,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'actionType' in kwargs:
            action_type = kwargs['actionType']
        if 'entityType' in kwargs:
            entity_type = kwargs['entityType']
        if 'entityUri' in kwargs:
            entity_uri = kwargs['entityUri']

        _setter("action_type", action_type)
        _setter("entity_type", entity_type)
        _setter("entity_uri", entity_uri)
        _setter("identifier", identifier)

    @property
    @pulumi.getter(name="actionType")
    def action_type(self) -> str:
        """
        The way in which this resource was affected by the work tracked by the work request.
        """
        return pulumi.get(self, "action_type")

    @property
    @pulumi.getter(name="entityType")
    def entity_type(self) -> str:
        """
        The resource type the work request affects.
        """
        return pulumi.get(self, "entity_type")

    @property
    @pulumi.getter(name="entityUri")
    def entity_uri(self) -> str:
        """
        The URI path on which the user can issue a GET request to access the resource metadata.
        """
        return pulumi.get(self, "entity_uri")

    @property
    @pulumi.getter
    def identifier(self) -> str:
        """
        The OCID of the resource the work request affects.
        """
        return pulumi.get(self, "identifier")


