# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Callable, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['AppCatalogSubscriptionArgs', 'AppCatalogSubscription']

@pulumi.input_type
class AppCatalogSubscriptionArgs:
    def __init__(__self__, *,
                 compartment_id: pulumi.Input[str],
                 listing_id: pulumi.Input[str],
                 listing_resource_version: pulumi.Input[str],
                 oracle_terms_of_use_link: pulumi.Input[str],
                 signature: pulumi.Input[str],
                 time_retrieved: pulumi.Input[str],
                 eula_link: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a AppCatalogSubscription resource.
        :param pulumi.Input[str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[str] listing_id: The OCID of the listing.
        :param pulumi.Input[str] listing_resource_version: Listing resource version.
        :param pulumi.Input[str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        :param pulumi.Input[str] eula_link: EULA link
        """
        AppCatalogSubscriptionArgs._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            listing_id=listing_id,
            listing_resource_version=listing_resource_version,
            oracle_terms_of_use_link=oracle_terms_of_use_link,
            signature=signature,
            time_retrieved=time_retrieved,
            eula_link=eula_link,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: pulumi.Input[str],
             listing_id: pulumi.Input[str],
             listing_resource_version: pulumi.Input[str],
             oracle_terms_of_use_link: pulumi.Input[str],
             signature: pulumi.Input[str],
             time_retrieved: pulumi.Input[str],
             eula_link: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'listingId' in kwargs:
            listing_id = kwargs['listingId']
        if 'listingResourceVersion' in kwargs:
            listing_resource_version = kwargs['listingResourceVersion']
        if 'oracleTermsOfUseLink' in kwargs:
            oracle_terms_of_use_link = kwargs['oracleTermsOfUseLink']
        if 'timeRetrieved' in kwargs:
            time_retrieved = kwargs['timeRetrieved']
        if 'eulaLink' in kwargs:
            eula_link = kwargs['eulaLink']

        _setter("compartment_id", compartment_id)
        _setter("listing_id", listing_id)
        _setter("listing_resource_version", listing_resource_version)
        _setter("oracle_terms_of_use_link", oracle_terms_of_use_link)
        _setter("signature", signature)
        _setter("time_retrieved", time_retrieved)
        if eula_link is not None:
            _setter("eula_link", eula_link)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Input[str]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Input[str]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> pulumi.Input[str]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @listing_resource_version.setter
    def listing_resource_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "listing_resource_version", value)

    @property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> pulumi.Input[str]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @oracle_terms_of_use_link.setter
    def oracle_terms_of_use_link(self, value: pulumi.Input[str]):
        pulumi.set(self, "oracle_terms_of_use_link", value)

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Input[str]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: pulumi.Input[str]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> pulumi.Input[str]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

    @time_retrieved.setter
    def time_retrieved(self, value: pulumi.Input[str]):
        pulumi.set(self, "time_retrieved", value)

    @property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> Optional[pulumi.Input[str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @eula_link.setter
    def eula_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eula_link", value)


@pulumi.input_type
class _AppCatalogSubscriptionState:
    def __init__(__self__, *,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 display_name: Optional[pulumi.Input[str]] = None,
                 eula_link: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 listing_resource_id: Optional[pulumi.Input[str]] = None,
                 listing_resource_version: Optional[pulumi.Input[str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[str]] = None,
                 publisher_name: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 summary: Optional[pulumi.Input[str]] = None,
                 time_created: Optional[pulumi.Input[str]] = None,
                 time_retrieved: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering AppCatalogSubscription resources.
        :param pulumi.Input[str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] eula_link: EULA link
        :param pulumi.Input[str] listing_id: The OCID of the listing.
        :param pulumi.Input[str] listing_resource_id: Listing resource id.
        :param pulumi.Input[str] listing_resource_version: Listing resource version.
        :param pulumi.Input[str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[str] publisher_name: Name of the publisher who published this listing.
        :param pulumi.Input[str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[str] summary: The short summary to the listing.
        :param pulumi.Input[str] time_created: Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        :param pulumi.Input[str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        _AppCatalogSubscriptionState._configure(
            lambda key, value: pulumi.set(__self__, key, value),
            compartment_id=compartment_id,
            display_name=display_name,
            eula_link=eula_link,
            listing_id=listing_id,
            listing_resource_id=listing_resource_id,
            listing_resource_version=listing_resource_version,
            oracle_terms_of_use_link=oracle_terms_of_use_link,
            publisher_name=publisher_name,
            signature=signature,
            summary=summary,
            time_created=time_created,
            time_retrieved=time_retrieved,
        )
    @staticmethod
    def _configure(
             _setter: Callable[[Any, Any], None],
             compartment_id: Optional[pulumi.Input[str]] = None,
             display_name: Optional[pulumi.Input[str]] = None,
             eula_link: Optional[pulumi.Input[str]] = None,
             listing_id: Optional[pulumi.Input[str]] = None,
             listing_resource_id: Optional[pulumi.Input[str]] = None,
             listing_resource_version: Optional[pulumi.Input[str]] = None,
             oracle_terms_of_use_link: Optional[pulumi.Input[str]] = None,
             publisher_name: Optional[pulumi.Input[str]] = None,
             signature: Optional[pulumi.Input[str]] = None,
             summary: Optional[pulumi.Input[str]] = None,
             time_created: Optional[pulumi.Input[str]] = None,
             time_retrieved: Optional[pulumi.Input[str]] = None,
             opts: Optional[pulumi.ResourceOptions]=None,
             **kwargs):
        if 'compartmentId' in kwargs:
            compartment_id = kwargs['compartmentId']
        if 'displayName' in kwargs:
            display_name = kwargs['displayName']
        if 'eulaLink' in kwargs:
            eula_link = kwargs['eulaLink']
        if 'listingId' in kwargs:
            listing_id = kwargs['listingId']
        if 'listingResourceId' in kwargs:
            listing_resource_id = kwargs['listingResourceId']
        if 'listingResourceVersion' in kwargs:
            listing_resource_version = kwargs['listingResourceVersion']
        if 'oracleTermsOfUseLink' in kwargs:
            oracle_terms_of_use_link = kwargs['oracleTermsOfUseLink']
        if 'publisherName' in kwargs:
            publisher_name = kwargs['publisherName']
        if 'timeCreated' in kwargs:
            time_created = kwargs['timeCreated']
        if 'timeRetrieved' in kwargs:
            time_retrieved = kwargs['timeRetrieved']

        if compartment_id is not None:
            _setter("compartment_id", compartment_id)
        if display_name is not None:
            _setter("display_name", display_name)
        if eula_link is not None:
            _setter("eula_link", eula_link)
        if listing_id is not None:
            _setter("listing_id", listing_id)
        if listing_resource_id is not None:
            _setter("listing_resource_id", listing_resource_id)
        if listing_resource_version is not None:
            _setter("listing_resource_version", listing_resource_version)
        if oracle_terms_of_use_link is not None:
            _setter("oracle_terms_of_use_link", oracle_terms_of_use_link)
        if publisher_name is not None:
            _setter("publisher_name", publisher_name)
        if signature is not None:
            _setter("signature", signature)
        if summary is not None:
            _setter("summary", summary)
        if time_created is not None:
            _setter("time_created", time_created)
        if time_retrieved is not None:
            _setter("time_retrieved", time_retrieved)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> Optional[pulumi.Input[str]]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @compartment_id.setter
    def compartment_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compartment_id", value)

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[pulumi.Input[str]]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @display_name.setter
    def display_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_name", value)

    @property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> Optional[pulumi.Input[str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @eula_link.setter
    def eula_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "eula_link", value)

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> Optional[pulumi.Input[str]]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @listing_id.setter
    def listing_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listing_id", value)

    @property
    @pulumi.getter(name="listingResourceId")
    def listing_resource_id(self) -> Optional[pulumi.Input[str]]:
        """
        Listing resource id.
        """
        return pulumi.get(self, "listing_resource_id")

    @listing_resource_id.setter
    def listing_resource_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listing_resource_id", value)

    @property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> Optional[pulumi.Input[str]]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @listing_resource_version.setter
    def listing_resource_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "listing_resource_version", value)

    @property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> Optional[pulumi.Input[str]]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @oracle_terms_of_use_link.setter
    def oracle_terms_of_use_link(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "oracle_terms_of_use_link", value)

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> Optional[pulumi.Input[str]]:
        """
        Name of the publisher who published this listing.
        """
        return pulumi.get(self, "publisher_name")

    @publisher_name.setter
    def publisher_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "publisher_name", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)

    @property
    @pulumi.getter
    def summary(self) -> Optional[pulumi.Input[str]]:
        """
        The short summary to the listing.
        """
        return pulumi.get(self, "summary")

    @summary.setter
    def summary(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "summary", value)

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        """
        return pulumi.get(self, "time_created")

    @time_created.setter
    def time_created(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_created", value)

    @property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> Optional[pulumi.Input[str]]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

    @time_retrieved.setter
    def time_retrieved(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "time_retrieved", value)


class AppCatalogSubscription(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 eula_link: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 listing_resource_version: Optional[pulumi.Input[str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 time_retrieved: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        This resource provides the App Catalog Subscription resource in Oracle Cloud Infrastructure Core service.

        Create a subscription for listing resource version for a compartment. It will take some time to propagate to all regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_app_catalog_subscription = oci.core.AppCatalogSubscription("testAppCatalogSubscription",
            compartment_id=var["compartment_id"],
            listing_id=data["oci_core_app_catalog_listing"]["test_listing"]["id"],
            listing_resource_version=var["app_catalog_subscription_listing_resource_version"],
            oracle_terms_of_use_link=var["app_catalog_subscription_oracle_terms_of_use_link"],
            signature=var["app_catalog_subscription_signature"],
            time_retrieved=var["app_catalog_subscription_time_retrieved"],
            eula_link=var["app_catalog_subscription_eula_link"])
        ```

        ## Import

        AppCatalogSubscriptions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/appCatalogSubscription:AppCatalogSubscription test_app_catalog_subscription "compartmentId/{compartmentId}/listingId/{listingId}/listingResourceVersion/{listingResourceVersion}"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[str] eula_link: EULA link
        :param pulumi.Input[str] listing_id: The OCID of the listing.
        :param pulumi.Input[str] listing_resource_version: Listing resource version.
        :param pulumi.Input[str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: AppCatalogSubscriptionArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        This resource provides the App Catalog Subscription resource in Oracle Cloud Infrastructure Core service.

        Create a subscription for listing resource version for a compartment. It will take some time to propagate to all regions.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_oci as oci

        test_app_catalog_subscription = oci.core.AppCatalogSubscription("testAppCatalogSubscription",
            compartment_id=var["compartment_id"],
            listing_id=data["oci_core_app_catalog_listing"]["test_listing"]["id"],
            listing_resource_version=var["app_catalog_subscription_listing_resource_version"],
            oracle_terms_of_use_link=var["app_catalog_subscription_oracle_terms_of_use_link"],
            signature=var["app_catalog_subscription_signature"],
            time_retrieved=var["app_catalog_subscription_time_retrieved"],
            eula_link=var["app_catalog_subscription_eula_link"])
        ```

        ## Import

        AppCatalogSubscriptions can be imported using the `id`, e.g.

        ```sh
         $ pulumi import oci:Core/appCatalogSubscription:AppCatalogSubscription test_app_catalog_subscription "compartmentId/{compartmentId}/listingId/{listingId}/listingResourceVersion/{listingResourceVersion}"
        ```

        :param str resource_name: The name of the resource.
        :param AppCatalogSubscriptionArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(AppCatalogSubscriptionArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            kwargs = kwargs or {}
            def _setter(key, value):
                kwargs[key] = value
            AppCatalogSubscriptionArgs._configure(_setter, **kwargs)
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 compartment_id: Optional[pulumi.Input[str]] = None,
                 eula_link: Optional[pulumi.Input[str]] = None,
                 listing_id: Optional[pulumi.Input[str]] = None,
                 listing_resource_version: Optional[pulumi.Input[str]] = None,
                 oracle_terms_of_use_link: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None,
                 time_retrieved: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = AppCatalogSubscriptionArgs.__new__(AppCatalogSubscriptionArgs)

            if compartment_id is None and not opts.urn:
                raise TypeError("Missing required property 'compartment_id'")
            __props__.__dict__["compartment_id"] = compartment_id
            __props__.__dict__["eula_link"] = eula_link
            if listing_id is None and not opts.urn:
                raise TypeError("Missing required property 'listing_id'")
            __props__.__dict__["listing_id"] = listing_id
            if listing_resource_version is None and not opts.urn:
                raise TypeError("Missing required property 'listing_resource_version'")
            __props__.__dict__["listing_resource_version"] = listing_resource_version
            if oracle_terms_of_use_link is None and not opts.urn:
                raise TypeError("Missing required property 'oracle_terms_of_use_link'")
            __props__.__dict__["oracle_terms_of_use_link"] = oracle_terms_of_use_link
            if signature is None and not opts.urn:
                raise TypeError("Missing required property 'signature'")
            __props__.__dict__["signature"] = signature
            if time_retrieved is None and not opts.urn:
                raise TypeError("Missing required property 'time_retrieved'")
            __props__.__dict__["time_retrieved"] = time_retrieved
            __props__.__dict__["display_name"] = None
            __props__.__dict__["listing_resource_id"] = None
            __props__.__dict__["publisher_name"] = None
            __props__.__dict__["summary"] = None
            __props__.__dict__["time_created"] = None
        super(AppCatalogSubscription, __self__).__init__(
            'oci:Core/appCatalogSubscription:AppCatalogSubscription',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            compartment_id: Optional[pulumi.Input[str]] = None,
            display_name: Optional[pulumi.Input[str]] = None,
            eula_link: Optional[pulumi.Input[str]] = None,
            listing_id: Optional[pulumi.Input[str]] = None,
            listing_resource_id: Optional[pulumi.Input[str]] = None,
            listing_resource_version: Optional[pulumi.Input[str]] = None,
            oracle_terms_of_use_link: Optional[pulumi.Input[str]] = None,
            publisher_name: Optional[pulumi.Input[str]] = None,
            signature: Optional[pulumi.Input[str]] = None,
            summary: Optional[pulumi.Input[str]] = None,
            time_created: Optional[pulumi.Input[str]] = None,
            time_retrieved: Optional[pulumi.Input[str]] = None) -> 'AppCatalogSubscription':
        """
        Get an existing AppCatalogSubscription resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] compartment_id: The compartmentID for the subscription.
        :param pulumi.Input[str] display_name: A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        :param pulumi.Input[str] eula_link: EULA link
        :param pulumi.Input[str] listing_id: The OCID of the listing.
        :param pulumi.Input[str] listing_resource_id: Listing resource id.
        :param pulumi.Input[str] listing_resource_version: Listing resource version.
        :param pulumi.Input[str] oracle_terms_of_use_link: Oracle TOU link
        :param pulumi.Input[str] publisher_name: Name of the publisher who published this listing.
        :param pulumi.Input[str] signature: A generated signature for this listing resource version retrieved the agreements API.
        :param pulumi.Input[str] summary: The short summary to the listing.
        :param pulumi.Input[str] time_created: Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        :param pulumi.Input[str] time_retrieved: Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 
               
               
               ** IMPORTANT **
               Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _AppCatalogSubscriptionState.__new__(_AppCatalogSubscriptionState)

        __props__.__dict__["compartment_id"] = compartment_id
        __props__.__dict__["display_name"] = display_name
        __props__.__dict__["eula_link"] = eula_link
        __props__.__dict__["listing_id"] = listing_id
        __props__.__dict__["listing_resource_id"] = listing_resource_id
        __props__.__dict__["listing_resource_version"] = listing_resource_version
        __props__.__dict__["oracle_terms_of_use_link"] = oracle_terms_of_use_link
        __props__.__dict__["publisher_name"] = publisher_name
        __props__.__dict__["signature"] = signature
        __props__.__dict__["summary"] = summary
        __props__.__dict__["time_created"] = time_created
        __props__.__dict__["time_retrieved"] = time_retrieved
        return AppCatalogSubscription(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> pulumi.Output[str]:
        """
        The compartmentID for the subscription.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> pulumi.Output[str]:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="eulaLink")
    def eula_link(self) -> pulumi.Output[Optional[str]]:
        """
        EULA link
        """
        return pulumi.get(self, "eula_link")

    @property
    @pulumi.getter(name="listingId")
    def listing_id(self) -> pulumi.Output[str]:
        """
        The OCID of the listing.
        """
        return pulumi.get(self, "listing_id")

    @property
    @pulumi.getter(name="listingResourceId")
    def listing_resource_id(self) -> pulumi.Output[str]:
        """
        Listing resource id.
        """
        return pulumi.get(self, "listing_resource_id")

    @property
    @pulumi.getter(name="listingResourceVersion")
    def listing_resource_version(self) -> pulumi.Output[str]:
        """
        Listing resource version.
        """
        return pulumi.get(self, "listing_resource_version")

    @property
    @pulumi.getter(name="oracleTermsOfUseLink")
    def oracle_terms_of_use_link(self) -> pulumi.Output[str]:
        """
        Oracle TOU link
        """
        return pulumi.get(self, "oracle_terms_of_use_link")

    @property
    @pulumi.getter(name="publisherName")
    def publisher_name(self) -> pulumi.Output[str]:
        """
        Name of the publisher who published this listing.
        """
        return pulumi.get(self, "publisher_name")

    @property
    @pulumi.getter
    def signature(self) -> pulumi.Output[str]:
        """
        A generated signature for this listing resource version retrieved the agreements API.
        """
        return pulumi.get(self, "signature")

    @property
    @pulumi.getter
    def summary(self) -> pulumi.Output[str]:
        """
        The short summary to the listing.
        """
        return pulumi.get(self, "summary")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> pulumi.Output[str]:
        """
        Date and time at which the subscription was created, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z`
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeRetrieved")
    def time_retrieved(self) -> pulumi.Output[str]:
        """
        Date and time the agreements were retrieved, in [RFC3339](https://tools.ietf.org/html/rfc3339) format. Example: `2018-03-20T12:32:53.532Z` 


        ** IMPORTANT **
        Any change to a property that does not support update will force the destruction and recreation of the resource with the new property values
        """
        return pulumi.get(self, "time_retrieved")

